/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.Db2DatabaseType;
import com.j256.ormlite.db.DerbyClientServerDatabaseType;
import com.j256.ormlite.db.DerbyEmbeddedDatabaseType;
import com.j256.ormlite.db.GenericOdbcDatabaseType;
import com.j256.ormlite.db.H2DatabaseType;
import com.j256.ormlite.db.HsqldbDatabaseType;
import com.j256.ormlite.db.MariaDbDatabaseType;
import com.j256.ormlite.db.MysqlDatabaseType;
import com.j256.ormlite.db.NetezzaDatabaseType;
import com.j256.ormlite.db.OracleDatabaseType;
import com.j256.ormlite.db.PostgresDatabaseType;
import com.j256.ormlite.db.SqlServerDatabaseType;
import com.j256.ormlite.db.SqlServerJtdsDatabaseType;
import com.j256.ormlite.db.SqliteDatabaseType;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTypeUtils {
    private static List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();

    private DatabaseTypeUtils() {
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        for (DatabaseType databaseType : databaseTypes) {
            if (!databaseType.isDatabaseUrlThisType(databaseUrl, dbTypePart)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        databaseTypes.add((DatabaseType)new Db2DatabaseType());
        databaseTypes.add((DatabaseType)new DerbyClientServerDatabaseType());
        databaseTypes.add((DatabaseType)new DerbyEmbeddedDatabaseType());
        databaseTypes.add((DatabaseType)new GenericOdbcDatabaseType());
        databaseTypes.add((DatabaseType)new H2DatabaseType());
        databaseTypes.add((DatabaseType)new HsqldbDatabaseType());
        databaseTypes.add((DatabaseType)new MysqlDatabaseType());
        databaseTypes.add((DatabaseType)new MariaDbDatabaseType());
        databaseTypes.add((DatabaseType)new NetezzaDatabaseType());
        databaseTypes.add((DatabaseType)new OracleDatabaseType());
        databaseTypes.add((DatabaseType)new PostgresDatabaseType());
        databaseTypes.add((DatabaseType)new SqliteDatabaseType());
        databaseTypes.add((DatabaseType)new SqlServerDatabaseType());
        databaseTypes.add((DatabaseType)new SqlServerJtdsDatabaseType());
    }
}

