/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class MappingUtils {
    private MappingUtils() {
    }

    public static <T> MappingStrategy<T> determineMappingStrategy(Class type) {
        HeaderColumnNameMappingStrategy mappingStrategy;
        Field[] fields = FieldUtils.getAllFields((Class)type);
        boolean positionAnnotationsPresent = false;
        for (Field field : fields) {
            if (field.isAnnotationPresent(CsvBindByPosition.class) || field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                positionAnnotationsPresent = true;
                break;
            }
            if (positionAnnotationsPresent) break;
        }
        if (positionAnnotationsPresent) {
            ColumnPositionMappingStrategy ms = new ColumnPositionMappingStrategy();
            ms.setType(type);
            mappingStrategy = ms;
        } else {
            HeaderColumnNameMappingStrategy ms = new HeaderColumnNameMappingStrategy();
            ms.setType(type);
            if (!ms.isAnnotationDriven()) {
                TreeSet<String> sortedFields = new TreeSet<String>();
                for (Field f : fields) {
                    if (f.isSynthetic()) continue;
                    sortedFields.add(f.getName());
                }
                String header = StringUtils.join(sortedFields, (char)',').concat("\n");
                try {
                    ms.captureHeader(new CSVReader(new StringReader(header)));
                    ms.findDescriptor(0);
                }
                catch (IOException e) {
                }
                catch (IntrospectionException e) {
                    CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException("");
                    csve.initCause(e);
                    throw csve;
                }
            }
            mappingStrategy = ms;
        }
        return mappingStrategy;
    }
}

