/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheOffheapEvictionManager;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.CacheStatisticsClearMessage;
import org.apache.ignite.internal.processors.cache.CacheStatisticsModeChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheStatisticsModeChangeTask;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDummyDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheUpdateTimeout;
import org.apache.ignite.internal.processors.cache.ClusterCachesInfo;
import org.apache.ignite.internal.processors.cache.ClusterCachesReconnectResult;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheEventManager;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionManager;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStore;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStoreFactory;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedTtlCleanupManager;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridNoStorageCacheMap;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.TxTimeoutOnPartitionMapExchangeChangeMessage;
import org.apache.ignite.internal.processors.cache.TxTimeoutOnPartitionMapExchangeChangeTask;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.WalStateFinishMessage;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.WalStateNodeLeaveExchangeTask;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.StopCachesOnClientReconnectExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.PartitionsEvictManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.local.atomic.GridLocalAtomicCache;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.FsyncModeFileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTransactionsImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaExchangeWorkerTask;
import org.apache.ignite.internal.processors.query.schema.SchemaNodeLeaveExchangeWorkerTask;
import org.apache.ignite.internal.processors.query.schema.message.SchemaAbstractDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaProposeDiscoveryMessage;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainClosure;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.CacheGroupMetricsMXBean;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheProcessor
extends GridProcessorAdapter
implements MetastorageLifecycleListener {
    private static final String MERGE_OF_CONFIG_CONFLICTS_MESSAGE = "Conflicts during configuration merge for cache '%s' : \n%s";
    private static final String MERGE_OF_CONFIG_REQUIRED_MESSAGE = "Failed to join node to the active cluster (the config of the cache '%s' has to be merged which is impossible on active grid). Deactivate grid and retry node join or clean the joining node.";
    private final boolean startClientCaches = IgniteSystemProperties.getBoolean("IGNITE_START_CACHES_ON_JOIN", false);
    private final boolean walFsyncWithDedicatedWorker = IgniteSystemProperties.getBoolean("IGNITE_WAL_FSYNC_WITH_DEDICATED_WORKER", false);
    private GridCacheSharedContext<?, ?> sharedCtx;
    private final ConcurrentMap<Integer, CacheGroupContext> cacheGrps = new ConcurrentHashMap<Integer, CacheGroupContext>();
    private final Map<String, GridCacheAdapter<?, ?>> caches;
    private final Map<String, GridCacheAdapter> stoppedCaches = new ConcurrentHashMap<String, GridCacheAdapter>();
    private final ConcurrentHashMap<String, IgniteCacheProxyImpl<?, ?>> jCacheProxies;
    private final Deque<String> stopSeq;
    private IgniteTransactionsImpl transactions;
    private ConcurrentMap<UUID, IgniteInternalFuture> pendingFuts = new ConcurrentHashMap<UUID, IgniteInternalFuture>();
    private ConcurrentMap<String, IgniteInternalFuture> pendingTemplateFuts = new ConcurrentHashMap<String, IgniteInternalFuture>();
    private ConcurrentMap<UUID, EnableStatisticsFuture> manageStatisticsFuts = new ConcurrentHashMap<UUID, EnableStatisticsFuture>();
    private ConcurrentMap<UUID, TxTimeoutOnPartitionMapExchangeChangeFuture> txTimeoutOnPartitionMapExchangeFuts = new ConcurrentHashMap<UUID, TxTimeoutOnPartitionMapExchangeChangeFuture>();
    private ClusterCachesInfo cachesInfo;
    private IdentityHashMap<CacheStore, ThreadLocal> sesHolders = new IdentityHashMap();
    private final Marshaller marsh;
    private final CountDownLatch cacheStartedLatch = new CountDownLatch(1);
    private final Set<String> internalCaches;
    private final String CACHE_GRP_METRICS_MBEAN_GRP = "Cache groups";

    public GridCacheProcessor(GridKernalContext ctx) {
        super(ctx);
        this.caches = new ConcurrentHashMap();
        this.jCacheProxies = new ConcurrentHashMap();
        this.stopSeq = new LinkedList<String>();
        this.internalCaches = new HashSet<String>();
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
    }

    private void initialize(CacheConfiguration cfg, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        CU.initializeConfigDefaults(this.log, cfg, cacheObjCtx);
        this.ctx.coordinators().preProcessCacheConfiguration(cfg);
        this.ctx.igfsHelper().preProcessCacheConfiguration(cfg);
    }

    private void suggestOptimizations(CacheConfiguration cfg, boolean hasStore) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        String msg = "Disable eviction policy (remove from configuration)";
        if (cfg.getEvictionPolicyFactory() != null || cfg.getEvictionPolicy() != null) {
            perf.add(msg, false);
        } else {
            perf.add(msg, true);
        }
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            perf.add("Disable near cache (set 'nearConfiguration' to null)", cfg.getNearConfiguration() == null);
            if (cfg.getAffinity() != null) {
                perf.add("Decrease number of backups (set 'backups' to 0)", cfg.getBackups() == 0);
            }
        }
        perf.add("Enable ATOMIC mode if not using transactions (set 'atomicityMode' to ATOMIC)", cfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC);
        perf.add("Disable fully synchronous writes (set 'writeSynchronizationMode' to PRIMARY_SYNC or FULL_ASYNC)", cfg.getWriteSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC);
        if (hasStore && cfg.isWriteThrough()) {
            perf.add("Enable write-behind to persistent store (set 'writeBehindEnabled' to true)", cfg.isWriteBehindEnabled());
        }
    }

    public void enableRebalance() {
        for (IgniteCacheProxy<?, ?> c : this.publicCaches()) {
            c.rebalance();
        }
    }

    public CachePartitionExchangeWorkerTask exchangeTaskForCustomDiscoveryMessage(DiscoveryCustomMessage msg) {
        if (msg instanceof SchemaAbstractDiscoveryMessage) {
            SchemaAbstractDiscoveryMessage msg0 = (SchemaAbstractDiscoveryMessage)msg;
            if (msg0.exchange()) {
                return new SchemaExchangeWorkerTask(msg0);
            }
        } else {
            CacheStatisticsModeChangeMessage msg0;
            if (msg instanceof ClientCacheChangeDummyDiscoveryMessage) {
                ClientCacheChangeDummyDiscoveryMessage msg02 = (ClientCacheChangeDummyDiscoveryMessage)msg;
                return msg02;
            }
            if (msg instanceof CacheStatisticsModeChangeMessage && (msg0 = (CacheStatisticsModeChangeMessage)msg).initial()) {
                return new CacheStatisticsModeChangeTask(msg0);
            }
        }
        return null;
    }

    void processCustomExchangeTask(CachePartitionExchangeWorkerTask task) {
        if (task instanceof SchemaExchangeWorkerTask) {
            SchemaAbstractDiscoveryMessage msg = ((SchemaExchangeWorkerTask)task).message();
            if (msg instanceof SchemaProposeDiscoveryMessage) {
                SchemaProposeDiscoveryMessage msg0 = (SchemaProposeDiscoveryMessage)msg;
                this.ctx.query().onSchemaPropose(msg0);
            } else {
                U.warn(this.log, "Unsupported schema discovery message: " + msg);
            }
        } else if (task instanceof SchemaNodeLeaveExchangeWorkerTask) {
            SchemaNodeLeaveExchangeWorkerTask task0 = (SchemaNodeLeaveExchangeWorkerTask)task;
            this.ctx.query().onNodeLeave(task0.node());
        } else if (task instanceof ClientCacheChangeDummyDiscoveryMessage) {
            ClientCacheChangeDummyDiscoveryMessage task0 = (ClientCacheChangeDummyDiscoveryMessage)task;
            this.sharedCtx.affinity().processClientCachesChanges(task0);
        } else if (task instanceof ClientCacheUpdateTimeout) {
            ClientCacheUpdateTimeout task0 = (ClientCacheUpdateTimeout)task;
            this.sharedCtx.affinity().sendClientCacheChangesMessage(task0);
        } else if (task instanceof CacheStatisticsModeChangeTask) {
            CacheStatisticsModeChangeTask task0 = (CacheStatisticsModeChangeTask)task;
            this.processStatisticsModeChange(task0.message());
        } else if (task instanceof TxTimeoutOnPartitionMapExchangeChangeTask) {
            TxTimeoutOnPartitionMapExchangeChangeTask task0 = (TxTimeoutOnPartitionMapExchangeChangeTask)task;
            this.processTxTimeoutOnPartitionMapExchangeChange(task0.message());
        } else if (task instanceof StopCachesOnClientReconnectExchangeTask) {
            StopCachesOnClientReconnectExchangeTask task0 = (StopCachesOnClientReconnectExchangeTask)task;
            this.stopCachesOnClientReconnect(task0.stoppedCaches());
            task0.onDone();
        } else if (task instanceof WalStateNodeLeaveExchangeTask) {
            WalStateNodeLeaveExchangeTask task0 = (WalStateNodeLeaveExchangeTask)task;
            this.sharedCtx.walState().onNodeLeft(task0.node().id());
        } else {
            U.warn(this.log, "Unsupported custom exchange task: " + task);
        }
    }

    private boolean storesLocallyOnClient(IgniteConfiguration c, CacheConfiguration cc) {
        if (c.isClientMode().booleanValue() && c.getDataStorageConfiguration() == null) {
            if (cc.getCacheMode() == CacheMode.LOCAL) {
                return true;
            }
            return this.ctx.discovery().cacheAffinityNode(this.ctx.discovery().localNode(), cc.getName());
        }
        return false;
    }

    private void validate(IgniteConfiguration c, CacheConfiguration cc, CacheType cacheType, @Nullable CacheStore cfgStore) throws IgniteCheckedException {
        String schema;
        this.assertParameter(cc.getName() != null && !cc.getName().isEmpty(), "name is null or empty");
        if (cc.getCacheMode() == CacheMode.REPLICATED && cc.getNearConfiguration() != null && this.ctx.discovery().cacheAffinityNode(this.ctx.discovery().localNode(), cc.getName())) {
            U.warn(this.log, "Near cache cannot be used with REPLICATED cache, will be ignored [cacheName=" + U.maskName(cc.getName()) + ']');
            cc.setNearConfiguration(null);
        }
        if (this.storesLocallyOnClient(c, cc)) {
            throw new IgniteCheckedException("DataRegion for client caches must be explicitly configured on client node startup. Use DataStorageConfiguration to configure DataRegion.");
        }
        if (cc.getCacheMode() == CacheMode.LOCAL && !cc.getAffinity().getClass().equals(LocalAffinityFunction.class)) {
            U.warn(this.log, "AffinityFunction configuration parameter will be ignored for local cache [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        if (cc.getAffinity().partitions() > 65000) {
            throw new IgniteCheckedException("Cannot have more than 65000 partitions [cacheName=" + cc.getName() + ", partitions=" + cc.getAffinity().partitions() + ']');
        }
        if (cc.getRebalanceMode() != CacheRebalanceMode.NONE) {
            this.assertParameter(cc.getRebalanceBatchSize() > 0, "rebalanceBatchSize > 0");
        }
        if ((cc.getCacheMode() == CacheMode.PARTITIONED || cc.getCacheMode() == CacheMode.REPLICATED) && cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC && cc.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) {
            U.warn(this.log, "Cache write synchronization mode is set to FULL_ASYNC. All single-key 'put' and 'remove' operations will return 'null', all 'putx' and 'removex' operations will return 'true' [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        DeploymentMode depMode = c.getDeploymentMode();
        if (!(!c.isPeerClassLoadingEnabled() || depMode != DeploymentMode.PRIVATE && depMode != DeploymentMode.ISOLATED || CU.isSystemCache(cc.getName()) || c.getMarshaller() instanceof BinaryMarshaller)) {
            throw new IgniteCheckedException("Cache can be started in PRIVATE or ISOLATED deployment mode only when BinaryMarshaller is used [depMode=" + (Object)((Object)this.ctx.config().getDeploymentMode()) + ", marshaller=" + c.getMarshaller().getClass().getName() + ']');
        }
        if (cc.getAffinity().partitions() > 65000) {
            throw new IgniteCheckedException("Affinity function must return at most 65000 partitions [actual=" + cc.getAffinity().partitions() + ", affFunction=" + cc.getAffinity() + ", cacheName=" + cc.getName() + ']');
        }
        if (cc.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            this.assertParameter(cc.getCacheMode() != CacheMode.LOCAL, "LOCAL cache mode cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            this.assertParameter(cc.getNearConfiguration() == null, "near cache cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            this.assertParameter(!cc.isReadThrough(), "readThrough cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            this.assertParameter(!cc.isWriteThrough(), "writeThrough cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            this.assertParameter(!cc.isWriteBehindEnabled(), "writeBehindEnabled cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ExpiryPolicy expPlc = null;
            if (cc.getExpiryPolicyFactory() instanceof FactoryBuilder.SingletonFactory) {
                expPlc = (ExpiryPolicy)cc.getExpiryPolicyFactory().create();
            }
            if (!(expPlc instanceof EternalExpiryPolicy)) {
                this.assertParameter(cc.getExpiryPolicyFactory() == null, "expiry policy cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            }
            this.assertParameter(cc.getInterceptor() == null, "interceptor cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
        }
        if (cc.isWriteBehindEnabled()) {
            if (cfgStore == null) {
                throw new IgniteCheckedException("Cannot enable write-behind (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
            }
            this.assertParameter(cc.getWriteBehindBatchSize() > 0, "writeBehindBatchSize > 0");
            this.assertParameter(cc.getWriteBehindFlushSize() >= 0, "writeBehindFlushSize >= 0");
            this.assertParameter(cc.getWriteBehindFlushFrequency() >= 0L, "writeBehindFlushFrequency >= 0");
            this.assertParameter(cc.getWriteBehindFlushThreadCount() > 0, "writeBehindFlushThreadCount > 0");
            if (cc.getWriteBehindFlushSize() == 0 && cc.getWriteBehindFlushFrequency() == 0L) {
                throw new IgniteCheckedException("Cannot set both 'writeBehindFlushFrequency' and 'writeBehindFlushSize' parameters to 0 for cache: " + U.maskName(cc.getName()));
            }
        }
        if (cc.isReadThrough() && cfgStore == null) {
            throw new IgniteCheckedException("Cannot enable read-through (loader or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        if (cc.isWriteThrough() && cfgStore == null) {
            throw new IgniteCheckedException("Cannot enable write-through (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        long delay = cc.getRebalanceDelay();
        if (delay != 0L) {
            if (cc.getCacheMode() != CacheMode.PARTITIONED) {
                U.warn(this.log, "Rebalance delay is supported only for partitioned caches (will ignore): " + cc.getName());
            } else if (cc.getRebalanceMode() == CacheRebalanceMode.SYNC) {
                if (delay < 0L) {
                    U.warn(this.log, "Ignoring SYNC rebalance mode with manual rebalance start (node will not wait for rebalancing to be finished): " + U.maskName(cc.getName()));
                } else {
                    U.warn(this.log, "Using SYNC rebalance mode with rebalance delay (node will wait until rebalancing is initiated for " + delay + "ms) for cache: " + U.maskName(cc.getName()));
                }
            }
        }
        this.ctx.igfsHelper().validateCacheConfiguration(cc);
        this.ctx.coordinators().validateCacheConfiguration(cc);
        if (cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC) {
            this.assertParameter(cc.getTransactionManagerLookupClassName() == null, "transaction manager can not be used with ATOMIC cache");
        }
        if (!(cc.getEvictionPolicyFactory() == null && cc.getEvictionPolicy() == null || cc.isOnheapCacheEnabled())) {
            throw new IgniteCheckedException("Onheap cache must be enabled if eviction policy is configured [cacheName=" + U.maskName(cc.getName()) + "]");
        }
        if (cacheType != CacheType.DATA_STRUCTURES && DataStructuresProcessor.isDataStructureCache(cc.getName())) {
            throw new IgniteCheckedException("Using cache names reserved for datastructures is not allowed for other cache types [cacheName=" + cc.getName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
        }
        if (cacheType != CacheType.DATA_STRUCTURES && DataStructuresProcessor.isReservedGroup(cc.getGroupName())) {
            throw new IgniteCheckedException("Using cache group names reserved for datastructures is not allowed for other cache types [cacheName=" + cc.getName() + ", groupName=" + cc.getGroupName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
        }
        if (this.ctx.query().moduleEnabled() && F.eq(schema = QueryUtils.normalizeSchemaName(cc.getName(), cc.getSqlSchema()), "IGNITE")) {
            if (cc.getSqlSchema() == null) {
                throw new IgniteCheckedException("SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=" + cc.getName() + ", schemaName=" + cc.getSqlSchema() + "]");
            }
            throw new IgniteCheckedException("SQL schema name is reserved (please choose another one) [cacheName=" + cc.getName() + ", schemaName=" + cc.getSqlSchema() + ']');
        }
        if (cc.isEncryptionEnabled() && !this.ctx.clientNode()) {
            if (!CU.isPersistentCache(cc, c.getDataStorageConfiguration())) {
                throw new IgniteCheckedException("Using encryption is not allowed for not persistent cache  [cacheName=" + cc.getName() + ", groupName=" + cc.getGroupName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
            }
            EncryptionSpi encSpi = c.getEncryptionSpi();
            if (encSpi == null) {
                throw new IgniteCheckedException("EncryptionSpi should be configured to use encrypted cache [cacheName=" + cc.getName() + ", groupName=" + cc.getGroupName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
            }
        }
    }

    private List<GridCacheManager> dhtManagers(GridCacheContext ctx) {
        return F.asList(new GridCacheManager[]{ctx.store(), ctx.events(), ctx.evicts(), ctx.queries(), ctx.continuousQueries(), ctx.dr()});
    }

    private Collection<GridCacheManager> dhtExcludes(GridCacheContext ctx) {
        if (ctx.config().getCacheMode() == CacheMode.LOCAL || !GridCacheUtils.isNearEnabled(ctx)) {
            return Collections.emptyList();
        }
        return F.asList(new GridCacheManager[]{ctx.queries(), ctx.continuousQueries(), ctx.store()});
    }

    private void prepare(CacheConfiguration cfg, Collection<Object> objs) throws IgniteCheckedException {
        this.prepare(cfg, cfg.getAffinity(), false);
        this.prepare(cfg, cfg.getAffinityMapper(), false);
        this.prepare(cfg, cfg.getEvictionFilter(), false);
        this.prepare(cfg, cfg.getInterceptor(), false);
        for (Object obj : objs) {
            this.prepare(cfg, obj, false);
        }
    }

    private void prepare(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) throws IgniteCheckedException {
        if (rsrc != null) {
            this.ctx.resource().injectGeneric(rsrc);
            this.ctx.resource().injectCacheName(rsrc, cfg.getName());
            this.registerMbean(rsrc, cfg.getName(), near);
        }
    }

    private void cleanup(GridCacheContext cctx) {
        CacheConfiguration cfg = cctx.config();
        this.cleanup(cfg, cfg.getAffinity(), false);
        this.cleanup(cfg, cfg.getAffinityMapper(), false);
        this.cleanup(cfg, cfg.getEvictionFilter(), false);
        this.cleanup(cfg, cfg.getInterceptor(), false);
        this.cleanup(cfg, cctx.store().configuredStore(), false);
        if (!CU.isUtilityCache(cfg.getName()) && !CU.isSystemCache(cfg.getName())) {
            this.unregisterMbean(cctx.cache().localMxBean(), cfg.getName(), false);
            this.unregisterMbean(cctx.cache().clusterMxBean(), cfg.getName(), false);
        }
        cctx.cleanup();
    }

    private void cleanup(CacheGroupContext grp) {
        CacheConfiguration cfg = grp.config();
        for (Object obj : grp.configuredUserObjects()) {
            this.cleanup(cfg, obj, false);
        }
        if (!grp.systemCache() && !U.IGNITE_MBEANS_DISABLED) {
            try {
                this.ctx.config().getMBeanServer().unregisterMBean(U.makeMBeanName(this.ctx.igniteInstanceName(), "Cache groups", grp.cacheOrGroupName()));
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to unregister MBean for cache group: " + grp.name(), e);
            }
        }
    }

    private void cleanup(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) {
        if (rsrc != null) {
            this.unregisterMbean(rsrc, cfg.getName(), near);
            try {
                this.ctx.resource().cleanupGeneric(rsrc);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cleanup resource: " + rsrc, e);
            }
        }
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        this.startCachesOnStart();
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
    }

    private void startCachesOnStart() throws IgniteCheckedException {
        if (!this.ctx.isDaemon()) {
            HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> caches = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
            HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> templates = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
            this.addCacheOnJoinFromConfig(caches, templates);
            CacheJoinNodeDiscoveryData discoData = new CacheJoinNodeDiscoveryData(IgniteUuid.randomUuid(), caches, templates, this.startAllCachesOnClientStart());
            this.cachesInfo.onStart(discoData);
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.cachesInfo = new ClusterCachesInfo(this.ctx);
        DeploymentMode depMode = this.ctx.config().getDeploymentMode();
        if (!F.isEmpty(this.ctx.config().getCacheConfiguration()) && depMode != DeploymentMode.CONTINUOUS && depMode != DeploymentMode.SHARED) {
            U.warn(this.log, "Deployment mode for cache is not CONTINUOUS or SHARED (it is recommended that you change deployment mode and restart): " + (Object)((Object)depMode));
        }
        this.initializeInternalCacheNames();
        Collection<CacheStoreSessionListener> sessionListeners = CU.startStoreSessionListeners(this.ctx, this.ctx.config().getCacheStoreSessionListenerFactories());
        this.sharedCtx = this.createSharedContext(this.ctx, sessionListeners);
        this.transactions = new IgniteTransactionsImpl(this.sharedCtx, null);
        for (GridCacheSharedManager<?, ?> mgr : this.sharedCtx.managers()) {
            mgr.start(this.sharedCtx);
        }
        if (!this.ctx.isDaemon() && !CU.isPersistenceEnabled(this.ctx.config()) || this.ctx.config().isClientMode().booleanValue()) {
            this.startCachesOnStart();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started cache processor.");
        }
        this.ctx.state().cacheProcessorStarted();
        this.ctx.authentication().cacheProcessorStarted();
    }

    private void addCacheOnJoin(CacheConfiguration<?, ?> cfg, boolean sql, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates) throws IgniteCheckedException {
        String cacheName = cfg.getName();
        CU.validateCacheName(cacheName);
        this.cloneCheckSerializable(cfg);
        CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
        this.initialize(cfg, cacheObjCtx);
        StoredCacheData cacheData = new StoredCacheData(cfg);
        cacheData.sql(sql);
        if (GridCacheUtils.isCacheTemplateName(cacheName)) {
            templates.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, CacheType.USER, false, 0L, true));
        } else {
            if (caches.containsKey(cacheName)) {
                throw new IgniteCheckedException("Duplicate cache name found (check configuration and assign unique name to each cache): " + cacheName);
            }
            CacheType cacheType = this.cacheType(cacheName);
            if (cacheType != CacheType.USER && cfg.getDataRegionName() == null) {
                cfg.setDataRegionName(this.sharedCtx.database().systemDateRegionName());
            }
            this.addStoredCache(caches, cacheData, cacheName, cacheType, true);
        }
    }

    private void addStoredCache(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, StoredCacheData cacheData, String cacheName, CacheType cacheType, boolean isStaticalyConfigured) {
        if (!cacheType.userCache()) {
            this.stopSeq.addLast(cacheName);
        } else {
            this.stopSeq.addFirst(cacheName);
        }
        caches.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, cacheType, cacheData.sql(), 0L, isStaticalyConfigured));
    }

    private void addCacheOnJoinFromConfig(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates) throws IgniteCheckedException {
        Map<String, StoredCacheData> storedCaches;
        assert (!this.ctx.config().isDaemon());
        CacheConfiguration[] cfgs = this.ctx.config().getCacheConfiguration();
        for (int i = 0; i < cfgs.length; ++i) {
            CacheConfiguration cfg;
            cfgs[i] = cfg = new CacheConfiguration(cfgs[i]);
            this.addCacheOnJoin(cfg, false, caches, templates);
        }
        if (CU.isPersistenceEnabled(this.ctx.config()) && this.ctx.cache().context().pageStore() != null && !F.isEmpty(storedCaches = this.ctx.cache().context().pageStore().readCacheConfigurations())) {
            for (StoredCacheData storedCacheData : storedCaches.values()) {
                String cacheName = storedCacheData.config().getName();
                if (!caches.containsKey(cacheName)) {
                    this.addStoredCache(caches, storedCacheData, cacheName, this.cacheType(cacheName), false);
                    continue;
                }
                CacheConfiguration<?, ?> cfg = caches.get(cacheName).cacheData().config();
                CacheConfiguration<?, ?> cfgFromStore = storedCacheData.config();
                this.validateCacheConfigurationOnRestore(cfg, cfgFromStore);
            }
        }
    }

    private void validateCacheConfigurationOnRestore(CacheConfiguration cfg, CacheConfiguration cfgFromStore) throws IgniteCheckedException {
        assert (cfg != null && cfgFromStore != null);
        if ((cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT || cfgFromStore.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) && cfg.getAtomicityMode() != cfgFromStore.getAtomicityMode()) {
            throw new IgniteCheckedException("Cannot start cache. Statically configured atomicity mode differs from previously stored configuration. Please check your configuration: [cacheName=" + cfg.getName() + ", configuredAtomicityMode=" + (Object)((Object)cfg.getAtomicityMode()) + ", storedAtomicityMode=" + (Object)((Object)cfgFromStore.getAtomicityMode()) + "]");
        }
        boolean staticCfgVal = cfg.isEncryptionEnabled();
        boolean storedVal = cfgFromStore.isEncryptionEnabled();
        if (storedVal != staticCfgVal) {
            throw new IgniteCheckedException("Encrypted flag value differs. Static config value is '" + staticCfgVal + "' and value stored on the disk is '" + storedVal + "'");
        }
    }

    private void initializeInternalCacheNames() {
        FileSystemConfiguration[] igfsCfgs = this.ctx.grid().configuration().getFileSystemConfiguration();
        if (igfsCfgs != null) {
            for (FileSystemConfiguration igfsCfg : igfsCfgs) {
                this.internalCaches.add(igfsCfg.getMetaCacheConfiguration().getName());
                this.internalCaches.add(igfsCfg.getDataCacheConfiguration().getName());
            }
        }
        if (IgniteComponentType.HADOOP.inClassPath()) {
            this.internalCaches.add("ignite-hadoop-mr-sys-cache");
        }
    }

    @Nullable
    public CacheGroupContext cacheGroup(int grpId) {
        return (CacheGroupContext)this.cacheGrps.get(grpId);
    }

    public Collection<CacheGroupContext> cacheGroups() {
        return this.cacheGrps.values();
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (this.ctx.isDaemon()) {
            return;
        }
        try {
            boolean checkConsistency;
            boolean bl = checkConsistency = !IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK");
            if (checkConsistency) {
                this.checkConsistency();
            }
            this.cachesInfo.onKernalStart(checkConsistency);
            this.sharedCtx.walState().onKernalStart();
            this.ctx.query().onCacheKernalStart();
            this.sharedCtx.exchange().onKernalStart(active, false);
        }
        finally {
            this.cacheStartedLatch.countDown();
        }
        if (!this.ctx.clientNode()) {
            this.addRemovedItemsCleanupTask(Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L));
        }
        if (!active) {
            return;
        }
        this.ctx.service().onUtilityCacheStarted();
        final AffinityTopologyVersion startTopVer = this.ctx.discovery().localJoin().joinTopologyVersion();
        final ArrayList syncFuts = new ArrayList(this.caches.size());
        this.sharedCtx.forAllCaches((IgniteInClosure<GridCacheContext>)new CIX1<GridCacheContext>(){

            @Override
            public void applyx(GridCacheContext cctx) {
                CacheMode cacheMode;
                CacheConfiguration cfg = cctx.config();
                if (cctx.affinityNode() && cfg.getRebalanceMode() == CacheRebalanceMode.SYNC && startTopVer.equals(cctx.startTopologyVersion()) && ((cacheMode = cfg.getCacheMode()) == CacheMode.REPLICATED || cacheMode == CacheMode.PARTITIONED && cfg.getRebalanceDelay() >= 0L)) {
                    syncFuts.add(cctx.preloader().syncFuture());
                }
            }
        });
        int size = syncFuts.size();
        for (int i = 0; i < size; ++i) {
            ((IgniteInternalFuture)syncFuts.get(i)).get();
        }
    }

    private void addRemovedItemsCleanupTask(long timeout) {
        this.ctx.timeout().addTimeoutObject(new RemovedItemsCleanupTask(timeout));
    }

    private void checkConsistency() throws IgniteCheckedException {
        for (ClusterNode n : this.ctx.discovery().remoteNodes()) {
            if (Boolean.TRUE.equals(n.attribute("org.apache.ignite.consistency.check.skipped"))) continue;
            this.checkRebalanceConfiguration(n);
            this.checkTransactionConfiguration(n);
            this.checkMemoryConfiguration(n);
            DeploymentMode locDepMode = this.ctx.config().getDeploymentMode();
            DeploymentMode rmtDepMode = (DeploymentMode)((Object)n.attribute("org.apache.ignite.ignite.dep.mode"));
            CU.checkAttributeMismatch(this.log, null, n.id(), "deploymentMode", "Deployment mode", (Object)locDepMode, (Object)rmtDepMode, true);
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopCaches(cancel);
        List<GridCacheSharedManager<?, ?>> mgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = it.previous();
            mgr.stop(cancel);
        }
        CU.stopStoreSessionListeners(this.ctx, this.sharedCtx.storeSessionListeners());
        this.sharedCtx.cleanup();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped cache processor.");
        }
    }

    public void stopCaches(boolean cancel) {
        for (String cacheName : this.stopSeq) {
            GridCacheAdapter cache = this.stoppedCaches.remove(cacheName);
            if (cache == null) continue;
            this.stopCache(cache, cancel, false);
        }
        for (GridCacheAdapter cache : this.stoppedCaches.values()) {
            if (cache != this.stoppedCaches.remove(cache.name())) continue;
            this.stopCache(cache, cancel, false);
        }
        for (CacheGroupContext grp : this.cacheGrps.values()) {
            this.stopCacheGroup(grp.groupId());
        }
    }

    public void blockGateways() {
        for (IgniteCacheProxy igniteCacheProxy : this.jCacheProxies.values()) {
            igniteCacheProxy.context().gate().onStopped();
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.cacheStartedLatch.countDown();
        GridCachePartitionExchangeManager exch = this.context().exchange();
        exch.onKernalStop(cancel);
        this.sharedCtx.mvcc().onStop();
        for (CacheGroupContext grp : this.cacheGrps.values()) {
            grp.onKernalStop();
        }
        this.onKernalStopCaches(cancel);
        this.cancelFutures();
        List<GridCacheSharedManager<?, ?>> sharedMgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> it = sharedMgrs.listIterator(sharedMgrs.size());
        while (it.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = it.previous();
            if (mgr == exch) continue;
            mgr.onKernalStop(cancel);
        }
    }

    public void onKernalStopCaches(boolean cancel) {
        GridCacheAdapter cache;
        IgniteCheckedException affErr = new IgniteCheckedException("Failed to wait for topology update, node is stopping.");
        for (CacheGroupContext cacheGroupContext : this.cacheGrps.values()) {
            GridAffinityAssignmentCache aff = cacheGroupContext.affinity();
            aff.cancelFutures(affErr);
        }
        for (String string : this.stopSeq) {
            cache = this.caches.remove(string);
            if (cache == null) continue;
            this.stoppedCaches.put(string, cache);
            this.onKernalStop(cache, cancel);
        }
        for (Map.Entry entry : this.caches.entrySet()) {
            cache = (GridCacheAdapter)entry.getValue();
            if (cache != this.caches.remove(entry.getKey())) continue;
            this.stoppedCaches.put((String)entry.getKey(), cache);
            this.onKernalStop((GridCacheAdapter)entry.getValue(), cancel);
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
        for (IgniteInternalFuture igniteInternalFuture : this.pendingFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (IgniteInternalFuture igniteInternalFuture : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (EnableStatisticsFuture enableStatisticsFuture : this.manageStatisticsFuts.values()) {
            enableStatisticsFuture.onDone(err);
        }
        for (TxTimeoutOnPartitionMapExchangeChangeFuture txTimeoutOnPartitionMapExchangeChangeFuture : this.txTimeoutOnPartitionMapExchangeFuts.values()) {
            txTimeoutOnPartitionMapExchangeChangeFuture.onDone(err);
        }
        for (CacheGroupContext cacheGroupContext : this.cacheGrps.values()) {
            cacheGroupContext.onDisconnected(reconnectFut);
        }
        for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
            GridCacheContext cctx = gridCacheAdapter.context();
            cctx.gate().onDisconnected(reconnectFut);
            List mgrs = gridCacheAdapter.context().managers();
            ListIterator it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager mgr = it.previous();
                mgr.onDisconnected(reconnectFut);
            }
        }
        this.sharedCtx.onDisconnected(reconnectFut);
        this.cachesInfo.onDisconnected();
    }

    private void stopCacheOnReconnect(GridCacheContext cctx, List<GridCacheAdapter> stoppedCaches) {
        cctx.gate().reconnected(true);
        this.sharedCtx.removeCacheContext(cctx);
        this.caches.remove(cctx.name());
        this.completeProxyInitialize(cctx.name());
        this.jCacheProxies.remove(cctx.name());
        stoppedCaches.add(cctx.cache());
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        ArrayList reconnected = new ArrayList(this.caches.size());
        DiscoveryDataClusterState state = this.ctx.state().clusterState();
        boolean active = state.active() && !state.transition();
        ClusterCachesReconnectResult reconnectRes = this.cachesInfo.onReconnected(active, state.transition());
        ArrayList<GridCacheAdapter> stoppedCaches = new ArrayList<GridCacheAdapter>();
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            boolean bl;
            boolean bl2 = bl = reconnectRes.stoppedCacheGroups().contains(cache.context().groupId()) || reconnectRes.stoppedCaches().contains(cache.name());
            if (bl) {
                this.stopCacheOnReconnect(cache.context(), stoppedCaches);
                continue;
            }
            cache.onReconnected();
            reconnected.add(cache);
            if (!cache.context().userCache()) continue;
            GridCacheContext<?, ?> cctx = cache.context();
            DynamicCacheDescriptor desc = this.cacheDescriptor(cctx.name());
            assert (desc != null) : cctx.name();
            boolean rmvIdx = !cache.context().group().persistenceEnabled();
            this.ctx.query().onCacheStop0(cctx, rmvIdx);
            this.ctx.query().onCacheStart0(cctx, desc.schema());
        }
        Set<Integer> stoppedGrps = reconnectRes.stoppedCacheGroups();
        for (CacheGroupContext cacheGroupContext : this.cacheGrps.values()) {
            if (stoppedGrps.contains(cacheGroupContext.groupId())) {
                this.cacheGrps.remove(cacheGroupContext.groupId());
                continue;
            }
            cacheGroupContext.onReconnected();
        }
        this.sharedCtx.onReconnected(active);
        for (GridCacheAdapter gridCacheAdapter : reconnected) {
            gridCacheAdapter.context().gate().reconnected(false);
        }
        if (!stoppedCaches.isEmpty()) {
            return this.sharedCtx.exchange().deferStopCachesOnClientReconnect(stoppedCaches);
        }
        return null;
    }

    private void startCache(GridCacheAdapter<?, ?> cache, QuerySchema schema) throws IgniteCheckedException {
        GridCacheContext<?, ?> cacheCtx = cache.context();
        CacheConfiguration cfg = cacheCtx.config();
        if (cfg.isStoreKeepBinary().booleanValue() && cfg.isStoreKeepBinary() != CacheConfiguration.DFLT_STORE_KEEP_BINARY && !(this.ctx.config().getMarshaller() instanceof BinaryMarshaller)) {
            U.warn(this.log, "CacheConfiguration.isStoreKeepBinary() configuration property will be ignored because BinaryMarshaller is not used");
        }
        for (GridCacheManager<?, ?> mgr : F.view(cacheCtx.managers(), F.notContains(this.dhtExcludes(cacheCtx)))) {
            mgr.start(cacheCtx);
        }
        cacheCtx.initConflictResolver();
        if (cfg.getCacheMode() != CacheMode.LOCAL && GridCacheUtils.isNearEnabled(cfg)) {
            GridCacheContext dhtCtx = cacheCtx.near().dht().context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.start(dhtCtx);
            }
            dhtCtx.initConflictResolver();
            dhtCtx.cache().start();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started DHT cache: " + dhtCtx.cache().name());
            }
        }
        this.ctx.continuous().onCacheStart(cacheCtx);
        cacheCtx.cache().start();
        this.ctx.query().onCacheStart(cacheCtx, schema);
        cacheCtx.onStarted();
        String memPlcName = cfg.getDataRegionName();
        if (memPlcName == null && this.ctx.config().getDataStorageConfiguration() != null) {
            memPlcName = this.ctx.config().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Started cache [name=" + cfg.getName() + ", id=" + cacheCtx.cacheId() + (cfg.getGroupName() != null ? ", group=" + cfg.getGroupName() : "") + ", memoryPolicyName=" + memPlcName + ", mode=" + (Object)((Object)cfg.getCacheMode()) + ", atomicity=" + (Object)((Object)cfg.getAtomicityMode()) + ", backups=" + cfg.getBackups() + ", mvcc=" + cacheCtx.mvccEnabled() + ']' + ", encryptionEnabled=" + cfg.isEncryptionEnabled() + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCache(GridCacheAdapter<?, ?> cache, boolean cancel, boolean destroy) {
        GridCacheContext<?, ?> ctx = cache.context();
        try {
            IgnitePageStoreManager pageStore;
            GridDhtCacheAdapter<?, ?> dht;
            if (!cache.isNear() && ctx.shared().wal() != null) {
                try {
                    ctx.shared().wal().flush(null, false);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to flush write-ahead log on cache stop [cache=" + ctx.name() + "]", e);
                }
            }
            this.sharedCtx.removeCacheContext(ctx);
            cache.stop();
            ctx.kernalContext().query().onCacheStop(ctx, !cache.context().group().persistenceEnabled() || destroy);
            if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
                dht.stop();
                GridCacheContext dhtCtx = dht.context();
                List<GridCacheManager> dhtMgrs = this.dhtManagers(dhtCtx);
                ListIterator<GridCacheManager> it = dhtMgrs.listIterator(dhtMgrs.size());
                while (it.hasPrevious()) {
                    GridCacheManager mgr = it.previous();
                    mgr.stop(cancel, destroy);
                }
            }
            List<GridCacheManager<?, ?>> mgrs = ctx.managers();
            Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
            ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager<?, ?> mgr = it.previous();
                if (excludes.contains(mgr)) continue;
                mgr.stop(cancel, destroy);
            }
            ctx.kernalContext().continuous().onCacheStop(ctx);
            ctx.kernalContext().cache().context().snapshot().onCacheStop(ctx);
            ctx.group().stopCache(ctx, destroy);
            U.stopLifecycleAware(this.log, this.lifecycleAwares(ctx.group(), cache.configuration(), ctx.store().configuredStore()));
            if (destroy && (pageStore = this.sharedCtx.pageStore()) != null) {
                try {
                    pageStore.removeCacheData(new StoredCacheData(ctx.config()));
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to delete cache configuration data while destroying cache[cache=" + ctx.name() + "]", e);
                }
            }
            if (this.log.isInfoEnabled()) {
                if (ctx.group().sharedGroup()) {
                    this.log.info("Stopped cache [cacheName=" + cache.name() + ", group=" + ctx.group().name() + ']');
                } else {
                    this.log.info("Stopped cache [cacheName=" + cache.name() + ']');
                }
            }
        }
        finally {
            this.cleanup(ctx);
        }
    }

    public void awaitStarted() throws IgniteCheckedException {
        U.await(this.cacheStartedLatch);
    }

    private void onKernalStart(GridCacheAdapter<?, ?> cache) throws IgniteCheckedException {
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx)) {
            GridDhtCacheAdapter<?, ?> dht = ctx.near().dht();
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStart();
            }
            dht.onKernalStart();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executed onKernalStart() callback for DHT cache: " + dht.name());
            }
        }
        for (GridCacheManager<?, ?> mgr : F.view(ctx.managers(), F0.notContains(this.dhtExcludes(ctx)))) {
            mgr.onKernalStart();
        }
        cache.onKernalStart();
        if (ctx.events().isRecordable(98)) {
            ctx.events().addEvent(98);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executed onKernalStart() callback for cache [name=" + cache.name() + ", mode=" + (Object)((Object)cache.configuration().getCacheMode()) + ']');
        }
    }

    private void onKernalStop(GridCacheAdapter<?, ?> cache, boolean cancel) {
        GridDhtCacheAdapter<?, ?> dht;
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStop(cancel);
            }
            dht.onKernalStop();
        }
        List<GridCacheManager<?, ?>> mgrs = ctx.managers();
        Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
        ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheManager mgr;
            mgr = it.previous();
            if (excludes.contains(mgr)) continue;
            mgr.onKernalStop(cancel);
        }
        cache.onKernalStop();
        if (ctx.events().isRecordable(99)) {
            ctx.events().addEvent(99);
        }
    }

    private GridCacheContext createCache(CacheConfiguration<?, ?> cfg, CacheGroupContext grp, @Nullable CachePluginManager pluginMgr, DynamicCacheDescriptor desc, AffinityTopologyVersion locStartTopVer, CacheObjectContext cacheObjCtx, boolean affNode, boolean updatesAllowed, boolean disabledAfterStart) throws IgniteCheckedException {
        assert (cfg != null);
        if (cfg.getCacheStoreFactory() instanceof GridCacheLoaderWriterStoreFactory) {
            GridCacheLoaderWriterStoreFactory factory = (GridCacheLoaderWriterStoreFactory)cfg.getCacheStoreFactory();
            this.prepare(cfg, factory.loaderFactory(), false);
            this.prepare(cfg, factory.writerFactory(), false);
        } else {
            this.prepare(cfg, cfg.getCacheStoreFactory(), false);
        }
        CacheStore cfgStore = cfg.getCacheStoreFactory() != null ? (CacheStore)cfg.getCacheStoreFactory().create() : null;
        this.validate(this.ctx.config(), cfg, desc.cacheType(), cfgStore);
        if (pluginMgr == null) {
            pluginMgr = new CachePluginManager(this.ctx, cfg);
        }
        pluginMgr.validate();
        if (cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            this.sharedCtx.coordinators().ensureStarted();
        }
        this.sharedCtx.jta().registerCache(cfg);
        if (desc.cacheType().userCache()) {
            this.suggestOptimizations(cfg, cfgStore != null);
        }
        ArrayList<Object> toPrepare = new ArrayList<Object>();
        if (cfgStore instanceof GridCacheLoaderWriterStore) {
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).loader());
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).writer());
        } else {
            toPrepare.add(cfgStore);
        }
        this.prepare(cfg, toPrepare);
        U.startLifecycleAware(this.lifecycleAwares(grp, cfg, cfgStore));
        boolean nearEnabled = GridCacheUtils.isNearEnabled(cfg);
        GridCacheAffinityManager affMgr = new GridCacheAffinityManager();
        GridCacheEventManager evtMgr = new GridCacheEventManager();
        GridCacheManagerAdapter evictMgr = nearEnabled || cfg.isOnheapCacheEnabled() ? new GridCacheEvictionManager() : new CacheOffheapEvictionManager();
        GridCacheQueryManager qryMgr = this.queryManager(cfg);
        CacheContinuousQueryManager contQryMgr = new CacheContinuousQueryManager();
        CacheDataStructuresManager dataStructuresMgr = new CacheDataStructuresManager();
        GridCacheTtlManager ttlMgr = new GridCacheTtlManager();
        CacheConflictResolutionManager rslvrMgr = pluginMgr.createComponent(CacheConflictResolutionManager.class);
        GridCacheDrManager drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
        CacheStoreManager storeMgr = pluginMgr.createComponent(CacheStoreManager.class);
        storeMgr.initialize(cfgStore, this.sesHolders);
        GridCacheContext cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, grp, desc.cacheType(), locStartTopVer, affNode, updatesAllowed, evtMgr, storeMgr, (CacheEvictionManager)((Object)evictMgr), qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr);
        cacheCtx.statisticsEnabled(desc.cacheConfiguration().isStatisticsEnabled());
        cacheCtx.cacheObjectContext(cacheObjCtx);
        GridCacheAdapter cache = null;
        block0 : switch (cfg.getCacheMode()) {
            case LOCAL: {
                switch (cfg.getAtomicityMode()) {
                    case TRANSACTIONAL: 
                    case TRANSACTIONAL_SNAPSHOT: {
                        cache = new GridLocalCache(cacheCtx);
                        break block0;
                    }
                    case ATOMIC: {
                        cache = new GridLocalAtomicCache(cacheCtx);
                        break block0;
                    }
                }
                assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                break;
            }
            case PARTITIONED: 
            case REPLICATED: {
                if (nearEnabled) {
                    switch (cfg.getAtomicityMode()) {
                        case TRANSACTIONAL: 
                        case TRANSACTIONAL_SNAPSHOT: {
                            cache = new GridNearTransactionalCache(cacheCtx);
                            break block0;
                        }
                        case ATOMIC: {
                            cache = new GridNearAtomicCache(cacheCtx);
                            break block0;
                        }
                    }
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
                switch (cfg.getAtomicityMode()) {
                    case TRANSACTIONAL: 
                    case TRANSACTIONAL_SNAPSHOT: {
                        cache = cacheCtx.affinityNode() ? new GridDhtColocatedCache(cacheCtx) : new GridDhtColocatedCache(cacheCtx, new GridNoStorageCacheMap());
                        break block0;
                    }
                    case ATOMIC: {
                        cache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap());
                        break block0;
                    }
                }
                assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                break;
            }
            default: {
                assert (false) : "Invalid cache mode: " + (Object)((Object)cfg.getCacheMode());
                break;
            }
        }
        cache.active(!disabledAfterStart);
        cacheCtx.cache(cache);
        GridCacheContext ret = cacheCtx;
        if (cfg.getCacheMode() != CacheMode.LOCAL && nearEnabled) {
            evictMgr = cfg.isOnheapCacheEnabled() ? new GridCacheEvictionManager() : new CacheOffheapEvictionManager();
            evtMgr = new GridCacheEventManager();
            pluginMgr = new CachePluginManager(this.ctx, cfg);
            drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
            cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, grp, desc.cacheType(), locStartTopVer, affNode, true, evtMgr, storeMgr, (CacheEvictionManager)((Object)evictMgr), qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr);
            cacheCtx.statisticsEnabled(desc.cacheConfiguration().isStatisticsEnabled());
            cacheCtx.cacheObjectContext(cacheObjCtx);
            GridDhtCacheAdapter dht = null;
            switch (cfg.getAtomicityMode()) {
                case TRANSACTIONAL: 
                case TRANSACTIONAL_SNAPSHOT: {
                    assert (cache instanceof GridNearTransactionalCache);
                    GridNearTransactionalCache near = (GridNearTransactionalCache)cache;
                    GridDhtCache dhtCache = cacheCtx.affinityNode() ? new GridDhtCache(cacheCtx) : new GridDhtCache(cacheCtx, new GridNoStorageCacheMap());
                    dhtCache.near(near);
                    near.dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                case ATOMIC: {
                    assert (cache instanceof GridNearAtomicCache);
                    GridNearAtomicCache near = (GridNearAtomicCache)cache;
                    GridDhtAtomicCache dhtCache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap());
                    dhtCache.near(near);
                    near.dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                default: {
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
            }
            cacheCtx.cache(dht);
        }
        if (!CU.isUtilityCache(cache.name()) && !CU.isSystemCache(cache.name())) {
            this.registerMbean(cache.localMxBean(), cache.name(), false);
            this.registerMbean(cache.clusterMxBean(), cache.name(), false);
        }
        return ret;
    }

    public void registrateProxyRestart(Map<String, DynamicCacheChangeRequest> reqs, GridFutureAdapter<?> fut) {
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            if (!reqs.containsKey(proxy.getName()) || !proxy.isRestarting() || reqs.get(proxy.getName()).disabledAfterStart()) continue;
            proxy.registrateFutureRestart(fut);
        }
    }

    public void completeProxyRestart(Map<String, DynamicCacheChangeRequest> reqs, AffinityTopologyVersion initVer, AffinityTopologyVersion doneVer) {
        if (initVer == null || doneVer == null) {
            return;
        }
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<?, ?> cacheCtx = cache.context();
            if (reqs.containsKey(cache.name()) || cacheCtx.startTopologyVersion().compareTo(initVer) <= 0 || cacheCtx.startTopologyVersion().compareTo(doneVer) <= 0) {
                this.completeProxyInitialize(cache.name());
            }
            if (cacheCtx.startTopologyVersion().compareTo(initVer) < 0 || cacheCtx.startTopologyVersion().compareTo(doneVer) > 0) continue;
            IgniteCacheProxyImpl<?, ?> proxy = this.jCacheProxies.get(cache.name());
            boolean canRestart = true;
            DynamicCacheChangeRequest req = reqs.get(cache.name());
            if (req != null) {
                boolean bl = canRestart = !req.disabledAfterStart();
            }
            if (proxy == null || !proxy.isRestarting() || !canRestart) continue;
            proxy.onRestarted(cacheCtx, cache);
            if (!cacheCtx.dataStructuresCache()) continue;
            this.ctx.dataStructures().restart(proxy.internalProxy());
        }
    }

    public Collection<String> cacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate[0]);
    }

    public IgniteCacheProxy<?, ?> getOrStartPublicCache(boolean start, boolean inclLoc) throws IgniteCheckedException {
        for (Map.Entry<String, GridCacheAdapter<?, ?>> entry : this.caches.entrySet()) {
            if (!entry.getValue().context().userCache()) continue;
            CacheConfiguration ccfg = entry.getValue().configuration();
            String cacheName = ccfg.getName();
            if (!inclLoc && ccfg.getCacheMode() == CacheMode.LOCAL) continue;
            return this.publicJCache(cacheName);
        }
        if (start) {
            for (Map.Entry<String, GridCacheAdapter<Object, Object>> entry : this.cachesInfo.registeredCaches().entrySet()) {
                CacheConfiguration ccfg;
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)((Object)entry.getValue());
                if (!desc.cacheType().userCache() || (ccfg = desc.cacheConfiguration()).getCacheMode() == CacheMode.LOCAL) continue;
                this.dynamicStartCache(null, ccfg.getName(), null, false, true, true).get();
                return this.publicJCache(ccfg.getName());
            }
        }
        return null;
    }

    public Collection<String> publicCacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache();
            }
        });
    }

    public Collection<String> publicAndDsCacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES;
            }
        });
    }

    public CacheMode cacheMode(String cacheName) {
        assert (cacheName != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(cacheName);
        return desc != null ? desc.cacheConfiguration().getCacheMode() : null;
    }

    @Nullable
    public LocalJoinCachesContext localJoinCachesContext() {
        return this.cachesInfo.localJoinCachesContext();
    }

    public IgniteInternalFuture<?> startCachesOnLocalJoin(AffinityTopologyVersion exchTopVer, LocalJoinCachesContext locJoinCtx) throws IgniteCheckedException {
        long time = System.currentTimeMillis();
        if (locJoinCtx == null) {
            return new GridFinishedFuture();
        }
        IgniteInternalFuture<?> res = this.sharedCtx.affinity().initCachesOnLocalJoin(locJoinCtx.cacheGroupDescriptors(), locJoinCtx.cacheDescriptors());
        for (T2<DynamicCacheDescriptor, NearCacheConfiguration> t : locJoinCtx.caches()) {
            DynamicCacheDescriptor desc = (DynamicCacheDescriptor)t.get1();
            this.prepareCacheStart(desc.cacheConfiguration(), desc, (NearCacheConfiguration)t.get2(), exchTopVer, false);
            this.context().exchange().exchangerUpdateHeartbeat();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting caches on local join performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
        return res;
    }

    boolean hasCachesReceivedFromJoin(ClusterNode node) {
        return this.cachesInfo.hasCachesReceivedFromJoin(node.id());
    }

    public Collection<DynamicCacheDescriptor> startReceivedCaches(UUID nodeId, AffinityTopologyVersion exchTopVer) throws IgniteCheckedException {
        List<DynamicCacheDescriptor> started = this.cachesInfo.cachesReceivedFromJoin(nodeId);
        for (DynamicCacheDescriptor desc : started) {
            IgnitePredicate<ClusterNode> filter = desc.groupDescriptor().config().getNodeFilter();
            if (!CU.affinityNode(this.ctx.discovery().localNode(), filter)) continue;
            this.prepareCacheStart(desc.cacheConfiguration(), desc, null, exchTopVer, false);
            this.context().exchange().exchangerUpdateHeartbeat();
        }
        return started;
    }

    void prepareCacheStart(CacheConfiguration startCfg, DynamicCacheDescriptor desc, @Nullable NearCacheConfiguration reqNearCfg, AffinityTopologyVersion exchTopVer, boolean disabledAfterStart) throws IgniteCheckedException {
        boolean affNode;
        assert (!this.caches.containsKey(startCfg.getName())) : startCfg.getName();
        CacheConfiguration ccfg = new CacheConfiguration(startCfg);
        CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(ccfg);
        if (ccfg.getCacheMode() == CacheMode.LOCAL) {
            affNode = true;
            ccfg.setNearConfiguration(null);
        } else if (CU.affinityNode(this.ctx.discovery().localNode(), desc.groupDescriptor().config().getNodeFilter())) {
            affNode = true;
        } else {
            affNode = false;
            ccfg.setNearConfiguration(reqNearCfg);
        }
        if (this.sharedCtx.pageStore() != null && affNode) {
            this.sharedCtx.pageStore().initializeForCache(desc.groupDescriptor(), desc.toStoredData());
        }
        String grpName = startCfg.getGroupName();
        CacheGroupContext grp = null;
        if (grpName != null) {
            for (CacheGroupContext grp0 : this.cacheGrps.values()) {
                if (!grp0.sharedGroup() || !grpName.equals(grp0.name())) continue;
                grp = grp0;
                break;
            }
            if (grp == null) {
                grp = this.startCacheGroup(desc.groupDescriptor(), desc.cacheType(), affNode, cacheObjCtx, exchTopVer);
            }
        } else {
            grp = this.startCacheGroup(desc.groupDescriptor(), desc.cacheType(), affNode, cacheObjCtx, exchTopVer);
        }
        GridCacheContext cacheCtx = this.createCache(ccfg, grp, null, desc, exchTopVer, cacheObjCtx, affNode, true, disabledAfterStart);
        cacheCtx.dynamicDeploymentId(desc.deploymentId());
        GridCacheAdapter cache = cacheCtx.cache();
        this.sharedCtx.addCacheContext(cacheCtx);
        this.caches.put(cacheCtx.name(), cache);
        this.startCache(cache, desc.schema() != null ? desc.schema() : new QuerySchema());
        grp.onCacheStarted(cacheCtx);
        this.onKernalStart(cache);
    }

    public void restartProxies() {
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            GridCacheContext<?, ?> cacheCtx;
            if (proxy == null || (cacheCtx = this.sharedCtx.cacheContext(CU.cacheId(proxy.getName()))) == null || !proxy.isRestarting()) continue;
            this.caches.get(proxy.getName()).active(true);
            proxy.onRestarted(cacheCtx, cacheCtx.cache());
            if (!cacheCtx.dataStructuresCache()) continue;
            this.ctx.dataStructures().restart(proxy.internalProxy());
        }
    }

    private CacheGroupContext startCacheGroup(CacheGroupDescriptor desc, CacheType cacheType, boolean affNode, CacheObjectContext cacheObjCtx, AffinityTopologyVersion exchTopVer) throws IgniteCheckedException {
        CacheConfiguration cfg = new CacheConfiguration((CompleteConfiguration<?, ?>)desc.config());
        String memPlcName = cfg.getDataRegionName();
        DataRegion dataRegion = this.sharedCtx.database().dataRegion(memPlcName);
        FreeList freeList = this.sharedCtx.database().freeList(memPlcName);
        ReuseList reuseList = this.sharedCtx.database().reuseList(memPlcName);
        boolean persistenceEnabled = this.sharedCtx.localNode().isClient() ? desc.persistenceEnabled() : dataRegion != null && dataRegion.config().isPersistenceEnabled();
        CacheGroupContext grp = new CacheGroupContext(this.sharedCtx, desc.groupId(), desc.receivedFrom(), cacheType, cfg, affNode, dataRegion, cacheObjCtx, freeList, reuseList, exchTopVer, persistenceEnabled, desc.walEnabled());
        for (Object obj : grp.configuredUserObjects()) {
            this.prepare(cfg, obj, false);
        }
        U.startLifecycleAware(grp.configuredUserObjects());
        grp.start();
        CacheGroupContext old = this.cacheGrps.put(desc.groupId(), grp);
        if (!grp.systemCache() && !U.IGNITE_MBEANS_DISABLED) {
            try {
                U.registerMBean(this.ctx.config().getMBeanServer(), this.ctx.igniteInstanceName(), "Cache groups", grp.cacheOrGroupName(), grp.mxBean(), CacheGroupMetricsMXBean.class);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to register MBean for cache group: " + grp.name(), e);
            }
        }
        assert (old == null) : old.name();
        return grp;
    }

    void blockGateway(String cacheName, boolean stop, boolean restart) {
        GridCacheAdapter<?, ?> cache;
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, false);
        if (restart && (cache = this.caches.get(cacheName)) != null) {
            cache.active(false);
        }
        if (proxy != null) {
            if (stop) {
                if (restart) {
                    proxy.restart();
                }
                proxy.context().gate().stopped();
            } else {
                proxy.closeProxy();
            }
        }
    }

    private void stopGateway(DynamicCacheChangeRequest req) {
        IgniteCacheProxyImpl<?, ?> proxy;
        assert (req.stop()) : req;
        if (req.restart()) {
            GridCacheAdapter<?, ?> cache;
            if (DataStructuresProcessor.isDataStructureCache(req.cacheName())) {
                this.ctx.dataStructures().suspend(req.cacheName());
            }
            if ((cache = this.caches.get(req.cacheName())) != null) {
                cache.active(false);
            }
            if ((proxy = this.jCacheProxies.get(req.cacheName())) != null) {
                proxy.restart();
            }
        } else {
            this.completeProxyInitialize(req.cacheName());
            proxy = this.jCacheProxies.remove(req.cacheName());
        }
        if (proxy != null) {
            proxy.context().gate().onStopped();
        }
    }

    private GridCacheContext<?, ?> prepareCacheStop(String cacheName, boolean destroy) {
        assert (this.sharedCtx.database().checkpointLockIsHeldByThread());
        GridCacheAdapter<?, ?> cache = this.caches.remove(cacheName);
        if (cache != null) {
            GridCacheContext<?, ?> ctx = cache.context();
            this.sharedCtx.removeCacheContext(ctx);
            this.onKernalStop(cache, true);
            this.stopCache(cache, true, destroy);
            return ctx;
        }
        return null;
    }

    void initCacheProxies(AffinityTopologyVersion startTopVer, @Nullable Throwable err) {
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<?, ?> cacheCtx = cache.context();
            if (!cacheCtx.startTopologyVersion().equals(startTopVer)) continue;
            if (!this.jCacheProxies.containsKey(cacheCtx.name())) {
                IgniteCacheProxyImpl newProxy = new IgniteCacheProxyImpl(cache.context(), cache, false);
                if (!cache.active()) {
                    newProxy.restart();
                }
                this.addjCacheProxy(cacheCtx.name(), newProxy);
            }
            if (cacheCtx.preloader() == null) continue;
            cacheCtx.preloader().onInitialExchangeComplete(err);
        }
    }

    Set<Integer> closeCaches(Set<String> cachesToClose, boolean retClientCaches) {
        HashSet ids = null;
        for (String cacheName : cachesToClose) {
            this.completeProxyInitialize(cacheName);
            this.blockGateway(cacheName, false, false);
            GridCacheContext<?, ?> ctx = this.sharedCtx.cacheContext(CU.cacheId(cacheName));
            if (ctx == null) continue;
            if (retClientCaches && !ctx.affinityNode()) {
                if (ids == null) {
                    ids = U.newHashSet(cachesToClose.size());
                }
                ids.add(ctx.cacheId());
            }
            this.closeCache(ctx);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCache(GridCacheContext cctx) {
        if (cctx.affinityNode()) {
            GridCacheAdapter<?, ?> cache = this.caches.get(cctx.name());
            assert (cache != null) : cctx.name();
            this.jCacheProxies.put(cctx.name(), new IgniteCacheProxyImpl(cache.context(), cache, false));
            this.completeProxyInitialize(cctx.name());
        } else {
            cctx.gate().onStopped();
            this.sharedCtx.io().writeLock();
            try {
                if (!cctx.affinityNode() && cctx.transactional()) {
                    this.sharedCtx.tm().rollbackTransactionsForCache(cctx.cacheId());
                }
                this.completeProxyInitialize(cctx.name());
                this.jCacheProxies.remove(cctx.name());
                this.sharedCtx.database().checkpointReadLock();
                try {
                    this.prepareCacheStop(cctx.name(), false);
                }
                finally {
                    this.sharedCtx.database().checkpointReadUnlock();
                }
                if (!cctx.group().hasCaches()) {
                    this.stopCacheGroup(cctx.group().groupId());
                }
            }
            finally {
                this.sharedCtx.io().writeUnlock();
            }
        }
    }

    void forceCloseCaches(ExchangeActions exchActions) {
        assert (exchActions != null && !exchActions.cacheStopRequests().isEmpty());
        this.processCacheStopRequestOnExchangeDone(exchActions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCacheStopRequestOnExchangeDone(ExchangeActions exchActions) {
        if (!exchActions.cacheStopRequests().isEmpty()) {
            try {
                this.sharedCtx.database().waitForCheckpoint("caches stop");
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to wait for checkpoint finish during cache stop.", e);
            }
        }
        for (ExchangeActions.CacheActionData cacheActionData : exchActions.cacheStopRequests()) {
            CacheGroupContext gctx = (CacheGroupContext)this.cacheGrps.get(cacheActionData.descriptor().groupId());
            if (gctx != null) {
                String msg = "Failed to wait for topology update, cache group is stopping.";
                gctx.affinity().cancelFutures(new CacheStoppedException("Failed to wait for topology update, cache group is stopping."));
            }
            this.stopGateway(cacheActionData.request());
            this.sharedCtx.database().checkpointReadLock();
            try {
                this.prepareCacheStop(cacheActionData.request().cacheName(), cacheActionData.request().destroy());
            }
            finally {
                this.sharedCtx.database().checkpointReadUnlock();
            }
        }
        this.sharedCtx.database().checkpointReadLock();
        try {
            for (ExchangeActions.CacheGroupActionData cacheGroupActionData : exchActions.cacheGroupsToStop()) {
                Integer groupId = cacheGroupActionData.descriptor().groupId();
                CacheGroupContext grp = (CacheGroupContext)this.cacheGrps.get(groupId);
                if (grp == null || !grp.persistenceEnabled() || !(this.sharedCtx.database() instanceof GridCacheDatabaseSharedManager)) continue;
                GridCacheDatabaseSharedManager mngr = (GridCacheDatabaseSharedManager)this.sharedCtx.database();
                mngr.removeCheckpointListener((DbCheckpointListener)((Object)grp.offheap()));
            }
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
        ArrayList<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGroups = new ArrayList<IgniteBiTuple<CacheGroupContext, Boolean>>();
        for (ExchangeActions.CacheGroupActionData action : exchActions.cacheGroupsToStop()) {
            Integer groupId = action.descriptor().groupId();
            if (!this.cacheGrps.containsKey(groupId)) continue;
            stoppedGroups.add(F.t(this.cacheGrps.get(groupId), action.destroy()));
            this.stopCacheGroup(groupId);
        }
        if (!this.sharedCtx.kernalContext().clientNode()) {
            this.sharedCtx.database().onCacheGroupsStopped(stoppedGroups);
        }
        if (exchActions.deactivate()) {
            this.sharedCtx.deactivate();
        }
    }

    public void onExchangeDone(AffinityTopologyVersion cacheStartVer, @Nullable ExchangeActions exchActions, @Nullable Throwable err) {
        this.initCacheProxies(cacheStartVer, err);
        if (exchActions == null) {
            return;
        }
        if (exchActions.systemCachesStarting() && exchActions.stateChangeRequest() == null) {
            this.ctx.dataStructures().restoreStructuresState(this.ctx);
            this.ctx.service().updateUtilityCache();
        }
        if (err == null) {
            this.processCacheStopRequestOnExchangeDone(exchActions);
        }
    }

    private void stopCacheGroup(int grpId) {
        CacheGroupContext grp = (CacheGroupContext)this.cacheGrps.remove(grpId);
        if (grp != null) {
            this.stopCacheGroup(grp);
        }
    }

    private void stopCacheGroup(CacheGroupContext grp) {
        grp.stopGroup();
        U.stopLifecycleAware(this.log, grp.configuredUserObjects());
        this.cleanup(grp);
    }

    void completeTemplateAddFuture(String cacheName, IgniteUuid deploymentId) {
        TemplateConfigurationFuture fut = (TemplateConfigurationFuture)this.pendingTemplateFuts.get(cacheName);
        if (fut != null && fut.deploymentId().equals(deploymentId)) {
            fut.onDone();
        }
    }

    void completeCacheStartFuture(DynamicCacheChangeRequest req, boolean success, @Nullable Throwable err) {
        DynamicCacheStartFuture fut;
        if (this.ctx.localNodeId().equals(req.initiatingNodeId()) && (fut = (DynamicCacheStartFuture)this.pendingFuts.get(req.requestId())) != null) {
            fut.onDone(success, err);
        }
    }

    void completeClientCacheChangeFuture(UUID reqId, @Nullable Exception err) {
        DynamicCacheStartFuture fut = (DynamicCacheStartFuture)this.pendingFuts.get(reqId);
        if (fut != null) {
            fut.onDone(false, (Throwable)err);
        }
    }

    private GridCacheSharedContext createSharedContext(GridKernalContext kernalCtx, Collection<CacheStoreSessionListener> storeSesLsnrs) throws IgniteCheckedException {
        IgniteCacheDatabaseSharedManager dbMgr;
        IgniteTxManager tm = new IgniteTxManager();
        GridCacheMvccManager mvccMgr = new GridCacheMvccManager();
        GridCacheVersionManager verMgr = new GridCacheVersionManager();
        GridCacheDeploymentManager depMgr = new GridCacheDeploymentManager();
        GridCachePartitionExchangeManager exchMgr = new GridCachePartitionExchangeManager();
        IgnitePageStoreManager pageStoreMgr = null;
        IgniteWriteAheadLogManager walMgr = null;
        if (CU.isPersistenceEnabled(this.ctx.config()) && !this.ctx.clientNode()) {
            dbMgr = new GridCacheDatabaseSharedManager(this.ctx);
            pageStoreMgr = this.ctx.plugins().createComponent(IgnitePageStoreManager.class);
            if (pageStoreMgr == null) {
                pageStoreMgr = new FilePageStoreManager(this.ctx);
            }
            if ((walMgr = this.ctx.plugins().createComponent(IgniteWriteAheadLogManager.class)) == null) {
                walMgr = this.ctx.config().getDataStorageConfiguration().getWalMode() == WALMode.FSYNC && !this.walFsyncWithDedicatedWorker ? new FsyncModeFileWriteAheadLogManager(this.ctx) : new FileWriteAheadLogManager(this.ctx);
            }
        } else {
            if (CU.isPersistenceEnabled(this.ctx.config()) && this.ctx.clientNode()) {
                U.warn(this.log, "Persistent Store is not supported on client nodes (Persistent Store's configuration will be ignored).");
            }
            dbMgr = new IgniteCacheDatabaseSharedManager();
        }
        WalStateManager walStateMgr = new WalStateManager(this.ctx);
        IgniteCacheSnapshotManager snpMgr = this.ctx.plugins().createComponent(IgniteCacheSnapshotManager.class);
        if (snpMgr == null) {
            snpMgr = new IgniteCacheSnapshotManager();
        }
        GridCacheIoManager ioMgr = new GridCacheIoManager();
        CacheAffinitySharedManager topMgr = new CacheAffinitySharedManager();
        GridCacheSharedTtlCleanupManager ttl = new GridCacheSharedTtlCleanupManager();
        PartitionsEvictManager evict = new PartitionsEvictManager();
        CacheJtaManagerAdapter jta = (CacheJtaManagerAdapter)IgniteComponentType.JTA.createOptional();
        MvccCachingManager mvccCachingMgr = new MvccCachingManager();
        return new GridCacheSharedContext(kernalCtx, tm, verMgr, mvccMgr, pageStoreMgr, walMgr, walStateMgr, dbMgr, snpMgr, depMgr, exchMgr, topMgr, ioMgr, ttl, evict, jta, storeSesLsnrs, mvccCachingMgr);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CACHE_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        this.cachesInfo.collectJoiningNodeData(dataBag);
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        this.cachesInfo.collectGridNodeData(dataBag);
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        this.cachesInfo.onJoiningNodeDataReceived(data);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.cachesInfo.onGridDataReceived(data);
        this.sharedCtx.walState().onCachesInfoCollected();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        if (!this.cachesInfo.isMergeConfigSupports(node)) {
            return null;
        }
        if (discoData.hasJoiningNodeData() && discoData.joiningNodeData() instanceof CacheJoinNodeDiscoveryData) {
            CacheJoinNodeDiscoveryData nodeData = (CacheJoinNodeDiscoveryData)discoData.joiningNodeData();
            boolean isGridActive = this.ctx.state().clusterState().active();
            StringBuilder errorMessage = new StringBuilder();
            for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : nodeData.caches().values()) {
                QuerySchemaPatch schemaPatch;
                DynamicCacheDescriptor localDesc;
                try {
                    SecurityContext secCtx;
                    byte[] secCtxBytes = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
                    if (secCtxBytes != null && (secCtx = (SecurityContext)U.unmarshal(this.marsh, secCtxBytes, U.resolveClassLoader(this.ctx.config()))) != null && cacheInfo.cacheType() == CacheType.USER) {
                        this.authorizeCacheCreate(cacheInfo.cacheData().config(), secCtx);
                    }
                }
                catch (IgniteCheckedException | SecurityException ex) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                    errorMessage.append(ex.getMessage());
                }
                if ((localDesc = this.cacheDescriptor(cacheInfo.cacheData().config().getName())) == null || !(schemaPatch = localDesc.makeSchemaPatch(cacheInfo.cacheData().queryEntities())).hasConflicts() && (!isGridActive || schemaPatch.isEmpty())) continue;
                if (errorMessage.length() > 0) {
                    errorMessage.append("\n");
                }
                if (schemaPatch.hasConflicts()) {
                    errorMessage.append(String.format(MERGE_OF_CONFIG_CONFLICTS_MESSAGE, localDesc.cacheName(), schemaPatch.getConflictsMessage()));
                    continue;
                }
                errorMessage.append(String.format(MERGE_OF_CONFIG_REQUIRED_MESSAGE, localDesc.cacheName()));
            }
            if (errorMessage.length() > 0) {
                String msg = errorMessage.toString();
                return new IgniteNodeValidationResult(node.id(), msg, msg);
            }
        }
        return null;
    }

    public void onStateChangeFinish(ChangeGlobalStateFinishMessage msg) {
        this.cachesInfo.onStateChangeFinish(msg);
    }

    public ExchangeActions onStateChangeRequest(ChangeGlobalStateMessage msg, AffinityTopologyVersion topVer, DiscoveryDataClusterState curState) throws IgniteCheckedException {
        return this.cachesInfo.onStateChangeRequest(msg, topVer, curState);
    }

    public void onCacheStatisticsModeChange(CacheStatisticsModeChangeMessage msg) {
        assert (msg != null);
        if (msg.initial()) {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null && !this.cacheNames().containsAll(msg.caches())) {
                fut.onDone(new IgniteCheckedException("One or more cache descriptors not found [caches=" + this.caches + ']'));
                return;
            }
            for (String cacheName : msg.caches()) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.cachesInfo.registeredCaches().get(cacheName);
                if (desc != null) {
                    if (desc.cacheConfiguration().isStatisticsEnabled() == msg.enabled()) continue;
                    desc.cacheConfiguration().setStatisticsEnabled(msg.enabled());
                    try {
                        this.ctx.cache().saveCacheConfiguration(desc);
                    }
                    catch (IgniteCheckedException e) {
                        this.log.error("Error while saving cache configuration to disk, cfg = " + (Object)((Object)desc.cacheConfiguration()), e);
                    }
                    continue;
                }
                this.log.warning("Failed to change cache descriptor configuration, cache not found [cacheName=" + cacheName + ']');
            }
        } else {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null) {
                fut.onDone();
            }
        }
    }

    private void onCacheStatisticsClear(CacheStatisticsClearMessage msg) {
        assert (msg != null);
        if (msg.initial()) {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null && !this.cacheNames().containsAll(msg.caches())) {
                fut.onDone(new IgniteCheckedException("One or more cache descriptors not found [caches=" + this.caches + ']'));
                return;
            }
            for (String cacheName : msg.caches()) {
                IgniteInternalCache cache = this.ctx.cache().cache(cacheName);
                if (cache != null) {
                    cache.localMxBean().clear();
                    continue;
                }
                this.log.warning("Failed to clear cache statistics, cache not found [cacheName=" + cacheName + ']');
            }
        } else {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null) {
                fut.onDone();
            }
        }
    }

    public void processStatisticsModeChange(CacheStatisticsModeChangeMessage msg) {
        assert (msg != null);
        for (String cacheName : msg.caches()) {
            IgniteInternalCache cache = this.cache(cacheName);
            if (cache != null) {
                cache.context().statisticsEnabled(msg.enabled());
                continue;
            }
            this.log.warning("Failed to change cache configuration, cache not found [cacheName=" + cacheName + ']');
        }
    }

    public void onTxTimeoutOnPartitionMapExchangeChange(TxTimeoutOnPartitionMapExchangeChangeMessage msg) {
        assert (msg != null);
        if (msg.isInit()) {
            TransactionConfiguration cfg = this.ctx.config().getTransactionConfiguration();
            if (cfg.getTxTimeoutOnPartitionMapExchange() != msg.getTimeout()) {
                cfg.setTxTimeoutOnPartitionMapExchange(msg.getTimeout());
            }
        } else {
            TxTimeoutOnPartitionMapExchangeChangeFuture fut = (TxTimeoutOnPartitionMapExchangeChangeFuture)this.txTimeoutOnPartitionMapExchangeFuts.get(msg.getRequestId());
            if (fut != null) {
                fut.onDone();
            }
        }
    }

    public void processTxTimeoutOnPartitionMapExchangeChange(TxTimeoutOnPartitionMapExchangeChangeMessage msg) {
        assert (msg != null);
        long timeout = this.ctx.config().getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
        if (timeout != msg.getTimeout()) {
            this.ctx.config().getTransactionConfiguration().setTxTimeoutOnPartitionMapExchange(msg.getTimeout());
        }
    }

    private void stopCachesOnClientReconnect(Collection<GridCacheAdapter> stoppedCaches) {
        assert (this.ctx.discovery().localNode().isClient());
        for (GridCacheAdapter cache : stoppedCaches) {
            CacheGroupContext grp = cache.context().group();
            this.onKernalStop(cache, true);
            this.stopCache(cache, true, false);
            this.sharedCtx.affinity().stopCacheOnReconnect(cache.context());
            if (grp.hasCaches()) continue;
            this.stopCacheGroup(grp);
            this.sharedCtx.affinity().stopCacheGroupOnReconnect(grp);
        }
    }

    private boolean startAllCachesOnClientStart() {
        return this.startClientCaches && this.ctx.clientNode();
    }

    public IgniteInternalFuture<?> createFromTemplate(String cacheName) {
        try {
            CacheConfiguration cfg = this.getOrCreateConfigFromTemplate(cacheName);
            return this.dynamicStartCache(cfg, cacheName, null, true, true, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public IgniteInternalFuture<?> getOrCreateFromTemplate(String cacheName, boolean checkThreadTx) {
        return this.getOrCreateFromTemplate(cacheName, cacheName, null, checkThreadTx);
    }

    public IgniteInternalFuture<?> getOrCreateFromTemplate(String cacheName, String templateName, CacheConfigurationOverride cfgOverride, boolean checkThreadTx) {
        assert (cacheName != null);
        try {
            if (this.publicJCache(cacheName, false, checkThreadTx) != null) {
                return new GridFinishedFuture();
            }
            CacheConfiguration ccfg = F.isEmpty(templateName) ? this.getOrCreateConfigFromTemplate(cacheName) : this.getOrCreateConfigFromTemplate(templateName);
            ccfg.setName(cacheName);
            if (cfgOverride != null) {
                cfgOverride.apply(ccfg);
            }
            return this.dynamicStartCache(ccfg, cacheName, null, false, true, checkThreadTx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
    }

    public CacheConfiguration getConfigFromTemplate(String cacheName) throws IgniteCheckedException {
        CacheConfiguration cfgTemplate = null;
        CacheConfiguration dfltCacheCfg = null;
        ArrayList<CacheConfiguration> wildcardNameCfgs = null;
        for (DynamicCacheDescriptor desc : this.cachesInfo.registeredTemplates().values()) {
            assert (desc.template());
            CacheConfiguration cfg = desc.cacheConfiguration();
            assert (cfg != null);
            if (F.eq(cacheName, cfg.getName())) {
                cfgTemplate = cfg;
                break;
            }
            if (cfg.getName() != null) {
                if (!GridCacheUtils.isCacheTemplateName(cfg.getName())) continue;
                if (cfg.getName().length() > 1) {
                    if (wildcardNameCfgs == null) {
                        wildcardNameCfgs = new ArrayList<CacheConfiguration>();
                    }
                    wildcardNameCfgs.add(cfg);
                    continue;
                }
                dfltCacheCfg = cfg;
                continue;
            }
            if (dfltCacheCfg != null) continue;
            dfltCacheCfg = cfg;
        }
        if (cfgTemplate == null && cacheName != null && wildcardNameCfgs != null) {
            Collections.sort(wildcardNameCfgs, new Comparator<CacheConfiguration>(){

                @Override
                public int compare(CacheConfiguration cfg1, CacheConfiguration cfg2) {
                    Integer len1 = cfg1.getName() != null ? cfg1.getName().length() : 0;
                    Integer len2 = cfg2.getName() != null ? cfg2.getName().length() : 0;
                    return len2.compareTo(len1);
                }
            });
            for (CacheConfiguration cfg : wildcardNameCfgs) {
                if (!cacheName.startsWith(cfg.getName().substring(0, cfg.getName().length() - 1))) continue;
                cfgTemplate = cfg;
                break;
            }
        }
        if (cfgTemplate == null) {
            cfgTemplate = dfltCacheCfg;
        }
        if (cfgTemplate == null) {
            return null;
        }
        cfgTemplate = this.cloneCheckSerializable(cfgTemplate);
        CacheConfiguration cfg = new CacheConfiguration(cfgTemplate);
        cfg.setName(cacheName);
        return cfg;
    }

    private CacheConfiguration getOrCreateConfigFromTemplate(String cacheName) throws IgniteCheckedException {
        CacheConfiguration cfg = this.getConfigFromTemplate(cacheName);
        return cfg != null ? cfg : new CacheConfiguration(cacheName);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        return this.dynamicStartCache(ccfg, cacheName, nearCfg, CacheType.USER, false, failIfExists, failIfNotStarted, checkThreadTx);
    }

    public IgniteInternalFuture<Boolean> dynamicStartSqlCache(CacheConfiguration ccfg) {
        A.notNull((Object)ccfg, "ccfg");
        return this.dynamicStartCache(ccfg, ccfg.getName(), ccfg.getNearConfiguration(), CacheType.USER, true, false, true, true);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean sql, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        assert (cacheName != null);
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        GridPlainClosure<Collection<byte[]>, IgniteInternalFuture<Boolean>> startCacheClsr = grpKeys -> {
            assert (ccfg == null || !ccfg.isEncryptionEnabled() || !grpKeys.isEmpty());
            DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(ccfg, cacheName, nearCfg, cacheType, sql, failIfExists, failIfNotStarted, false, null, ccfg != null && ccfg.isEncryptionEnabled() ? (byte[])grpKeys.iterator().next() : null);
            if (req != null) {
                if (req.clientStartOnly()) {
                    return this.startClientCacheChange(F.asMap(req.cacheName(), req), null);
                }
                return F.first(this.initiateCacheChanges(F.asList(req)));
            }
            return new GridFinishedFuture();
        };
        try {
            if (ccfg != null && ccfg.isEncryptionEnabled()) {
                this.ctx.encryption().checkEncryptedCacheSupported();
                return this.generateEncryptionKeysAndStartCacheAfter(1, startCacheClsr);
            }
            return startCacheClsr.apply(Collections.EMPTY_SET);
        }
        catch (Exception e) {
            return new GridFinishedFuture<Boolean>(e);
        }
    }

    private IgniteInternalFuture<Boolean> generateEncryptionKeysAndStartCacheAfter(final int keyCnt, final GridPlainClosure<Collection<byte[]>, IgniteInternalFuture<Boolean>> after) {
        IgniteInternalFuture<Collection<byte[]>> genEncKeyFut = this.ctx.encryption().generateKeys(keyCnt);
        final GridFutureAdapter<Boolean> res = new GridFutureAdapter<Boolean>();
        genEncKeyFut.listen(new IgniteInClosure<IgniteInternalFuture<Collection<byte[]>>>(){

            @Override
            public void apply(IgniteInternalFuture<Collection<byte[]>> fut) {
                try {
                    Collection<byte[]> grpKeys = fut.result();
                    if (F.size(grpKeys, F.alwaysTrue()) != keyCnt) {
                        res.onDone(false, fut.error());
                    }
                    IgniteInternalFuture dynStartCacheFut = (IgniteInternalFuture)after.apply(grpKeys);
                    dynStartCacheFut.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Boolean> fut) {
                            try {
                                res.onDone(fut.get(), fut.error());
                            }
                            catch (IgniteCheckedException e) {
                                res.onDone(false, e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    res.onDone(false, e);
                }
            }
        });
        return res;
    }

    private IgniteInternalFuture<Boolean> startClientCacheChange(@Nullable Map<String, DynamicCacheChangeRequest> startReqs, @Nullable Set<String> cachesToClose) {
        assert (startReqs != null ^ cachesToClose != null);
        DynamicCacheStartFuture fut = new DynamicCacheStartFuture(UUID.randomUUID());
        IgniteInternalFuture old = this.pendingFuts.put(fut.id, fut);
        assert (old == null) : old;
        this.ctx.discovery().clientCacheStartEvent(fut.id, startReqs, cachesToClose);
        IgniteCheckedException err = this.checkNodeState();
        if (err != null) {
            fut.onDone(err);
        }
        return fut;
    }

    public IgniteInternalFuture<Boolean> dynamicStartCaches(Collection<CacheConfiguration> ccfgList, boolean failIfExists, boolean checkThreadTx, boolean disabledAfterStart) {
        return this.dynamicStartCachesByStoredConf(ccfgList.stream().map(StoredCacheData::new).collect(Collectors.toList()), failIfExists, checkThreadTx, disabledAfterStart);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCachesByStoredConf(Collection<StoredCacheData> storedCacheDataList, boolean failIfExists, boolean checkThreadTx, boolean disabledAfterStart) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        GridPlainClosure<Collection<byte[]>, IgniteInternalFuture<Boolean>> startCacheClsr = grpKeys -> {
            ArrayList<DynamicCacheChangeRequest> srvReqs = null;
            LinkedHashMap<String, DynamicCacheChangeRequest> clientReqs = null;
            Iterator grpKeysIter = grpKeys.iterator();
            for (Object ccfg : storedCacheDataList) {
                assert (!((StoredCacheData)ccfg).config().isEncryptionEnabled() || grpKeysIter.hasNext());
                DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(((StoredCacheData)ccfg).config(), ((StoredCacheData)ccfg).config().getName(), null, this.resolveCacheType(((StoredCacheData)ccfg).config()), ((StoredCacheData)ccfg).sql(), failIfExists, true, disabledAfterStart, ((StoredCacheData)ccfg).queryEntities(), ((StoredCacheData)ccfg).config().isEncryptionEnabled() ? (byte[])grpKeysIter.next() : null);
                if (req == null) continue;
                if (req.clientStartOnly()) {
                    if (clientReqs == null) {
                        clientReqs = U.newLinkedHashMap(storedCacheDataList.size());
                    }
                    clientReqs.put(req.cacheName(), req);
                    continue;
                }
                if (srvReqs == null) {
                    srvReqs = new ArrayList<DynamicCacheChangeRequest>(storedCacheDataList.size());
                }
                srvReqs.add(req);
            }
            if (srvReqs == null && clientReqs == null) {
                return new GridFinishedFuture();
            }
            if (clientReqs != null && srvReqs == null) {
                return this.startClientCacheChange(clientReqs, null);
            }
            GridCompoundFuture compoundFut = new GridCompoundFuture();
            for (DynamicCacheStartFuture fut : this.initiateCacheChanges(srvReqs)) {
                compoundFut.add(fut);
            }
            if (clientReqs != null) {
                IgniteInternalFuture<Boolean> clientStartFut = this.startClientCacheChange(clientReqs, null);
                compoundFut.add(clientStartFut);
            }
            compoundFut.markInitialized();
            return compoundFut;
        };
        int encGrpCnt = 0;
        for (StoredCacheData ccfg : storedCacheDataList) {
            if (!ccfg.config().isEncryptionEnabled()) continue;
            ++encGrpCnt;
        }
        return this.generateEncryptionKeysAndStartCacheAfter(encGrpCnt, startCacheClsr);
    }

    @NotNull
    private CacheType resolveCacheType(CacheConfiguration ccfg) {
        if (CU.isUtilityCache(ccfg.getName())) {
            return CacheType.UTILITY;
        }
        if (this.internalCaches.contains(ccfg.getName())) {
            return CacheType.INTERNAL;
        }
        if (DataStructuresProcessor.isDataStructureCache(ccfg.getName())) {
            return CacheType.DATA_STRUCTURES;
        }
        return CacheType.USER;
    }

    public IgniteInternalFuture<Boolean> dynamicDestroyCache(String cacheName, boolean sql, boolean checkThreadTx, boolean restart) {
        assert (cacheName != null);
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.stopRequest(this.ctx, cacheName, sql, true);
        req.stop(true);
        req.destroy(true);
        req.restart(restart);
        return F.first(this.initiateCacheChanges(F.asList(req)));
    }

    public IgniteInternalFuture<?> dynamicDestroyCaches(Collection<String> cacheNames, boolean checkThreadTx, boolean restart) {
        return this.dynamicDestroyCaches(cacheNames, checkThreadTx, restart, true);
    }

    public IgniteInternalFuture<?> dynamicDestroyCaches(Collection<String> cacheNames, boolean checkThreadTx, boolean restart, boolean destroy) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        ArrayList<DynamicCacheChangeRequest> reqs = new ArrayList<DynamicCacheChangeRequest>(cacheNames.size());
        for (String cacheName : cacheNames) {
            reqs.add(this.createStopRequest(cacheName, restart, destroy));
        }
        return this.dynamicChangeCaches(reqs);
    }

    @NotNull
    public DynamicCacheChangeRequest createStopRequest(String cacheName, boolean restart, boolean destroy) {
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.stopRequest(this.ctx, cacheName, false, true);
        req.stop(true);
        req.destroy(destroy);
        req.restart(restart);
        return req;
    }

    @NotNull
    public IgniteInternalFuture<?> dynamicChangeCaches(List<DynamicCacheChangeRequest> reqs) {
        GridCompoundFuture compoundFut = new GridCompoundFuture();
        for (DynamicCacheStartFuture fut : this.initiateCacheChanges(reqs)) {
            compoundFut.add(fut);
        }
        compoundFut.markInitialized();
        return compoundFut;
    }

    public IgniteInternalFuture<Boolean> changeWalMode(Collection<String> cacheNames, boolean enabled) {
        if (this.transactions().tx() != null || this.sharedCtx.lockedTopologyVersion(null) != null) {
            throw new IgniteException("Cache WAL mode cannot be changed within lock or transaction.");
        }
        return this.sharedCtx.walState().init(cacheNames, enabled);
    }

    public boolean walEnabled(String cacheName) {
        DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(cacheName);
        if (desc == null) {
            throw new IgniteException("Cache not found: " + cacheName);
        }
        return desc.groupDescriptor().walEnabled();
    }

    IgniteInternalFuture<?> dynamicCloseCache(String cacheName) {
        assert (cacheName != null);
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, false);
        if (proxy == null || proxy.isProxyClosed()) {
            return new GridFinishedFuture();
        }
        this.checkEmptyTransactions();
        if (proxy.context().isLocal()) {
            return this.dynamicDestroyCache(cacheName, false, true, false);
        }
        return this.startClientCacheChange(null, Collections.singleton(cacheName));
    }

    public IgniteInternalFuture<?> resetCacheState(Collection<String> cacheNames) {
        this.checkEmptyTransactions();
        if (F.isEmpty(cacheNames)) {
            cacheNames = this.cachesInfo.registeredCaches().keySet();
        }
        ArrayList<DynamicCacheChangeRequest> reqs = new ArrayList<DynamicCacheChangeRequest>(cacheNames.size());
        for (String cacheName : cacheNames) {
            DynamicCacheDescriptor desc = this.cacheDescriptor(cacheName);
            if (desc == null) {
                U.warn(this.log, "Failed to find cache for reset lost partition request, cache does not exist: " + cacheName);
                continue;
            }
            DynamicCacheChangeRequest req = DynamicCacheChangeRequest.resetLostPartitions(this.ctx, cacheName);
            reqs.add(req);
        }
        GridCompoundFuture fut = new GridCompoundFuture();
        for (DynamicCacheStartFuture f : this.initiateCacheChanges(reqs)) {
            fut.add(f);
        }
        fut.markInitialized();
        return fut;
    }

    public CacheType cacheType(String cacheName) {
        if (CU.isUtilityCache(cacheName)) {
            return CacheType.UTILITY;
        }
        if (this.internalCaches.contains(cacheName)) {
            return CacheType.INTERNAL;
        }
        if (DataStructuresProcessor.isDataStructureCache(cacheName)) {
            return CacheType.DATA_STRUCTURES;
        }
        return CacheType.USER;
    }

    public void saveCacheConfiguration(DynamicCacheDescriptor desc) throws IgniteCheckedException {
        assert (desc != null);
        if (this.sharedCtx.pageStore() != null && !this.sharedCtx.kernalContext().clientNode() && GridCacheUtils.isPersistentCache(desc.cacheConfiguration(), this.sharedCtx.gridConfig().getDataStorageConfiguration())) {
            this.sharedCtx.pageStore().storeCacheData(desc.toStoredData(), true);
        }
    }

    public void cleanupCachesDirectories() throws IgniteCheckedException {
        if (this.sharedCtx.pageStore() == null || this.sharedCtx.kernalContext().clientNode()) {
            return;
        }
        for (DynamicCacheDescriptor desc : this.cacheDescriptors().values()) {
            if (!GridCacheUtils.isPersistentCache(desc.cacheConfiguration(), this.sharedCtx.gridConfig().getDataStorageConfiguration())) continue;
            this.sharedCtx.pageStore().cleanupPersistentSpace(desc.cacheConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DynamicCacheStartFuture> initiateCacheChanges(Collection<DynamicCacheChangeRequest> reqs) {
        ArrayList<DynamicCacheStartFuture> res = new ArrayList<DynamicCacheStartFuture>(reqs.size());
        ArrayList<DynamicCacheChangeRequest> sndReqs = new ArrayList<DynamicCacheChangeRequest>(reqs.size());
        for (DynamicCacheChangeRequest req : reqs) {
            this.authorizeCacheChange(req);
            DynamicCacheStartFuture fut = new DynamicCacheStartFuture(req.requestId());
            try {
                DynamicCacheDescriptor desc;
                if (req.stop() && (desc = this.cacheDescriptor(req.cacheName())) == null) {
                    fut.onDone(false);
                }
                if (req.start() && req.startCacheConfiguration() != null) {
                    CacheConfiguration ccfg = req.startCacheConfiguration();
                    try {
                        this.cachesInfo.validateStartCacheConfiguration(ccfg);
                    }
                    catch (IgniteCheckedException e) {
                        fut.onDone(e);
                    }
                }
                if (fut.isDone()) continue;
                DynamicCacheStartFuture old = (DynamicCacheStartFuture)this.pendingFuts.putIfAbsent(req.requestId(), fut);
                assert (old == null);
                if (fut.isDone()) continue;
                sndReqs.add(req);
            }
            catch (Exception e) {
                fut.onDone(e);
            }
            finally {
                res.add(fut);
            }
        }
        IgniteCheckedException err = null;
        if (!sndReqs.isEmpty()) {
            try {
                this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(sndReqs));
                err = this.checkNodeState();
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
        }
        if (err != null) {
            for (DynamicCacheStartFuture fut : res) {
                fut.onDone(err);
            }
        }
        return res;
    }

    private void authorizeCacheCreate(CacheConfiguration cfg, SecurityContext secCtx) {
        this.ctx.security().authorize(null, SecurityPermission.CACHE_CREATE, secCtx);
        if (cfg != null && cfg.isOnheapCacheEnabled() && IgniteSystemProperties.getBoolean("IGNITE_DISABLE_ONHEAP_CACHE")) {
            throw new SecurityException("Authorization failed for enabling on-heap cache.");
        }
    }

    private void authorizeCacheChange(DynamicCacheChangeRequest req) {
        if (req.cacheType() == null || req.cacheType() == CacheType.USER) {
            if (req.stop()) {
                this.ctx.security().authorize(null, SecurityPermission.CACHE_DESTROY, null);
            } else {
                this.authorizeCacheCreate(req.startCacheConfiguration(), null);
            }
        }
    }

    @Nullable
    private IgniteCheckedException checkNodeState() {
        if (this.ctx.isStopping()) {
            return new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
        }
        if (this.ctx.clientDisconnected()) {
            return new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
        }
        return null;
    }

    public void onDiscoveryEvent(int type, @Nullable DiscoveryCustomMessage customMsg, ClusterNode node, AffinityTopologyVersion topVer, DiscoveryDataClusterState state) {
        this.cachesInfo.onDiscoveryEvent(type, node, topVer);
        this.sharedCtx.affinity().onDiscoveryEvent(type, customMsg, node, topVer, state);
    }

    public boolean onCustomEvent(DiscoveryCustomMessage msg, AffinityTopologyVersion topVer, ClusterNode node) {
        if (msg instanceof SchemaAbstractDiscoveryMessage) {
            this.ctx.query().onDiscovery((SchemaAbstractDiscoveryMessage)msg);
            return false;
        }
        if (msg instanceof CacheAffinityChangeMessage) {
            return this.sharedCtx.affinity().onCustomEvent((CacheAffinityChangeMessage)msg);
        }
        if (msg instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)msg).needExchange()) {
            return true;
        }
        if (msg instanceof WalStateAbstractMessage) {
            WalStateAbstractMessage msg0 = (WalStateAbstractMessage)msg;
            if (msg0 instanceof WalStateProposeMessage) {
                this.sharedCtx.walState().onProposeDiscovery((WalStateProposeMessage)msg);
            } else if (msg0 instanceof WalStateFinishMessage) {
                this.sharedCtx.walState().onFinishDiscovery((WalStateFinishMessage)msg);
            }
            return msg0.needExchange();
        }
        if (msg instanceof DynamicCacheChangeBatch) {
            return this.cachesInfo.onCacheChangeRequested((DynamicCacheChangeBatch)msg, topVer);
        }
        if (msg instanceof DynamicCacheChangeFailureMessage) {
            this.cachesInfo.onCacheChangeRequested((DynamicCacheChangeFailureMessage)msg, topVer);
        }
        if (msg instanceof ClientCacheChangeDiscoveryMessage) {
            this.cachesInfo.onClientCacheChange((ClientCacheChangeDiscoveryMessage)msg, node);
        }
        if (msg instanceof CacheStatisticsModeChangeMessage) {
            this.onCacheStatisticsModeChange((CacheStatisticsModeChangeMessage)msg);
        }
        if (msg instanceof CacheStatisticsClearMessage) {
            this.onCacheStatisticsClear((CacheStatisticsClearMessage)msg);
        }
        if (msg instanceof TxTimeoutOnPartitionMapExchangeChangeMessage) {
            this.onTxTimeoutOnPartitionMapExchangeChange((TxTimeoutOnPartitionMapExchangeChangeMessage)msg);
        }
        return false;
    }

    private int validatePreloadOrder(CacheConfiguration[] cfgs) throws IgniteCheckedException {
        int maxOrder = 0;
        for (CacheConfiguration cfg : cfgs) {
            int rebalanceOrder = cfg.getRebalanceOrder();
            if (rebalanceOrder > 0) {
                if (cfg.getCacheMode() == CacheMode.LOCAL) {
                    throw new IgniteCheckedException("Rebalance order set for local cache (fix configuration and restart the node): " + U.maskName(cfg.getName()));
                }
                if (cfg.getRebalanceMode() == CacheRebalanceMode.NONE) {
                    throw new IgniteCheckedException("Only caches with SYNC or ASYNC rebalance mode can be set as rebalance dependency for other caches [cacheName=" + U.maskName(cfg.getName()) + ", rebalanceMode=" + (Object)((Object)cfg.getRebalanceMode()) + ", rebalanceOrder=" + cfg.getRebalanceOrder() + ']');
                }
                maxOrder = Math.max(maxOrder, rebalanceOrder);
                continue;
            }
            if (rebalanceOrder >= 0) continue;
            throw new IgniteCheckedException("Rebalance order cannot be negative for cache (fix configuration and restart the node) [cacheName=" + cfg.getName() + ", rebalanceOrder=" + rebalanceOrder + ']');
        }
        return maxOrder;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = this.validateHashIdResolvers(node);
        if (res == null) {
            res = this.validateRestartingCaches(node);
        }
        return res;
    }

    public void resetRestartingCaches() {
        this.cachesInfo.restartingCaches().clear();
    }

    private IgniteNodeValidationResult validateRestartingCaches(ClusterNode node) {
        if (this.cachesInfo.hasRestartingCaches()) {
            String msg = "Joining node during caches restart is not allowed [joiningNodeId=" + node.id() + ", restartingCaches=" + new HashSet<String>(this.cachesInfo.restartingCaches()) + ']';
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        return null;
    }

    @Nullable
    private IgniteNodeValidationResult validateHashIdResolvers(ClusterNode node) {
        if (!node.isClient()) {
            for (DynamicCacheDescriptor desc : this.cacheDescriptors().values()) {
                CacheConfiguration cfg = desc.cacheConfiguration();
                if (!(cfg.getAffinity() instanceof RendezvousAffinityFunction)) continue;
                RendezvousAffinityFunction aff = (RendezvousAffinityFunction)cfg.getAffinity();
                Object nodeHashObj = aff.resolveNodeHash(node);
                for (ClusterNode topNode : this.ctx.discovery().aliveServerNodes()) {
                    Object topNodeHashObj = aff.resolveNodeHash(topNode);
                    if (nodeHashObj.hashCode() != topNodeHashObj.hashCode()) continue;
                    String errMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + cfg.getName() + ", existingNodeId=" + topNode.id() + ']';
                    String sndMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + cfg.getName() + ", existingNodeId=" + topNode.id() + ']';
                    return new IgniteNodeValidationResult(topNode.id(), errMsg, sndMsg);
                }
            }
        }
        return null;
    }

    private void checkTransactionConfiguration(ClusterNode rmt) throws IgniteCheckedException {
        TransactionConfiguration locTxCfg;
        TransactionConfiguration txCfg = (TransactionConfiguration)rmt.attribute("org.apache.ignite.tx");
        if (txCfg != null && (locTxCfg = this.ctx.config().getTransactionConfiguration()).isTxSerializableEnabled() != txCfg.isTxSerializableEnabled()) {
            throw new IgniteCheckedException("Serializable transactions enabled mismatch (fix txSerializableEnabled property or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [rmtNodeId=" + rmt.id() + ", locTxSerializableEnabled=" + locTxCfg.isTxSerializableEnabled() + ", rmtTxSerializableEnabled=" + txCfg.isTxSerializableEnabled() + ']');
        }
    }

    private void checkMemoryConfiguration(ClusterNode rmt) throws IgniteCheckedException {
        MemoryConfiguration memCfg;
        ClusterNode locNode = this.ctx.discovery().localNode();
        if (this.ctx.config().isClientMode().booleanValue() || locNode.isDaemon() || rmt.isClient() || rmt.isDaemon()) {
            return;
        }
        DataStorageConfiguration dsCfg = null;
        Object dsCfgBytes = rmt.attribute("org.apache.ignite.data.storage.config");
        if (dsCfgBytes instanceof byte[]) {
            dsCfg = (DataStorageConfiguration)new JdkMarshaller().unmarshal((byte[])dsCfgBytes, U.resolveClassLoader(this.ctx.config()));
        }
        if (dsCfg == null && (memCfg = (MemoryConfiguration)rmt.attribute("org.apache.ignite.memory")) != null) {
            dsCfg = new DataStorageConfiguration();
            dsCfg.setPageSize(memCfg.getPageSize());
        }
        if (dsCfg != null) {
            DataStorageConfiguration locDsCfg = this.ctx.config().getDataStorageConfiguration();
            if (dsCfg.getPageSize() != locDsCfg.getPageSize()) {
                throw new IgniteCheckedException("Memory configuration mismatch (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [rmtNodeId=" + rmt.id() + ", locPageSize = " + locDsCfg.getPageSize() + ", rmtPageSize = " + dsCfg.getPageSize() + "]");
            }
        }
    }

    private void checkRebalanceConfiguration(ClusterNode rmt) throws IgniteCheckedException {
        ClusterNode locNode = this.ctx.discovery().localNode();
        if (this.ctx.config().isClientMode().booleanValue() || locNode.isDaemon() || rmt.isClient() || rmt.isDaemon()) {
            return;
        }
        Integer rebalanceThreadPoolSize = (Integer)rmt.attribute("org.apache.ignite.rebalance.pool.size");
        if (rebalanceThreadPoolSize != null && rebalanceThreadPoolSize.intValue() != this.ctx.config().getRebalanceThreadPoolSize()) {
            throw new IgniteCheckedException("Rebalance configuration mismatch (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property). Different values of such parameter may lead to rebalance process instability and hanging.  [rmtNodeId=" + rmt.id() + ", locRebalanceThreadPoolSize = " + this.ctx.config().getRebalanceThreadPoolSize() + ", rmtRebalanceThreadPoolSize = " + rebalanceThreadPoolSize + "]");
        }
    }

    private GridCacheQueryManager queryManager(CacheConfiguration cfg) {
        return cfg.getCacheMode() == CacheMode.LOCAL ? new GridCacheLocalQueryManager() : new GridCacheDistributedQueryManager();
    }

    public long lastDataVersion() {
        long max = 0L;
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<Object, Object> ctx = cache.context();
            if (ctx.versions().last().order() > max) {
                max = ctx.versions().last().order();
            }
            if (!ctx.isNear() || (ctx = ctx.near().dht().context()).versions().last().order() <= max) continue;
            max = ctx.versions().last().order();
        }
        return max;
    }

    public <K, V> IgniteInternalCache<K, V> cache(String name) {
        IgniteCacheProxyImpl<?, ?> jcache;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        return (jcache = this.jcacheProxy(name, true)) == null ? null : jcache.internalProxy();
    }

    private void awaitInitializeProxy(IgniteCacheProxyImpl<?, ?> jcache) {
        if (jcache != null) {
            CountDownLatch initLatch = jcache.getInitLatch();
            try {
                while (initLatch.getCount() > 0L) {
                    initLatch.await(2000L, TimeUnit.MILLISECONDS);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Failed to wait proxy initialization, cache=" + jcache.getName() + ", localNodeId=" + this.ctx.localNodeId());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void completeProxyInitialize(String name) {
        IgniteCacheProxyImpl<?, ?> jcache = this.jCacheProxies.get(name);
        if (jcache != null) {
            CountDownLatch proxyInitLatch = jcache.getInitLatch();
            if (proxyInitLatch.getCount() > 0L) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Finish proxy initialization, cacheName=" + name + ", localNodeId=" + this.ctx.localNodeId());
                }
                proxyInitLatch.countDown();
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Can not finish proxy initialization because proxy does not exist, cacheName=" + name + ", localNodeId=" + this.ctx.localNodeId());
        }
    }

    public <K, V> IgniteInternalCache<K, V> getOrStartCache(String name) throws IgniteCheckedException {
        return this.getOrStartCache(name, null);
    }

    public <K, V> IgniteInternalCache<K, V> getOrStartCache(String name, CacheConfiguration ccfg) throws IgniteCheckedException {
        IgniteCacheProxyImpl<?, ?> cache;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        if ((cache = this.jcacheProxy(name, true)) == null) {
            this.dynamicStartCache(ccfg, name, null, false, ccfg == null, true).get();
            cache = this.jcacheProxy(name, true);
        }
        return cache == null ? null : cache.internalProxy();
    }

    public Collection<IgniteInternalCache<?, ?>> caches() {
        return F.viewReadOnly(this.jCacheProxies.values(), new IgniteClosure<IgniteCacheProxy<?, ?>, IgniteInternalCache<?, ?>>(){

            @Override
            public IgniteInternalCache<?, ?> apply(IgniteCacheProxy<?, ?> entries) {
                return entries.internalProxy();
            }
        }, new IgnitePredicate[0]);
    }

    public Collection<IgniteCacheProxy<?, ?>> jcaches() {
        return F.viewReadOnly(this.jCacheProxies.values(), new IgniteClosure<IgniteCacheProxyImpl<?, ?>, IgniteCacheProxy<?, ?>>(){

            @Override
            public IgniteCacheProxy<?, ?> apply(IgniteCacheProxyImpl<?, ?> proxy) {
                return proxy.gatewayWrapper();
            }
        }, new IgnitePredicate[0]);
    }

    public <K, V> IgniteInternalCache<K, V> utilityCache() {
        return this.internalCacheEx("ignite-sys-cache");
    }

    private <K, V> IgniteInternalCache<K, V> internalCacheEx(String name) {
        if (this.ctx.discovery().localNode().isClient()) {
            GridCacheAdapter<?, ?> cacheAdapter;
            IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(name, true);
            if (proxy == null && (cacheAdapter = this.caches.get(name)) != null) {
                proxy = new IgniteCacheProxyImpl(cacheAdapter.context(), cacheAdapter, false);
                IgniteCacheProxyImpl<?, ?> prev = this.addjCacheProxy(name, proxy);
                if (prev != null) {
                    proxy = prev;
                }
                this.completeProxyInitialize(proxy.getName());
            }
            assert (proxy != null) : name;
            return proxy.internalProxy();
        }
        return this.internalCache(name);
    }

    public <K, V> IgniteInternalCache<K, V> publicCache(String name) {
        DynamicCacheDescriptor desc;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + name);
        }
        if ((desc = this.cacheDescriptor(name)) == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        if (!desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + name);
        }
        IgniteCacheProxyImpl<?, ?> jcache = this.jcacheProxy(name, true);
        if (jcache == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        return jcache.internalProxy();
    }

    public <K, V> IgniteCacheProxy<K, V> publicJCache(String cacheName) throws IgniteCheckedException {
        return this.publicJCache(cacheName, true, true);
    }

    @Nullable
    public <K, V> IgniteCacheProxy<K, V> publicJCache(String cacheName, boolean failIfNotStarted, boolean checkThreadTx) throws IgniteCheckedException {
        DynamicCacheDescriptor desc;
        assert (cacheName != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + cacheName);
        }
        if ((desc = this.cacheDescriptor(cacheName)) != null && !desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + cacheName);
        }
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, true);
        if (proxy == null) {
            this.dynamicStartCache(null, cacheName, null, false, failIfNotStarted, checkThreadTx).get();
            proxy = this.jcacheProxy(cacheName, true);
        }
        return proxy != null ? proxy.gatewayWrapper() : null;
    }

    public CacheConfiguration cacheConfiguration(String name) {
        assert (name != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(name);
        if (desc == null) {
            throw new IllegalStateException("Cache doesn't exist: " + name);
        }
        return desc.cacheConfiguration();
    }

    public DynamicCacheDescriptor cacheDescriptor(String name) {
        return (DynamicCacheDescriptor)this.cachesInfo.registeredCaches().get(name);
    }

    public Map<String, DynamicCacheDescriptor> cacheDescriptors() {
        return this.cachesInfo.registeredCaches();
    }

    public Map<Integer, CacheGroupDescriptor> cacheGroupDescriptors() {
        return this.cachesInfo.registeredCacheGroups();
    }

    @Nullable
    public DynamicCacheDescriptor cacheDescriptor(int cacheId) {
        for (DynamicCacheDescriptor cacheDesc : this.cacheDescriptors().values()) {
            CacheConfiguration ccfg = cacheDesc.cacheConfiguration();
            assert (ccfg != null) : cacheDesc;
            if (CU.cacheId(ccfg.getName()) != cacheId) continue;
            return cacheDesc;
        }
        return null;
    }

    public void addCacheConfiguration(CacheConfiguration cacheCfg) throws IgniteCheckedException {
        assert (cacheCfg.getName() != null);
        String name = cacheCfg.getName();
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.cachesInfo.registeredTemplates().get(name);
        if (desc != null) {
            return;
        }
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.addTemplateRequest(this.ctx, cacheCfg);
        TemplateConfigurationFuture fut = new TemplateConfigurationFuture(req.cacheName(), req.deploymentId());
        TemplateConfigurationFuture old = (TemplateConfigurationFuture)this.pendingTemplateFuts.putIfAbsent(cacheCfg.getName(), fut);
        if (old != null) {
            fut = old;
        }
        IgniteCheckedException err = null;
        try {
            this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(Collections.singleton(req)));
            if (this.ctx.isStopping()) {
                err = new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
            } else if (this.ctx.clientDisconnected()) {
                err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
            }
        }
        catch (IgniteCheckedException e) {
            err = e;
        }
        if (err != null) {
            fut.onDone(err);
        }
        fut.get();
    }

    public <K, V> IgniteCacheProxy<K, V> jcache(String name) {
        GridCacheAdapter<?, ?> cacheAdapter;
        assert (name != null);
        IgniteCacheProxyImpl<?, ?> cache = this.jcacheProxy(name, true);
        if (cache == null && (cacheAdapter = this.caches.get(name)) != null) {
            cache = new IgniteCacheProxyImpl(cacheAdapter.context(), cacheAdapter, false);
            IgniteCacheProxyImpl<?, ?> prev = this.addjCacheProxy(name, cache);
            if (prev != null) {
                cache = prev;
            }
            this.completeProxyInitialize(cache.getName());
        }
        if (cache == null) {
            throw new IllegalArgumentException("Cache is not configured: " + name);
        }
        return cache;
    }

    @Nullable
    public IgniteCacheProxyImpl<?, ?> jcacheProxy(String name, boolean awaitInit) {
        IgniteCacheProxyImpl<?, ?> cache = this.jCacheProxies.get(name);
        if (awaitInit) {
            this.awaitInitializeProxy(cache);
        }
        return cache;
    }

    @Nullable
    public IgniteCacheProxyImpl<?, ?> addjCacheProxy(String name, IgniteCacheProxyImpl<?, ?> proxy) {
        return this.jCacheProxies.putIfAbsent(name, proxy);
    }

    public Collection<IgniteCacheProxy<?, ?>> publicCaches() {
        ArrayList res = new ArrayList(this.jCacheProxies.size());
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            if (!proxy.context().userCache()) continue;
            res.add(proxy.gatewayWrapper());
        }
        return res;
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(String name) {
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting internal cache adapter: " + name);
        }
        return this.caches.get(name);
    }

    private void cancelFutures() {
        this.sharedCtx.mvcc().onStop();
        IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled (node is stopping).");
        for (IgniteInternalFuture fut : this.pendingFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.manageStatisticsFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.txTimeoutOnPartitionMapExchangeFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
    }

    public Collection<GridCacheAdapter<?, ?>> internalCaches() {
        return this.caches.values();
    }

    public boolean systemCache(String name) {
        assert (name != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(name);
        return desc != null && !desc.cacheType().userCache();
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        for (GridCacheAdapter<?, ?> c : this.caches.values()) {
            X.println(">>> Cache memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", cache=" + c.name() + ']', new Object[0]);
            c.context().printMemoryStats();
        }
    }

    public void onUndeployed(ClassLoader ldr) {
        if (!this.ctx.isStopping()) {
            for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
                if (!cache.context().userCache() || !cache.context().deploymentEnabled()) continue;
                cache.onUndeploy(ldr);
            }
        }
    }

    public <K, V> GridCacheSharedContext<K, V> context() {
        return this.sharedCtx;
    }

    public IgniteTransactionsEx transactions() {
        return this.transactions;
    }

    public void createMissingQueryCaches() throws IgniteCheckedException {
        for (Map.Entry e : this.cachesInfo.registeredCaches().entrySet()) {
            DynamicCacheDescriptor desc = (DynamicCacheDescriptor)e.getValue();
            if (!this.isMissingQueryCache(desc)) continue;
            this.dynamicStartCache(null, desc.cacheConfiguration().getName(), null, false, true, true).get();
        }
    }

    private boolean isMissingQueryCache(DynamicCacheDescriptor desc) {
        CacheConfiguration ccfg = desc.cacheConfiguration();
        return !this.caches.containsKey(ccfg.getName()) && QueryUtils.isEnabled(ccfg);
    }

    private void registerMbean(Object obj, @Nullable String cacheName, boolean near) throws IgniteCheckedException {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (obj != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        Object mbeanImpl = obj instanceof IgniteMBeanAware ? ((IgniteMBeanAware)obj).getMBean() : obj;
        for (Class<?> itf : mbeanImpl.getClass().getInterfaces()) {
            if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
            try {
                U.registerMBean(srvr, this.ctx.igniteInstanceName(), cacheName, obj.getClass().getName(), mbeanImpl, itf);
                break;
            }
            catch (Throwable e) {
                throw new IgniteCheckedException("Failed to register MBean for component: " + obj, e);
            }
        }
    }

    private void unregisterMbean(Object o, @Nullable String cacheName, boolean near) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (o != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        boolean needToUnregister = o instanceof IgniteMBeanAware;
        if (!needToUnregister) {
            for (Class<?> itf : o.getClass().getInterfaces()) {
                if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
                needToUnregister = true;
                break;
            }
        }
        if (needToUnregister) {
            try {
                srvr.unregisterMBean(U.makeMBeanName(this.ctx.igniteInstanceName(), cacheName, o.getClass().getName()));
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to unregister MBean for component: " + o, e);
            }
        }
    }

    private Iterable<Object> lifecycleAwares(CacheGroupContext grp, CacheConfiguration ccfg, Object ... objs) {
        ArrayList<Object> ret = new ArrayList<Object>(7 + objs.length);
        if (grp.affinityFunction() != ccfg.getAffinity()) {
            ret.add(ccfg.getAffinity());
        }
        ret.add(ccfg.getAffinityMapper());
        ret.add(ccfg.getEvictionFilter());
        ret.add(ccfg.getEvictionPolicyFactory());
        ret.add(ccfg.getEvictionPolicy());
        ret.add(ccfg.getInterceptor());
        NearCacheConfiguration nearCfg = ccfg.getNearConfiguration();
        if (nearCfg != null) {
            ret.add(nearCfg.getNearEvictionPolicyFactory());
            ret.add(nearCfg.getNearEvictionPolicy());
        }
        Collections.addAll(ret, objs);
        return ret;
    }

    public void checkEmptyTransactions() throws IgniteException {
        if (this.transactions().tx() != null || this.sharedCtx.lockedTopologyVersion(null) != null) {
            throw new IgniteException("Cannot start/stop cache within lock or transaction.");
        }
    }

    private CacheConfiguration cloneCheckSerializable(final CacheConfiguration val) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        return this.withBinaryContext(new IgniteOutClosureX<CacheConfiguration>(){

            @Override
            public CacheConfiguration applyx() throws IgniteCheckedException {
                if (val.getCacheStoreFactory() != null) {
                    try {
                        ClassLoader ldr = GridCacheProcessor.this.ctx.config().getClassLoader();
                        if (ldr == null) {
                            ldr = val.getCacheStoreFactory().getClass().getClassLoader();
                        }
                        U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, val.getCacheStoreFactory()), U.resolveClassLoader(ldr, GridCacheProcessor.this.ctx.config()));
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteCheckedException("Failed to validate cache configuration. Cache store factory is not serializable. Cache name: " + U.maskName(val.getName()), e);
                    }
                }
                try {
                    return (CacheConfiguration)((Object)U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, (Object)val), U.resolveClassLoader(GridCacheProcessor.this.ctx.config())));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteCheckedException("Failed to validate cache configuration (make sure all objects in cache configuration are serializable): " + U.maskName(val.getName()), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withBinaryContext(IgniteOutClosureX<T> c) throws IgniteCheckedException {
        T t;
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        BinaryContext oldCtx = null;
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller binMarsh = ((CacheObjectBinaryProcessorImpl)objProc).marshaller();
            oldCtx = binMarsh == null ? null : binMarsh.pushContext();
        }
        try {
            t = c.applyx();
        }
        catch (Throwable throwable) {
            if (objProc instanceof CacheObjectBinaryProcessorImpl) {
                GridBinaryMarshaller.popContext(oldCtx);
            }
            throw throwable;
        }
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller.popContext(oldCtx);
        }
        return t;
    }

    private DynamicCacheChangeRequest prepareCacheChangeRequest(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean sql, boolean failIfExists, boolean failIfNotStarted, boolean disabledAfterStart, @Nullable Collection<QueryEntity> qryEntities, @Nullable byte[] encKey) throws IgniteCheckedException {
        DynamicCacheDescriptor desc = this.cacheDescriptor(cacheName);
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(UUID.randomUUID(), cacheName, this.ctx.localNodeId());
        req.sql(sql);
        req.failIfExists(failIfExists);
        req.disabledAfterStart(disabledAfterStart);
        req.encryptionKey(encKey);
        if (ccfg != null) {
            this.cloneCheckSerializable(ccfg);
            if (desc != null) {
                if (failIfExists) {
                    throw new CacheExistsException("Failed to start cache (a cache with the same name is already started): " + cacheName);
                }
                CacheConfiguration descCfg = desc.cacheConfiguration();
                if (nearCfg != null) {
                    if (CU.affinityNode(this.ctx.discovery().localNode(), descCfg.getNodeFilter())) {
                        if (descCfg.getNearConfiguration() != null) {
                            return null;
                        }
                        throw new IgniteCheckedException("Failed to start near cache (local node is an affinity node for cache): " + cacheName);
                    }
                    req.clientStartOnly(true);
                } else if (!CU.affinityNode(this.ctx.discovery().localNode(), descCfg.getNodeFilter())) {
                    req.clientStartOnly(true);
                }
                req.deploymentId(desc.deploymentId());
                req.startCacheConfiguration(descCfg);
                req.schema(desc.schema());
            } else {
                req.deploymentId(IgniteUuid.randomUuid());
                CacheConfiguration cfg = new CacheConfiguration(ccfg);
                CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
                this.initialize(cfg, cacheObjCtx);
                req.startCacheConfiguration(cfg);
                req.schema(new QuerySchema(qryEntities != null ? QueryUtils.normalizeQueryEntities(qryEntities, cfg) : cfg.getQueryEntities()));
            }
        } else {
            req.clientStartOnly(true);
            if (desc != null) {
                ccfg = desc.cacheConfiguration();
            }
            if (ccfg == null) {
                if (failIfNotStarted) {
                    throw new CacheExistsException("Failed to start client cache (a cache with the given name is not started): " + cacheName);
                }
                return null;
            }
            req.deploymentId(desc.deploymentId());
            req.startCacheConfiguration(ccfg);
            req.schema(desc.schema());
        }
        if (nearCfg != null) {
            req.nearCacheConfiguration(nearCfg);
        }
        req.cacheType(cacheType);
        return req;
    }

    public void enableStatistics(Collection<String> cacheNames, boolean enabled) throws IgniteCheckedException {
        Collection<IgniteInternalCache> caches = this.manageStatisticsCaches(cacheNames);
        HashSet<String> globalCaches = new HashSet<String>(U.capacity(caches.size()));
        for (IgniteInternalCache cache : caches) {
            cache.context().statisticsEnabled(enabled);
            if (cache.context().isLocal()) continue;
            globalCaches.add(cache.name());
        }
        if (globalCaches.isEmpty()) {
            return;
        }
        CacheStatisticsModeChangeMessage msg = new CacheStatisticsModeChangeMessage(UUID.randomUUID(), globalCaches, enabled);
        EnableStatisticsFuture fut = new EnableStatisticsFuture(msg.requestId());
        this.manageStatisticsFuts.put(msg.requestId(), fut);
        this.ctx.grid().context().discovery().sendCustomEvent(msg);
        fut.get();
    }

    public void clearStatistics(Collection<String> cacheNames) throws IgniteCheckedException {
        Collection<IgniteInternalCache> caches = this.manageStatisticsCaches(cacheNames);
        HashSet<String> globalCaches = new HashSet<String>(U.capacity(caches.size()));
        for (IgniteInternalCache cache : caches) {
            if (cache.context().isLocal()) continue;
            globalCaches.add(cache.name());
        }
        if (globalCaches.isEmpty()) {
            return;
        }
        CacheStatisticsClearMessage msg = new CacheStatisticsClearMessage(UUID.randomUUID(), globalCaches);
        EnableStatisticsFuture fut = new EnableStatisticsFuture(msg.requestId());
        this.manageStatisticsFuts.put(msg.requestId(), fut);
        this.ctx.grid().context().discovery().sendCustomEvent(msg);
        fut.get();
    }

    private Collection<IgniteInternalCache> manageStatisticsCaches(Collection<String> caches) throws IgniteCheckedException {
        assert (caches != null);
        ArrayList<IgniteInternalCache> res = new ArrayList<IgniteInternalCache>(caches.size());
        if (!this.cacheNames().containsAll(caches)) {
            throw new IgniteCheckedException("One or more cache descriptors not found [caches=" + caches + ']');
        }
        for (String cacheName : caches) {
            IgniteInternalCache cache = this.cache(cacheName);
            if (cache == null) {
                throw new IgniteCheckedException("Cache not found [cacheName=" + cacheName + ']');
            }
            res.add(cache);
        }
        return res;
    }

    public void setTxTimeoutOnPartitionMapExchange(long timeout) throws IgniteCheckedException {
        UUID requestId = UUID.randomUUID();
        TxTimeoutOnPartitionMapExchangeChangeFuture fut = new TxTimeoutOnPartitionMapExchangeChangeFuture(requestId);
        this.txTimeoutOnPartitionMapExchangeFuts.put(requestId, fut);
        TxTimeoutOnPartitionMapExchangeChangeMessage msg = new TxTimeoutOnPartitionMapExchangeChangeMessage(requestId, timeout);
        this.ctx.grid().context().discovery().sendCustomEvent(msg);
        fut.get();
    }

    public <T> T clone(final T obj) throws IgniteCheckedException {
        return this.withBinaryContext(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                return U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, obj), U.resolveClassLoader(GridCacheProcessor.this.ctx.config()));
            }
        });
    }

    private class TxTimeoutOnPartitionMapExchangeChangeFuture
    extends GridFutureAdapter<Void> {
        private UUID id;

        private TxTimeoutOnPartitionMapExchangeChangeFuture(UUID id) {
            this.id = id;
        }

        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            GridCacheProcessor.this.txTimeoutOnPartitionMapExchangeFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(TxTimeoutOnPartitionMapExchangeChangeFuture.class, this);
        }
    }

    private class EnableStatisticsFuture
    extends GridFutureAdapter<Void> {
        private UUID id;

        private EnableStatisticsFuture(UUID id) {
            this.id = id;
        }

        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            GridCacheProcessor.this.manageStatisticsFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(EnableStatisticsFuture.class, this);
        }
    }

    private class RemovedItemsCleanupTask
    implements GridTimeoutObject {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final long endTime;
        private final long timeout;

        RemovedItemsCleanupTask(long timeout) {
            this.timeout = timeout;
            this.endTime = U.currentTimeMillis() + timeout;
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void onTimeout() {
            GridCacheProcessor.this.ctx.closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (CacheGroupContext grp : GridCacheProcessor.this.sharedCtx.cache().cacheGroups()) {
                            if (grp.isLocal() || !grp.affinityNode()) continue;
                            GridDhtPartitionTopology top = null;
                            try {
                                top = grp.topology();
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            if (top != null) {
                                for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
                                    part.cleanupRemoveQueue();
                                }
                            }
                            if (!GridCacheProcessor.this.ctx.isStopping()) continue;
                            return;
                        }
                    }
                    catch (Exception e) {
                        U.error(GridCacheProcessor.this.log, "Failed to cleanup removed cache items: " + e, e);
                    }
                    if (GridCacheProcessor.this.ctx.isStopping()) {
                        return;
                    }
                    GridCacheProcessor.this.addRemovedItemsCleanupTask(RemovedItemsCleanupTask.this.timeout);
                }
            }, true);
        }
    }

    static class LocalAffinityFunction
    implements AffinityFunction {
        private static final long serialVersionUID = 0L;

        LocalAffinityFunction() {
        }

        @Override
        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            ClusterNode locNode = null;
            for (ClusterNode n : affCtx.currentTopologySnapshot()) {
                if (!n.isLocal()) continue;
                locNode = n;
                break;
            }
            if (locNode == null) {
                throw new IgniteException("Local node is not included into affinity nodes for 'LOCAL' cache");
            }
            ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(this.partitions());
            for (int part = 0; part < this.partitions(); ++part) {
                res.add(Collections.singletonList(locNode));
            }
            return Collections.unmodifiableList(res);
        }

        @Override
        public void reset() {
        }

        @Override
        public int partitions() {
            return 1;
        }

        @Override
        public int partition(Object key) {
            return 0;
        }

        @Override
        public void removeNode(UUID nodeId) {
        }
    }

    private class TemplateConfigurationFuture
    extends GridFutureAdapter<Object> {
        @GridToStringInclude
        private IgniteUuid deploymentId;
        private String cacheName;

        private TemplateConfigurationFuture(String cacheName, IgniteUuid deploymentId) {
            this.deploymentId = deploymentId;
            this.cacheName = cacheName;
        }

        public IgniteUuid deploymentId() {
            return this.deploymentId;
        }

        @Override
        public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingTemplateFuts.remove(this.cacheName, this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(TemplateConfigurationFuture.class, this);
        }
    }

    private class DynamicCacheStartFuture
    extends GridFutureAdapter<Boolean> {
        private UUID id;

        private DynamicCacheStartFuture(UUID id) {
            this.id = id;
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingFuts.remove(this.id, this);
            GridCacheProcessor.this.context().exchange().exchangerUpdateHeartbeat();
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(DynamicCacheStartFuture.class, this);
        }
    }
}

