/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.igfs.IgfsAbstractOutputStream;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsFileWorkerBatch;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

class IgfsOutputStreamImpl
extends IgfsAbstractOutputStream {
    private static final int MAX_BLOCKS_CNT = 16;
    private final IgfsMode mode;
    private final IgniteInternalFuture<Boolean> writeFut;
    private IgfsEntryInfo fileInfo;
    private IgfsFileAffinityRange streamRange;
    protected int remainderDataLen;
    private byte[] remainder;
    protected long space;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgfsOutputStreamImpl(IgfsContext igfsCtx, IgfsPath path, IgfsEntryInfo fileInfo, int bufSize, IgfsMode mode, @Nullable IgfsFileWorkerBatch batch) {
        super(igfsCtx, path, bufSize, batch);
        assert (fileInfo != null && fileInfo.isFile()) : "Unexpected file info: " + fileInfo;
        assert (mode != null && mode != IgfsMode.PROXY && (mode == IgfsMode.PRIMARY && batch == null || batch != null));
        if (fileInfo.lockId() == null) {
            throw new IgfsException("Failed to acquire file lock (concurrently modified?): " + path);
        }
        Object object = this.mux;
        synchronized (object) {
            this.fileInfo = fileInfo;
            this.mode = mode;
            this.streamRange = this.initialStreamRange(fileInfo);
            this.writeFut = igfsCtx.data().writeStart(fileInfo.id());
        }
    }

    private long length() {
        return this.fileInfo.length();
    }

    @Override
    protected int optimizeBufferSize(int bufSize) {
        assert (bufSize > 0);
        if (this.fileInfo == null) {
            return bufSize;
        }
        int blockSize = this.fileInfo.blockSize();
        if (blockSize <= 0) {
            return bufSize;
        }
        if (bufSize <= blockSize) {
            return blockSize;
        }
        int maxBufSize = blockSize * 16;
        if (bufSize > maxBufSize) {
            return maxBufSize;
        }
        if (this.fileInfo.length() == 0L) {
            return bufSize / blockSize * blockSize;
        }
        return bufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.mux;
        synchronized (object) {
            this.checkClosed(null, 0);
            this.sendBufferIfNotEmpty();
            this.flushRemainder();
            this.awaitAcks();
            if (this.igfsCtx.configuration().isUpdateFileLengthOnFlush() && this.space > 0L) {
                try {
                    IgfsEntryInfo fileInfo0 = this.igfsCtx.meta().reserveSpace(this.fileInfo.id(), this.space, this.streamRange);
                    if (fileInfo0 == null) {
                        throw new IOException("File was concurrently deleted: " + this.path);
                    }
                    this.fileInfo = fileInfo0;
                    this.streamRange = this.initialStreamRange(this.fileInfo);
                    this.space = 0L;
                }
                catch (IgniteCheckedException e) {
                    throw new IOException("Failed to update file length data [path=" + this.path + ", space=" + this.space + ']', e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            IOException err = null;
            boolean flushSuccess = false;
            try {
                this.sendBufferIfNotEmpty();
                this.flushRemainder();
                this.igfsCtx.data().writeClose(this.fileInfo.id());
                this.writeFut.get();
                flushSuccess = true;
            }
            catch (Exception e) {
                err = new IOException("Failed to flush data during stream close [path=" + this.path + ", fileInfo=" + this.fileInfo + ']', e);
            }
            if (this.batch != null) {
                this.batch.finish();
            }
            try {
                if (flushSuccess && this.space > 0L) {
                    this.igfsCtx.meta().unlock(this.fileInfo.id(), this.fileInfo.lockId(), System.currentTimeMillis(), true, this.space, this.streamRange);
                } else {
                    this.igfsCtx.meta().unlock(this.fileInfo.id(), this.fileInfo.lockId(), System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                if (err == null) {
                    err = new IOException("File to release file lock: " + this.path, e);
                }
                err.addSuppressed(e);
            }
            if (this.batch != null && this.mode == IgfsMode.DUAL_SYNC) {
                try {
                    this.batch.await();
                }
                catch (IgniteCheckedException e) {
                    if (err == null) {
                        err = new IOException("Failed to close secondary file system stream [path=" + this.path + ", fileInfo=" + this.fileInfo + ']', e);
                    }
                    err.addSuppressed(e);
                }
            }
            if (err != null) {
                throw err;
            }
            this.updateMetricsOnClose();
        }
    }

    private void flushRemainder() throws IOException {
        try {
            if (this.remainder != null) {
                this.remainder = this.igfsCtx.data().storeDataBlocks(this.fileInfo, this.length() + this.space, null, 0, ByteBuffer.wrap(this.remainder, 0, this.remainderDataLen), true, this.streamRange, this.batch);
                this.remainder = null;
                this.remainderDataLen = 0;
            }
        }
        catch (IgniteCheckedException e) {
            throw new IOException("Failed to flush data (remainder) [path=" + this.path + ", space=" + this.space + ']', e);
        }
    }

    @Override
    protected void send(Object data, int writeLen) throws IOException {
        assert (Thread.holdsLock(this.mux));
        assert (data instanceof ByteBuffer || data instanceof DataInput);
        try {
            this.bytes += (long)writeLen;
            this.space += (long)writeLen;
            int blockSize = this.fileInfo.blockSize();
            if (this.remainderDataLen + writeLen < blockSize) {
                if (this.remainder == null) {
                    this.remainder = new byte[blockSize];
                } else if (this.remainder.length != blockSize) {
                    assert (this.remainderDataLen == this.remainder.length);
                    byte[] allocated = new byte[blockSize];
                    U.arrayCopy(this.remainder, 0, allocated, 0, this.remainder.length);
                    this.remainder = allocated;
                }
                if (data instanceof ByteBuffer) {
                    ((ByteBuffer)data).get(this.remainder, this.remainderDataLen, writeLen);
                } else {
                    ((DataInput)data).readFully(this.remainder, this.remainderDataLen, writeLen);
                }
                this.remainderDataLen += writeLen;
            } else {
                this.remainder = data instanceof ByteBuffer ? this.igfsCtx.data().storeDataBlocks(this.fileInfo, this.length() + this.space, this.remainder, this.remainderDataLen, (ByteBuffer)data, false, this.streamRange, this.batch) : this.igfsCtx.data().storeDataBlocks(this.fileInfo, this.length() + this.space, this.remainder, this.remainderDataLen, (DataInput)data, writeLen, false, this.streamRange, this.batch);
                this.remainderDataLen = this.remainder == null ? 0 : this.remainder.length;
            }
        }
        catch (IgniteCheckedException e) {
            throw new IOException("Failed to store data into file: " + this.path, e);
        }
    }

    private void awaitAcks() throws IOException {
        try {
            this.igfsCtx.data().awaitAllAcksReceived(this.fileInfo.id());
        }
        catch (IgniteCheckedException e) {
            throw new IOException("Failed to wait for flush acknowledge: " + this.fileInfo.id, e);
        }
    }

    private IgfsFileAffinityRange initialStreamRange(IgfsEntryInfo fileInfo) {
        IgfsFileMap map;
        if (!this.igfsCtx.configuration().isFragmentizerEnabled()) {
            return null;
        }
        if (!Boolean.parseBoolean(fileInfo.properties().get("locWrite"))) {
            return null;
        }
        int blockSize = fileInfo.blockSize();
        long off = (fileInfo.length() + (long)blockSize - 1L) / (long)blockSize * (long)blockSize;
        long lastBlockOff = off - (long)fileInfo.blockSize();
        if (lastBlockOff < 0L) {
            lastBlockOff = 0L;
        }
        IgniteUuid prevAffKey = (map = fileInfo.fileMap()) == null ? null : map.affinityKey(lastBlockOff, false);
        IgniteUuid affKey = this.igfsCtx.data().nextAffinityKey(prevAffKey);
        return affKey == null ? null : new IgfsFileAffinityRange(off, off, affKey);
    }

    @Override
    public String toString() {
        return S.toString(IgfsOutputStreamImpl.class, this);
    }
}

