/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.secondary.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class LocalFileSystemUtils {
    public static final PosixFilePermission[] POSIX_PERMISSIONS = PosixFilePermission.values();

    public static void updateProperties(File file, String grp, String perm) {
        PosixFileAttributeView attrs = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
        if (attrs == null) {
            throw new UnsupportedOperationException("Posix file attributes not available");
        }
        if (grp != null) {
            try {
                UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
                GroupPrincipal grp0 = lookupService.lookupPrincipalByGroupName(grp);
                attrs.setGroup(grp0);
            }
            catch (IOException e) {
                throw new IgfsException("Update the 'grpName' property is failed.", e);
            }
        }
        if (perm != null) {
            int perm0 = Integer.parseInt(perm, 8);
            HashSet<PosixFilePermission> permSet = new HashSet<PosixFilePermission>(9);
            for (int i = 0; i < POSIX_PERMISSIONS.length; ++i) {
                if ((perm0 & 1 << i) == 0) continue;
                permSet.add(POSIX_PERMISSIONS[i]);
            }
            try {
                attrs.setPermissions(permSet);
            }
            catch (IOException e) {
                throw new IgfsException("Update the 'permission' property is failed.", e);
            }
        }
    }

    @Nullable
    public static PosixFileAttributes posixAttributes(File file) {
        PosixFileAttributes attrs = null;
        try {
            PosixFileAttributeView view = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                attrs = view.readAttributes();
            }
        }
        catch (IOException e) {
            throw new IgfsException("Failed to read POSIX attributes: " + file.getAbsolutePath(), e);
        }
        return attrs;
    }

    @Nullable
    public static BasicFileAttributes basicAttributes(File file) {
        BasicFileAttributes attrs = null;
        try {
            BasicFileAttributeView view = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                attrs = view.readAttributes();
            }
        }
        catch (IOException e) {
            throw new IgfsException("Failed to read basic file attributes: " + file.getAbsolutePath(), e);
        }
        return attrs;
    }

    public static Map<String, String> posixAttributesToMap(PosixFileAttributes attrs) {
        if (attrs == null) {
            return null;
        }
        HashMap<String, String> props = U.newHashMap(3);
        props.put("usrName", attrs.owner().getName());
        props.put("grpName", attrs.group().getName());
        int perm = 0;
        for (PosixFilePermission p : attrs.permissions()) {
            perm |= 1 << 8 - p.ordinal();
        }
        props.put("permission", '0' + Integer.toOctalString(perm));
        return props;
    }

    private LocalFileSystemUtils() {
    }
}

