/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestNoId;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;

public class JdbcRequest
extends ClientListenerRequestNoId
implements JdbcRawBinarylizable {
    static final byte QRY_EXEC = 2;
    static final byte QRY_FETCH = 3;
    static final byte QRY_CLOSE = 4;
    static final byte QRY_META = 5;
    public static final byte BATCH_EXEC = 6;
    static final byte META_TABLES = 7;
    static final byte META_COLUMNS = 8;
    static final byte META_INDEXES = 9;
    static final byte META_PARAMS = 10;
    static final byte META_PRIMARY_KEYS = 11;
    static final byte META_SCHEMAS = 12;
    static final byte BULK_LOAD_BATCH = 13;
    static final byte BATCH_EXEC_ORDERED = 14;
    private byte type;

    public JdbcRequest(byte type) {
        this.type = type;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeByte(this.type);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
    }

    public byte type() {
        return this.type;
    }

    public static JdbcRequest readRequest(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        JdbcRequest req;
        byte reqType = reader.readByte();
        switch (reqType) {
            case 2: {
                req = new JdbcQueryExecuteRequest();
                break;
            }
            case 3: {
                req = new JdbcQueryFetchRequest();
                break;
            }
            case 5: {
                req = new JdbcQueryMetadataRequest();
                break;
            }
            case 4: {
                req = new JdbcQueryCloseRequest();
                break;
            }
            case 6: {
                req = new JdbcBatchExecuteRequest();
                break;
            }
            case 7: {
                req = new JdbcMetaTablesRequest();
                break;
            }
            case 8: {
                req = new JdbcMetaColumnsRequest();
                break;
            }
            case 9: {
                req = new JdbcMetaIndexesRequest();
                break;
            }
            case 10: {
                req = new JdbcMetaParamsRequest();
                break;
            }
            case 11: {
                req = new JdbcMetaPrimaryKeysRequest();
                break;
            }
            case 12: {
                req = new JdbcMetaSchemasRequest();
                break;
            }
            case 13: {
                req = new JdbcBulkLoadBatchRequest();
                break;
            }
            case 14: {
                req = new JdbcOrderedBatchExecuteRequest();
                break;
            }
            default: {
                throw new IgniteException("Unknown SQL listener request ID: [request ID=" + reqType + ']');
            }
        }
        req.readBinary(reader, ver);
        return req;
    }
}

