/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;

public class NodeIdMessage
implements Message {
    private static final long serialVersionUID = 0L;
    static final int MESSAGE_SIZE = 16;
    public static final int MESSAGE_FULL_SIZE = 18;
    private byte[] nodeIdBytes;

    public NodeIdMessage() {
    }

    public NodeIdMessage(UUID nodeId) {
        assert (nodeId != null);
        this.nodeIdBytes = U.uuidToBytes(nodeId);
        assert (this.nodeIdBytes.length == 16) : "Node ID size must be 16";
    }

    public byte[] nodeIdBytes() {
        return this.nodeIdBytes;
    }

    public static byte[] nodeIdBytesWithType(UUID nodeId) {
        byte[] nodeIdBytesWithType = new byte[18];
        nodeIdBytesWithType[0] = -1;
        nodeIdBytesWithType[1] = -1;
        U.uuidToBytes(nodeId, nodeIdBytesWithType, 2);
        return nodeIdBytesWithType;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        assert (this.nodeIdBytes.length == 16);
        if (buf.remaining() < 18) {
            return false;
        }
        TcpCommunicationSpi.writeMessageType(buf, this.directType());
        buf.put(this.nodeIdBytes);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        if (buf.remaining() < 16) {
            return false;
        }
        this.nodeIdBytes = new byte[16];
        buf.get(this.nodeIdBytes);
        return true;
    }

    @Override
    public short directType() {
        return -1;
    }

    @Override
    public byte fieldsCount() {
        return 0;
    }

    public String toString() {
        return S.toString(NodeIdMessage.class, this);
    }
}

