/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.freemaker;

import com.ksoft.freemaker.MyTemplateExceptionHandler;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class Templater {
    static Logger logger = Logger.getLogger((String)Templater.class.getName());
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
    private static StringTemplateLoader stringLoader = new StringTemplateLoader();

    public static void init() {
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler((TemplateExceptionHandler)new MyTemplateExceptionHandler());
        cfg.setLogTemplateExceptions(false);
    }

    public static void putTemplate(String name, String templateContent) {
        stringLoader.putTemplate(name, templateContent);
    }

    public static String process(String templateName, Object dataModel) {
        String result = "";
        try {
            Template template = cfg.getTemplate(templateName);
            StringWriter stringWriter = new StringWriter();
            template.process(dataModel, (Writer)stringWriter);
            stringWriter.flush();
            result = stringWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Process template " + templateName + " error. Data: " + dataModel.toString()), (Throwable)e);
        }
        return result;
    }
}

