/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BackupLapsJob
implements Job {
    static Logger logger = Logger.getLogger((String)BackupLapsJob.class.getName());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block10: {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
            String dir = SettingsManager.getDir("laps_backup_folder", "backups/laps");
            String fileName = String.valueOf(dir) + "/laps_" + format.format(new Date());
            File tempFile = new File(fileName);
            String password = SettingModel.get("laps_backup:password");
            try {
                try {
                    if (!SettingModel.getBool("laps_backup:enabled")) break block10;
                    JobDataMap dataMap = context.getJobDetail().getJobDataMap();
                    logger.debug((Object)("Running " + this.getClass() + " schedulled job " + context.getJobDetail().getKey()));
                    String searchBase = SettingModel.get("laps_backup:ldap_base");
                    LdapManager.exportLdap(fileName, searchBase);
                    logger.debug((Object)"Ldap export completed");
                    if (tempFile.exists() && password != null && !password.isEmpty()) {
                        try {
                            ZipFile zipFile = new ZipFile(String.valueOf(fileName) + ".zip");
                            ZipParameters parameters = new ZipParameters();
                            parameters.setCompressionMethod(8);
                            parameters.setCompressionLevel(5);
                            parameters.setEncryptFiles(true);
                            parameters.setEncryptionMethod(99);
                            parameters.setAesKeyStrength(3);
                            parameters.setPassword(SettingModel.get("laps_backup:password"));
                            zipFile.addFile(tempFile, parameters);
                            logger.debug((Object)("Backup compressed to " + zipFile.getFile().getAbsolutePath()));
                            LogModel.registerTask(LogModel.EVENT_TYPE.TASK, "LAPS backup completed");
                        }
                        catch (Exception e) {
                            logger.error((Object)"compression error", (Throwable)e);
                        }
                        tempFile.delete();
                        logger.debug((Object)("tempFile " + tempFile.getAbsolutePath() + " deleted"));
                    }
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    logger.info((Object)("Job " + context.getJobDetail().getKey() + " completed"));
                }
                catch (Exception e) {
                    LogModel.registerTask(LogModel.EVENT_TYPE.TASK, "LAPS backup error");
                    logger.error((Object)"laps backup error", (Throwable)e);
                    if (tempFile.exists() && tempFile.length() == 0L) {
                        tempFile.delete();
                    }
                    this.deleteOldFiles();
                }
            }
            finally {
                this.deleteOldFiles();
            }
        }
    }

    private void deleteOldFiles() {
        try {
            String backupDir = SettingsManager.getDir("laps_backup_folder", "backups/laps");
            int maxCount = Integer.parseInt(SettingModel.get("laps_backup:files_count"));
            File dir = new File(backupDir);
            File[] files = dir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                }
            });
            if (files.length > maxCount) {
                int j = files.length - 1;
                while (j > maxCount - 1) {
                    File f = files[j];
                    f.delete();
                    logger.debug((Object)("Old file " + f.getAbsolutePath() + " deleted"));
                    --j;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"deleteOldFiles error", (Throwable)e);
        }
    }
}

