/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.j256.ormlite.stmt.QueryBuilder;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CleanLDAPUsersJob
implements Job {
    static Logger logger = Logger.getLogger((String)CleanLDAPUsersJob.class.getName());

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        QueryBuilder qb = DBManager.getDao(AccountModel.class).queryBuilder();
        try {
            qb.where().eq("external", (Object)true);
            List models = qb.query();
            for (AccountModel model : models) {
                if (LdapManager.leaveOrDelUser(model.login)) continue;
                logger.info((Object)("User " + model.login + " not found in ldap, will be deleted"));
                DBManager.getDao((Object)model).delete((Object)model);
                LogModel.register(LogModel.EVENT_TYPE.USER_DELETE, "127.0.0.1", "SYSTEM", model.login, "", "User " + model.login + " was removed (not found in AD)");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

