/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.JiaManager;
import com.ksoft.laps.db.TransactionModel;
import java.time.Instant;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JIAJob
implements Job {
    static Logger logger = Logger.getLogger((String)JIAJob.class.getName());

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.deleteUncommittedTransactions();
        this.cleanOldCommittedTransactions();
    }

    public void deleteUncommittedTransactions() {
        DeleteBuilder db = DBManager.getDao(TransactionModel.class).deleteBuilder();
        Long now = Instant.now().toEpochMilli();
        int allowedCommitDelayMilli = 30000;
        db.where().raw(now + "> ts_created + " + allowedCommitDelayMilli + " AND ts_committed=0", new ArgumentHolder[0]);
        try {
            int deleted = db.delete();
            if (deleted > 0) {
                logger.debug((Object)("Deleted " + deleted + " uncommitted tranzactions"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete uncommitted tranzactions " + e));
        }
    }

    public void cleanOldCommittedTransactions() {
        QueryBuilder qb = DBManager.getDao(TransactionModel.class).queryBuilder();
        try {
            Long now = Instant.now().toEpochMilli();
            qb.where().raw(now + " > ts_till", new ArgumentHolder[0]);
            List models = qb.query();
            for (TransactionModel model : models) {
                TransactionModel.TRANS_TYPE elementType = TransactionModel.TRANS_TYPE.valueOf(model.type.toUpperCase());
                switch (elementType) {
                    case ROLE_APPLY: {
                        DBManager.getDao((Object)model).delete((Object)model);
                        break;
                    }
                    case GROUP_APPLY: {
                        boolean isDeletedFromGroup = JiaManager.getInstance().removeUserFromGroup(model.owner, model.value);
                        if (isDeletedFromGroup) {
                            DBManager.getDao((Object)model).delete((Object)model);
                            break;
                        }
                        logger.error((Object)("Unable to delete " + model.owner + " from " + model.value));
                    }
                }
                logger.debug((Object)("Old transaction " + model.id + " deleted. Owner: " + model.owner + " type " + model.type + " created: " + model.ts_created + " committed: " + model.ts_committed + " ts_till: " + model.ts_till + " Now: " + now + " value: " + model.value));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to cleanOldCommittedJobs", (Throwable)e);
        }
    }
}

