/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.ksoft.jobs.BackupLapsJob;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import java.security.SecureRandom;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LDAPPasswordRotateJob
implements Job {
    static Logger logger = Logger.getLogger((String)BackupLapsJob.class.getName());
    private static SecureRandom random = new SecureRandom();
    private static final String ALPHA_CAPS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUMERIC = "0123456789";
    private static final String SPECIAL_CHARS = "!@#$%&*_=+-";

    public static String generatePassword(int len, String dic) {
        String result = "";
        int i = 0;
        while (i < len) {
            int index = random.nextInt(dic.length());
            result = String.valueOf(result) + dic.charAt(index);
            ++i;
        }
        return result;
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        boolean result;
        String newPassword;
        String DN = SettingModel.get("ldap_server:master_user_dn");
        String oldPassword = LdapManager.changeBindUserPassword(DN, newPassword = LDAPPasswordRotateJob.generatePassword(16, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%&*_=+-0123456789"));
        boolean bl = result = oldPassword != null;
        if (oldPassword != null && !oldPassword.isEmpty()) {
            SettingModel.set("ldap_server:password", newPassword);
        }
        LogModel.registerTask(LogModel.EVENT_TYPE.TASK, "LDAP password changed: " + result);
    }
}

