/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.db.HostModel;
import com.ksoft.laps.db.SettingModel;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LicenseCheckJob
implements Job {
    static Logger logger = Logger.getLogger((String)LicenseCheckJob.class.getName());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        int adPcCount = 0;
        int localPcCount = 0;
        int licensedPCcount = CoreEngine.getLicenseManager().getLicensedPCCount();
        try {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            logger.debug((Object)("Running " + this.getClass() + " schedulled job " + context.getJobDetail().getKey()));
            String searchBase = SettingModel.get("ldap_server:computer_base");
            adPcCount = LdapManager.countManagedPC(searchBase, licensedPCcount);
        }
        catch (Exception dataMap) {
            // empty catch block
        }
        try {
            List hostModels = DBManager.findAll(HostModel.class);
            if (hostModels != null && hostModels.size() > 0) {
                localPcCount = hostModels.size();
            }
        }
        catch (Exception hostModels) {
            // empty catch block
        }
        int totalPcCount = adPcCount + localPcCount;
        CoreEngine.getLicenseManager().setActualManagedPCcount(totalPcCount);
        logger.debug((Object)("License check results: licensed PC count = " + licensedPCcount + " actual PC count: " + totalPcCount + " AD: " + adPcCount + " local:" + localPcCount));
    }
}

