/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.jobs;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.ksoft.core.DBManager;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import java.time.Instant;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LogRetentionJob
implements Job {
    static Logger logger = Logger.getLogger((String)LogRetentionJob.class.getName());

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        long olderThanDays = SettingModel.getInt("log:delete_older_than_days", 365);
        long now = Instant.now().toEpochMilli();
        long deleteTo = now - olderThanDays * 24L * 60L * 60L * 1000L;
        Instant iDeleteTo = Instant.ofEpochMilli(deleteTo);
        try {
            DeleteBuilder builder = DBManager.getDao(LogModel.class).deleteBuilder();
            builder.where().lt("ts_created", (Object)deleteTo);
            int count = builder.delete();
            LogModel.registerTask(LogModel.EVENT_TYPE.TASK, "Log retention completed. Deleted " + count + " records older than " + iDeleteTo.toString());
            logger.debug((Object)("Log retention deleted " + count + " records older than " + iDeleteTo.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"LogRetentionJob error", (Throwable)e);
        }
    }
}

