/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.CapchaHelper;
import com.ksoft.auth.IAccountModel;
import com.ksoft.auth.TOTPProvider;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.MobileManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.laps.db.TOTPModel;
import com.ksoft.laps.db.UserProfileModel;
import com.ksoft.tls.TlsHelper;
import com.ksoft.utils.NullAwareBeanUtilsBean;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.crypto.SecretKey;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/account")
@Singleton
public class AccountApi {
    private static final SecretKey secretKey = SettingModel.createSecretKey(TlsHelper.keyToBase64String((Key)AuthFilter.getPublicKey()).substring(0, 16));
    @Context
    HttpServletRequest requestContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    @Context
    ContainerResponseContext responseContext;
    static Logger logger = Logger.getLogger((String)AccountApi.class.getName());
    @Context
    ResourceInfo resourceInfo;

    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @PermitAll
    @Path(value="/auth")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response auth(String request) throws Exception {
        String errorMessage = "";
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject result = new JSONObject();
        JSONObject jrequest = new JSONObject(request);
        String login = jrequest.getString("login").toLowerCase();
        String password = jrequest.optString("password", "");
        String otp = jrequest.optString("otp", "");
        String confirm_otp = jrequest.optString("confirm_otp", "");
        String capcha = jrequest.optString("capcha", "");
        String capcha_uuid = jrequest.optString("capcha_uuid", "");
        String otp_secret = jrequest.optString("secret", "");
        AccountModel model = new AccountModel();
        model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
        AuthManager.AUTHSTATUS authStatus = AuthManager.AUTHSTATUS.FAIL;
        String lockoutKey = "auth_lockout:" + login;
        Long lockoutTime = ClusterManager.getLong(lockoutKey);
        long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        if (lockoutTime != null) {
            long diff = now - lockoutTime;
            if (diff < (long)SettingModel.getInt("auth:lockout_duration").intValue()) {
                JSONObject jresp = new JSONObject();
                jresp.put("status", (Object)"LOCKOUT_TIMEOUT");
                jresp.put("error", (Object)("Account locked. Please wait " + ((long)SettingModel.getInt("auth:lockout_duration").intValue() - diff) + " seconds"));
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jresp.toString()).build();
            }
            ClusterManager.remove(lockoutKey, true);
        }
        if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:capcha_count") || this.getFailCountPerIP(source_ip) >= SettingModel.getInt("auth:capcha_count")) {
            if (capcha.isEmpty()) {
                JSONObject jresp = new JSONObject();
                String capchaString = CapchaHelper.generateRandomString((String)SettingModel.get("auth:capcha_alphabet"), (int)SettingModel.getInt("auth:capcha_length", 5));
                String base64Capcha = CapchaHelper.generateBase64CapchaImage((String)capchaString);
                String uuid = UUID.randomUUID().toString();
                logger.debug((Object)("Capcha generated for login " + login + " src_ip: " + source_ip));
                jresp.put("capcha_img", (Object)base64Capcha);
                jresp.put("capcha_uuid", (Object)uuid);
                ClusterManager.putToCache("capcha:" + login + ":" + uuid, capchaString, true);
                jresp.put("status", (Object)AuthManager.AUTHSTATUS.CAPCHA_REQUIRED);
                logger.debug((Object)("Capcha required for " + login + " from " + source_ip));
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jresp.toString()).build();
            }
            String capchaKey = "capcha:" + login + ":" + capcha_uuid;
            String c_value = ClusterManager.get(capchaKey);
            if (c_value == null || !c_value.toLowerCase().equals(capcha.toLowerCase())) {
                logger.error((Object)(String.valueOf(login) + " wrong capcha entered: " + capcha + " expected: " + c_value));
                JSONObject jresp = new JSONObject();
                jresp.put("status", (Object)AuthManager.AUTHSTATUS.WRONG_CAPCHA);
                String capchaString = CapchaHelper.generateRandomString((String)SettingModel.get("auth:capcha_alphabet"), (int)SettingModel.getInt("auth:capcha_length", 5));
                String base64Capcha = CapchaHelper.generateBase64CapchaImage((String)capchaString);
                logger.debug((Object)("Capcha generated for login " + login + " src_ip: " + source_ip));
                jresp.put("capcha_img", (Object)base64Capcha);
                jresp.put("capcha_uuid", (Object)capcha_uuid);
                ClusterManager.putToCache(capchaKey, capchaString, true);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jresp.toString()).build();
            }
            logger.debug((Object)("Capcha is OK for " + login + " from " + source_ip));
            ClusterManager.remove(capchaKey, true);
        }
        if (model == null) {
            authStatus = CoreEngine.getInstance().getAuthManager().authNonExisting(login, password, otp, source_ip);
            boolean isGeneratedOTPconfimed = false;
            if (authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP) && !otp_secret.isEmpty() && !otp.isEmpty() && (CoreEngine.getInstance().getAuthManager().isOTPrequredForInternal() || CoreEngine.getInstance().getAuthManager().isOTPrequiredForExternal() && CoreEngine.getInstance().getAuthManager().getExtAuthProvider() != null && CoreEngine.getInstance().getAuthManager().getExtAuthProvider().getClass().equals(TOTPProvider.class))) {
                isGeneratedOTPconfimed = TOTPProvider.checkTOTPbyKey((String)otp_secret, (String)confirm_otp);
                if (isGeneratedOTPconfimed && authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP)) {
                    logger.debug((Object)("TOTP confirmed for user " + login));
                } else {
                    logger.debug((Object)("TOTP confirmation error for user " + login));
                }
            }
            if (authStatus.equals((Object)AuthManager.AUTHSTATUS.SUCCESS) || isGeneratedOTPconfimed && authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP)) {
                String filter = String.format(SettingModel.get("ldap_server:user_filter"), login);
                ArrayList<HashMap<String, String>> adResult = LdapManager.search(filter, SettingModel.get("ldap_server:user_base"), "mail", 1);
                model = new AccountModel();
                model.login = login;
                model.enabled = true;
                model.external = true;
                Set<String> userRoles = LdapManager.getUserPortalRoles(model);
                JSONArray jRoles = new JSONArray(userRoles);
                model.roles = jRoles.toString();
                model.hash = "external";
                model.email = adResult.size() == 1 ? adResult.get(0).getOrDefault("mail", "") : "";
                DBManager.getDao((Object)model).create((Object)model);
                if (isGeneratedOTPconfimed && authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP)) {
                    logger.debug((Object)("TOTP confirmed for user " + login));
                    if (model.totp != null) {
                        model.totp.secretKey = otp_secret;
                        model.totp.initialTOTP = null;
                        DBManager.getDao(TOTPModel.class).update((Object)model.totp);
                    } else {
                        TOTPModel totp = new TOTPModel();
                        totp.account = model;
                        totp.secretKey = otp_secret;
                        DBManager.getDao(TOTPModel.class).create((Object)totp);
                        model.totp = totp;
                        DBManager.getDao(AccountModel.class).update((Object)model);
                    }
                    authStatus = CoreEngine.getInstance().getAuthManager().authExisting((IAccountModel)model, password, confirm_otp, source_ip);
                }
            } else if (authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP) && !otp_secret.isEmpty() && !otp.isEmpty()) {
                errorMessage = "OTP wrong";
            }
        } else if (!otp_secret.isEmpty() && !otp.isEmpty() && (CoreEngine.getInstance().getAuthManager().isOTPrequredForInternal() || CoreEngine.getInstance().getAuthManager().isOTPrequiredForExternal() && CoreEngine.getInstance().getAuthManager().getExtAuthProvider() != null && CoreEngine.getInstance().getAuthManager().getExtAuthProvider().getClass().equals(TOTPProvider.class)) && !model.getChange_password().booleanValue() && model.getEnabled().booleanValue()) {
            authStatus = CoreEngine.getInstance().getAuthManager().authExisting((IAccountModel)model, password, otp, source_ip);
            boolean isGeneratedOTPconfimed = TOTPProvider.checkTOTPbyKey((String)otp_secret, (String)confirm_otp);
            if (isGeneratedOTPconfimed && authStatus.equals((Object)AuthManager.AUTHSTATUS.GENERATE_OTP)) {
                logger.debug((Object)("TOTP confirmed for user " + login));
                if (model.totp != null) {
                    model.totp.secretKey = otp_secret;
                    model.totp.initialTOTP = null;
                    DBManager.getDao(TOTPModel.class).update((Object)model.totp);
                } else {
                    TOTPModel totp = new TOTPModel();
                    totp.account = model;
                    totp.secretKey = otp_secret;
                    DBManager.getDao(TOTPModel.class).create((Object)totp);
                    model.totp = totp;
                    DBManager.getDao(AccountModel.class).update((Object)model);
                }
                authStatus = CoreEngine.getInstance().getAuthManager().authExisting((IAccountModel)model, password, confirm_otp, source_ip);
            } else {
                authStatus = AuthManager.AUTHSTATUS.GENERATE_OTP;
                errorMessage = "Activate OTP generator";
            }
        } else {
            authStatus = CoreEngine.getInstance().getAuthManager().authExisting((IAccountModel)model, password, otp, source_ip);
        }
        switch (authStatus) {
            case SUCCESS: {
                String newToken = model.generateJWTtoken(AuthFilter.getPrivateKey(), source_ip, AuthFilter.tokenExpirationMinutes);
                NewCookie authCookie = new NewCookie("X-Token", newToken, "/", null, null, AuthFilter.tokenExpirationMinutes * 60, AuthFilter.IS_SECURE, true);
                String csrfToken = Jwts.builder().setSubject(login).setAudience("csrf").claim("ip", (Object)source_ip).signWith(SignatureAlgorithm.RS512, (Key)AuthFilter.getPrivateKey()).compact();
                NewCookie XSRF = new NewCookie("XSRF-TOKEN", csrfToken, "/", null, null, 3600, AuthFilter.IS_SECURE, false);
                LogModel.register(LogModel.EVENT_TYPE.LOGIN_SUCCESS, source_ip, login, "", "", "");
                this.deleteFailCountPerLogin(login);
                this.deleteFailCountPerIP(source_ip);
                ClusterManager.remove(lockoutKey, true);
                if (!capcha.isEmpty() && !capcha_uuid.isEmpty()) {
                    ClusterManager.remove("capcha:" + login + ":" + capcha_uuid, true);
                }
                if (model.getExternal().booleanValue()) {
                    Set<String> userRoles = LdapManager.getUserPortalRoles(model);
                    model.roles = new JSONArray(userRoles).toString();
                    DBManager.getDao((Object)model).update((Object)model);
                }
                return Response.ok((Object)model.toJSON().toString()).cookie(new NewCookie[]{authCookie, XSRF}).build();
            }
            case GENERATE_OTP: 
            case PASSWORD_CHANGE: {
                String tempToken = Jwts.builder().setSubject(login).setAudience(authStatus.toString()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 60000L * (long)AuthFilter.getTokenExpirationMinutes())).claim("ip", (Object)source_ip).signWith(SignatureAlgorithm.RS512, (Key)AuthFilter.getPrivateKey()).compact();
                JSONObject jresp = new JSONObject();
                jresp.put("status", (Object)authStatus);
                jresp.put("token", (Object)tempToken);
                if (!errorMessage.isEmpty()) {
                    jresp.put("error", (Object)errorMessage);
                }
                this.deleteFailCountPerLogin(login);
                this.deleteFailCountPerIP(source_ip);
                if (!capcha.isEmpty() && !capcha_uuid.isEmpty()) {
                    ClusterManager.remove("capcha:" + login + ":" + capcha_uuid, true);
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jresp.toString()).build();
            }
        }
        JSONObject jrespDefault = new JSONObject();
        jrespDefault.put("status", (Object)authStatus);
        this.increaseFailCount(login, source_ip);
        if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:capcha_count") || this.getFailCountPerIP(source_ip) >= SettingModel.getInt("auth:capcha_count")) {
            jrespDefault.put("status", (Object)AuthManager.AUTHSTATUS.CAPCHA_REQUIRED);
            jrespDefault.put("reason", (Object)authStatus);
            String capchaString = CapchaHelper.generateRandomString((String)SettingModel.get("auth:capcha_alphabet"), (int)SettingModel.getInt("auth:capcha_length", 5));
            String base64Capcha = CapchaHelper.generateBase64CapchaImage((String)capchaString);
            String uuid = UUID.randomUUID().toString();
            logger.debug((Object)("Capcha generated for login " + login + " src_ip: " + source_ip));
            jrespDefault.put("capcha_img", (Object)base64Capcha);
            jrespDefault.put("capcha_uuid", (Object)uuid);
            ClusterManager.putToCache("capcha:" + login + ":" + uuid, capchaString, true);
        }
        if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:lockout_threshold")) {
            jrespDefault.put("status", (Object)"LOCKOUT_TIMEOUT");
            jrespDefault.put("error", (Object)("Account locked. Please wait " + SettingModel.getInt("auth:lockout_duration") + " seconds"));
            ClusterManager.putToCache(lockoutKey, String.valueOf(now), true);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jrespDefault.toString()).build();
    }

    @PermitAll
    @Path(value="/pushauth")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response pushAuth(String request) throws Exception {
        if (!SettingModel.getBool("mobile:enabled")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Mobile features not enabled").build();
        }
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject jrequest = new JSONObject(request);
        String login = jrequest.getString("login").toLowerCase().trim();
        AccountModel model = new AccountModel();
        model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
        JSONObject jrespDefault = new JSONObject();
        if (model != null && model.getEnabled().booleanValue()) {
            if (model.getExternal().booleanValue() && !LdapManager.getLdapManagerInstance().isUserAllowedToLogin(model.getLogin())) {
                jrespDefault.put("error", (Object)"User not allowed to login");
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jrespDefault.toString()).build();
            }
            JSONObject profile = model.getFullProfileJSON();
            if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                JSONObject mobileConf = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
                String fcmToken = mobileConf.optString("fcmToken");
                String session = MobileManager.getInstance().sendAuthPush(fcmToken, login, source_ip);
                jrespDefault.put("session", (Object)session);
                jrespDefault.put("message", (Object)"Push request have been sent, wait for confirmation.");
                return Response.ok((Object)jrespDefault.toString()).build();
            }
            jrespDefault.put("error", (Object)"User have not registered any mobile device");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jrespDefault.toString()).build();
        }
        jrespDefault.put("status", (Object)AuthManager.AUTHSTATUS.FAIL);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jrespDefault.toString()).build();
    }

    @PermitAll
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Path(value="/pushstatus")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response pushStatus(String request) throws Exception {
        if (!SettingModel.getBool("mobile:enabled")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Mobile features not enabled").build();
        }
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject jrequest = new JSONObject(request);
        String session = jrequest.getString("session");
        String login = jrequest.getString("login");
        String status = MobileManager.getInstance().getPushAuthStatus(login, source_ip, session);
        JSONObject result = new JSONObject();
        if (status.equals("true")) {
            AccountModel model = new AccountModel();
            model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            String newToken = model.generateJWTtoken(AuthFilter.getPrivateKey(), source_ip, AuthFilter.tokenExpirationMinutes);
            NewCookie authCookie = new NewCookie("X-Token", newToken, "/", null, null, AuthFilter.tokenExpirationMinutes * 60, AuthFilter.IS_SECURE, true);
            String csrfToken = Jwts.builder().setSubject(login).setAudience("csrf").claim("ip", (Object)source_ip).signWith(SignatureAlgorithm.RS512, (Key)AuthFilter.getPrivateKey()).compact();
            NewCookie XSRF = new NewCookie("XSRF-TOKEN", csrfToken, "/", null, null, 3600, AuthFilter.IS_SECURE, false);
            logger.info((Object)("User " + login + " authed via push"));
            LogModel.register(LogModel.EVENT_TYPE.LOGIN_SUCCESS, source_ip, login, "", "", "Push authentication confirmed");
            this.deleteFailCountPerLogin(login);
            this.deleteFailCountPerIP(source_ip);
            result = model.toJSON();
            result.put("status", (Object)status);
            return Response.ok((Object)result.toString()).cookie(new NewCookie[]{authCookie, XSRF}).build();
        }
        if (status.equals("false")) {
            logger.warn((Object)("User " + login + " authed rejected via push"));
            LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", "Push authentication rejected");
        }
        result.put("status", (Object)status);
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @Path(value="/roles")
    @Produces(value={"application/json"})
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    public Response getRoles() throws Exception {
        return Response.ok((Object)AuthFilter.getAllRoles().toString()).build();
    }

    @PermitAll
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    @Path(value="/checkaccess")
    @GET
    public Response checkToken() throws Exception {
        try {
            String login = AuthFilter.getAuthenticatedLogin(this.requestContext);
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            return Response.ok((Object)model.toJSON().toString()).build();
        }
        catch (Exception ice) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @PermitAll
    @Path(value="/logout")
    @GET
    @Produces(value={"application/json"})
    public Response logout() throws URISyntaxException {
        NewCookie authCookie = new NewCookie("X-Token", "", "/", null, null, AuthFilter.tokenExpirationMinutes * 60, AuthFilter.IS_SECURE, true);
        return Response.ok().location(new URI("/web/")).cookie(new NewCookie[]{authCookie}).build();
    }

    @PermitAll
    @Path(value="updatepassword")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateMyPassword(String request) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject json = new JSONObject(request);
        String login = "";
        if (json.has("login")) {
            String token = json.getString("token");
            login = ((Claims)Jwts.parser().requireAudience(AuthManager.AUTHSTATUS.PASSWORD_CHANGE.toString()).require("ip", (Object)source_ip).setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).getSubject();
        } else {
            login = AuthFilter.getAuthenticatedLogin(this.requestContext);
        }
        AccountModel accountModel = (AccountModel)DBManager.getDao(AccountModel.class).queryForEq("login", (Object)login).get(0);
        DBManager.findOne((Object)accountModel, (String)"login", (Object)login);
        if (accountModel.external.booleanValue()) {
            boolean extPwdUpdated = LdapManager.changeUserPassword(login, json.getString("oldpassword"), json.getString("password"));
            LogModel.register(LogModel.EVENT_TYPE.USER_PASSWORD_UPDATE, source_ip, login, login, "", "External password update result: " + extPwdUpdated);
            if (extPwdUpdated) {
                return Response.ok().build();
            }
            return Response.serverError().entity((Object)"{\"error\":\"Password not updated\"}").build();
        }
        if (accountModel.id != null && !accountModel.external.booleanValue() && !accountModel.checkPassword(json.getString("oldpassword")).equals((Object)AuthManager.AUTHSTATUS.WRONG_PASSWORD)) {
            accountModel.password = json.getString("password");
            accountModel.change_password = false;
            accountModel.hashPassword();
            LogModel.register(LogModel.EVENT_TYPE.USER_PASSWORD_UPDATE, source_ip, login, login, "", "Password updated");
            DBManager.getDao((Object)accountModel).update((Object)accountModel);
            DBManager.getDao((Object)accountModel).refresh((Object)accountModel);
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)"{\"error\":\"wrong old password\"}").build();
    }

    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @RolesAllowed(value={"ADMIN", "USERMANAGEMENT"})
    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response read(@PathParam(value="id") int id) throws Exception {
        AccountModel model = null;
        model = (AccountModel)DBManager.createDao(AccountModel.class).queryForId((Object)id);
        if (model == null) {
            throw new Exception("model with id " + id + " not found");
        }
        return Response.ok((Object)model).build();
    }

    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @RolesAllowed(value={"ADMIN", "USERMANAGEMENT"})
    @GET
    @Produces(value={"application/json"})
    public Response readAll() throws Exception {
        List models = DBManager.findAll(AccountModel.class);
        GenericEntity<List<AccountModel>> list = new GenericEntity<List<AccountModel>>(models){};
        return Response.ok((Object)list).build();
    }

    @RolesAllowed(value={"ADMIN", "USERMANAGEMENT"})
    @Path(value="/toggle/{id}")
    @POST
    @Produces(value={"application/json"})
    public Response toggle(@PathParam(value="id") int id) throws Exception {
        String login = AuthFilter.getAuthenticatedLogin(this.requestContext);
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        AccountModel model = null;
        model = (AccountModel)DBManager.createDao(AccountModel.class).queryForId((Object)id);
        if (model == null) {
            throw new Exception("model with id " + id + " not found");
        }
        if (model.login.equals("admin")) {
            throw new Exception("admin user could not be disabled");
        }
        model.enabled = model.enabled == false;
        DBManager.getDao((Object)model).update((Object)model);
        if (model.enabled.booleanValue()) {
            LogModel.register(LogModel.EVENT_TYPE.USER_ENABLED, source_ip, login, model.login, "", "User " + model.login + " enabled");
        } else {
            LogModel.register(LogModel.EVENT_TYPE.USER_DISABLED, source_ip, login, model.login, "", "User " + model.login + " disabled");
        }
        return Response.ok((Object)model).build();
    }

    @RolesAllowed(value={"ADMIN", "USERMANAGEMENT"})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(String request) throws Exception {
        JSONObject json = new JSONObject(request);
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String login = AuthFilter.getAuthenticatedLogin(this.requestContext);
        AccountModel newModel = AccountModel.fromJSONString(request);
        AccountModel oldModel = (AccountModel)DBManager.createDao(AccountModel.class).queryForId((Object)newModel.id);
        if (newModel.login.equals("admin") && !login.equals("admin")) {
            logger.error((Object)"admin user must be modified only by admin itself");
            throw new Exception("admin user must be modified only by admin itself");
        }
        if (!newModel.external.booleanValue() && newModel.password != null && !newModel.password.isEmpty()) {
            newModel.hashPassword();
        }
        if (newModel.external.booleanValue()) {
            newModel.hash = "external";
            newModel.change_password = false;
        }
        String initial_TOTP = json.optString("initial_TOTP", "");
        if (oldModel != null) {
            if (json.optBoolean("reset_totp", false) && oldModel.totp != null) {
                DBManager.getDao((Object)oldModel.totp).delete((Object)oldModel.totp);
                DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
                LogModel.register(LogModel.EVENT_TYPE.DELETE_TOTP, source_ip, login, newModel.login, "", "TOTP token removed for user " + newModel.login);
            }
            if (initial_TOTP != null && !initial_TOTP.equals("")) {
                if (oldModel.totp != null) {
                    oldModel.totp.initialTOTP = initial_TOTP;
                    oldModel.totp.secretKey = AuthManager.AUTHSTATUS.INITIAL_OTP_NEEDED.toString();
                    DBManager.getDao(TOTPModel.class).update((Object)oldModel.totp);
                    LogModel.register(LogModel.EVENT_TYPE.INIT_TOTP, source_ip, login, newModel.login, "", "Initial TOTP set for user " + newModel.login);
                } else {
                    TOTPModel totp = new TOTPModel();
                    totp.account = oldModel;
                    totp.initialTOTP = initial_TOTP;
                    totp.secretKey = AuthManager.AUTHSTATUS.INITIAL_OTP_NEEDED.toString();
                    DBManager.getDao(TOTPModel.class).create((Object)totp);
                    oldModel.totp = totp;
                    LogModel.register(LogModel.EVENT_TYPE.INIT_TOTP, source_ip, login, newModel.login, "", "Initial TOTP set for user " + newModel.login);
                }
                logger.debug((Object)("Initial TOTP set for user " + newModel.login));
            }
            NullAwareBeanUtilsBean notNullBeanUtils = new NullAwareBeanUtilsBean();
            notNullBeanUtils.copyProperties((Object)oldModel, (Object)newModel);
            DBManager.getDao((Object)oldModel).update((Object)oldModel);
            DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
            logger.info((Object)("model of class " + oldModel.getClass() + " with id " + oldModel.id + " updated"));
            LogModel.register(LogModel.EVENT_TYPE.USER_MODIFY, source_ip, login, newModel.login, "", "User modified " + newModel.login);
        } else {
            LogModel.register(LogModel.EVENT_TYPE.USER_ADD, source_ip, login, newModel.login, "", "User added " + newModel.login);
            DBManager.getDao((Object)newModel).create((Object)newModel);
            logger.info((Object)("model of class " + newModel.getClass() + " created"));
            if (initial_TOTP != null && !initial_TOTP.equals("")) {
                TOTPModel totp = new TOTPModel();
                totp.account = newModel;
                totp.initialTOTP = initial_TOTP;
                totp.secretKey = AuthManager.AUTHSTATUS.INITIAL_OTP_NEEDED.toString();
                DBManager.getDao(TOTPModel.class).create((Object)totp);
                LogModel.register(LogModel.EVENT_TYPE.INIT_TOTP, source_ip, login, newModel.login, "", "Initial TOTP set for user " + newModel.login);
                newModel.totp = totp;
                DBManager.getDao((Object)newModel).update((Object)newModel);
            }
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN", "USERMANAGEMENT"})
    @Path(value="/{ids}")
    @DELETE
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="ids") String selected) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String login = AuthFilter.getAuthenticatedLogin(this.requestContext);
        String[] sids = selected.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> logins = new ArrayList<String>();
        String[] stringArray = sids;
        int n = sids.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            AccountModel model = (AccountModel)DBManager.getDao(AccountModel.class).queryForId((Object)Integer.parseInt(s));
            if (model != null) {
                if (!model.login.toLowerCase().equals("admin")) {
                    ids.add(Integer.parseInt(s));
                    logins.add(model.login);
                }
            } else {
                logger.warn((Object)("Attempt to delete account model with no existent id: " + s));
            }
            ++n2;
        }
        if (ids.size() > 0) {
            DBManager.getDao(AccountModel.class).deleteIds(ids);
            for (String user_dst : logins) {
                LogModel.register(LogModel.EVENT_TYPE.USER_DELETE, source_ip, login, user_dst, "", "User deleted");
                logger.debug((Object)("User " + user_dst + " deleted"));
            }
        }
        return Response.ok().build();
    }

    @PermitAll
    @Path(value="/totp/generate")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @POST
    public Response generateTOTP(String request) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject json = new JSONObject(request);
        String token = json.getString("token");
        String login = ((Claims)Jwts.parser().requireAudience(AuthManager.AUTHSTATUS.GENERATE_OTP.toString()).require("ip", (Object)source_ip).setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).getSubject();
        GoogleAuthenticatorKey key = TOTPProvider.generateSecret((String)login);
        String base64QROde = TOTPProvider.generateQRcode((String)"LAPS", (String)login, (GoogleAuthenticatorKey)key);
        JSONObject result = new JSONObject();
        result.put("secret", (Object)key.getKey());
        result.put("qrcode", (Object)base64QROde);
        LogModel.register(LogModel.EVENT_TYPE.GENERATE_TOTP_SECRET, source_ip, login, login, "", "TOTP token generated");
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Path(value="/mobile/enrollMobileDevice")
    public Response enrollMobileDevice() throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject result = new JSONObject();
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String login = AuthFilter.getAuthenticatedLogin(this.requestContext).toLowerCase();
        AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
        JSONObject profile = model.getFullProfileJSON();
        if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
            logger.error((Object)("User " + login + " already has registered device"));
            return Response.serverError().entity((Object)"{\"error\":\"Mobile device already registered, delete it before new device registration\"}").build();
        }
        JSONObject deviceRegistrationJson = MobileManager.getInstance().startDeviceRegistration(login);
        ByteArrayOutputStream bytes = QRCode.from((String)deviceRegistrationJson.toString()).withSize(250, 250).to(ImageType.JPG).stream();
        byte[] encodedBytes = Base64.encodeBase64((byte[])bytes.toByteArray());
        result.put("mobileqr", (Object)new String(encodedBytes));
        logger.debug((Object)("Mobile registration data generated for " + login + " from " + source_ip));
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Path(value="/mobile/device")
    public Response getMobileDevice() throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        JSONObject result = new JSONObject();
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String login = AuthFilter.getAuthenticatedLogin(this.requestContext);
        AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
        JSONObject profile = model.getFullProfileJSON();
        if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
            result = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
            result.put("status", (Object)"enrolled");
        } else {
            result.put("status", (Object)"not_enrolled");
        }
        return Response.ok((Object)result.toString()).build();
    }

    @PermitAll
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Path(value="/capcha/generate/{login}")
    public Response generateCapcha(@PathParam(value="login") String login) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String capchaString = CapchaHelper.generateRandomString((String)SettingModel.get("auth:capcha_alphabet"), (int)SettingModel.getInt("auth:capcha_length", 5));
        String base64Capcha = CapchaHelper.generateBase64CapchaImage((String)capchaString);
        String uuid = UUID.randomUUID().toString();
        logger.debug((Object)("Capcha generated for login " + login + " src_ip: " + source_ip));
        JSONObject result = new JSONObject();
        result.put("capcha_img", (Object)base64Capcha);
        result.put("capcha_uuid", (Object)uuid);
        ClusterManager.putToCache("capcha:" + login + ":" + uuid, capchaString, true);
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @Path(value="/profile")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    public Response profile() throws URISyntaxException {
        AccountModel model = AuthFilter.getAuthenticatedModel(this.requestContext);
        JSONObject result = model.getNonSensitiveProfileJSON();
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @Path(value="/profile/CMD_PATTERN")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    public Response profileGetItems() throws URISyntaxException, JSONException {
        String result;
        block15: {
            String category = "CMD_PATTERN";
            AccountModel model = AuthFilter.getAuthenticatedModel(this.requestContext);
            UserProfileModel.CATEGORY profileCategory = UserProfileModel.CATEGORY.valueOf(category);
            Predicate<UserProfileModel> profilePredicate = p -> p.category.equals(category);
            UserProfileModel profileModel = null;
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            result = "";
            if (model.profiles == null) break block15;
            profileModel = model.profiles.stream().filter(profilePredicate).findFirst().orElse(null);
            if (profileModel == null) {
                return Response.ok((Object)"").build();
            }
            if (profileModel.type == null) {
                profileModel.type = "array";
            }
            switch (profileModel.type) {
                case "array": {
                    result = new JSONArray(profileModel.value).toString();
                    break;
                }
                case "object": {
                    result = new JSONObject(profileModel.value).toString();
                    break;
                }
                case "string": {
                    result = profileModel.value;
                    break;
                }
                default: {
                    result = new JSONArray(profileModel.value).toString();
                }
            }
            JSONArray jSONArray = new JSONArray(profileModel.value);
        }
        return Response.ok((Object)result).build();
    }

    @RolesAllowed(value={"AUTHED"})
    @Path(value="/profile/CMD_PATTERN/{id}")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    public Response profileGetItem(@PathParam(value="id") String id) throws URISyntaxException, JSONException, SQLException {
        String category = "CMD_PATTERN";
        JSONObject result = new JSONObject();
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.requestContext);
        SelectArg selectCategory = new SelectArg((Object)category);
        QueryBuilder qb = DBManager.getDao(UserProfileModel.class).queryBuilder();
        qb.where().eq("category", (Object)selectCategory).and().eq("account_id", (Object)accountModel.id);
        UserProfileModel profileModel = (UserProfileModel)DBManager.getDao(UserProfileModel.class).queryForFirst(qb.prepare());
        if (profileModel != null) {
            JSONArray existing = new JSONArray(profileModel.value);
            int i = 0;
            while (i < existing.length()) {
                JSONObject json = existing.getJSONObject(i);
                if (json.getString("id").equals(id)) {
                    result = json;
                }
                ++i;
            }
        }
        return Response.ok((Object)result.toString()).build();
    }

    @Path(value="/profile/CMD_PATTERN/{id}")
    @DELETE
    @RolesAllowed(value={"AUTHED"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response delProfile(@PathParam(value="id") String id) throws Exception {
        String category = "CMD_PATTERN";
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.requestContext);
        SelectArg selectCategory = new SelectArg((Object)category);
        QueryBuilder qb = DBManager.getDao(UserProfileModel.class).queryBuilder();
        qb.where().eq("category", (Object)selectCategory).and().eq("account_id", (Object)accountModel.id);
        UserProfileModel profileModel = (UserProfileModel)DBManager.getDao(UserProfileModel.class).queryForFirst(qb.prepare());
        JSONArray existing = new JSONArray(profileModel.value);
        String[] ids = id.split(",");
        int foundIndex = -1;
        JSONArray rest = new JSONArray();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String _id = stringArray[n2];
            int i = 0;
            while (i < existing.length()) {
                if (existing.getJSONObject(i).getString("id").equals(_id)) {
                    existing.remove(i);
                    break;
                }
                ++i;
            }
            ++n2;
        }
        if (existing.length() == 0) {
            DBManager.getDao((Object)profileModel).delete((Object)profileModel);
        } else {
            profileModel.value = existing.toString();
            DBManager.getDao((Object)profileModel).update((Object)profileModel);
        }
        return Response.ok().build();
    }

    @Path(value="/profile/CMD_PATTERN")
    @PUT
    @RolesAllowed(value={"AUTHED"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProfile(String request) throws Exception {
        String category = "CMD_PATTERN";
        JSONObject jsonObject = new JSONObject(request);
        JSONArray jsonArray = new JSONArray();
        String string = "";
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.requestContext);
        logger.debug((Object)("update profile request for " + accountModel.login + " " + request));
        SelectArg selectCategory = new SelectArg((Object)category);
        QueryBuilder qb = DBManager.getDao(UserProfileModel.class).queryBuilder();
        qb.where().eq("category", (Object)selectCategory).and().eq("account_id", (Object)accountModel.id);
        UserProfileModel profileModel = (UserProfileModel)DBManager.getDao(UserProfileModel.class).queryForFirst(qb.prepare());
        if (profileModel != null) {
            JSONArray existing = new JSONArray(profileModel.value);
            String updateUUID = jsonObject.optString("id", "");
            int foundIndex = -1;
            int i = 0;
            while (i < existing.length()) {
                if (existing.getJSONObject(i).getString("id").equals(updateUUID)) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex >= 0) {
                existing.put(foundIndex, (Object)jsonObject);
            } else {
                jsonObject.put("id", (Object)UUID.randomUUID().toString());
                existing.put((Object)jsonObject);
            }
            profileModel.value = existing.toString();
            DBManager.getDao((Object)profileModel).update((Object)profileModel);
            logger.debug((Object)("Profile [" + category + "] updated for " + accountModel.login));
        } else {
            profileModel = new UserProfileModel();
            jsonObject.put("id", (Object)UUID.randomUUID().toString());
            jsonArray.put((Object)jsonObject);
            profileModel.value = jsonArray.toString();
            profileModel.category = category;
            profileModel.account = accountModel;
            DBManager.getDao((Object)profileModel).create((Object)profileModel);
            logger.debug((Object)("New profile [" + category + "] created for " + accountModel.login));
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"AUTHED"})
    @Path(value="/profile/{category}/{operation}")
    @POST
    @Produces(value={"application/json"})
    public Response profileAdd(@PathParam(value="category") String category, @PathParam(value="operation") String operation, String request) throws URISyntaxException, JSONException, SQLException {
        JSONObject json = new JSONObject(request);
        String value = json.optString("value");
        AccountModel model = AuthFilter.getAuthenticatedModel(this.requestContext);
        model.modifyProfile(operation, category, value);
        return Response.ok().build();
    }

    private Integer getFailCountPerLogin(String login) {
        Integer count = ClusterManager.getInteger("fail_login:" + login);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    private Integer getFailCountPerIP(String ip) {
        Integer count = ClusterManager.getInteger("fail_ip:" + ip);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    private void deleteFailCountPerLogin(String login) {
        ClusterManager.putToCache("fail_login:" + login, "0", true);
    }

    private void deleteFailCountPerIP(String ip) {
        ClusterManager.putToCache("fail_ip:" + ip, "0", true);
    }

    private void increaseFailCount(String login, String ip) {
        Integer l = this.getFailCountPerLogin(login) + 1;
        Integer i = this.getFailCountPerIP(ip) + 1;
        ClusterManager.putToCache("fail_login:" + login, l.toString(), true);
        ClusterManager.putToCache("fail_ip:" + ip, i.toString(), true);
    }
}

