/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.tls.TlsHelper;
import com.ksoft.web.CacheControl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.security.pkcs10.PKCS10;

@Path(value="/certs")
@Singleton
public class CertsApi {
    static Logger logger = Logger.getLogger((String)CertsApi.class.getName());
    @Context
    HttpServletRequest requestContext;

    @RolesAllowed(value={"ADMIN"})
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response readAll() throws Exception {
        JSONArray result = TlsHelper.listCerts();
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/csr")
    @Produces(value={"text/plain"})
    @POST
    public Response generateCSR(String request) throws Exception {
        String hostname;
        JSONObject json = new JSONObject(request);
        String CN = hostname = json.getString("name").trim();
        if (hostname.contains(";") && !hostname.isEmpty()) {
            CN = hostname.substring(0, hostname.indexOf(";"));
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outStream);
        TlsHelper.generateSelfSignedCertificate((String)CN, (String)hostname);
        PrivateKey privKey = TlsHelper.getPrivateKey((String)CN);
        PublicKey pubKey = TlsHelper.getCertificate((String)CN).getPublicKey();
        PKCS10 csr = TlsHelper.generateCSR((PublicKey)pubKey, (PrivateKey)privKey, (String)"SHA256WithRSA", (String)hostname);
        csr.print(printStream);
        byte[] csrBytes = outStream.toByteArray();
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (printStream != null) {
            printStream.close();
        }
        return Response.ok((Object)new String(csrBytes)).header("Content-Disposition", (Object)("attachment; filename=" + CN + ".csr")).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @PUT
    @Produces(value={"application/json"})
    public Response importToKeyStore(String request) throws Exception {
        JSONObject json = new JSONObject(request);
        String FILE_UPLOAD_PATH = System.getProperty("java.io.tmpdir");
        String alias = json.getString("alias");
        String file = json.getString("file");
        String certfile = String.valueOf(FILE_UPLOAD_PATH) + File.separator + file;
        File f = new File(certfile);
        if (f.exists()) {
            TlsHelper.importCert((String)certfile, (String)alias);
            f.delete();
            TlsHelper.reinit();
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{ids}")
    @DELETE
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="ids") String selected) throws Exception {
        String[] sids = selected.split(",");
        if (sids.length > 0) {
            String[] stringArray = sids;
            int n = sids.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                TlsHelper.deleteCert((String)alias);
                ++n2;
            }
        }
        return Response.ok().build();
    }
}

