/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.tls.TlsHelper;
import com.ksoft.web.AuthFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/cluster")
@Singleton
public class ClusterApi {
    @Context
    HttpServletRequest requestContext;
    static Logger logger = Logger.getLogger((String)ClusterApi.class.getName());

    @RolesAllowed(value={"ENGINE"})
    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getInfo() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        String version = LapsLauncher.getVersion();
        JSONObject json = new JSONObject();
        json.put("version", (Object)version);
        return Response.ok((Object)json.toString()).build();
    }

    @RolesAllowed(value={"ENGINE"})
    @GET
    @Path(value="/settings")
    @Produces(value={"application/json"})
    public Response getAllSettings() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        List models = DBManager.findAll(SettingModel.class);
        GenericEntity<List<SettingModel>> list = new GenericEntity<List<SettingModel>>(models){};
        return Response.ok((Object)list).build();
    }

    @RolesAllowed(value={"ENGINE"})
    @POST
    @Path(value="/settings/{group}")
    @Produces(value={"application/json"})
    public Response updateSettings(@PathParam(value="group") String group, String request) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONArray array = new JSONArray(request);
        boolean needNotify = false;
        int i = 0;
        while (i < array.length()) {
            JSONObject json = array.getJSONObject(i);
            String key = json.getString("key");
            String remoteValue = json.getString("value");
            Long remote_modified = json.optLong("modified", 0L);
            SettingModel oldModel = (SettingModel)DBManager.createDao(SettingModel.class).queryForId((Object)key);
            Long cachedModified = SettingModel.getModified(key);
            String cachedValue = SettingModel.get(key);
            if (cachedModified == null) {
                cachedModified = 0L;
            }
            if (remote_modified > cachedModified) {
                if (!cachedValue.equals(remoteValue)) {
                    needNotify = true;
                    SettingModel.updateCache(key, remoteValue, remote_modified);
                }
                logger.debug((Object)("New settings from " + source_ip + " " + key + " existing timestamp: " + cachedModified + " remote timestamp: " + remote_modified));
                if (oldModel != null) {
                    oldModel.value = remoteValue;
                    oldModel.modified = remote_modified;
                    DBManager.getDao((Object)oldModel).update((Object)oldModel);
                    DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
                } else {
                    logger.error((Object)("Sync settings error from " + source_ip + ". " + key + " does not exist in current engine"));
                }
            }
            ++i;
        }
        if (needNotify) {
            logger.debug((Object)("New settings " + group + " recieved from " + source_ip));
            CoreEngine.getInstance().notifySettingsUpdate(group, false);
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ENGINE"})
    @POST
    @Path(value="/cache")
    @Produces(value={"application/json"})
    public Response updateCache(String request) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject json = new JSONObject(request);
        String key = json.getString("key");
        String sValue = json.getString("value");
        ClusterManager.putToCache(key, sValue, false);
        logger.debug((Object)("New cache element  " + key + " recieved from " + source_ip));
        return Response.ok().build();
    }

    @RolesAllowed(value={"ENGINE"})
    @DELETE
    @Path(value="/cache/{key}")
    @Produces(value={"application/json"})
    public Response removeFromCache(@PathParam(value="key") String key) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        ClusterManager.remove(key, false);
        logger.debug((Object)("Cache element  " + key + " deleted by request from " + source_ip));
        return Response.ok().build();
    }

    @RolesAllowed(value={"ENGINE"})
    @GET
    @Path(value="/cache")
    @Produces(value={"application/json"})
    public Response getCache() throws JSONException {
        JSONArray result = ClusterManager.getFullCache();
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ENGINE"})
    @GET
    @Path(value="/library/{type}/{operation}/{id}")
    @Produces(value={"application/json"})
    public Response notifyLibrary(@PathParam(value="type") String libTtype, @PathParam(value="operation") String operation, @PathParam(value="id") String id) throws JSONException {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        ClusterManager.LibraryNotification notifyType = ClusterManager.LibraryNotification.valueOf(operation.toUpperCase());
        logger.debug((Object)("Library notification recieved from " + source_ip + ". Library type: " + libTtype + " operation:" + operation));
        switch (notifyType) {
            case DEL: {
                String[] sids = id.split(",");
                logger.debug((Object)("Attempt to delete " + libTtype + " ids:" + sids));
                LibraryManager.del(libTtype, sids);
                break;
            }
            case RELOAD: {
                logger.debug((Object)("Attempt to reload " + libTtype + " id:" + id));
                LibraryManager.reload(libTtype, id);
                break;
            }
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ENGINE"})
    @DELETE
    @Path(value="/cert/{ids}")
    @Produces(value={"application/json"})
    public Response deleteCertificates(@PathParam(value="ids") String selected) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String[] sids = selected.split(",");
        if (sids.length > 0) {
            String[] stringArray = sids;
            int n = sids.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                TlsHelper.deleteCert((String)alias);
                ++n2;
            }
        }
        logger.debug((Object)("Certificates " + selected + " deleted by request from " + source_ip));
        return Response.ok().build();
    }
}

