/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.computers.ComputersGroupsManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.core.computers.LocalPCPolicyManager;
import com.ksoft.laps.db.HostModel;
import com.ksoft.laps.db.SecretModel;
import com.ksoft.web.CacheControl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/computers")
@Singleton
public class ComputersApi {
    @Context
    HttpServletRequest requestContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    @Context
    ContainerResponseContext responseContext;
    static Logger logger = Logger.getLogger((String)ComputersApi.class.getName());

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Path(value="/pctree")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    public Response getComputersTree() {
        JSONArray tree = ComputersManager.getInstance().getComputersTree();
        return Response.ok((Object)tree.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Path(value="/pctree/computers/{id}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    public Response getComputersFromGroup(@PathParam(value="id") String groupId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        List computers = DBManager.findAll(HostModel.class, (String)"node_id", (Object)groupId);
        GenericEntity<List<HostModel>> pclist = new GenericEntity<List<HostModel>>(computers){};
        return Response.ok((Object)pclist).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/pctree/computers/{id}")
    @POST
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    public Response updateComputer(@PathParam(value="id") String computerId, String request) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        JSONObject jReq = new JSONObject(request);
        Integer id = Integer.parseInt(computerId);
        HostModel host = (HostModel)DBManager.getDao(HostModel.class).queryForId((Object)id);
        if (host != null) {
            host.managedby = jReq.optString("managedby", null);
            DBManager.getDao(HostModel.class).update((Object)host);
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/pctree/group/add")
    @POST
    public Response addPcGroup(String request) throws JSONException {
        JSONObject json = new JSONObject(request);
        String name = json.getString("name");
        String parentNodeId = json.getString("node_id");
        String result = ComputersManager.getInstance().addPcGroup(name, parentNodeId);
        if (result != null) {
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("id", (Object)result);
            return Response.ok((Object)jsonResult.toString()).build();
        }
        return Response.serverError().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/pctree/group/rename")
    @POST
    public Response renamePcGroup(String request) throws JSONException {
        JSONObject json = new JSONObject(request);
        String name = json.getString("name");
        String nodeId = json.getString("node_id");
        boolean result = ComputersManager.getInstance().renamePCGroup(name, nodeId);
        if (result) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Path(value="/pctree/group/details/{nodeId}")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    public Response groupDetaild(@PathParam(value="nodeId") String nodeId) throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        JSONObject jResp = new JSONObject();
        JSONArray policy = LocalPCPolicyManager.getInstance().getPolicyForNode(nodeId);
        jResp.put("policy", (Object)policy);
        JSONArray groups = ComputersManager.getInstance().getAllowedGroupsForNode(nodeId);
        jResp.put("groups", (Object)groups);
        JSONArray rules = ComputersGroupsManager.getInstance().getRulesForNode(nodeId);
        jResp.put("rules", (Object)rules);
        return Response.ok((Object)jResp.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/pctree/group/paste")
    @POST
    public Response movePcGroup(String request) throws JSONException {
        JSONObject json = new JSONObject(request);
        String fromId = json.getString("fromid");
        String toId = json.getString("toid");
        boolean result = ComputersManager.getInstance().movePcGroup(fromId, toId);
        if (result) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/pctree/group/{id}")
    @DELETE
    public Response deletePcGroup(@PathParam(value="id") String id) throws JSONException {
        if (id.equals("0") || id.equals("-1")) {
            return Response.serverError().build();
        }
        boolean result = ComputersManager.getInstance().deletePcGroup(id);
        if (result) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @PermitAll
    @Path(value="/remote/ping")
    @GET
    public Response ping() {
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/host/{ids}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteComputers(@PathParam(value="ids") String selected) throws Exception {
        String[] sids = selected.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<SelectArg> selectIds = new ArrayList<SelectArg>();
        ArrayList<SelectArg> selectIds2 = new ArrayList<SelectArg>();
        String[] stringArray = sids;
        int n = sids.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ids.add(Integer.parseInt(s));
            selectIds.add(new SelectArg((Object)Integer.parseInt(s)));
            selectIds2.add(new SelectArg((Object)Integer.parseInt(s)));
            ++n2;
        }
        if (ids.size() > 0) {
            DeleteBuilder secretDelBuilder = DBManager.getDao(SecretModel.class).deleteBuilder();
            secretDelBuilder.where().in("host_id", selectIds);
            DBManager.getDao(SecretModel.class).delete(secretDelBuilder.prepare());
            DeleteBuilder delHostBuilder = DBManager.getDao(HostModel.class).deleteBuilder();
            delHostBuilder.where().in("id", selectIds2);
            DBManager.getDao(HostModel.class).delete(delHostBuilder.prepare());
            logger.debug((Object)("Hosts with ids " + ids.toString() + " deleted"));
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/moveto/{nodeId}/{ids}")
    @PUT
    @Produces(value={"application/json"})
    public Response moveComputers(@PathParam(value="nodeId") String newNodeId, @PathParam(value="ids") String selected) throws Exception {
        JSONObject resp = new JSONObject();
        if (!ComputersManager.getInstance().isNodeExists(newNodeId)) {
            resp.put("error", (Object)"Node does not exist");
            return Response.serverError().entity((Object)resp.toString()).build();
        }
        String[] sids = selected.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<SelectArg> selectIds = new ArrayList<SelectArg>();
        String[] stringArray = sids;
        int n = sids.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ids.add(Integer.parseInt(s));
            selectIds.add(new SelectArg((Object)Integer.parseInt(s)));
            ++n2;
        }
        if (ids.size() > 0) {
            UpdateBuilder userUpdateBuilder = DBManager.getDao(HostModel.class).updateBuilder();
            userUpdateBuilder.updateColumnValue("node_id", (Object)new SelectArg((Object)newNodeId));
            userUpdateBuilder.where().in("id", selectIds);
            userUpdateBuilder.update();
        }
        return Response.ok().build();
    }
}

