/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.dao.ForeignCollection;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.computers.ComputersGroupsManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.core.computers.LocalPCPolicyManager;
import com.ksoft.laps.db.HostModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SecretModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/v1/remotepc")
@Singleton
public class ComputersRemoteApi {
    @Context
    HttpServletRequest requestContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    @Context
    ContainerResponseContext responseContext;
    static Logger logger = Logger.getLogger((String)ComputersRemoteApi.class.getName());

    @PermitAll
    @Path(value="/ping")
    @GET
    public Response ping() {
        return Response.ok((Object)"ok").build();
    }

    @PermitAll
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/join")
    public Response joinPC(String request) throws JSONException, NoSuchAlgorithmException, InvalidKeySpecException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        JSONObject json = new JSONObject(request);
        JSONObject jResp = new JSONObject();
        String uuid = json.getString("uuid");
        String name = json.getString("name");
        String nodeUUID = json.optString("nodeid", null);
        Long ts = json.getLong("ts");
        String hmac = json.getString("hmac");
        String version = json.getString("version");
        long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        if (Math.abs(now - ts) >= SettingModel.getLong("computers_auth:max_clock_diff")) {
            String errMsg = "Wrong ts: current time " + now + " timestamp from request: " + ts;
            jResp.put("error", (Object)errMsg);
            logger.error((Object)("PC " + name + " join fail:" + errMsg));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jResp.toString()).build();
        }
        if (ComputersManager.getInstance().checkHMAC(hmac, SettingModel.get("computers_auth:hmac_password"), String.valueOf(name) + uuid + ts)) {
            if (ComputersManager.getInstance().joinPC(source_ip, uuid, nodeUUID, name, version)) {
                jResp.put("pubkey", (Object)SettingModel.get("computers_auth:pubkey_password"));
                String token = AuthFilter.generateTokenForPCAgent(uuid, SettingModel.getInt("computers_auth:pc_token_duration_days"));
                jResp.put("token", (Object)token);
                JSONArray policy = LocalPCPolicyManager.getInstance().getPolicyForHost(uuid);
                jResp.put("policy", (Object)policy);
                jResp.put("sync_interval_min", (Object)SettingModel.getInt("computers_agent:sync_interval_min"));
                jResp.put("policy_interval_sec", (Object)SettingModel.getInt("computers_agent:policy_interval_sec"));
                return Response.ok((Object)jResp.toString()).build();
            }
            String errMsg = "Unable to join computer";
            jResp.put("error", (Object)errMsg);
            logger.error((Object)(String.valueOf(errMsg) + " name"));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jResp.toString()).build();
        }
        String errMsg = "Wrong hmac";
        jResp.put("error", (Object)errMsg);
        logger.error((Object)("PC " + name + " join fail:" + errMsg));
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jResp.toString()).build();
    }

    @RolesAllowed(value={"PCAGENT"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Path(value="/password/prepare")
    public Response passwordChangePrepare(String request) throws Exception {
        String pcUuid = AuthFilter.getAuthenticatedPCUUID(this.requestContext);
        JSONObject json = new JSONObject(request);
        JSONObject jResp = new JSONObject();
        String subject = json.getString("subject");
        String secret = json.getString("secret");
        try {
            String commitUUID = ComputersManager.getInstance().passwordChangePrepare(pcUuid, subject, secret);
            if (commitUUID != null) {
                jResp.put("uuid", (Object)commitUUID);
                return Response.ok((Object)jResp.toString()).build();
            }
            logger.error((Object)("Preparation not successfull for" + pcUuid));
            jResp.put("error", (Object)"Preparation not successfull");
            return Response.serverError().entity((Object)jResp.toString()).build();
        }
        catch (ComputersManager.ComputerManagerException e) {
            logger.error((Object)"passwordChangePrepare error", (Throwable)e);
            jResp.put("error", (Object)e.getMessage());
            jResp.put("code", (Object)e.getErrorCode().toString());
            return Response.serverError().entity((Object)jResp.toString()).build();
        }
    }

    @RolesAllowed(value={"PCAGENT"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/password/commit")
    public Response passwordCommit(String request) throws Exception {
        String pcUuid = AuthFilter.getAuthenticatedPCUUID(this.requestContext);
        JSONObject json = new JSONObject(request);
        String subject = json.getString("subject");
        String commitUUID = json.getString("uuid");
        JSONObject jResp = new JSONObject();
        try {
            boolean isCommitted = ComputersManager.getInstance().passwordChangeCommit(pcUuid, subject, commitUUID);
            if (isCommitted) {
                return Response.ok().build();
            }
            jResp.put("error", (Object)"Password commit error");
            return Response.serverError().entity((Object)jResp.toString()).build();
        }
        catch (ComputersManager.ComputerManagerException e) {
            logger.error((Object)"passwordChangePrepare error", (Throwable)e);
            jResp.put("error", (Object)e.getMessage());
            jResp.put("code", (Object)e.getErrorCode().toString());
            return Response.serverError().entity((Object)jResp.toString()).build();
        }
    }

    @RolesAllowed(value={"PCAGENT"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/settings/sync")
    public Response syncSettings(String request) throws SQLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, IOException, JSONException {
        JSONObject json = new JSONObject(request);
        String version = json.getString("version");
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String uuid = AuthFilter.getAuthenticatedPCUUID(this.requestContext);
        JSONObject jResp = new JSONObject();
        HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)uuid);
        if (hostModel != null) {
            hostModel.version = version;
            hostModel.touchLastSeen();
            JSONArray policy = LocalPCPolicyManager.getInstance().getPolicyForHost(uuid);
            jResp.put("policy", (Object)policy);
            ForeignCollection<SecretModel> secrets = hostModel.secrets;
            JSONArray expireArray = new JSONArray();
            secrets.forEach(secret -> {
                JSONObject j = new JSONObject();
                try {
                    Long tsExpire = -1L;
                    if (secret.ts_expire != null) {
                        tsExpire = secret.ts_expire;
                    }
                    j.put("expire", (Object)tsExpire);
                    j.put("subject", (Object)secret.subject);
                    expireArray.put((Object)j);
                }
                catch (Exception e) {
                    logger.error((Object)("Something wrong with secret of " + uuid), (Throwable)e);
                }
            });
            jResp.put("expire", (Object)expireArray);
            String token = AuthFilter.generateTokenForPCAgent(uuid, SettingModel.getInt("computers_auth:pc_token_duration_days"));
            jResp.put("token", (Object)token);
            jResp.put("sync_interval_min", (Object)SettingModel.getInt("computers_agent:sync_interval_min"));
            jResp.put("policy_interval_sec", (Object)SettingModel.getInt("computers_agent:policy_interval_sec"));
            String newNodeId = ComputersGroupsManager.getInstance().getNodeIDforComputer(hostModel.name, source_ip);
            if (newNodeId != null && !hostModel.node_id.equals(newNodeId) && ComputersManager.getInstance().isNodeExists(newNodeId)) {
                hostModel.node_id = newNodeId;
            }
            DBManager.getDao(HostModel.class).update((Object)hostModel);
            return Response.ok((Object)jResp.toString()).build();
        }
        return Response.serverError().build();
    }

    @RolesAllowed(value={"PCAGENT"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/log/send")
    public Response sendLogs(String request) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        String source_ip = AuthFilter.getSourceIP(this.requestContext);
        String pcUuid = AuthFilter.getAuthenticatedPCUUID(this.requestContext);
        HostModel model = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)pcUuid);
        if (model != null) {
            JSONArray jArray = new JSONArray(request);
            int i = 0;
            while (i < jArray.length()) {
                String line = (String)jArray.get(i);
                LogModel.register(LogModel.EVENT_TYPE.AGENT_EVENT, source_ip, "", model.name, line);
                ++i;
            }
        }
        return Response.ok().build();
    }
}

