/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.laps.core.BitLockerManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.web.LAPSextra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Path(value="/file")
@Singleton
public class FileRecieverApi {
    static Logger logger = Logger.getLogger((String)FileRecieverApi.class.getName());

    @RolesAllowed(value={"ADMIN"})
    @POST
    @LAPSextra(noCSRFCheck=true)
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/upload/{what}")
    public String fileUpload(@Context HttpServletRequest request, @PathParam(value="what") String what) throws Exception {
        JSONObject result;
        block32: {
            result = new JSONObject();
            Object candidateName = null;
            String FILE_UPLOAD_PATH = "";
            File savedFile = null;
            switch (what) {
                case "bitlockergroups": 
                case "groups": 
                case "cert": 
                case "license": {
                    FILE_UPLOAD_PATH = System.getProperty("java.io.tmpdir");
                    break;
                }
                default: {
                    return "Wrong type";
                }
            }
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) break block32;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
            FileItemIterator iter = fileUpload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getName().replace("..", "").replace("/", "").replace("\\", "");
                if (!name.matches("[a-zA-Z0-9_\\.-]+")) {
                    logger.error((Object)("Wrong file name " + name));
                    return "wrong name";
                }
                InputStream inputStream = item.openStream();
                if (!item.isFormField()) {
                    savedFile = new File(String.valueOf(FILE_UPLOAD_PATH) + File.separator + name);
                    logger.info((Object)("Saving file " + name + " to " + savedFile.getAbsolutePath()));
                    FileOutputStream fileStream = new FileOutputStream(savedFile);
                    int read = 0;
                    byte[] bytes = new byte[65536];
                    while ((read = inputStream.read(bytes)) != -1) {
                        fileStream.write(bytes, 0, read);
                    }
                    fileStream.close();
                }
                inputStream.close();
            }
            switch (what) {
                case "groups": {
                    LdapManager ldapManager = (LdapManager)LibraryManager.getManager(LibraryManager.TYPE.GROUP_OU_MAPPING.toString());
                    int importedCount = ldapManager.importFromFile(savedFile.getAbsolutePath());
                    savedFile.delete();
                    result.put("count", importedCount);
                    break;
                }
                case "bitlockergroups": {
                    BitLockerManager bitlockerManager = (BitLockerManager)LibraryManager.getManager(LibraryManager.TYPE.BITLOCKER_MAPPING.toString());
                    int importedBitLockerCount = bitlockerManager.importFromFile(savedFile.getAbsolutePath());
                    savedFile.delete();
                    result.put("count", importedBitLockerCount);
                    break;
                }
                case "license": {
                    String licenseFile = String.valueOf(SettingsManager.getBaseFolder()) + "conf/license.txt";
                    java.nio.file.Path to = Paths.get(licenseFile, new String[0]);
                    java.nio.file.Path from = Paths.get(savedFile.getAbsolutePath(), new String[0]);
                    boolean licImported = CoreEngine.getLicenseManager().loadLicense(savedFile.getAbsolutePath());
                    if (!licImported) {
                        throw new Exception("License file is invalid");
                    }
                    Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
                    CoreEngine.getLicenseManager().setLicenseFile(licenseFile);
                }
            }
        }
        return result.toString();
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @LAPSextra(noCSRFCheck=true)
    @Path(value="/download/{what}/{name}")
    public Response fileDownload(@Context HttpServletRequest request, @PathParam(value="what") String what, @PathParam(value="name") String name) throws Exception {
        String fileName = name.replace("\"", "").replace("..", ".").replace("/", "").replace("\\", "");
        String FILE_PATH = "";
        switch (what) {
            case "log": {
                FILE_PATH = String.valueOf(SettingsManager.getBaseFolder()) + "logs/" + fileName;
            }
        }
        File f = new File(FILE_PATH);
        if (f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            return Response.ok((Object)fis).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        return Response.serverError().build();
    }
}

