/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.JiaManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.TransactionModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/jia")
@Singleton
public class JIAApi {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;

    @GET
    @RolesAllowed(value={"ADMIN", "JIAUSER"})
    @Path(value="/myroles")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getMyRoles() throws JSONException {
        AccountModel model = AuthFilter.getAuthenticatedModel(this.servletContext);
        Set<String> roles = JiaManager.getInstance().getUserRoles(model);
        JSONArray jsonArray = new JSONArray();
        for (String role : roles) {
            JSONObject jRole = new JSONObject();
            jRole.put("name", (Object)role);
            jRole.put("ttl", (Object)JiaManager.getInstance().getRoleTTLSeconds(role));
            JSONObject config = JiaManager.getInstance().getRoleConfig(role);
            if (config != null) {
                jRole.put("config", (Object)config);
            }
            jsonArray.put((Object)jRole);
        }
        return Response.ok((Object)jsonArray.toString()).build();
    }

    @GET
    @Path(value="/sessions")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @RolesAllowed(value={"ADMIN", "JIAUSER"})
    public Response getMyTasks() throws SQLException, JSONException {
        AccountModel model = AuthFilter.getAuthenticatedModel(this.servletContext);
        Long now = Instant.now().toEpochMilli();
        JSONArray tasks = JiaManager.getInstance().getActiveTasks(model);
        return Response.ok((Object)tasks.toString()).build();
    }

    @DELETE
    @RolesAllowed(value={"ADMIN", "JIAUSER"})
    @Path(value="/session/{id}")
    public Response stopRole(@PathParam(value="id") Integer id) throws SQLException {
        AccountModel model = AuthFilter.getAuthenticatedModel(this.servletContext);
        boolean isStopped = JiaManager.getInstance().stopRole(id, model);
        if (isStopped) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/apply")
    @RolesAllowed(value={"ADMIN", "JIAUSER"})
    public Response applyToRole(String sRequest) throws JSONException, SQLException {
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        AccountModel model = AuthFilter.getAuthenticatedModel(this.servletContext);
        JSONObject request = new JSONObject(sRequest);
        String roleName = request.getString("role");
        Long tillMilli = request.getLong("till");
        Integer transId = JiaManager.getInstance().applyToRole(model, roleName, tillMilli);
        if (transId > 0) {
            TransactionModel transaction = (TransactionModel)DBManager.getDao(TransactionModel.class).queryForId((Object)transId);
            GenericEntity<TransactionModel> result = new GenericEntity<TransactionModel>(transaction){};
            LogModel.register(LogModel.EVENT_TYPE.JITA_ROLE_APPLY, source_ip, model.getLogin(), "", "Role " + roleName + " applied. Transaction id: " + transId);
            return Response.ok((Object)result).build();
        }
        LogModel.register(LogModel.EVENT_TYPE.JITA_ROLE_APPLY_FAIL, source_ip, model.getLogin(), "", "Role " + roleName + " not applied");
        return Response.serverError().build();
    }
}

