/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.auth.AuthManager;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.APITokenManager;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/laps")
@Singleton
public class LapsAPI {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    private static HashMap<String, Integer> failCountPerLogin = new HashMap();
    private static HashMap<String, Integer> failCountPerIP = new HashMap();
    static Logger logger = Logger.getLogger((String)LapsAPI.class.getName());
    static String safeRegex = "[a-zA-Z0-9_\\\\@\\.-]+";

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/password/{pc}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPassword(@PathParam(value="pc") String pc) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
        String searchPC = pc.trim().toLowerCase();
        String login = accountModel.getLogin();
        Integer timeout = SettingModel.getInt("laps_extra:laps_access_timeout");
        if (searchPC.trim().matches("[a-zA-Z0-9_-]+")) {
            JSONObject result = null;
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            Long pre = ClusterManager.getLong("laps_pwd_access:" + login);
            if (pre != null) {
                long diff = now - pre;
                if (diff < (long)timeout.intValue()) {
                    logger.error((Object)("Laps password access to fast login: " + login + " pc: " + searchPC + " current time:" + now + " previous:" + pre + " timeout:" + timeout));
                    return Response.serverError().entity((Object)("{\"error\":\"Too fast requests, please wait " + String.valueOf((long)timeout.intValue() - diff) + " sec\"}")).build();
                }
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            } else {
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            }
            JSONObject adSecrets = new JSONObject();
            JSONObject localSercrets = new JSONObject();
            result = LdapManager.getCompInfo(searchPC.trim(), accountModel);
            if (result.has("error")) {
                LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, login, "", searchPC, result.getString("error"));
                return Response.serverError().entity((Object)result.toString()).build();
            }
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, login, "", searchPC, "");
            if (!CoreEngine.getLicenseManager().isLicenseValid()) {
                result.put("error", (Object)CoreEngine.getLicenseManager().getLicenseError());
                logger.error((Object)("License invalid! Returning masked value for PC " + searchPC));
            }
            return Response.ok((Object)result.toString()).build();
        }
        logger.error((Object)("PC not pass regex " + searchPC));
        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", searchPC, "PC not mathced regex [a-zA-Z0-9_-]+");
        return Response.serverError().entity((Object)"{\"error\":\"PC not passed regex [a-zA-Z0-9_-]+, please check computer name\"}").build();
    }

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/v2/password/{pc}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPasswordv2(@PathParam(value="pc") String pc) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
        String searchPC = pc.trim().toLowerCase();
        String login = accountModel.getLogin();
        Integer timeout = SettingModel.getInt("laps_extra:laps_access_timeout");
        if (searchPC.trim().matches("[a-zA-Z0-9_-]+")) {
            Object result = null;
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            Long pre = ClusterManager.getLong("laps_pwd_access:" + login);
            if (pre != null) {
                long diff = now - pre;
                if (diff < (long)timeout.intValue()) {
                    logger.error((Object)("Laps password access to fast login: " + login + " pc: " + searchPC + " current time:" + now + " previous:" + pre + " timeout:" + timeout));
                    return Response.serverError().entity((Object)("{\"error\":\"Too fast requests, please wait " + String.valueOf((long)timeout.intValue() - diff) + " sec\"}")).build();
                }
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            } else {
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            }
            JSONObject adSecrets = new JSONObject();
            JSONObject localSercrets = new JSONObject();
            String errorMsg = "";
            if (LdapManager.isLDAPconfigured()) {
                adSecrets = LdapManager.getCompInfo(searchPC.trim(), accountModel);
            }
            localSercrets = ComputersManager.getInstance().getCompInfo(searchPC.trim(), accountModel);
            if (adSecrets.has("error")) {
                errorMsg = adSecrets.getString("error");
            }
            if (localSercrets.has("error")) {
                if (!errorMsg.isEmpty()) {
                    errorMsg = String.valueOf(errorMsg) + "\r\n";
                }
                errorMsg = String.valueOf(errorMsg) + localSercrets.getString("error");
            }
            if (!errorMsg.isEmpty()) {
                result.put("error", (Object)errorMsg);
            }
            if (adSecrets.has("password") || adSecrets.has("extra")) {
                result.put("laps", (Object)adSecrets);
            }
            if (localSercrets.has("secrets")) {
                result.put("localsecrets", (Object)localSercrets.getJSONArray("secrets"));
            } else {
                result.put("localsecrets", (Object)new JSONArray());
            }
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, login, "", searchPC, "");
            if (!CoreEngine.getLicenseManager().isLicenseValid()) {
                result.put("error", (Object)CoreEngine.getLicenseManager().getLicenseError());
                logger.error((Object)("License invalid! Returning masked value for PC " + searchPC));
            }
            return Response.ok((Object)result.toString()).build();
        }
        logger.error((Object)("PC not pass regex " + searchPC));
        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", searchPC, "PC not mathced regex [a-zA-Z0-9_-]+");
        return Response.serverError().entity((Object)"{\"error\":\"PC not passed regex [a-zA-Z0-9_-]+, please check computer name\"}").build();
    }

    @PermitAll
    @Path(value="/passwordbyotp")
    @POST
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPasswordByOTP(String request) throws Exception {
        JSONObject jresp = new JSONObject();
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        JSONObject json = new JSONObject(request);
        String login = json.getString("login").trim().toLowerCase();
        String password = json.optString("password", null);
        String otp = json.getString("otp");
        String pc = json.getString("pc").trim().toLowerCase();
        if (failCountPerLogin.getOrDefault(login, 0) >= SettingModel.getInt("auth:capcha_count") || failCountPerIP.getOrDefault(source_ip, 0) >= SettingModel.getInt("auth:capcha_count")) {
            jresp.put("status", (Object)AuthManager.AUTHSTATUS.CAPCHA_REQUIRED);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jresp.toString()).build();
        }
        AuthManager.AUTHSTATUS authStatus = CoreEngine.getInstance().getAuthManager().authNonExisting(login, password, otp, source_ip);
        if (authStatus.equals((Object)AuthManager.AUTHSTATUS.SUCCESS)) {
            AccountModel accountModel = new AccountModel();
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login.toLowerCase());
            if (model != null) {
                accountModel = model;
            } else {
                accountModel.login = login.toLowerCase();
                accountModel.external = true;
                accountModel.enabled = true;
            }
            if (pc.matches("[a-zA-Z0-9_-]+")) {
                JSONObject result = null;
                result = LdapManager.getCompInfo(pc, accountModel);
                if (result.has("error")) {
                    LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", pc, result.getString("error"));
                    return Response.serverError().entity((Object)result.toString()).build();
                }
                LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, accountModel.login, "", pc, "");
                return Response.ok((Object)result.toString()).build();
            }
            logger.error((Object)("PC not pass regex " + pc));
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", pc, "PC not mathced regex [a-zA-Z0-9_-]+");
            return Response.serverError().entity((Object)"{\"error\":\"PC not passed regex [a-zA-Z0-9_-]+, please check computer name\"}").build();
        }
        return null;
    }

    @PermitAll
    @Path(value="/passwordbytoken/{pc}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPasswordByToken(@PathParam(value="pc") String pc) throws Exception {
        JSONObject result = new JSONObject();
        String token = AuthFilter.getAuthToken(this.servletContext);
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        APITokenManager manager = APITokenManager.getInstance();
        String tokenID = manager.getTokenID(token);
        if (manager.checkToken(token, source_ip)) {
            String allowedOU = manager.getAllowedOU(token);
            if (pc.matches("[a-zA-Z0-9_-]+") && allowedOU != null) {
                result = LdapManager.getCompInfoRestricted(pc, allowedOU);
            }
        } else {
            result.put("error", (Object)"Invalid token");
            logger.error((Object)("Invalid token from " + source_ip));
        }
        if (result.has("error")) {
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, "Token_" + tokenID, "", pc, result.getString("error"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)result.toString()).build();
        }
        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, "Token_" + tokenID, "", pc, "");
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/expire")
    @POST
    @Produces(value={"application/json"})
    public Response setExpire(String request) throws Exception {
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
        boolean forceUpdateToAllDC = SettingModel.getBool("laps_extra:expire_force_alldc");
        JSONObject json = new JSONObject(request);
        String computer = json.getString("computer").trim().toLowerCase();
        Long expire = json.getLong("expire");
        boolean result = LdapManager.setExpire(computer, accountModel, expire, forceUpdateToAllDC);
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        if (result) {
            LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE, source_ip, accountModel.login.toLowerCase(), "", computer, "New expire: " + Instant.ofEpochMilli(expire).toString());
            return Response.ok().build();
        }
        LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE_FAIL, source_ip, accountModel.login.toLowerCase(), "", computer, "Failed to set new expire: " + Instant.ofEpochMilli(expire).toString());
        return Response.serverError().build();
    }
}

