/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.db.LibraryModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.utils.NullAwareBeanUtilsBean;
import com.ksoft.web.CacheControl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Path(value="/library")
@Singleton
public class LibraryApi {
    static Logger logger = Logger.getLogger((String)LibraryApi.class.getName());

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{type}")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    @Produces(value={"application/json"})
    public Response readAll(@PathParam(value="type") String type) throws Exception {
        List models = DBManager.findAll(LibraryModel.class, (String)"type", (Object)type);
        GenericEntity<List<LibraryModel>> list = new GenericEntity<List<LibraryModel>>(models){};
        return Response.ok((Object)list).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{type}/{id}")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    @Produces(value={"application/json"})
    public Response read(@PathParam(value="type") String type, @PathParam(value="id") int id) throws Exception {
        JSONObject config;
        LibraryModel model = null;
        SelectArg selectIdArg = new SelectArg();
        selectIdArg.setValue((Object)id);
        SelectArg selectTypeArg = new SelectArg();
        selectTypeArg.setValue((Object)type);
        QueryBuilder qb = DBManager.createDao(LibraryModel.class).queryBuilder();
        qb.where().eq("id", (Object)selectIdArg).and().eq("type", (Object)selectTypeArg);
        model = (LibraryModel)DBManager.getDao(LibraryModel.class).queryForFirst(qb.prepare());
        if (model == null) {
            throw new Exception("model with id " + id + " of type " + type + " not found");
        }
        JSONObject json = model.toJSON();
        if (json.has("config") && (config = json.getJSONObject("config")).has("password")) {
            config.put("password", (Object)"******");
            json.put("config", (Object)config);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{type}/{ids}")
    @DELETE
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="type") String type, @PathParam(value="ids") String selected) throws Exception {
        String[] sids = selected.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<SelectArg> selectIds = new ArrayList<SelectArg>();
        String[] stringArray = sids;
        int n = sids.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ids.add(Integer.parseInt(s));
            selectIds.add(new SelectArg((Object)Integer.parseInt(s)));
            ++n2;
        }
        if (ids.size() > 0) {
            DeleteBuilder delBuilder = DBManager.getDao(LibraryModel.class).deleteBuilder();
            delBuilder.where().eq("type", (Object)type).and().in("id", selectIds);
            DBManager.getDao(LibraryModel.class).delete(delBuilder.prepare());
            LibraryManager.del(type, sids);
            logger.debug((Object)("Elements " + type + " with ids " + ids.toString() + " deleted"));
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{type}/{action}/{id}")
    @POST
    @Produces(value={"application/json"})
    public Response toggle(@PathParam(value="type") String type, @PathParam(value="action") String action, @PathParam(value="id") String id) throws Exception {
        Boolean enabled;
        SelectArg selectIdArg = new SelectArg();
        selectIdArg.setValue((Object)id);
        SelectArg selectTypeArg = new SelectArg();
        selectTypeArg.setValue((Object)type);
        QueryBuilder qb = DBManager.createDao(LibraryModel.class).queryBuilder();
        qb.where().eq("type", (Object)selectTypeArg).and().eq("id", (Object)selectIdArg);
        LibraryModel model = (LibraryModel)DBManager.getDao(LibraryModel.class).queryForFirst(qb.prepare());
        boolean oldEnabled = model.enabled;
        model.enabled = action.equals("toggle") ? Boolean.valueOf(model.enabled == false) : (enabled = Boolean.valueOf(action));
        if (oldEnabled != model.enabled) {
            DBManager.getDao((Object)model).update((Object)model);
            if (model.enabled.booleanValue()) {
                LibraryManager.getManager(type).add(id, model.name, model.getConfigJSON());
                ClusterManager.getInstance().notifyRemoteLibrary(type, ClusterManager.LibraryNotification.RELOAD, id);
            } else {
                LibraryManager.getManager(type).del(id);
                ClusterManager.getInstance().notifyRemoteLibrary(type, ClusterManager.LibraryNotification.DEL, id);
            }
            logger.debug((Object)("Elements " + type + " with ids " + id.toString() + " enabled " + oldEnabled + "=>" + model.enabled));
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{type}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="type") String type, String request) throws Exception {
        LibraryModel newModel = LibraryModel.fromJSONString(request);
        newModel.type = type;
        if (newModel.id == null) {
            newModel.beforeCreate();
            DBManager.getDao((Object)newModel).create((Object)newModel);
            LibraryManager.create(type, newModel.id.toString(), newModel.name, newModel.getConfigJSON());
            ClusterManager.getInstance().notifyRemoteLibrary(type, ClusterManager.LibraryNotification.RELOAD, newModel.id.toString());
            logger.info((Object)("model of class " + newModel.getClass() + " created"));
        } else {
            JSONObject newConfig;
            QueryBuilder qb = DBManager.createDao(LibraryModel.class).queryBuilder();
            SelectArg selectId = new SelectArg((Object)newModel.id);
            SelectArg selectType = new SelectArg((Object)type);
            qb.where().eq("id", (Object)selectId).and().eq("type", (Object)selectType);
            LibraryModel oldModel = (LibraryModel)DBManager.getDao(LibraryModel.class).queryForFirst(qb.prepare());
            if (newModel.config != null && !newModel.config.isEmpty() && (newConfig = newModel.getConfigJSON()).has("password") && newConfig.getString("password").equals("******")) {
                newConfig.put("password", (Object)SettingModel.decrypt(oldModel.getConfigJSON().getString("password")));
                newModel.config = newConfig.toString();
            }
            NullAwareBeanUtilsBean notNullBeanUtils = new NullAwareBeanUtilsBean();
            notNullBeanUtils.copyProperties((Object)oldModel, (Object)newModel);
            oldModel.name = newModel.name;
            oldModel.config = newModel.config;
            oldModel.beforeUpdate();
            DBManager.getDao((Object)oldModel).update((Object)oldModel);
            DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
            LibraryManager.update(type, oldModel.id.toString(), oldModel.name, oldModel.getConfigJSON());
            ClusterManager.getInstance().notifyRemoteLibrary(type, ClusterManager.LibraryNotification.RELOAD, oldModel.id.toString());
            logger.info((Object)("model of class " + oldModel.getClass() + " with id " + oldModel.id + " updated"));
        }
        return Response.ok().build();
    }
}

