/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.ksoft.core.DBManager;
import com.ksoft.laps.db.LogModel;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/logs")
@Singleton
public class LogsApi {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    static Logger logger = Logger.getLogger((String)LogsApi.class.getName());

    @RolesAllowed(value={"ADMIN", "LOGSACCESS"})
    @Path(value="/search")
    @POST
    @Produces(value={"application/json"})
    public Response search(String request) throws JSONException, SQLException {
        Long maxRows = 20000L;
        JSONObject jObject = new JSONObject(request);
        Iterator keys = jObject.keys();
        long from = 0L;
        long to = 0L;
        SelectArg selectFromArg = new SelectArg();
        selectFromArg.setValue((Object)from);
        SelectArg selectToArg = new SelectArg();
        selectToArg.setValue((Object)to);
        QueryBuilder builder = DBManager.getDao(LogModel.class).queryBuilder();
        Where where = builder.where();
        where.ge("id", (Object)1);
        block8: while (keys.hasNext()) {
            String key;
            switch (key = (String)keys.next()) {
                case "from": {
                    from = jObject.getLong(key);
                    selectFromArg.setValue((Object)from);
                    where.and().ge("ts_created", (Object)selectFromArg);
                    break;
                }
                case "to": {
                    to = jObject.getLong(key);
                    selectToArg.setValue((Object)to);
                    where.and().le("ts_created", (Object)selectToArg);
                    break;
                }
                default: {
                    String value = jObject.getString(key);
                    if (value.isEmpty()) continue block8;
                    SelectArg selectKeyArg = new SelectArg();
                    selectKeyArg.setValue((Object)jObject.getString(key));
                    where.and().like(key, (Object)selectKeyArg);
                }
            }
        }
        builder.limit(maxRows);
        builder.orderBy("ts_created", true);
        List models = DBManager.getDao(LogModel.class).query(builder.prepare());
        GenericEntity<List<LogModel>> list = new GenericEntity<List<LogModel>>(models){};
        return Response.ok((Object)list).build();
    }

    @RolesAllowed(value={"ADMIN", "LOGSACCESS"})
    @Path(value="/categories")
    @GET
    @Produces(value={"application/json"})
    public Response categories() throws JSONException, SQLException {
        JSONArray array = new JSONArray();
        LogModel.CATEGORY[] values = LogModel.CATEGORY.values();
        int i = 0;
        while (i < values.length) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)values[i].name());
            json.put("name", (Object)values[i].toString());
            array.put((Object)json);
            ++i;
        }
        return Response.ok((Object)array.toString()).build();
    }

    @RolesAllowed(value={"ADMIN", "LOGSACCESS"})
    @Path(value="/export")
    @POST
    @Produces(value={"text/plain"})
    public Response export(String request) throws JSONException, SQLException, IOException {
        Long maxRows = 1000000L;
        JSONObject jObject = new JSONObject(request);
        Iterator keys = jObject.keys();
        long from = 0L;
        long to = 0L;
        SelectArg selectFromArg = new SelectArg();
        selectFromArg.setValue((Object)from);
        SelectArg selectToArg = new SelectArg();
        selectToArg.setValue((Object)to);
        final QueryBuilder builder = DBManager.getDao(LogModel.class).queryBuilder();
        Where where = builder.where();
        where.ge("id", (Object)1);
        block8: while (keys.hasNext()) {
            String key;
            switch (key = (String)keys.next()) {
                case "from": {
                    from = jObject.getLong(key);
                    selectFromArg.setValue((Object)from);
                    where.and().ge("ts_created", (Object)selectFromArg);
                    break;
                }
                case "to": {
                    to = jObject.getLong(key);
                    selectToArg.setValue((Object)to);
                    where.and().le("ts_created", (Object)selectToArg);
                    break;
                }
                default: {
                    String value = jObject.getString(key);
                    if (value.isEmpty()) continue block8;
                    SelectArg selectKeyArg = new SelectArg();
                    selectKeyArg.setValue((Object)jObject.getString(key));
                    where.and().like(key, (Object)selectKeyArg);
                }
            }
        }
        builder.limit(maxRows);
        builder.orderBy("ts_created", true);
        List models = DBManager.getDao(LogModel.class).query(builder.prepare());
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException {
                CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), ';', '\"', '\\');
                try {
                    CloseableIterator iterator = DBManager.getDao(LogModel.class).iterator(builder.prepare());
                    while (iterator.hasNext()) {
                        LogModel model = (LogModel)iterator.next();
                        writer.writeNext(model.getValues().toArray(new String[0]));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"Export log error", (Throwable)e);
                }
                writer.flush();
            }
        };
        return Response.ok((Object)stream).header("x-filename", (Object)"export.log").build();
    }
}

