/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.MobileManager;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import com.ksoft.web.LAPSextra;
import javax.annotation.security.PermitAll;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Path(value="/mobile")
@Singleton
public class MobileApi {
    static Logger logger = Logger.getLogger((String)MobileApi.class.getName());
    @Context
    HttpServletRequest requestContext;

    @PermitAll
    @Path(value="/")
    @GET
    public Response dummy1() {
        if (SettingModel.getBool("mobile:enabled") && SettingModel.get("mobile:mode").equals("webhook")) {
            return Response.ok().entity((Object)"enabled").build();
        }
        return Response.ok().entity((Object)"disabled").build();
    }

    @PermitAll
    @Path(value="/fromdevice")
    @GET
    public Response dummy() {
        if (SettingModel.getBool("mobile:enabled") && SettingModel.get("mobile:mode").equals("webhook")) {
            return Response.ok().entity((Object)"enabled").build();
        }
        return Response.ok().entity((Object)"disabled").build();
    }

    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @PermitAll
    @Path(value="/fromdevice")
    @POST
    @LAPSextra(noCSRFCheck=true)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response fromdevice(String request) throws Exception {
        block40: {
            String type;
            String source_ip = AuthFilter.getSourceIP(this.requestContext);
            if (!SettingModel.getBool("mobile:enabled") || !SettingModel.get("mobile:mode").equals("webhook")) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"error\":\"Mobile features not enabled\"}").build();
            }
            JSONObject jResp = new JSONObject();
            if (!SettingModel.get("mobile:mode").equals("webhook")) break block40;
            JSONObject jReq = new JSONObject(request);
            switch (type = jReq.getString("type")) {
                case "register": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "register_otp": {
                    if (CoreEngine.getInstance().getAuthManager().isOTPrequiredForExternal()) {
                        jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                        break;
                    }
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"error\":\"Check OTP settings\"}").build();
                }
                case "auth_confirm": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "laps_password": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "secrets": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "laps_expire": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "check_pin": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "set_pin": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "profile_modify": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "profile_get": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
                case "update_token": {
                    jResp = MobileManager.getInstance().processIncomingCloudMessage(jReq, source_ip);
                    break;
                }
            }
            if (jResp.has("error")) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jResp.toString()).build();
            }
            return Response.ok((Object)jResp.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

