/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.HostModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

@Path(value="/search")
@Singleton
public class SearchAPI {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    static Logger logger = Logger.getLogger((String)SearchAPI.class.getName());
    static String safeRegex = "[\ufffd-\ufffd\ufffd-\ufffda-zA-Z 0-9_\\\\@\\.-]+";

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/myip")
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @GET
    @Produces(value={"application/json"})
    public Response getMyIP() throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        JSONObject json = new JSONObject();
        json.put("ip", (Object)source_ip);
        String dns = this.reverseDns(source_ip);
        if (dns != null) {
            String pc = "";
            int dotStart = dns.indexOf(".");
            if (dotStart > 1) {
                pc = dns.substring(0, dotStart);
                json.put("pc", (Object)pc);
            }
        }
        return Response.ok((Object)json.toString()).build();
    }

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/{type}/{what}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="type") String type, @PathParam(value="what") String what) throws Exception {
        JSONArray results;
        block32: {
            results = new JSONArray();
            String source_ip = AuthFilter.getSourceIP(this.servletContext);
            AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
            if (what.length() < 3 || !what.matches(safeRegex)) break block32;
            String filter = null;
            String base = null;
            String attribs = "cn,distinguishedName";
            switch (type) {
                case "computer": {
                    HashSet<String> computers = new HashSet<String>();
                    try {
                        ArrayList<HashMap<String, String>> searchResults;
                        if (LdapManager.isLDAPconfigured() && (searchResults = LdapManager.search(filter = "(&(CN=" + what + "*)(objectClass=computer))", base = SettingModel.get("ldap_server:computer_base"), attribs, 10)).size() > 0) {
                            String[] attribattay = attribs.split(",");
                            for (HashMap<String, String> m : searchResults) {
                                if (!m.containsKey("cn")) continue;
                                computers.add(m.get("cn"));
                            }
                        }
                    }
                    catch (Exception searchResults) {
                        // empty catch block
                    }
                    QueryBuilder builder = DBManager.getDao(HostModel.class).queryBuilder();
                    Where where = builder.where().like("name", (Object)new SelectArg((Object)(String.valueOf(what) + "%")));
                    builder.limit(Long.valueOf(10L));
                    builder.orderBy("name", true);
                    List models = DBManager.getDao(HostModel.class).query(builder.prepare());
                    for (HostModel host : models) {
                        computers.add(host.name);
                    }
                    for (String pc : computers) {
                        JSONObject json = new JSONObject();
                        json.put("cn", (Object)pc);
                        results.put((Object)json);
                    }
                    break;
                }
                case "ou": {
                    filter = "(&(|(OU=" + what + "*)(CN=" + what + "*))(|(objectClass=organizationalUnit)(objectClass=container)))";
                    base = SettingModel.get("ldap_server:computer_base");
                    ArrayList<HashMap<String, String>> searchResultsOU = LdapManager.search(filter, base, attribs, 10);
                    if (searchResultsOU.size() <= 0) break;
                    String[] attribattay = attribs.split(",");
                    for (HashMap<String, String> m : searchResultsOU) {
                        JSONObject json = new JSONObject();
                        String[] stringArray = attribattay;
                        int n = attribattay.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String a = stringArray[n2];
                            if (m.containsKey(a)) {
                                json.put(a, (Object)m.get(a));
                            }
                            ++n2;
                        }
                        results.put((Object)json);
                    }
                    break;
                }
                case "group": {
                    filter = "(&(CN=*" + what + "*)(objectClass=group))";
                    base = SettingModel.get("ldap_server:group_base");
                    ArrayList<HashMap<String, String>> searchResultsGroup = LdapManager.search(filter, base, attribs, 10);
                    if (searchResultsGroup.size() <= 0) break;
                    String[] attribattay = attribs.split(",");
                    for (HashMap<String, String> m : searchResultsGroup) {
                        JSONObject json = new JSONObject();
                        String[] stringArray = attribattay;
                        int n = attribattay.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String a = stringArray[n3];
                            if (m.containsKey(a)) {
                                json.put(a, (Object)m.get(a));
                            }
                            ++n3;
                        }
                        results.put((Object)json);
                    }
                    break;
                }
                case "ad_group_or_user": {
                    filter = "(&(CN=*" + what + "*)(objectClass=group))";
                    base = SettingModel.get("ldap_server:group_base");
                    this.processLdapResults(filter, base, attribs, 10, results);
                    filter = "(&(|(samaccountname=" + what + "*)(CN=*" + what + "*))(objectCategory=person))";
                    base = SettingModel.get("ldap_server:group_base");
                    this.processLdapResults(filter, base, attribs, 10, results);
                    break;
                }
                case "ip": {
                    String dns = this.reverseDns(what);
                    if (dns != null) {
                        String pc = "";
                        int dotStart = dns.indexOf(".");
                        if (dotStart <= 1) break;
                        pc = dns.substring(0, dotStart);
                        JSONObject json = new JSONObject();
                        json.put("pc", (Object)pc);
                        results.put((Object)json);
                        break;
                    }
                    return Response.serverError().entity((Object)"Unable to reslove IP").build();
                }
            }
        }
        return Response.ok((Object)results.toString()).build();
    }

    public String reverseDns(String hostIp) throws Exception {
        String result = "";
        Object opt = null;
        try {
            ExtendedResolver res = new ExtendedResolver();
            Name name = ReverseMap.fromAddress((String)hostIp);
            int type = 12;
            int dclass = 1;
            Record rec = Record.newRecord((Name)name, (int)type, (int)dclass);
            Message query = Message.newQuery((Record)rec);
            Message response = res.send(query);
            Record[] answers = response.getSectionArray(1);
            if (answers.length == 0) {
                result = null;
            } else {
                result = answers[0].rdataToString();
                if (result.substring(result.length() - 1).equals(".")) {
                    result = result.substring(0, result.length() - 1);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Reverse dns error " + hostIp), (Throwable)e);
        }
        return result;
    }

    private void processLdapResults(String filter, String base, String attribs, int limit, JSONArray results) throws NamingException, JSONException {
        ArrayList<HashMap<String, String>> searchResultsOU = LdapManager.search(filter, base, attribs, 10);
        if (searchResultsOU.size() > 0) {
            String[] attribattay = attribs.split(",");
            for (HashMap<String, String> m : searchResultsOU) {
                JSONObject json = new JSONObject();
                String[] stringArray = attribattay;
                int n = attribattay.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    if (m.containsKey(a)) {
                        json.put(a, (Object)m.get(a));
                    }
                    ++n2;
                }
                results.put((Object)json);
            }
        }
    }
}

