/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.APITokenManager;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.SecretManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SecretModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import java.time.Instant;
import java.util.HashMap;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/v1/secret")
@Singleton
public class SecretsAPI {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext containerContext;
    private static HashMap<String, Integer> failCountPerLogin = new HashMap();
    private static HashMap<String, Integer> failCountPerIP = new HashMap();
    static Logger logger = Logger.getLogger((String)SecretsAPI.class.getName());
    static String safeRegex = "[a-zA-Z0-9_\\\\@\\.-]+";

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/get/{pc}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPasswords(@PathParam(value="pc") String pc) throws Exception {
        JSONArray allSecrets = new JSONArray();
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
        String searchPC = pc.trim().toLowerCase();
        SecretManager secretManager = SecretManager.getInstance();
        try {
            allSecrets = secretManager.getAllSecrets(accountModel, source_ip, pc);
            return Response.ok((Object)allSecrets.toString()).build();
        }
        catch (Exception e) {
            logger.error((Object)("SecretManager returned error. " + accountModel.getLogin() + " " + source_ip + " " + e.getMessage()));
            return Response.serverError().entity((Object)("{\"error\":\"" + e.getMessage().replace("\"", "") + "\"}")).build();
        }
    }

    @PermitAll
    @Path(value="/passwordbytoken/{pc}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getPasswordByToken(@PathParam(value="pc") String pc) throws Exception {
        JSONObject result = new JSONObject();
        String token = AuthFilter.getAuthToken(this.servletContext);
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        APITokenManager manager = APITokenManager.getInstance();
        String tokenID = manager.getTokenID(token);
        if (manager.checkToken(token, source_ip)) {
            String allowedOU = manager.getAllowedOU(token);
            if (pc.matches("[a-zA-Z0-9_-]+") && allowedOU != null) {
                result = LdapManager.getCompInfoRestricted(pc, allowedOU);
            }
        } else {
            result.put("error", (Object)"Invalid token");
            logger.error((Object)("Invalid token from " + source_ip));
        }
        if (result.has("error")) {
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, "Token_" + tokenID, "", pc, result.getString("error"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)result.toString()).build();
        }
        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, "Token_" + tokenID, "", pc, "");
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN", "LAPSUSER"})
    @Path(value="/expire")
    @POST
    @Produces(value={"application/json"})
    public Response setExpire(String request) throws Exception {
        String source_ip = AuthFilter.getSourceIP(this.servletContext);
        AccountModel accountModel = AuthFilter.getAuthenticatedModel(this.servletContext);
        JSONObject json = new JSONObject(request);
        String id = json.getString("id").trim().toLowerCase();
        String host = "";
        String subject = "";
        Long expire = json.getLong("expire");
        boolean result = false;
        switch (id) {
            case "lapsid": 
            case "winlapsid": {
                boolean forceUpdateToAllDC = SettingModel.getBool("laps_extra:expire_force_alldc");
                host = json.getString("computer").trim().toLowerCase();
                result = LdapManager.setExpire(host, accountModel, expire, forceUpdateToAllDC);
                break;
            }
            default: {
                SecretModel secretModel = (SecretModel)DBManager.getDao(SecretModel.class).queryForId((Object)id);
                if (secretModel == null) break;
                host = secretModel.host.name;
                subject = secretModel.subject;
                result = ComputersManager.getInstance().setExpire(secretModel, accountModel, expire);
            }
        }
        if (result) {
            LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE, source_ip, accountModel.login.toLowerCase(), subject, host, "New expire: " + Instant.ofEpochMilli(expire).toString());
        } else {
            LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE_FAIL, source_ip, accountModel.login.toLowerCase(), subject, host, "Failed to set new expire: " + Instant.ofEpochMilli(expire).toString());
        }
        return Response.ok().build();
    }
}

