/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.auth.AuthManager;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CacheControl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Path(value="/setting")
@Singleton
public class SettingsApi {
    @Context
    HttpServletRequest servletContext;
    @Context
    SecurityContext securityContext;
    static Logger logger = Logger.getLogger((String)SettingsApi.class.getName());
    Pattern keyPattern = Pattern.compile("[a-zA-Z0-9_:-]+");

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/group/{group}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getGroup(@PathParam(value="group") String group) throws Exception {
        if (this.keyPattern.matcher(group).matches()) {
            QueryBuilder qb = DBManager.getDao(SettingModel.class).queryBuilder();
            SelectArg selectArg = new SelectArg();
            selectArg.setValue((Object)(String.valueOf(group) + ":%"));
            qb.orderBy("order", true).where().like("key", (Object)selectArg);
            List models = DBManager.getDao(SettingModel.class).query(qb.prepare());
            for (SettingModel model : models) {
                if (model.key.toLowerCase().endsWith("password") && model.value != null && !model.value.isEmpty()) {
                    model.value = "******";
                }
                if (!model.key.toLowerCase().equals("auth:extauth_type")) continue;
                model.extra = AuthManager.getSupportedExtAuthProviders().toString();
            }
            GenericEntity<List<SettingModel>> list = new GenericEntity<List<SettingModel>>(models){};
            return Response.ok((Object)list).build();
        }
        return Response.serverError().entity((Object)"regex failed for group").build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/{key}")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getOne(@PathParam(value="key") String key) throws Exception {
        SettingModel model = (SettingModel)DBManager.getDao(SettingModel.class).queryForId((Object)key);
        if (model.key.toLowerCase().endsWith("password") && model.value != null && !model.value.isEmpty()) {
            model.value = "******";
        }
        return Response.ok((Object)model).build();
    }

    @PermitAll
    @Path(value="/default")
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    public Response getDefault() throws Exception {
        String[] groups;
        AuthFilter.getSourceIP(this.servletContext);
        ArrayList<SettingModel> resultModels = new ArrayList<SettingModel>();
        String _groups = "auth,mobile";
        String[] stringArray = groups = _groups.split(",");
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            QueryBuilder qb = DBManager.getDao(SettingModel.class).queryBuilder();
            SelectArg selectArg = new SelectArg();
            selectArg.setValue((Object)(String.valueOf(group) + ":%"));
            qb.orderBy("order", true).where().like("key", (Object)selectArg);
            List models = DBManager.getDao(SettingModel.class).query(qb.prepare());
            for (SettingModel model : models) {
                if (!model.key.toLowerCase().endsWith("password") || model.value == null || model.value.isEmpty()) continue;
                model.value = "******";
            }
            Predicate<SettingModel> capchaPredicate = c -> c.key.startsWith("auth:capcha") || c.key.startsWith("auth:laps_expire") || c.key.startsWith("mobile:url") || c.key.startsWith("mobile:org") || c.key.contains("password") || c.key.contains("url");
            if (models != null) {
                models.removeIf(capchaPredicate);
                resultModels.addAll(models);
            }
            ++n2;
        }
        String _keys = "laps_extra:logoff_onscreenchange";
        String[] keys = _keys.split(",");
        ArrayList<SelectArg> selectKeys = new ArrayList<SelectArg>();
        String[] stringArray2 = keys;
        int selectArg = keys.length;
        int qb = 0;
        while (qb < selectArg) {
            String key = stringArray2[qb];
            selectKeys.add(new SelectArg((Object)key));
            ++qb;
        }
        QueryBuilder qb2 = DBManager.getDao(SettingModel.class).queryBuilder();
        qb2.where().in("key", selectKeys);
        List models = DBManager.getDao(SettingModel.class).query(qb2.prepare());
        for (SettingModel model : models) {
            if (model.key.toLowerCase().endsWith("password") && model.value != null && !model.value.isEmpty()) {
                model.value = "******";
            }
            resultModels.add(model);
        }
        return Response.ok(resultModels).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(String request) throws Exception {
        Type listType = new TypeToken<ArrayList<SettingModel>>(){}.getType();
        List models = (List)new Gson().fromJson(request, listType);
        boolean needNotify = false;
        String group = null;
        for (SettingModel newModel : models) {
            group = newModel.key.split(":")[0];
            SettingModel oldModel = (SettingModel)DBManager.createDao(SettingModel.class).queryForId((Object)newModel.key);
            if (oldModel == null || oldModel.value.equals(newModel.value) || newModel.value.equals("******")) continue;
            oldModel.setValue(newModel.value);
            oldModel.beforeUpdate();
            DBManager.getDao((Object)oldModel).update((Object)oldModel);
            DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
            SettingModel.updateCache(oldModel.key, oldModel.value, oldModel.modified);
            needNotify = true;
        }
        if (needNotify) {
            CoreEngine.getInstance().notifySettingsUpdate(group, true);
        }
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @Path(value="/check/{group}")
    @POST
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response check(@PathParam(value="group") String group, String request) throws Exception {
        Type listType = new TypeToken<ArrayList<SettingModel>>(){}.getType();
        List models = (List)new Gson().fromJson(request, listType);
        HashMap<String, String> settings = new HashMap<String, String>();
        for (SettingModel model : models) {
            if (model.key.toLowerCase().endsWith("password") && model.value.equals("******")) {
                settings.put(model.key, SettingModel.get(model.key));
                continue;
            }
            settings.put(model.key, model.value);
        }
        JSONObject json = CoreEngine.getInstance().checkSettings(group, settings);
        return Response.ok((Object)json.toString()).build();
    }
}

