/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.api;

import com.ksoft.core.FrameWorkInfo;
import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.web.CacheControl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.rzo.yajsw.app.WrapperJVMMain;

@Path(value="/system")
@Singleton
public class SystemApi {
    static Logger logger = Logger.getLogger((String)SystemApi.class.getName());

    @RolesAllowed(value={"ADMIN"})
    @GET
    @Produces(value={"application/json"})
    @Path(value="/restart")
    public Response restart() {
        logger.info((Object)"Restart command recieved, attempt to restart");
        WrapperJVMMain.WRAPPER_MANAGER.restart();
        return Response.ok().build();
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @Produces(value={"application/json"})
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Path(value="/health")
    public Response health() throws JSONException {
        JSONObject result = new JSONObject();
        result.put("status", (Object)"running");
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    @Path(value="/log/files")
    public Response logFiles() throws JSONException {
        File[] files;
        JSONArray result = new JSONArray();
        File dir = new File(String.valueOf(SettingsManager.getBaseFolder()) + "/logs");
        if (dir.exists() && (files = dir.listFiles()).length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                }
            });
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result.put((Object)f.getName());
                ++n2;
            }
        }
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @POST
    @Produces(value={"application/json"})
    @Path(value="/log/search")
    public Response searchLogs(String request) throws Exception {
        JSONObject json = new JSONObject(request);
        String filename = json.getString("file");
        if (!filename.matches("[a-zA-Z0-9_\\.-]+")) {
            throw new Exception("file not match regex");
        }
        String searchString = json.optString("filter", "").toLowerCase();
        int limit = json.optInt("limit", 10000);
        File file = new File(String.valueOf(SettingsManager.getBaseFolder()) + "/logs/" + filename);
        StringBuilder sb = new StringBuilder();
        int resultCount = 0;
        if (file.exists()) {
            Throwable throwable = null;
            Object var10_11 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!searchString.isEmpty()) {
                        if (line.toLowerCase().contains(searchString)) {
                            ++resultCount;
                            sb.append(String.valueOf(line) + "\n");
                        }
                    } else {
                        ++resultCount;
                        sb.append(String.valueOf(line) + "\n");
                    }
                    if (resultCount <= limit) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        JSONObject result = new JSONObject();
        result.put("result", (Object)sb.toString());
        result.put("count", resultCount);
        return Response.ok((Object)result.toString()).build();
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @CacheControl(noCache=true, noStore=true, maxAge=0)
    @Produces(value={"application/json"})
    @Path(value="/host")
    public Response getHostInfo() throws Exception {
        JSONObject result = new JSONObject();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            String ip = addr.toString();
            result.put("ip", (Object)ip);
            result.put("hostname", (Object)hostname);
            result.put("version", (Object)("portal: " + LapsLauncher.getVersion() + " framework: " + FrameWorkInfo.getVersion()));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get host network info");
        }
        return Response.ok((Object)result.toString()).build();
    }
}

