/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.laps.core.ILibrary;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class APITokenManager
implements ILibrary {
    private String salt = "saltq7q87KKKKKKjjjjIIIfhjkHHHcatasdfa!@#";
    static Logger logger = Logger.getLogger((String)APITokenManager.class.getName());
    HashMap<String, JSONObject> tokensHash = new HashMap();
    HashMap<String, String> tokensID = new HashMap();
    static APITokenManager instance = new APITokenManager();

    public static APITokenManager getInstance() {
        return instance;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        Object token = null;
        try {
            String tokenHash = config.getString("tokenHash").trim();
            this.tokensHash.put(tokenHash, config);
            this.tokensID.put(id, tokenHash);
            logger.info((Object)("Api token added " + name));
        }
        catch (Exception e) {
            logger.error((Object)("Add token " + name + " error "), (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        String tokenHash = this.tokensID.get(id);
        try {
            String newTokenHash = config.getString("tokenHash").trim();
            this.tokensHash.remove(tokenHash);
            this.tokensHash.put(newTokenHash, config);
            logger.info((Object)("API token updated for " + name));
        }
        catch (Exception e) {
            logger.error((Object)("Update token " + name + " error "), (Throwable)e);
        }
    }

    @Override
    public void del(String id) {
        String tokenHash = this.tokensID.get(id);
        if (tokenHash != null) {
            this.tokensID.remove(id);
            this.tokensHash.remove(tokenHash);
            logger.info((Object)("API token removed: " + id));
        }
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    public boolean checkToken(String token, String IP) {
        boolean result = false;
        try {
            String tokenHash = APITokenManager.hashToken(token, this.salt);
            JSONObject config = this.tokensHash.get(tokenHash);
            if (config != null && token != null) {
                String allowedIP = config.optString("ip", "").trim();
                if (!allowedIP.isEmpty()) {
                    if (IP.equals(allowedIP)) {
                        result = true;
                    }
                } else {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("checkTocken error from " + IP), (Throwable)e);
        }
        return result;
    }

    public String getAllowedOU(String token) {
        String result = null;
        try {
            String tokenHash = APITokenManager.hashToken(token, this.salt);
            JSONObject config = this.tokensHash.get(tokenHash);
            if (config != null) {
                result = config.optString("ou");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getAllowedOU error", (Throwable)e);
        }
        return result;
    }

    public String getTokenID(String token) {
        String result = null;
        try {
            String tokenHash = APITokenManager.hashToken(token, this.salt);
            for (String k : this.tokensID.keySet()) {
                String v = this.tokensID.get(k);
                if (!v.equals(tokenHash)) continue;
                result = k;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTokenID error", (Throwable)e);
        }
        return result;
    }

    @Override
    public String beforeCreate(String config) {
        String result = config;
        try {
            JSONObject json = new JSONObject(config);
            String token = json.optString("apitoken", "");
            if (!token.isEmpty()) {
                String hash = APITokenManager.hashToken(token, this.salt);
                json.put("tokenHash", (Object)hash);
                json.remove("apitoken");
                result = json.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"API Token beforeCreate error", (Throwable)e);
        }
        return result;
    }

    @Override
    public String beforeUpdate(String config) {
        String result = config;
        try {
            JSONObject json = new JSONObject(config);
            String token = json.optString("apitoken", "");
            if (!token.isEmpty()) {
                String hash = APITokenManager.hashToken(token, this.salt);
                json.put("tokenHash", (Object)hash);
                json.remove("apitoken");
                result = json.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"API Token beforeUpdate error", (Throwable)e);
        }
        return result;
    }

    public static String hashToken(String token, String salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String result = "";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update((String.valueOf(salt) + token).getBytes("UTF-8"));
        byte[] digest = md.digest();
        result = String.format("%064x", new BigInteger(1, digest));
        return result;
    }
}

