/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public abstract class AbstractWorker
implements Runnable {
    static Logger abstractLogger = Logger.getLogger((String)AbstractWorker.class.getName());
    private Object lock = new Object();
    private final long DEFAULT_TIMEOUT = 1000L;
    private long timeout = 1000L;
    private boolean isRunning = true;
    private boolean isActive = true;
    protected long helth_mon_interval = 20000L;
    protected Timer health_mon_timer = null;
    protected STATE state = STATE.STOPPED;
    protected STATUS status = STATUS.SUCCESS;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Wrong timeout: " + timeout);
        }
        this.timeout = timeout;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.getLock();
        synchronized (object) {
            this.isActive = true;
            this.getLock().notifyAll();
            this.state = STATE.RUNNING;
            abstractLogger.debug((Object)(this.getClass() + " RESUMED"));
        }
    }

    public void pause() {
        this.state = STATE.PAUSED;
        this.isActive = false;
        abstractLogger.debug((Object)(this.getClass() + " PAUSED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        abstractLogger.debug((Object)("Stop called for class" + this.getClass()));
        this.state = STATE.STOPPED;
        this.isRunning = false;
        if (this.health_mon_timer != null) {
            this.health_mon_timer.cancel();
        }
        Object object = this.getLock();
        synchronized (object) {
            this.isActive = true;
            this.getLock().notifyAll();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void work() throws Exception;

    protected abstract void handleError(Exception var1);

    protected abstract void prepareWorker() throws Exception;

    protected abstract void releaseWorker() throws Exception;

    protected boolean isStartWorkCondition() {
        return this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected abstract void health_monitor();

    protected void setHelthMonInterval(long helth_mon_interval) {
        this.helth_mon_interval = helth_mon_interval;
    }

    protected void startHealthMonitoring() {
        try {
            TimerTask monTask = new TimerTask(){

                @Override
                public void run() {
                    AbstractWorker.this.health_monitor();
                }
            };
            this.health_mon_timer = new Timer();
            this.health_mon_timer.scheduleAtFixedRate(monTask, 0L, this.helth_mon_interval);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public String getState() {
        return this.state.getValue();
    }

    protected void setState(STATE state) {
        this.state = state;
    }

    public String getStatus() {
        return this.status.getValue();
    }

    protected void setStatus(STATUS status) {
        this.status = status;
    }

    public static enum STATE {
        RUNNING("running"),
        PAUSED("paused"),
        STOPPED("stopped");

        private String state;

        private STATE(String state) {
            this.state = state;
        }

        public String getValue() {
            return this.state;
        }

        public String toString() {
            return this.state;
        }
    }

    public static enum STATUS {
        SUCCESS("success"),
        WARNING("warning"),
        DANGER("danger");

        private final String status;

        private STATUS(String status) {
            this.status = status;
        }

        public String getValue() {
            return this.status;
        }

        public String toString() {
            return this.status;
        }
    }
}

