/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.tls.TlsHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AdmPWDKeyManager
implements ILibrary {
    static ConcurrentHashMap<Integer, Cipher> ciphers = new ConcurrentHashMap();
    static HashMap<String, Integer> idToCipher = new HashMap();
    static AdmPWDKeyManager instance = new AdmPWDKeyManager();
    static Logger logger = Logger.getLogger((String)AdmPWDKeyManager.class.getName());

    public static AdmPWDKeyManager getInstance() {
        return instance;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        logger.info((Object)("Attempt to import key " + name));
        try {
            Integer keyId = config.getInt("id");
            String key = config.getString("password");
            key = SettingModel.decrypt(key);
            Cipher cipher = this.initCipher(key);
            ciphers.put(keyId, cipher);
            idToCipher.put(id, keyId);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to add lapse key " + name), (Throwable)e);
        }
    }

    public Cipher initCipher(String keyBase64) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        PrivateKey privKey = TlsHelper.privateKeyFromBase64String((String)keyBase64, (String)"RSA");
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
        OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), PSource.PSpecified.DEFAULT);
        cipher.init(2, (Key)privKey, oaepParams);
        return cipher;
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        this.add(id, name, config);
    }

    @Override
    public void del(String id) {
        try {
            Integer keyId = idToCipher.get(id);
            idToCipher.remove(id);
            ciphers.remove(keyId);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete " + id));
        }
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    @Override
    public String beforeCreate(String config) throws UnsupportedEncodingException, GeneralSecurityException, JSONException {
        String result = config;
        JSONObject json = new JSONObject(config);
        String key = json.getString("password");
        this.initCipher(key);
        key = SettingModel.encrypt(key);
        json.put("password", (Object)key);
        result = json.toString();
        return result;
    }

    @Override
    public String beforeUpdate(String config) throws UnsupportedEncodingException, GeneralSecurityException, JSONException {
        return this.beforeCreate(config);
    }

    public String decrypt(Integer keyId, String encryptedPassword) {
        String result = encryptedPassword;
        try {
            if (ciphers.containsKey(keyId)) {
                Cipher cipher = ciphers.get(keyId);
                byte[] pt = cipher.doFinal(Base64.decodeBase64((String)encryptedPassword));
                result = new String(pt, StandardCharsets.UTF_16LE);
            } else {
                logger.error((Object)("Unable to decrypt password, key " + keyId + " does not exist"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to decrypt password, key " + keyId), (Throwable)e);
        }
        return result;
    }
}

