/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LibraryModel;
import com.opencsv.CSVReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BitLockerManager
implements ILibrary {
    static HashMap<String, HashMap<String, String>> bitLockerAccessMatrix = new HashMap();
    static Logger logger = Logger.getLogger((String)BitLockerManager.class.getName());
    static BitLockerManager instance = new BitLockerManager();
    static HashMap<String, String> idToGroup = new HashMap();

    public static BitLockerManager getInstance() {
        return instance;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            idToGroup.put(id, config.getString("group").toLowerCase());
            HashMap<String, String> groupOU = new HashMap<String, String>();
            groupOU.put(config.getString("group").toLowerCase(), config.getString("ou").toLowerCase());
            bitLockerAccessMatrix.put(id, groupOU);
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        try {
            idToGroup.put(id, config.getString("group").toLowerCase());
            HashMap<String, String> groupOU = new HashMap<String, String>();
            groupOU.put(config.getString("group").toLowerCase(), config.getString("ou").toLowerCase());
            bitLockerAccessMatrix.put(id, groupOU);
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    @Override
    public void del(String id) {
        try {
            if (idToGroup.containsKey(id)) {
                String group = idToGroup.get(id);
                bitLockerAccessMatrix.remove(id);
                idToGroup.remove(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Ldap remove error", (Throwable)e);
        }
    }

    @Override
    public int importFromFile(String filePath) {
        logger.debug((Object)("Start import from " + filePath));
        int count = 0;
        try {
            String[] values;
            InputStreamReader ir = new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8");
            CSVReader reader = new CSVReader((Reader)ir, ";".charAt(0));
            String type = LibraryManager.TYPE.BITLOCKER_MAPPING.toString();
            LibraryModel model = null;
            while ((values = reader.readNext()) != null) {
                try {
                    if (values.length != 3) continue;
                    String name = values[0];
                    String group = values[1];
                    String OU = values[2];
                    if (!OU.contains("=") || name.isEmpty() || group.isEmpty()) continue;
                    JSONObject config = new JSONObject();
                    config.put("ou", (Object)OU);
                    config.put("group", (Object)group);
                    long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                    QueryBuilder qb = DBManager.createDao(LibraryModel.class).queryBuilder();
                    qb.where().eq("name", (Object)new SelectArg((Object)name)).and().eq("type", (Object)new SelectArg((Object)type));
                    model = (LibraryModel)DBManager.createDao(LibraryModel.class).queryForFirst(qb.prepare());
                    if (model == null) {
                        model = new LibraryModel();
                        model.type = type;
                        model.name = name;
                        model.modified = changedDate;
                        model.config = config.toString();
                        DBManager.getDao((Object)model).create((Object)model);
                    } else {
                        model.version = model.version + 1;
                        model.modified = changedDate;
                        model.config = config.toString();
                        DBManager.getDao((Object)model).update((Object)model);
                    }
                    idToGroup.put(model.id.toString(), group.toLowerCase());
                    HashMap<String, String> groupOU = new HashMap<String, String>();
                    groupOU.put(group.toLowerCase(), OU.toLowerCase());
                    bitLockerAccessMatrix.put(model.id.toString(), groupOU);
                    ++count;
                }
                catch (Exception e) {
                    logger.error((Object)"CSV line process error", (Throwable)e);
                }
            }
            ir.close();
        }
        catch (Exception e) {
            logger.error((Object)"importFromFile error", (Throwable)e);
        }
        logger.debug((Object)("Imported from " + filePath + " count:" + count));
        return count;
    }

    public boolean isUserAllowedToLogin(String login) {
        boolean result = false;
        try {
            if (!login.matches(LdapManager.userRegex)) {
                logger.error((Object)("isUserAllowedToLogin not matched regex for login " + login));
                return result;
            }
            JSONArray jGroups = LdapManager.getUserGroups(login);
            int i = 0;
            while (i < jGroups.length()) {
                String group = jGroups.getString(i);
                for (HashMap<String, String> groupOU : bitLockerAccessMatrix.values()) {
                    if (!groupOU.containsKey(group.toLowerCase())) continue;
                    result = true;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)("isUserAllowedToLogin " + login + " error"), (Throwable)e);
        }
        return result;
    }

    private static boolean isUserAllowedForPC(String pcDN, AccountModel accountModel) throws JSONException {
        boolean result = false;
        if (!accountModel.login.matches(LdapManager.userRegex)) {
            logger.error((Object)("isUserAllowedForPC not matched regex for login " + accountModel.login));
            return result;
        }
        if (accountModel.getExternal().booleanValue()) {
            try {
                String userDN = LdapManager.getDNbyLogin(accountModel.login);
                if (userDN != null) {
                    JSONArray jGroups = LdapManager.getUserGroups(accountModel);
                    logger.debug((Object)("For login " + accountModel.login + " found " + jGroups.length() + " groups"));
                    int i = 0;
                    while (i < jGroups.length()) {
                        String group = jGroups.getString(i);
                        for (HashMap<String, String> groupOU : bitLockerAccessMatrix.values()) {
                            if (!groupOU.containsKey(group.toLowerCase())) continue;
                            String ou = groupOU.get(group.toLowerCase()).toLowerCase();
                            if (!pcDN.toLowerCase().endsWith(ou)) continue;
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"isUserAllowedForPC error", (Throwable)e);
            }
        } else if (accountModel.login.equals("admin")) {
            result = true;
        }
        return result;
    }

    private HashMap<String, String> getBitlockerPassword(String pcDN, AccountModel accountModel) {
        HashMap<String, String> result = null;
        try {
            if (BitLockerManager.isUserAllowedForPC(pcDN, accountModel)) {
                String filter = "(&(objectClass=msFVE-RecoveryInformation))";
                String attribs = "whenCreated,msFVE-RecoveryPassword,CN";
                String[] returningAttributes = attribs.split(",");
                ArrayList<HashMap<String, String>> searchResults = LdapManager.search(filter, pcDN, attribs, 50);
                if (searchResults.size() > 0) {
                    result = new HashMap<String, String>();
                    for (HashMap<String, String> r : searchResults) {
                        if (!r.containsKey("msFVE-RecoveryPassword")) continue;
                        String pasword = r.get("msFVE-RecoveryPassword");
                        String date = r.get("whenCreated");
                        result.put(date, pasword);
                    }
                }
            } else {
                logger.error((Object)("No access rights to " + pcDN + " for " + accountModel.getLogin()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("getBitlockerPassword error " + pcDN), (Throwable)e);
        }
        return result;
    }

    public JSONObject getBitLockerInfo(String pc, AccountModel accountModel) {
        JSONObject result = new JSONObject();
        try {
            String attribs;
            if (pc.equals("__test1__")) {
                result.put("Bitlocker 2023", (Object)"bitP@$$w0rd");
                result.put("Bitlocker 2024", (Object)"bitP@$$w0rd");
                return result;
            }
            if (!pc.matches(LdapManager.pcRegex) || !accountModel.getLogin().matches(LdapManager.userRegex)) {
                result.put("error", (Object)"PC not mathced regex");
                return result;
            }
            String filter = "(&(CN=" + pc + ")(objectClass=computer))";
            ArrayList<HashMap<String, String>> searchResults = LdapManager.search(filter, LdapManager.computerSearchBase, attribs = "CN,distinguishedName", 1);
            if (searchResults.size() > 0) {
                HashMap<String, String> r = searchResults.get(0);
                String pcDN = r.get("distinguishedName");
                if (!BitLockerManager.isUserAllowedForPC(pcDN, accountModel)) {
                    result.put("error", (Object)"No access rights");
                } else {
                    HashMap<String, String> bitLockerPasswordInfo = this.getBitlockerPassword(pcDN, accountModel);
                    if (bitLockerPasswordInfo != null && bitLockerPasswordInfo.size() > 0) {
                        for (String date : bitLockerPasswordInfo.keySet()) {
                            String bitPassword = bitLockerPasswordInfo.get(date);
                            result.put("Bitlocker " + date, (Object)bitPassword);
                        }
                    }
                }
            } else {
                result.put("error", (Object)("Computer " + pc + " not found"));
                logger.error((Object)("Computer " + pc + " not found"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCompInfo error", (Throwable)e);
            try {
                result.put("error", (Object)e.getMessage().toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }
}

