/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.tls.TlsHelper;
import com.ksoft.web.AuthFilter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterManager {
    static Logger logger = Logger.getLogger((String)ClusterManager.class.getName());
    static ClusterManager instance = new ClusterManager();
    static boolean isClusterModeEnabled = false;
    public static LoadingCache<String, String> expireCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return null;
        }
    });

    public static void putToCache(String key, String value, boolean sendRemote) {
        expireCache.put((Object)key, (Object)value);
        if (sendRemote) {
            instance.putToRemoteCache("cluster", key, value);
        }
    }

    public static String get(String key) {
        return (String)expireCache.getIfPresent((Object)key);
    }

    public static long getCacheSize() {
        return expireCache.size();
    }

    public static Integer getInteger(String key) {
        Integer result = null;
        String s = (String)expireCache.getIfPresent((Object)key);
        try {
            if (s != null) {
                result = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get Integer from cache " + key), (Throwable)e);
        }
        return result;
    }

    public static Long getLong(String key) {
        Long result = null;
        String s = (String)expireCache.getIfPresent((Object)key);
        try {
            if (s != null) {
                result = Long.parseLong(s);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get Long from cache " + key), (Throwable)e);
        }
        return result;
    }

    public static void remove(String key, boolean sendRemote) {
        expireCache.invalidate((Object)key);
        if (sendRemote) {
            instance.removeRemoteCache("cluster", key);
        }
    }

    public static JSONArray getFullCache() throws JSONException {
        JSONArray jarray = new JSONArray();
        for (Map.Entry entry : expireCache.asMap().entrySet()) {
            JSONObject json = new JSONObject();
            json.put((String)entry.getKey(), entry.getValue());
            jarray.put((Object)json);
        }
        return jarray;
    }

    public static boolean isUrlIsAtThisHost(URL url) throws UnknownHostException {
        if (LapsLauncher.debugCluster) {
            int sslPort;
            int port = url.getPort();
            return port == (sslPort = SettingsManager.getSslPort());
        }
        String host = url.getHost();
        InetAddress addr = InetAddress.getByName(host);
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static boolean isAdressIsLocal(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public String checkConnection() {
        String[] urls;
        String result = "";
        String urls_s = SettingModel.get("cluster:uri");
        String[] stringArray = urls = urls_s.split(";");
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String u = stringArray[n2];
            try {
                URL url = new URL(u);
                if (!ClusterManager.isUrlIsAtThisHost(url)) {
                    Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/info").request().cookie("X-Token", AuthFilter.generateTokenForEngine()).get();
                    if (responseEntity.getStatus() == 200) {
                        if (result != "") {
                            result = String.valueOf(result) + "\n";
                        }
                        result = String.valueOf(result) + u + " OK";
                    } else {
                        if (result != "") {
                            result = String.valueOf(result) + "\n";
                        }
                        result = String.valueOf(result) + u + " FAIL " + responseEntity.getStatus();
                    }
                }
            }
            catch (Exception e) {
                if (result != "") {
                    result = String.valueOf(result) + "\n";
                }
                result = String.valueOf(result) + u + " " + e.getCause().toString();
                logger.error((Object)("Unable to connect to " + u));
            }
            ++n2;
        }
        return result;
    }

    public void syncCacheFromRemote() {
        block11: {
            if (!isClusterModeEnabled) {
                return;
            }
            logger.debug((Object)"syncCacheFromRemote started");
            try {
                String[] urls;
                String urls_s = SettingModel.get("cluster:uri");
                if (urls_s.contains("domain.com")) break block11;
                String[] stringArray = urls = urls_s.split(";");
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    try {
                        URL url = new URL(u);
                        if (!ClusterManager.isUrlIsAtThisHost(url)) {
                            Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/cache").request().cookie("X-Token", AuthFilter.generateTokenForEngine()).get();
                            if (responseEntity.getStatus() == 200) {
                                int c = 0;
                                String resp = (String)responseEntity.readEntity(String.class);
                                JSONArray arr = new JSONArray(resp);
                                int i = 0;
                                while (i < arr.length()) {
                                    JSONObject json = arr.getJSONObject(i);
                                    Iterator keys = json.keys();
                                    String key = (String)keys.next();
                                    String value = json.optString(key);
                                    if (!ClusterManager.containsKey(key)) {
                                        ++c;
                                        ClusterManager.putToCache(key, value, false);
                                    }
                                    ++i;
                                }
                                logger.debug((Object)("Imported " + c + " keys from remote cache " + u));
                            } else {
                                logger.error((Object)("Unable to get remote cache" + u + " status " + responseEntity.getStatus()));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to get remote cache " + u));
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to sync remote cache ", (Throwable)e);
            }
        }
    }

    public void syncSettingsFromRemote() {
        if (!isClusterModeEnabled) {
            return;
        }
        logger.debug((Object)"syncSettingsFromRemote started");
        String urls_s = SettingModel.get("cluster:uri");
        if (!urls_s.contains("domain.com")) {
            String[] urls;
            String[] stringArray = urls = urls_s.split(";");
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String u = stringArray[n2];
                try {
                    URL url = new URL(u);
                    if (!ClusterManager.isUrlIsAtThisHost(url)) {
                        List models = DBManager.findAll(SettingModel.class);
                        Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/settings").request().cookie("X-Token", AuthFilter.generateTokenForEngine()).get();
                        if (responseEntity.getStatus() == 200) {
                            String resp = (String)responseEntity.readEntity(String.class);
                            JSONArray settings = new JSONArray(resp);
                            if (settings.length() == 0) break;
                            ArrayList<JSONObject> al = new ArrayList<JSONObject>();
                            int i = 0;
                            while (i < settings.length()) {
                                al.add(settings.getJSONObject(i));
                                ++i;
                            }
                            al.sort(new Comparator<JSONObject>(){

                                @Override
                                public int compare(JSONObject o1, JSONObject o2) {
                                    String s1 = o1.optString("key");
                                    String s2 = o2.optString("key");
                                    return s1.compareTo(s2);
                                }
                            });
                            String preGroup = settings.getJSONObject(0).getString("key").split(":")[0];
                            boolean needNotify = false;
                            int i2 = 0;
                            while (i2 < settings.length()) {
                                JSONObject s = settings.getJSONObject(i2);
                                String key = s.getString("key");
                                String group = key.split(":")[0];
                                if (!group.equals(preGroup) && needNotify) {
                                    needNotify = false;
                                    preGroup = group;
                                    CoreEngine.getInstance().notifySettingsUpdate(preGroup, false);
                                }
                                Long remote_modified = s.optLong("modified", 0L);
                                String remoteValue = s.getString("value");
                                if (remote_modified > 0L) {
                                    Long cachedModified = SettingModel.getModified(key);
                                    String cachedValue = SettingModel.get(key);
                                    if (cachedModified == null) {
                                        cachedModified = 0L;
                                    }
                                    if (remote_modified > cachedModified) {
                                        if (!cachedValue.equals(remoteValue)) {
                                            needNotify = true;
                                            logger.debug((Object)("New settings from " + u + " " + key + " existing timestamp: " + cachedModified + " remote timestamp: " + remote_modified));
                                            SettingModel.updateCache(key, remoteValue, remote_modified);
                                            SettingModel oldModel = (SettingModel)DBManager.createDao(SettingModel.class).queryForId((Object)key);
                                            if (oldModel != null) {
                                                oldModel.value = remoteValue;
                                                oldModel.modified = remote_modified;
                                                DBManager.getDao((Object)oldModel).update((Object)oldModel);
                                                DBManager.getDao((Object)oldModel).refresh((Object)oldModel);
                                            }
                                        } else {
                                            logger.error((Object)("Sync settings error from " + u + ". " + key + " does not exist in current engine"));
                                        }
                                    }
                                }
                                ++i2;
                            }
                            if (needNotify) {
                                String group = preGroup;
                                CoreEngine.getInstance().notifySettingsUpdate(group, false);
                            }
                        } else {
                            logger.error((Object)("Unable to sync with " + u));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Sync settings error " + u), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public static ClusterManager getInstance() {
        return instance;
    }

    public void putSettingsToRemote(String group) throws SQLException, JSONException {
        block10: {
            if (!isClusterModeEnabled) {
                return;
            }
            QueryBuilder qb = DBManager.getDao(SettingModel.class).queryBuilder();
            SelectArg selectArg = new SelectArg();
            selectArg.setValue((Object)(String.valueOf(group) + ":%"));
            qb.orderBy("order", true).where().like("key", (Object)selectArg);
            List models = DBManager.getDao(SettingModel.class).query(qb.prepare());
            JSONArray array = new JSONArray();
            for (SettingModel model : models) {
                JSONObject json = new JSONObject();
                json.put("key", (Object)model.key);
                json.put("value", (Object)model.value);
                json.put("modified", (Object)model.modified);
                array.put((Object)json);
            }
            try {
                String[] urls;
                String urls_s = SettingModel.get("cluster:uri");
                if (urls_s.contains("domain.com")) break block10;
                String[] stringArray = urls = urls_s.split(";");
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    try {
                        URL url = new URL(u);
                        if (!ClusterManager.isUrlIsAtThisHost(url)) {
                            Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/settings/" + group).request().cookie("X-Token", AuthFilter.generateTokenForEngine()).post(Entity.entity((Object)array.toString(), (String)"application/json"));
                            if (responseEntity.getStatus() == 200) {
                                logger.debug((Object)("Settings " + group + " sent to remote " + u));
                            } else {
                                logger.error((Object)("Unable send settings " + group + " to remote " + u));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to send settings " + group + " " + u), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to send settings " + group), (Throwable)e);
            }
        }
    }

    public void putToRemoteCache(String cacheName, String key, String value) {
        block9: {
            if (!isClusterModeEnabled) {
                return;
            }
            try {
                String[] urls;
                JSONObject json = new JSONObject();
                json.put("key", (Object)key);
                json.put("value", (Object)value);
                String urls_s = SettingModel.get("cluster:uri");
                if (urls_s.contains("domain.com")) break block9;
                String[] stringArray = urls = urls_s.split(";");
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    try {
                        URL url = new URL(u);
                        if (!ClusterManager.isUrlIsAtThisHost(url)) {
                            Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/cache").request().cookie("X-Token", AuthFilter.generateTokenForEngine()).post(Entity.entity((Object)json.toString(), (String)"application/json"));
                            if (responseEntity.getStatus() == 200) {
                                logger.debug((Object)("Key " + key + " put to remote cache " + u));
                            } else {
                                logger.error((Object)("Unable to put key " + key + " to remote cache " + u));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to remove " + key + " from cache " + u), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to update remote cache " + cacheName), (Throwable)e);
            }
        }
    }

    public void removeRemoteCache(String cacheName, String key) {
        if (!isClusterModeEnabled) {
            return;
        }
        String urls_s = SettingModel.get("cluster:uri");
        if (!urls_s.contains("domain.com")) {
            String[] urls;
            String[] stringArray = urls = urls_s.split(";");
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String u = stringArray[n2];
                try {
                    URL url = new URL(u);
                    if (!ClusterManager.isUrlIsAtThisHost(url)) {
                        Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/cache/" + key).request().cookie("X-Token", AuthFilter.generateTokenForEngine()).delete();
                        if (responseEntity.getStatus() == 200) {
                            logger.debug((Object)("Key " + key + " removed from remote cache " + u));
                        } else {
                            logger.error((Object)("Unable to remove key " + key + " from remote cache " + u));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to remove " + key + " from cache " + u), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public void notifyRemoteLibrary(String libType, LibraryNotification notifyType, String id) {
        block9: {
            if (!isClusterModeEnabled) {
                return;
            }
            try {
                String[] urls;
                String urls_s = SettingModel.get("cluster:uri");
                if (urls_s.contains("domain.com")) break block9;
                String[] stringArray = urls = urls_s.split(";");
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    try {
                        URL url = new URL(u);
                        if (!ClusterManager.isUrlIsAtThisHost(url)) {
                            Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/library/" + libType.toString() + "/" + notifyType.toString() + "/" + id).request().cookie("X-Token", AuthFilter.generateTokenForEngine()).get();
                            if (responseEntity.getStatus() == 200) {
                                logger.debug((Object)("Library: " + libType + " operation: " + (Object)((Object)notifyType) + " id: " + id + " " + u));
                            } else {
                                logger.error((Object)("Library: " + libType + " operation: " + (Object)((Object)notifyType) + " id: " + id + " " + u));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("ERROR occured! Library: " + libType + " operation: " + (Object)((Object)notifyType) + " id: " + id + " " + u), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to notifyRemoteLibrary " + libType + " operation: " + (Object)((Object)notifyType) + " id: " + id), (Throwable)e);
            }
        }
    }

    public void syncLibraryFromRemote() {
    }

    public static boolean containsKey(String key) {
        return expireCache.asMap().containsKey(key);
    }

    public void setEnabled(boolean isEnabled) {
        isClusterModeEnabled = isEnabled;
        if (isClusterModeEnabled) {
            logger.debug((Object)"Cluster mode activated, start syncing");
        }
    }

    public void deleteCertificates(String selectedIds) {
        block9: {
            if (!isClusterModeEnabled) {
                return;
            }
            try {
                String[] urls;
                String urls_s = SettingModel.get("cluster:uri");
                if (urls_s.contains("domain.com")) break block9;
                String[] stringArray = urls = urls_s.split(";");
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    try {
                        URL url = new URL(u);
                        if (!ClusterManager.isUrlIsAtThisHost(url)) {
                            Response responseEntity = TlsHelper.getTlsClient().target(u).path("/api/cluster/cert/" + selectedIds).request().cookie("X-Token", AuthFilter.generateTokenForEngine()).delete();
                            if (responseEntity.getStatus() == 200) {
                                logger.debug((Object)("Certificates with IDs : " + selectedIds + " deleted "));
                            } else {
                                logger.error((Object)("Certificates with IDs : " + selectedIds + " status: " + responseEntity.getStatus()));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("ERROR occured! Certificates with IDs : " + selectedIds + " delete operation "), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to deleteCertificates " + selectedIds), (Throwable)e);
            }
        }
    }

    public static enum LibraryNotification {
        RELOAD("reload"),
        DEL("del");

        private final String value;

        private LibraryNotification(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

