/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.auth.AuthManager;
import com.ksoft.auth.DuoAuthProvider;
import com.ksoft.auth.FortiAuthProvider;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.auth.LinOTPProvider;
import com.ksoft.auth.MultifactorAuthProvider;
import com.ksoft.auth.RadiusProvider;
import com.ksoft.auth.TOTPProvider;
import com.ksoft.core.DBManager;
import com.ksoft.core.ISecurityLogger;
import com.ksoft.jobs.BackupLapsJob;
import com.ksoft.jobs.CleanLDAPUsersJob;
import com.ksoft.jobs.ClusterSyncJob;
import com.ksoft.jobs.LDAPPasswordRotateJob;
import com.ksoft.jobs.LogRetentionJob;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.JobManager;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.core.LicenseManager;
import com.ksoft.laps.core.LogFeeder;
import com.ksoft.laps.core.MobileManager;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.laps.output.SyslogOutput;
import com.ksoft.ldap.LDAPHelper;
import com.ksoft.tls.TlsHelper;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.GenericExceptionMapper;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CoreEngine {
    SyslogOutput syslog = null;
    AuthManager authManager = null;
    JobManager jobManager = new JobManager();
    MobileManager mobileManager = MobileManager.getInstance();
    LogFeeder logFeeder = new LogFeeder();
    static LicenseManager licenseManager = new LicenseManager();
    static CoreEngine instance = null;
    static Logger logger = Logger.getLogger((String)CoreEngine.class.getName());
    static ISecurityLogger securityLogger = new LogModel();

    public void init() {
        try {
            this.initSettings();
            this.initLicenseManager();
            this.initSyslog();
            this.initLogFeeder();
            this.initClusterManager();
            this.initComputersManager();
            logger.debug((Object)"Calling LibraryManager init");
            LibraryManager.init();
            logger.debug((Object)"Calling LibraryManager finished");
            this.initLdap();
            this.initAuthManager();
            this.initMobileManager();
            this.jobManager.initJobs();
            logger.info((Object)"Core engine init completed");
        }
        catch (Exception e) {
            logger.error((Object)"CoreEngine init error", (Throwable)e);
        }
    }

    private void initLogFeeder() {
        Thread thread = new Thread((Runnable)this.logFeeder, "logFeederThread");
        thread.start();
        logger.info((Object)"Log feeder started");
    }

    private void initComputersManager() {
        try {
            JSONArray computersTree = new JSONArray(SettingModel.get("computers:tree"));
            String _pubKey = SettingModel.get("computers_auth:pubkey_password");
            String _privKey = SettingModel.get("computers_auth:privkey_password");
            String _hmacKey = SettingModel.get("computers_auth:hmac_password");
            if (_hmacKey == null || _hmacKey.isEmpty()) {
                _hmacKey = "changeMe";
                SettingModel.set("computers_auth:hmac_password", _hmacKey);
            }
            PublicKey pubKey = null;
            PrivateKey privKey = null;
            boolean isKeysOk = false;
            try {
                if (_pubKey != null && !_pubKey.isEmpty()) {
                    pubKey = TlsHelper.publicKeyFromBase64String((String)_pubKey, (String)"RSA");
                }
                if (_privKey != null && !_privKey.isEmpty()) {
                    privKey = TlsHelper.privateKeyFromBase64String((String)_privKey, (String)"RSA");
                }
                if (privKey != null && pubKey != null) {
                    isKeysOk = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"key init error (normal during first start", (Throwable)e);
            }
            if (!isKeysOk) {
                logger.info((Object)"Generating keys for ComputerManager");
                try {
                    KeyPair kp = TlsHelper.genereateKeyPair((String)"RSA", (int)2048);
                    pubKey = kp.getPublic();
                    privKey = kp.getPrivate();
                    SettingModel.set("computers_auth:pubkey_password", TlsHelper.keyToBase64String((Key)pubKey));
                    SettingModel.set("computers_auth:privkey_password", TlsHelper.keyToBase64String((Key)privKey));
                    logger.info((Object)"Keys for ComputerManager genereated");
                }
                catch (Exception e1) {
                    logger.error((Object)"Unable to generate keypair for ComputerManager", (Throwable)e1);
                }
            }
            ComputersManager.getInstance().init(computersTree, pubKey, privKey);
            logger.info((Object)"ComputersManager init completed");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init ComputersManager", (Throwable)e);
        }
    }

    private void initClusterManager() {
        try {
            ClusterManager.getInstance().setEnabled(SettingModel.getBool("cluster:enabled"));
            if (!SettingModel.getBool("cluster:enabled")) {
                return;
            }
            ClusterManager.getInstance().syncCacheFromRemote();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init ClusterManager", (Throwable)e);
        }
    }

    private void initSettings() {
        SettingModel.initCache();
        String proxy = SettingModel.get("proxy:uri");
        if (proxy != null && !proxy.isEmpty()) {
            TlsHelper.setProxy((String)proxy, (String)SettingModel.get("proxy:login"), (String)SettingModel.get("proxy:password"));
        }
    }

    private void initMobileManager() {
        try {
            String mode;
            switch (mode = SettingModel.get("mobile:mode")) {
                case "polling": {
                    this.mobileManager.initPullMode(SettingModel.get("mobile:url"), SettingModel.get("mobile:org"), SettingModel.get("mobile:password"));
                    break;
                }
                case "webhook": {
                    this.mobileManager.initWebHookMode(SettingModel.get("mobile:published_url"), SettingModel.get("mobile:url"), SettingModel.get("mobile:org"), SettingModel.get("mobile:password"));
                    break;
                }
            }
            this.mobileManager.setClockDiff(SettingModel.getInt("mobile:max_clock_diff"));
            this.mobileManager.setPushAuthWaitInterval(SettingModel.getInt("mobile:push_auth_wait"));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init MobileManager");
        }
    }

    private void initLicenseManager() throws NoSuchAlgorithmException, InvalidKeySpecException {
        licenseManager.init();
        String licenseFile = String.valueOf(SettingsManager.getBaseFolder()) + "conf/license.txt";
        licenseManager.setLicenseFile(licenseFile);
        licenseManager.loadLicense();
    }

    private IAuthProvider initExtOTPAuthProvider() {
        String type = SettingModel.get("auth:extauth_type");
        Object extAuthProvider = null;
        switch (type) {
            case "radius": {
                extAuthProvider = new RadiusProvider(SettingModel.get("radius:host"), SettingModel.get("radius:password"), SettingModel.get("radius:nas"), SettingModel.get("radius:type"), SettingModel.getBool("radius:challengeresponse"));
                break;
            }
            case "linotp": {
                extAuthProvider = new LinOTPProvider(SettingModel.get("linotp:validate_url"));
                break;
            }
            case "fortiauth": {
                extAuthProvider = new FortiAuthProvider(SettingModel.get("fortiauth:validate_url"), SettingModel.get("fortiauth:user"), SettingModel.get("fortiauth:password"));
                break;
            }
            case "totp": {
                extAuthProvider = new TOTPProvider(this::getTOTPSecretForLogin, this::getInitialTOTPForLogin);
                break;
            }
            case "duo": {
                extAuthProvider = new DuoAuthProvider(SettingModel.get("duo:hostname"), SettingModel.get("duo:integration_key"), SettingModel.get("duo:password"), SettingModel.getBool("duo:use_proxy"), SettingModel.getBool("duo:do_cert_check"));
                break;
            }
            case "multifactor": {
                extAuthProvider = new MultifactorAuthProvider(SettingModel.get("multifactor:apiurl"), SettingModel.get("multifactor:nas"), SettingModel.get("multifactor:password"), SettingModel.getBool("multifactor:isPush"), SettingModel.getBool("multifactor:use_proxy"), SettingModel.getBool("multifactor:do_cert_check"));
                break;
            }
        }
        if (extAuthProvider != null) {
            logger.debug((Object)("ExtAuthProvider " + extAuthProvider.getClass().getSimpleName() + " initialized"));
        } else {
            logger.warn((Object)"ExtAuthProvider is null");
        }
        return extAuthProvider;
    }

    private void initAuthManager() {
        IAuthProvider extOTPAuthProvider = this.initExtOTPAuthProvider();
        LdapManager extAuthProvider = new LdapManager();
        TOTPProvider intOTPAuthProvider = new TOTPProvider(this::getTOTPSecretForLogin, this::getInitialTOTPForLogin);
        boolean requirePasswordExt = SettingModel.getBool("auth:require_passwd_ext");
        boolean requirePasswordInt = SettingModel.getBool("auth:require_passwd_int");
        boolean requireOtpForExternal = SettingModel.getBool("auth:require_otp_ext");
        boolean requireOtpForInternal = SettingModel.getBool("auth:require_otp_int");
        this.authManager = new AuthManager(requirePasswordExt, requirePasswordInt, requireOtpForExternal, requireOtpForInternal, (IAuthProvider)extAuthProvider, extOTPAuthProvider, (IAuthProvider)intOTPAuthProvider);
        this.authManager.setSecurityLogger(securityLogger);
    }

    private String getTOTPSecretForLogin(String login) {
        String secret = null;
        try {
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login.toLowerCase());
            if (model != null && model.totp != null) {
                secret = model.totp.secretKey;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getSecretForLogin for " + login), (Throwable)e);
        }
        return secret;
    }

    private String getInitialTOTPForLogin(String login) {
        String initialTOTP = null;
        try {
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login.toLowerCase());
            if (model != null && model.totp != null) {
                initialTOTP = model.totp.initialTOTP;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getInitialTOTPForLogin for " + login), (Throwable)e);
        }
        return initialTOTP;
    }

    public static CoreEngine getInstance() {
        if (instance == null) {
            instance = new CoreEngine();
            instance.init();
            return instance;
        }
        return instance;
    }

    public static SyslogOutput getSyslog() {
        return CoreEngine.getInstance().syslog;
    }

    public static LicenseManager getLicenseManager() {
        CoreEngine.getInstance();
        return licenseManager;
    }

    public IAuthProvider getExternalAuthProvider() {
        return CoreEngine.getInstance().authManager.getExtAuthProvider();
    }

    public void initLdap() {
        LDAPHelper.setConnectTimeout((int)SettingModel.getInt("ldap_server:connect_timeout", 2000));
        LDAPHelper.setReadTimeout((int)SettingModel.getInt("ldap_server:read_timeout", 10000));
        LdapManager.init(SettingModel.get("ldap_server:master_user_dn"), SettingModel.get("ldap_server:password"), SettingModel.get("ldap_server:host"), SettingModel.get("ldap_server:user_base"), SettingModel.get("ldap_server:user_filter"), SettingModel.get("ldap_server:computer_base"), SettingModel.get("ldap_server:group_base"), SettingModel.get("ldap_server:managedby_attrib"), SettingModel.getBool("ldap_server:verifySSL"));
    }

    public void initSyslog() {
        if (SettingModel.get("syslog:enabled").equals("true")) {
            this.syslog = new SyslogOutput(SettingModel.get("syslog:server"), SettingModel.getInt("syslog:port"));
        }
    }

    public void notifySettingsUpdate(String group, boolean sendToOtherEngines) {
        logger.debug((Object)("notifySettingsUpdate " + group));
        try {
            switch (group) {
                case "ldap_server": {
                    this.initLdap();
                    break;
                }
                case "syslog": {
                    this.initSyslog();
                    break;
                }
                case "linotp": 
                case "radius": 
                case "duo": 
                case "auth": 
                case "totp": 
                case "multifactor": {
                    this.initAuthManager();
                    break;
                }
                case "laps_backup": {
                    if (SettingModel.getBool("laps_backup:enabled")) {
                        this.jobManager.initJob(BackupLapsJob.class, SettingModel.get("laps_backup:cron"));
                        break;
                    }
                    this.jobManager.stopJob(BackupLapsJob.class);
                    break;
                }
                case "ldap_cron": {
                    this.jobManager.initJob(CleanLDAPUsersJob.class, SettingModel.get("ldap_cron:remove_users_cron"));
                    if (SettingModel.getBool("ldap_cron:pass_change_enabled")) {
                        this.jobManager.initJob(LDAPPasswordRotateJob.class, SettingModel.get("ldap_cron:password_change_cron"));
                        break;
                    }
                    this.jobManager.stopJob(LDAPPasswordRotateJob.class);
                    break;
                }
                case "log": {
                    this.jobManager.initJob(LogRetentionJob.class, SettingModel.get("log:cron"));
                    break;
                }
                case "token": {
                    int tokenExpiration;
                    AuthFilter.tokenExpirationMinutes = tokenExpiration = Integer.parseInt(SettingModel.get("token:user_expiration_minutes"));
                    break;
                }
                case "network": {
                    boolean showStackTrace = SettingModel.getBool("network:show_stacktrace");
                    GenericExceptionMapper.setDisplayErrorInfo(showStackTrace);
                    break;
                }
                case "mobile": {
                    if (SettingModel.getBool("mobile:enabled")) {
                        this.initMobileManager();
                        break;
                    }
                    this.mobileManager.stop();
                    break;
                }
                case "proxy": {
                    String proxy = SettingModel.get("proxy:uri");
                    if (proxy == null || proxy.isEmpty()) break;
                    TlsHelper.setProxy((String)proxy, (String)SettingModel.get("proxy:login"), (String)SettingModel.get("proxy:password"));
                    break;
                }
                case "cluster": {
                    ClusterManager.getInstance().setEnabled(SettingModel.getBool("cluster:enabled"));
                    if (SettingModel.getBool("cluster:enabled")) {
                        this.jobManager.initJob(ClusterSyncJob.class, SettingModel.get("cluster:sync_cron"));
                        break;
                    }
                    this.jobManager.stopJob(ClusterSyncJob.class);
                    break;
                }
                case "computers": {
                    this.initComputersManager();
                    break;
                }
            }
            if (sendToOtherEngines && SettingModel.getBool("cluster:enabled")) {
                ClusterManager.getInstance().putSettingsToRemote(group);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to apply setting for group " + group));
        }
    }

    public AuthManager getAuthManager() {
        return this.authManager;
    }

    public JSONObject checkSettings(String group, HashMap<String, String> settings) {
        JSONObject json = new JSONObject();
        try {
            switch (group) {
                case "ldap_server": {
                    boolean ldapVerifySSL = Boolean.parseBoolean(settings.get("ldap_server:verifySSL"));
                    LDAPHelper lh = new LDAPHelper(settings.get("ldap_server:master_user_dn"), settings.get("ldap_server:password"), settings.get("ldap_server:host"), true, ldapVerifySSL);
                    InitialLdapContext ctx = lh.getContext();
                    if (ctx == null) {
                        json.put("error", (Object)"Unable to connect to LDAP");
                        break;
                    }
                    json.put("success", (Object)"Connected to LDAP");
                    ctx.close();
                    break;
                }
                case "cluster": {
                    String clusterResult = ClusterManager.getInstance().checkConnection();
                    if (!(clusterResult.isEmpty() || clusterResult.toLowerCase().contains("exception") || clusterResult.toLowerCase().contains("fail"))) {
                        json.put("success", (Object)clusterResult);
                        break;
                    }
                    json.put("error", (Object)clusterResult);
                }
            }
        }
        catch (Exception e) {
            try {
                json.put("exception", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }
}

