/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.freemaker.Templater;
import com.ksoft.laps.core.AbstractWorker;
import com.ksoft.laps.db.AlertModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.ldap.LDAPHelper;
import com.ksoft.utils.Email;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Authenticator;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class HealthMonitor
extends AbstractWorker {
    static Logger logger = Logger.getLogger((String)HealthMonitor.class.getName());
    static LinkedBlockingQueue<AlertModel> queue = new LinkedBlockingQueue();

    public HealthMonitor() {
        AlertModel.setQueue(queue);
    }

    public static void checkLDAPconnection() throws NamingException, JSONException {
        String[] hosts;
        AlertModel result = null;
        JSONObject json = new JSONObject();
        String[] stringArray = hosts = SettingModel.get("ldap_server:host").split(";");
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            String supressKey = "ldap_connection:" + host;
            LDAPHelper lh = new LDAPHelper(SettingModel.get("ldap_server:master_user_dn"), SettingModel.get("ldap_server:password"), host, true, true);
            InitialLdapContext ctx = lh.getContext();
            if (ctx != null) {
                ctx.close();
            } else {
                JSONObject data = new JSONObject();
                data.put("host", (Object)host);
                logger.error((Object)("Unable connect to " + host));
                result = AlertModel.register(AlertModel.ALERT_TYPE.LDAP_CONNECTION, supressKey, host, data);
            }
            ++n2;
        }
    }

    public void deliver(AlertModel alert) {
        logger.debug((Object)("Attempt to deliver alert " + alert.name));
        try {
            String transport = "email";
            logger.debug((Object)("Found policy for alert " + alert.type + " transport is " + transport));
            switch (transport.toLowerCase()) {
                case "email": {
                    String server = SettingModel.get("email_server:server");
                    Integer port = Integer.parseInt(SettingModel.get("email_server:port"));
                    Boolean usessl = Boolean.parseBoolean(SettingModel.get("email_server:usessl"));
                    String from = SettingModel.get("email_server:from");
                    String username = SettingModel.get("email_server:username");
                    String password = SettingModel.get("email_server:password");
                    Properties sessionProperties = new Properties();
                    Email.PasswordAuthenticator passwordAuthenticator = null;
                    if (usessl.booleanValue()) {
                        sessionProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    }
                    sessionProperties.put("mail.smtp.host", server);
                    sessionProperties.put("mail.smtp.port", port);
                    sessionProperties.put("mail.from", from);
                    if (!username.isEmpty() && !password.isEmpty()) {
                        sessionProperties.put("mail.smtp.auth", "true");
                        passwordAuthenticator = new Email.PasswordAuthenticator(username, password);
                    }
                    sessionProperties.put("supress.key", alert.supressKey);
                    sessionProperties.put("supress.period", SettingModel.getInt("alert:supression"));
                    String body = Templater.process(alert.type, alert.getJSON());
                    String subject = "WebLAPS alert " + alert.name;
                    String to = SettingModel.get("alert:to");
                    Email.send((Properties)sessionProperties, (Authenticator)passwordAuthenticator, (String)to, (String)subject, (String)body);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to deliver alert " + alert.name), (Throwable)e);
        }
    }

    @Override
    protected void work() throws Exception {
        AlertModel alert = queue.take();
        if (alert.isNew || !alert.isNew && !SettingModel.getBool("alert:deliver_only_new")) {
            this.deliver(alert);
        }
    }

    @Override
    protected void handleError(Exception t) {
    }

    @Override
    protected void prepareWorker() throws Exception {
    }

    @Override
    protected void releaseWorker() throws Exception {
    }

    @Override
    protected void health_monitor() {
    }

    public static enum HEALTH_CHECK {
        OK,
        WARN,
        FAIL;

    }
}

