/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.TransactionModel;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JiaManager
implements ILibrary {
    static JiaManager instance = new JiaManager();
    static Logger logger = Logger.getLogger((String)JiaManager.class.getName());
    static HashMap<String, String> idToRole = new HashMap();
    static HashMap<String, JSONArray> rolePrivelegedGroups = new HashMap();
    static HashMap<String, Integer> roleMaxTTL = new HashMap();
    static HashMap<String, JSONObject> roleConfig = new HashMap();
    static HashMap<String, String> accessMatrix = new HashMap();

    public static JiaManager getInstance() {
        return instance;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            String roleName = name.toLowerCase();
            String roleGroup = config.getString("role_group").toLowerCase();
            idToRole.put(id, roleName);
            JSONArray privGroups = config.getJSONArray("priv_groups");
            rolePrivelegedGroups.put(roleName, privGroups);
            accessMatrix.put(roleName, roleGroup);
            roleMaxTTL.put(roleName, config.getInt("ttl"));
            roleConfig.put(roleName, config);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to add role element " + id + " " + name), (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        this.add(id, name, config);
    }

    @Override
    public void del(String id) {
        if (idToRole.containsKey(id)) {
            String roleName = idToRole.get(id);
            idToRole.remove(id);
            rolePrivelegedGroups.remove(roleName);
            accessMatrix.remove(roleName);
            roleMaxTTL.remove(roleName);
            roleConfig.remove(roleName);
        } else {
            logger.error((Object)("Unable to delete role with id " + id + " not found"));
        }
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    public Set<String> getUserRoles(AccountModel model) {
        Set<String> userRoles = new HashSet<String>();
        if (model.getExternal().booleanValue()) {
            userRoles = this.getUserRoles(model.login);
        }
        return userRoles;
    }

    public Set<String> getUserRoles(String login) {
        HashSet<String> userRoles = new HashSet<String>();
        try {
            JSONArray userGroups = LdapManager.getUserGroups(login);
            int i = 0;
            while (i < userGroups.length()) {
                String userGroup = userGroups.getString(i).toLowerCase();
                for (String roleName : accessMatrix.keySet()) {
                    String roleGroup = accessMatrix.get(roleName).toLowerCase();
                    if (!roleGroup.toLowerCase().equals(userGroup)) continue;
                    userRoles.add(roleName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to getUserRoles " + login));
        }
        return userRoles;
    }

    public boolean isUserAllowedJIA(String login) {
        boolean result = false;
        if (this.getUserRoles(login).size() > 0) {
            result = true;
        }
        return result;
    }

    public boolean removeUserFromGroup(String login, String privGroup) {
        boolean result = false;
        try {
            logger.debug((Object)("Deleting " + login + " from " + privGroup));
            result = LdapManager.removeUserFromGroup(login, privGroup, true);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete " + login + " from " + privGroup));
        }
        return result;
    }

    public boolean addUserToGroup(String login, String privGroup) {
        boolean result = false;
        try {
            logger.debug((Object)("Addint " + login + " to " + privGroup));
            LdapManager.addUserToGroup(login, privGroup, true);
        }
        catch (Exception e) {
            logger.error((Object)("Unable add " + login + " from " + privGroup));
        }
        return result;
    }

    public Integer applyToRole(AccountModel accountModel, String roleName, Long tillMilli) {
        Integer result = -1;
        boolean isAddedToAllPirvGroups = true;
        try {
            int roleTTLMilli = roleMaxTTL.get(roleName) * 1000;
            Long now = Instant.now().toEpochMilli();
            Long tempTillMilli = tillMilli;
            if (tillMilli > now + (long)roleTTLMilli) {
                tempTillMilli = now + (long)roleTTLMilli;
                logger.warn((Object)("User " + accountModel.getLogin() + " requested role " + roleName + " till " + tillMilli + " which is > than allowed " + tempTillMilli + " role ttl: " + roleTTLMilli));
            }
            if (tillMilli < now) {
                logger.error((Object)("User " + accountModel.getLogin() + " requested role " + roleName + " till " + tillMilli + " which is < now " + now));
                return -1;
            }
            logger.debug((Object)("Attempt to apply to role " + roleName + " by " + accountModel.getLogin() + " tilll " + tempTillMilli));
            int roleTransId = TransactionModel.addOrUpdateTransaction(accountModel.getLogin(), TransactionModel.TRANS_TYPE.ROLE_APPLY, roleName, null, null, tempTillMilli);
            ArrayList<String> groupTransactions = new ArrayList<String>();
            Set<String> userRoles = this.getUserRoles(accountModel);
            if (userRoles.contains(roleName.toLowerCase())) {
                JSONArray privGroups = rolePrivelegedGroups.get(roleName);
                int i = 0;
                while (i < privGroups.length()) {
                    String privGroup = privGroups.getString(i);
                    int transId = TransactionModel.addOrUpdateTransaction(accountModel.getLogin(), TransactionModel.TRANS_TYPE.GROUP_APPLY, roleName, privGroup, null, tempTillMilli);
                    if (transId > 0) {
                        boolean isAdded = LdapManager.addUserToGroup(accountModel.getLogin(), privGroup, true);
                        if (isAdded) {
                            boolean isCommitted = TransactionModel.commitTransaction(transId);
                            if (!isCommitted) {
                                this.removeUserFromGroup(accountModel.getLogin(), privGroup);
                                logger.error((Object)("Transaction " + transId + " for " + accountModel.getLogin() + " not committed!"));
                            } else {
                                groupTransactions.add(String.valueOf(transId));
                            }
                        } else {
                            isAddedToAllPirvGroups = false;
                            logger.error((Object)("Unable to add " + accountModel.getLogin() + " to " + privGroup));
                        }
                    } else {
                        logger.error((Object)("Unable to add transaction for " + accountModel.getLogin() + " skipping role assigment"));
                    }
                    ++i;
                }
                TransactionModel roleTrans = (TransactionModel)DBManager.getDao(TransactionModel.class).queryForId((Object)roleTransId);
                if (roleTrans != null) {
                    roleTrans.value = String.join((CharSequence)",", groupTransactions);
                    DBManager.getDao(TransactionModel.class).update((Object)roleTrans);
                    if (TransactionModel.commitTransaction(roleTransId)) {
                        result = roleTransId;
                    }
                } else {
                    logger.error((Object)("Unable to find role transaction with id " + roleTransId + " during final commit"));
                }
            } else {
                logger.error((Object)("User " + accountModel.getLogin() + " has no " + roleName + " rights"));
                result = -1;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to apply to role " + roleName + " by " + accountModel.getLogin()), (Throwable)e);
        }
        return result;
    }

    public Integer getRoleTTLSeconds(String role) {
        return roleMaxTTL.get(role);
    }

    public JSONArray getActiveTasks(AccountModel model) throws SQLException, JSONException {
        JSONArray result = new JSONArray();
        Long now = Instant.now().toEpochMilli();
        List transactions = DBManager.getDao(TransactionModel.class).queryBuilder().where().eq("owner", (Object)model.getLogin()).and().eq("type", (Object)TransactionModel.TRANS_TYPE.ROLE_APPLY).and().gt("ts_till", (Object)now).and().gt("ts_committed", (Object)0).query();
        for (TransactionModel t : transactions) {
            JSONObject j = new JSONObject();
            j.put("id", (Object)t.id);
            j.put("name", (Object)t.name);
            j.put("ts_till", (Object)t.ts_till);
            j.put("ts_created", (Object)t.ts_created);
            j.put("ts_committed", (Object)t.ts_committed);
            result.put((Object)j);
        }
        return result;
    }

    public boolean stopRole(int id, AccountModel model) throws SQLException {
        boolean result = false;
        TransactionModel roleTrans = (TransactionModel)DBManager.getDao(TransactionModel.class).queryBuilder().where().idEq((Object)id).and().eq("owner", (Object)model.getLogin()).and().eq("type", (Object)TransactionModel.TRANS_TYPE.ROLE_APPLY).queryForFirst();
        if (roleTrans != null) {
            List<String> groupTransIds = Arrays.asList(roleTrans.value.split(","));
            List groupTransactions = DBManager.getDao(TransactionModel.class).queryBuilder().where().eq("owner", (Object)model.getLogin()).and().eq("type", (Object)TransactionModel.TRANS_TYPE.GROUP_APPLY).and().in("id", groupTransIds).query();
            boolean allGroupsDeleted = true;
            for (TransactionModel groupTrans : groupTransactions) {
                String groupName = groupTrans.value;
                boolean deleteResult = this.removeUserFromGroup(model.getLogin(), groupName);
                if (!deleteResult) {
                    allGroupsDeleted = false;
                    continue;
                }
                DBManager.getDao((Object)groupTrans).delete((Object)groupTrans);
            }
            if (allGroupsDeleted) {
                DBManager.getDao((Object)roleTrans).delete((Object)roleTrans);
                logger.info((Object)("Session " + roleTrans.name + " was stopped by user. Owner: " + roleTrans.owner));
                result = true;
                LogModel.register(LogModel.EVENT_TYPE.JITA_ROLE_STOP, "", model.getLogin(), "", "Session " + roleTrans.name + " was stopped by user. Owner: " + roleTrans.owner);
            } else {
                LogModel.register(LogModel.EVENT_TYPE.JITA_ROLE_STOP, "", model.getLogin(), "", "Not all groups were deleted from session " + roleTrans.name + " owner: " + roleTrans.owner);
                logger.error((Object)("Not all groups were deleted from session " + roleTrans.name + " owner: " + roleTrans.owner));
            }
        } else {
            LogModel.register(LogModel.EVENT_TYPE.JITA_ROLE_STOP_FAIL, "", model.getLogin(), "", "Session " + id + " not found");
            logger.error((Object)("Unable to stop role session " + id + " for " + model.getLogin()));
        }
        return result;
    }

    public JSONObject getRoleConfig(String roleName) {
        if (roleConfig.containsKey(roleName)) {
            return roleConfig.get(roleName);
        }
        return null;
    }
}

