/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.jobs.BackupLapsJob;
import com.ksoft.jobs.CleanLDAPUsersJob;
import com.ksoft.jobs.ClusterSyncJob;
import com.ksoft.jobs.JIAJob;
import com.ksoft.jobs.LDAPPasswordRotateJob;
import com.ksoft.jobs.LicenseCheckJob;
import com.ksoft.jobs.LogRetentionJob;
import com.ksoft.laps.db.SettingModel;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class JobManager {
    static Logger logger = Logger.getLogger((String)JobManager.class.getName());
    private Scheduler scheduler = null;
    HashMap<String, JobKey> jobs = new HashMap();

    public void initJobs() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this.scheduler = schedulerFactory.getScheduler();
            this.initAllJobs();
            this.scheduler.start();
        }
        catch (Exception e) {
            logger.error((Object)"initJobs error", (Throwable)e);
        }
    }

    private void initAllJobs() {
        if (SettingModel.getBool("laps_backup:enabled")) {
            this.initJob(BackupLapsJob.class, SettingModel.get("laps_backup:cron"));
        }
        if (SettingModel.getBool("ldap_cron:pass_change_enabled")) {
            this.initJob(LDAPPasswordRotateJob.class, SettingModel.get("ldap_cron:password_change_cron"));
        }
        if (SettingModel.getBool("cluster:enabled")) {
            this.initJob(ClusterSyncJob.class, SettingModel.get("cluster:sync_cron"));
        }
        this.initJob(LogRetentionJob.class, SettingModel.get("log:cron"));
        this.initJob(CleanLDAPUsersJob.class, SettingModel.get("ldap_cron:remove_users_cron"));
        this.initJob(LicenseCheckJob.class, "0 0/15 * * * ?");
        this.initJob(JIAJob.class, SettingModel.get("jia:cron"));
    }

    public void initJob(Class claz, String cron_expression) {
        String name = claz.getSimpleName();
        try {
            this.stopJob(claz);
            if (cron_expression != null && !cron_expression.isEmpty()) {
                JobDetail jobDetail = JobBuilder.newJob((Class)claz).withIdentity(name).build();
                CronExpression cexp = new CronExpression(cron_expression);
                CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(name).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cexp)).forJob(jobDetail).build();
                this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                this.jobs.put(name, jobDetail.getKey());
                logger.info((Object)("Job " + name + " scheduled: " + cron_expression));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to init job " + name), (Throwable)e);
        }
    }

    public void stopJob(Class claz) {
        String name = claz.getSimpleName();
        try {
            if (this.jobs.containsKey(name)) {
                this.scheduler.deleteJob(this.jobs.get(name));
                this.jobs.remove(name);
                logger.debug((Object)("Job " + name + " removed"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to stop job " + name));
        }
    }
}

