/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.core.DBManager;
import com.ksoft.core.FrameWorkInfo;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.laps.db.TOTPModel;
import com.ksoft.ldap.MySSLSocketFactory;
import com.ksoft.tls.TlsHelper;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.WebServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.rzo.yajsw.app.WrapperJVMMain;

public class LapsLauncher {
    static Logger logger = Logger.getLogger((String)LapsLauncher.class.getName());
    static CommandLine commandLine;
    static String version;
    public static boolean debugCluster;
    public static boolean debugMobile;

    static {
        version = "3.1.0";
        debugCluster = false;
        debugMobile = false;
    }

    public static void main(String[] args) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, GeneralSecurityException, JSONException {
        System.setProperty("java.net.preferIPv4Stack", "true");
        BasicConfigurator.configure();
        debugMobile = System.getProperty("debugmobile", "false").equals("true");
        debugCluster = System.getProperty("debugcluster", "false").equals("true");
        try {
            logger.info((Object)("OS: " + System.getProperty("os.name") + ". Portal version: " + version + ". Framework version: " + FrameWorkInfo.getVersion()));
            Security.addProvider((Provider)new BouncyCastleProvider());
            LapsLauncher.initSettingsManager();
            String seed = SettingsManager.getStringValue("seed", "ree123##");
            SettingModel.setInternalSecretKey(seed);
            String jettyCertAlias = SettingsManager.getStringValue("jetty_cert_alias", "jetty");
            TlsHelper.init((String)(String.valueOf(SettingsManager.getKeyStoreFolder()) + "/keystore.jks"), (String)SettingsManager.getKeyStorePass());
            TlsHelper.setSslContextFactoryCertAlias((String)jettyCertAlias);
            MySSLSocketFactory.init((SSLContext)TlsHelper.getSSLctx());
            ArrayList<String> classes = SettingsManager.getModelsClassToInit();
            String jdbcClass = SettingsManager.getStringValue("jdbc_driver", "org.sqlite.JDBC");
            String dbHost = SettingsManager.getStringValue("db_host", "localhost");
            int dbPort = SettingsManager.getIntValue("db_port", 0);
            String dbName = SettingsManager.getStringValue("db", "laps");
            String dbUser = SettingsManager.getStringValue("db_user", "");
            String dbPassword = SettingsManager.getStringValue("db_password", "");
            if (jdbcClass.equals("org.sqlite.JDBC")) {
                dbHost = String.valueOf(SettingsManager.getBaseFolder()) + dbHost;
            }
            DBManager.init((String)jdbcClass, (String)dbHost, (int)dbPort, (String)dbName, (String)dbUser, (String)dbPassword, classes);
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            LapsLauncher.afterFirstRun();
            privateKey = TlsHelper.getPrivateKey((String)jettyCertAlias);
            publicKey = TlsHelper.getCertificate((String)jettyCertAlias).getPublicKey();
            if (args.length > 0) {
                commandLine = LapsLauncher.initCommandLine(args);
                if (commandLine == null) {
                    return;
                }
                String[] params = null;
                if (commandLine.hasOption("exportdb")) {
                    params = commandLine.getOptionValues("exportdb");
                    String fileName = params[0];
                    FileUtils.deleteQuietly((File)new File(fileName));
                    DBManager.exportDB((String)fileName);
                    System.out.println("DB exported to " + fileName);
                    return;
                }
                if (commandLine.hasOption("exportlocaldb")) {
                    DBManager.init((String)"org.sqlite.JDBC", null, (int)0, null, null, null, classes);
                    params = commandLine.getOptionValues("exportlocaldb");
                    String fileName = params[0];
                    FileUtils.deleteQuietly((File)new File(fileName));
                    DBManager.exportDB((String)fileName);
                    System.out.println("DB exported to " + fileName);
                    return;
                }
                if (commandLine.getArgList().contains("resetpass")) {
                    AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)"admin");
                    System.out.print("Enter new password for admin: ");
                    accountModel.password = System.console().readLine();
                    if (accountModel.totp != null) {
                        DBManager.getDao(TOTPModel.class).delete((Object)accountModel.totp);
                        accountModel.totp = null;
                    }
                    accountModel.hashPassword();
                    DBManager.getDao((Object)accountModel).update((Object)accountModel);
                    System.out.println("admin password reset completed");
                } else if (commandLine.hasOption("decrypt")) {
                    params = commandLine.getOptionValues("decrypt");
                    SecretKey key = SettingModel.createSecretKey(params[1]);
                    System.out.println(SettingModel.decrypt(params[0], key));
                } else {
                    if (commandLine.hasOption("importdb")) {
                        params = commandLine.getOptionValues("importdb");
                        String fileName = params[0];
                        boolean doDelete = Boolean.parseBoolean(params[1]);
                        DBManager.restoreFromFile((String)fileName, (boolean)doDelete);
                        System.out.println("DB imported from " + fileName);
                        return;
                    }
                    if (commandLine.hasOption("migratedb")) {
                        DBManager.migrate((String)jdbcClass, (String)dbHost, (int)dbPort, (String)dbName, (String)dbUser, (String)dbPassword, (String)"resources/db/master.changelog.xml");
                        System.out.println("DB migration completed. Start portal");
                        return;
                    }
                }
                return;
            }
            AuthFilter.setPrivateKey(privateKey);
            AuthFilter.setPublicKey(publicKey);
            logger.debug((Object)"Calling CoreEngine.getInstance");
            CoreEngine.getInstance();
            logger.debug((Object)"Calling CoreEngine.getInstance completed");
            logger.debug((Object)"Calling WrapperJVMMain.WRAPPER_MANAGER.reportServiceStartup");
            try {
                WrapperJVMMain.WRAPPER_MANAGER.reportServiceStartup();
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to call WrapperJVMMain.WRAPPER_MANAGER.reportServiceStartup()");
            }
            logger.debug((Object)"Starting web server");
            int sslport = SettingsManager.getSslPort();
            WebServer ws = new WebServer(sslport);
            if (!ws.start()) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Launcher init error", (Throwable)e);
        }
    }

    private static void afterFirstRun() throws KeyStoreException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getCanonicalHostName();
        if (!SettingsManager.getStringValue("init_completed", "false").equals("true")) {
            logger.info((Object)"First run. Load default settings");
            AccountModel account = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)"admin");
            if (account == null) {
                account = new AccountModel();
                account.login = "admin";
                account.enabled = true;
                account.external = false;
                account.roles = "[\"ADMIN\"]";
                account.password = "admin";
                account.email = "admin@localhost";
                account.hashPassword();
                DBManager.getDao((Object)account).create((Object)account);
            }
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            InputStream input = classLoader.getResourceAsStream("resources/default.conf");
            try {
                int read;
                File file = File.createTempFile(String.valueOf(new Date().getTime()) + "_lps", ".tmp");
                FileOutputStream out = new FileOutputStream(file);
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, read);
                }
                out.flush();
                ((OutputStream)out).close();
                input.close();
                DBManager.restoreFromFile((File)file, (boolean)true);
                file.delete();
            }
            catch (Exception e) {
                logger.error((Object)"load from jar error", (Throwable)e);
            }
            if (TlsHelper.getCertificate((String)"jetty") == null) {
                logger.info((Object)("Server certificate generation " + hostname));
                TlsHelper.generateSelfSignedCertificate((String)"jetty", (String)hostname);
                TlsHelper.reinit();
            }
            SettingsManager.setValue("init_completed", "true");
            SettingsManager.saveConfig();
        }
    }

    private static void initSettingsManager() {
        String path = LapsLauncher.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = String.valueOf(path.substring(0, path.lastIndexOf("/bin"))) + "/";
        String confDir = String.valueOf(path) + "conf";
        String string = confDir = System.getProperty("os.name").contains("indow") ? confDir.substring(1) : confDir;
        if (!Files.exists(Paths.get(confDir, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(confDir, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e1) {
                logger.error((Object)"Unable to create conf directory");
            }
        }
        String fileConfig = String.valueOf(confDir) + "/engine.conf";
        if (debugCluster) {
            fileConfig = String.valueOf(confDir) + "/engine_cluster.conf";
        }
        try {
            JSONObject config = new JSONObject();
            if (new File(fileConfig).exists()) {
                config = new JSONObject(FileUtils.readFileToString((File)new File(fileConfig)));
            }
            config.put("basepath", (Object)path);
            SettingsManager.setGlobalConfig(config);
        }
        catch (Exception e) {
            logger.error((Object)"initSettingsManager error", (Throwable)e);
        }
    }

    private static CommandLine initCommandLine(String[] args) {
        CommandLine line = null;
        Options options = new Options();
        options.addOption("help", "print help");
        options.addOption(Option.builder((String)"importdb").hasArgs().numberOfArgs(2).desc("import db from file").argName("file> <removeExisting>").build());
        options.addOption(Option.builder((String)"exportdb").hasArgs().numberOfArgs(1).desc("export to file").argName("file").build());
        options.addOption(Option.builder((String)"exportlocaldb").hasArgs().numberOfArgs(1).desc("export SQLite db to file").argName("file").build());
        options.addOption("resetpass", "reset admin password");
        options.addOption("movelocaldb", "move data from sqlite to external DB");
        options.addOption("migratedb", "migrate database");
        try {
            Object params = null;
            DefaultParser parser = new DefaultParser();
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("launcher", options);
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("launcher", options);
        }
        return line;
    }

    public static String getVersion() {
        return version;
    }
}

