/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.AdmPWDKeyManager;
import com.ksoft.laps.core.BitLockerManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.JiaManager;
import com.ksoft.laps.core.LibraryManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LibraryModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.ldap.LDAPHelper;
import com.ksoft.web.AuthFilter;
import com.opencsv.CSVReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LdapManager
implements ILibrary,
IAuthProvider {
    static LdapManager instance = new LdapManager();
    static Logger logger = Logger.getLogger((String)LdapManager.class.getName());
    static LDAPHelper ldapHelper;
    static HashMap<String, String> idToGroup;
    static HashMap<String, HashMap<String, String>> lapsAccessMatrix;
    static String bind_user;
    static String password;
    static String host;
    static String userSearchBase;
    static String computerSearchBase;
    static String userSearchString;
    static String managedByAttribute;
    public static String groupSearchBase;
    static String userRegex;
    static String pcRegex;
    private static LoadingCache<String, JSONArray> userGroupCache;
    private static LoadingCache<String, HashMap<String, String>> userAtributeCache;
    private static LoadingCache<String, ArrayList<HashMap<String, String>>> singleControllerSearchCache;

    static {
        idToGroup = new HashMap();
        lapsAccessMatrix = new HashMap();
        password = "";
        host = "";
        userRegex = "[a-zA-Z0-9_\\\\@\\.-]+";
        pcRegex = "[a-zA-Z0-9_-]+";
    }

    public static void init(String bind_user, String password, String host, String userSearchBase, String userSearchString, String computerSearchBase, String groupSearchBase, String managedByAttribute, boolean verifySSL) {
        LdapManager.bind_user = bind_user;
        LdapManager.password = password;
        LdapManager.host = host;
        LdapManager.userSearchBase = userSearchBase;
        LdapManager.computerSearchBase = computerSearchBase;
        LdapManager.userSearchString = userSearchString;
        LdapManager.groupSearchBase = groupSearchBase;
        LdapManager.managedByAttribute = managedByAttribute;
        LdapManager.initCaches();
        LDAPHelper.setConnectTimeout((int)SettingModel.getInt("ldap_server:connect_timeout", 2000));
        LDAPHelper.setReadTimeout((int)SettingModel.getInt("ldap_server:read_timeout", 10000));
        ldapHelper = new LDAPHelper(bind_user, password, host, true, verifySSL);
    }

    public static void initCaches() {
        userGroupCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, JSONArray>(){

            public JSONArray load(String login) throws Exception {
                return LdapManager.getUserGroupsFromAD(login);
            }
        });
        userAtributeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, HashMap<String, String>>(){

            public HashMap<String, String> load(String login) throws Exception {
                return LdapManager.getUserAttributesFromAD(login);
            }
        });
        singleControllerSearchCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, ArrayList<HashMap<String, String>>>(){

            public ArrayList<HashMap<String, String>> load(String key) throws Exception {
                return null;
            }
        });
    }

    public static LdapManager getLdapManagerInstance() {
        return instance;
    }

    public static void reinit() {
        ldapHelper = new LDAPHelper(bind_user, password, host, true, true);
    }

    public static ArrayList<HashMap<String, String>> search(String filter, String base, String attribs, int limit) throws NamingException {
        String key = String.valueOf(filter) + "::" + base + "::" + attribs + "::" + limit;
        ArrayList searchResults = (ArrayList)singleControllerSearchCache.getIfPresent((Object)key);
        if (searchResults == null) {
            String[] returningAttributes = attribs.split(",");
            searchResults = ldapHelper.search(base, filter, returningAttributes, limit);
            if (searchResults != null) {
                singleControllerSearchCache.put((Object)key, (Object)searchResults);
            }
        } else {
            logger.debug((Object)("singleControllerSearchCache cache hit. Filter: " + filter + " base: " + base + " attribs: " + attribs + " limit: " + limit));
        }
        return searchResults;
    }

    private static String decryptPassword(String password) {
        int keyId = 0;
        boolean isEncrypted = false;
        boolean isLicenseValid = CoreEngine.getLicenseManager().isLicenseValid();
        String result = password;
        if (SettingModel.getBool("laps_extra:encrypt_support")) {
            try {
                String encryptedPassword = "";
                String[] array = password.split(":");
                switch (array.length) {
                    case 1: {
                        isEncrypted = false;
                        result = password;
                        break;
                    }
                    case 2: {
                        keyId = Integer.parseInt(array[0].trim());
                        encryptedPassword = array[1].trim();
                        isEncrypted = true;
                    }
                }
                if (isEncrypted) {
                    result = AdmPWDKeyManager.getInstance().decrypt(keyId, encryptedPassword);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to decrypt password", (Throwable)e);
            }
        }
        if (!isLicenseValid) {
            int len = result.length();
            String masked = result.substring(0, len - 3);
            result = masked = String.valueOf(masked) + "_UNLICENSED";
        }
        return result;
    }

    public static boolean isLDAPconfigured() {
        boolean result = false;
        if (!(password.isEmpty() || host.isEmpty() || host.equals("host.domain.com"))) {
            result = true;
        }
        return result;
    }

    public static boolean isComputerInAD(String pc) {
        boolean result = false;
        try {
            if (!LdapManager.isLDAPconfigured()) {
                logger.debug((Object)"Ldap is not configured");
                return result;
            }
            if (!pc.trim().matches(pcRegex)) {
                logger.error((Object)("pc " + pc + " not matched regex [a-zA-Z0-9_-]+"));
                return result;
            }
            String filter = "(&(CN=" + pc + ")(objectClass=computer))";
            String attribs = "CN";
            String[] returningAttributes = attribs.split(",");
            ArrayList<HashMap<String, String>> searchRes = LdapManager.search(filter, computerSearchBase, attribs, 1);
            if (searchRes.size() > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("isComputerInAD " + pc + " error"), (Throwable)e);
        }
        return result;
    }

    public static JSONObject getCompInfo(String pc, AccountModel accountModel) {
        JSONObject result = new JSONObject();
        boolean forceUpdateToAllDC = SettingModel.getBool("laps_extra:expire_force_alldc");
        Integer expireMinutes = SettingModel.getInt("laps_extra:laps_expire");
        String filter = "(&(CN=" + pc + ")(objectClass=computer))";
        String attribs = "ms-Mcs-AdmPwd,ms-Mcs-AdmPwdExpirationTime,msLAPS-Password,msLAPS-PasswordExpirationTime,distinguishedName";
        String extraAttribs = SettingModel.get("laps_extra:extra_pc_attributes");
        if (extraAttribs != null && !extraAttribs.isEmpty()) {
            attribs = String.valueOf(attribs) + "," + extraAttribs.trim();
        }
        String[] returningAttributes = attribs.split(",");
        try {
            if (pc.equals("__test1__")) {
                result.put("password", (Object)"mockPW0iLlD1");
                result.put("expire", ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond());
                JSONObject jExtra = new JSONObject();
                JSONArray otherPasswords = new JSONArray();
                otherPasswords.put((Object)"somePWD1");
                otherPasswords.put((Object)"somePWD2");
                result.put("other_passwords", (Object)otherPasswords);
                jExtra.put("Some other attribute", (Object)"Value of attribute");
                result.put("extra", (Object)jExtra);
                result.put("warning", (Object)"More than one passwords found, try all of them");
                result.put("winlaps_password", (Object)"WINLAPSbitP@$$w0rd");
                result.put("winlaps_other_passwords", (Object)otherPasswords);
                result.put("winlaps_login", (Object)"localadmin");
                result.put("winlaps_expire", ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond());
                return result;
            }
            if (!pc.matches(pcRegex) || !accountModel.getLogin().matches(userRegex)) {
                result.put("error", (Object)"PC not mathced regex");
                return result;
            }
            boolean isPwdFound = false;
            boolean isLapsInstalled = false;
            boolean isWinLapsInstalled = false;
            boolean isWinLapsPwdFound = false;
            boolean isComputerFound = false;
            HashSet<String> allPasswordsSet = new HashSet<String>();
            HashSet<String> allWinLAPSPasswordsSet = new HashSet<String>();
            String winLAPSlogin = "";
            HashMap searchRes = ldapHelper.search(computerSearchBase, filter, returningAttributes, 1, SettingModel.getBool("laps_extra:query_alldc"));
            ArrayList searchResults = new ArrayList();
            for (String adHost : searchRes.keySet()) {
                ArrayList sr = (ArrayList)searchRes.get(adHost);
                if (sr.size() <= 0) continue;
                isComputerFound = true;
                HashMap r = (HashMap)sr.get(0);
                String pcDN = (String)r.get("distinguishedName");
                if (r.containsKey("ms-Mcs-AdmPwd")) {
                    isPwdFound = true;
                    isLapsInstalled = true;
                    allPasswordsSet.add(LdapManager.decryptPassword((String)r.get("ms-Mcs-AdmPwd")));
                    searchResults = sr;
                }
                if (r.containsKey("msLAPS-Password")) {
                    isWinLapsPwdFound = true;
                    isWinLapsInstalled = true;
                    JSONObject winLapsData = LdapManager.processWindowsLAPS((String)r.get("msLAPS-Password"));
                    if (winLapsData != null) {
                        allWinLAPSPasswordsSet.add(winLapsData.getString("p"));
                        if (winLapsData.has("n")) {
                            winLAPSlogin = winLapsData.getString("n");
                        }
                    }
                    searchResults = sr;
                }
                if (r.containsKey("ms-Mcs-AdmPwdExpirationTime")) {
                    isLapsInstalled = true;
                }
                if (!r.containsKey("msLAPS-PasswordExpirationTime")) continue;
                isWinLapsInstalled = true;
            }
            if (isComputerFound && !isLapsInstalled && !isWinLapsInstalled) {
                searchResults = (ArrayList)searchRes.get(searchRes.keySet().iterator().next());
            }
            logger.debug((Object)("getCompInfo " + pc + " isPwdFound:" + isPwdFound + " isWinLAPSPwdFound:" + isWinLapsPwdFound + " pwdCount: " + allPasswordsSet.size() + " isLapsInstalled: " + isLapsInstalled + " isWinLapsInstalled: " + isWinLapsInstalled + " DCcount: " + searchRes.size()));
            ArrayList allPasswords = new ArrayList(allPasswordsSet);
            ArrayList allWinLAPSPasswords = new ArrayList(allWinLAPSPasswordsSet);
            if (isComputerFound) {
                String[] extraAttribesArray;
                JSONObject jExtra;
                HashMap r = (HashMap)searchResults.get(0);
                String pcDN = (String)r.get("distinguishedName");
                if (isPwdFound || isWinLapsPwdFound) {
                    result.put("dn", (Object)pcDN);
                    if (!LdapManager.isUserAllowedForPC(pcDN, accountModel)) {
                        result.put("error", (Object)"No access rights");
                    } else {
                        Long expire;
                        String pass;
                        int i;
                        JSONArray otherPasswords;
                        jExtra = new JSONObject();
                        if (isPwdFound) {
                            result.put("password", allPasswords.get(0));
                            if (allPasswords.size() > 1) {
                                otherPasswords = new JSONArray();
                                logger.warn((Object)("More than one passwords found for PC " + pc + " by user " + accountModel.getLogin()));
                                result.put("warning", (Object)"More than one passwords found, try all of them");
                                i = 1;
                                while (i < allPasswords.size()) {
                                    pass = (String)allPasswords.get(i);
                                    otherPasswords.put((Object)pass);
                                    ++i;
                                }
                                result.put("other_passwords", (Object)otherPasswords);
                            }
                        }
                        if (isWinLapsPwdFound) {
                            result.put("winlaps_password", allWinLAPSPasswords.get(0));
                            result.put("winlaps_login", (Object)winLAPSlogin);
                            if (allWinLAPSPasswordsSet.size() > 1) {
                                otherPasswords = new JSONArray();
                                logger.warn((Object)("More than one WinLAPS passwords found for PC " + pc + " by user " + accountModel.getLogin()));
                                result.put("warning", (Object)"More than one WindowsLAPS passwords found, try all of them");
                                i = 1;
                                while (i < allWinLAPSPasswords.size()) {
                                    pass = (String)allWinLAPSPasswords.get(i);
                                    otherPasswords.put((Object)pass);
                                    ++i;
                                }
                                result.put("winlaps_other_passwords", (Object)otherPasswords);
                            }
                        }
                        if (extraAttribs != null && !extraAttribs.isEmpty()) {
                            String[] stringArray = extraAttribesArray = extraAttribs.trim().split(",");
                            int n = extraAttribesArray.length;
                            int pass2 = 0;
                            while (pass2 < n) {
                                String e = stringArray[pass2];
                                if (r.containsKey(e)) {
                                    jExtra.put(e, r.get(e));
                                }
                                ++pass2;
                            }
                            result.put("extra", (Object)jExtra);
                        }
                        if (r.containsKey("ms-Mcs-AdmPwdExpirationTime")) {
                            expire = Long.parseLong((String)r.get("ms-Mcs-AdmPwdExpirationTime"));
                            expire = expire / 10000000L - 11644473600L;
                            result.put("expire", (Object)expire);
                            if (expireMinutes != null && expireMinutes > 0) {
                                Long newExpire = System.currentTimeMillis() + (long)(expireMinutes * 60) * 1000L;
                                logger.info((Object)("Attempt to set new expire for " + pc + ". Old " + expire + " New: " + newExpire));
                                boolean expireSeted = LdapManager.setExpire(pc, accountModel, newExpire, forceUpdateToAllDC);
                                if (expireSeted) {
                                    Long newExpire2 = newExpire / 1000L;
                                    result.put("expire", (Object)newExpire2);
                                }
                            }
                        } else if (!r.containsKey("msLAPS-PasswordExpirationTime")) {
                            logger.warn((Object)("ms-Mcs-AdmPwdExpirationTime for " + pc + " not found"));
                        }
                        if (r.containsKey("msLAPS-PasswordExpirationTime")) {
                            expire = Long.parseLong((String)r.get("msLAPS-PasswordExpirationTime"));
                            expire = expire / 10000000L - 11644473600L;
                            result.put("winlaps_expire", (Object)expire);
                            if (expireMinutes != null && expireMinutes > 0) {
                                Long newExpire = System.currentTimeMillis() + (long)(expireMinutes * 60) * 1000L;
                                logger.info((Object)("Attempt to set new expire for " + pc + ". Old " + expire + " New: " + newExpire));
                                boolean expireSeted = LdapManager.setExpire(pc, accountModel, newExpire, forceUpdateToAllDC);
                                if (expireSeted) {
                                    Long newExpire2 = newExpire / 1000L;
                                    result.put("winlaps_expire", (Object)newExpire2);
                                }
                            }
                        } else if (!r.containsKey("ms-Mcs-AdmPwdExpirationTime")) {
                            logger.warn((Object)("msLAPS-PasswordExpirationTime for " + pc + " not found"));
                        }
                    }
                } else {
                    logger.error((Object)("LAPS password not found for " + pc + " user: " + accountModel.getLogin()));
                    jExtra = new JSONObject();
                    if (extraAttribs != null && !extraAttribs.isEmpty()) {
                        String[] stringArray = extraAttribesArray = extraAttribs.trim().split(",");
                        int n = extraAttribesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String e = stringArray[n2];
                            if (r.containsKey(e)) {
                                jExtra.put(e, r.get(e));
                            }
                            ++n2;
                        }
                    }
                    if (jExtra.length() > 0) {
                        result.put("extra", (Object)jExtra);
                    }
                    if (r.containsKey("ms-Mcs-AdmPwdExpirationTime") || r.containsKey("msLAPS-PasswordExpirationTime")) {
                        logger.warn((Object)("bind user has no access rights " + pc + " " + accountModel.login));
                        result.put("error", (Object)"AD bind user has no access rigths");
                    } else {
                        result.put("error", (Object)"ms-Mcs-AdmPwd or msLAPS-Password attribute was not found. Please check if LAPS is installed");
                        logger.error((Object)("ms-Mcs-AdmPwd or msLAPS-Password attribute not found " + pc + " " + accountModel.login));
                    }
                }
            } else {
                result.put("error", (Object)("Computer " + pc + " not found"));
                logger.error((Object)("Computer " + pc + " not found"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCompInfo error", (Throwable)e);
            try {
                result.put("error", (Object)e.getMessage().toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    private static JSONObject processWindowsLAPS(String winLapsData) {
        JSONObject result = null;
        boolean isLicenseValid = CoreEngine.getLicenseManager().isLicenseValid();
        try {
            if (winLapsData != null && !winLapsData.isEmpty()) {
                JSONObject j = new JSONObject(winLapsData);
                if (j.has("p")) {
                    String password = j.getString("p");
                    result = j;
                    if (!isLicenseValid) {
                        int len = password.length();
                        String masked = password.substring(0, len - 3);
                        password = masked = String.valueOf(masked) + "_UNLICENSED";
                        j.put("p", (Object)masked);
                    }
                } else {
                    logger.error((Object)"WindowsLAPS data has no 'p' field");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"WindowsLAPS data processing error", (Throwable)e);
        }
        return result;
    }

    public static boolean setExpire(String pc, AccountModel accountModel, long unixMillis, boolean forceToAllDC) {
        boolean result = false;
        Integer expireMaxMinDifference = SettingModel.getInt("laps_extra:laps_max_expire");
        Long maxExpireMillis = Instant.now().toEpochMilli() + (long)(expireMaxMinDifference * 60 * 1000);
        String filter = "(&(CN=" + pc + ")(objectClass=computer))";
        String attribs = "ms-Mcs-AdmPwd,ms-Mcs-AdmPwdExpirationTime,msLAPS-Password,msLAPS-PasswordExpirationTime,distinguishedName";
        String[] returningAttributes = attribs.split(",");
        try {
            HashMap<String, String> r;
            String dn;
            if (!pc.matches(pcRegex) || !accountModel.login.matches(userRegex)) {
                return result;
            }
            ArrayList<HashMap<String, String>> searchResults = LdapManager.search(filter, computerSearchBase, attribs, 1);
            if (searchResults.size() > 0 && LdapManager.isUserAllowedForPC(dn = (r = searchResults.get(0)).get("distinguishedName"), accountModel)) {
                if (unixMillis < Instant.now().toEpochMilli()) {
                    unixMillis = Instant.now().toEpochMilli();
                    logger.warn((Object)("unixMillis < Now fixing unixMillis=" + unixMillis + " PC: " + pc + ", login: " + accountModel.login));
                }
                if (unixMillis > maxExpireMillis) {
                    unixMillis = maxExpireMillis;
                    logger.warn((Object)("unixMillis > maxExpireMillis fixing unixMillis=" + unixMillis + " PC: " + pc + ", login: " + accountModel.login));
                }
                Long adExpire = (unixMillis / 1000L + 11644473600L) * 10000000L;
                if (unixMillis >= Instant.now().toEpochMilli() && unixMillis <= maxExpireMillis) {
                    if (forceToAllDC) {
                        if (r.containsKey("msLAPS-PasswordExpirationTime")) {
                            result = ldapHelper.modify(dn, "msLAPS-PasswordExpirationTime", (Object)adExpire.toString(), forceToAllDC);
                        }
                        if (r.containsKey("ms-Mcs-AdmPwdExpirationTime")) {
                            result = ldapHelper.modify(dn, "ms-Mcs-AdmPwdExpirationTime", (Object)adExpire.toString(), forceToAllDC);
                        }
                    } else {
                        if (r.containsKey("msLAPS-PasswordExpirationTime")) {
                            result = ldapHelper.modify(dn, "msLAPS-PasswordExpirationTime", (Object)adExpire.toString());
                        }
                        if (r.containsKey("ms-Mcs-AdmPwdExpirationTime")) {
                            result = ldapHelper.modify(dn, "ms-Mcs-AdmPwdExpirationTime", (Object)adExpire.toString());
                        }
                    }
                } else {
                    logger.error((Object)("SetExpire constraint error. PC: " + pc + ", login: " + accountModel.login + " unixmillis: " + String.valueOf(unixMillis) + " maxExpireMillis: " + String.valueOf(maxExpireMillis)));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("setExpire error for " + pc + " by " + accountModel.login), (Throwable)e);
        }
        return result;
    }

    public boolean isUserAllowedToLogin(String login) {
        boolean result;
        block7: {
            result = false;
            if (!login.matches(userRegex)) {
                logger.error((Object)("isUserAllowedToLogin not matched regex for login " + login));
                return result;
            }
            boolean isDisabled = LdapManager.isUserDisabledInAD(login);
            if (!isDisabled) break block7;
            logger.debug((Object)(String.valueOf(String.valueOf(login)) + " isDisabled= " + isDisabled));
            return false;
        }
        try {
            result = LdapManager.isUserAllowedToLAPS(login);
            if (!result) {
                result = BitLockerManager.getInstance().isUserAllowedToLogin(login);
                logger.debug((Object)("BitLockerManager.isUserAllowedToLogin(): " + result));
            }
            if (!result) {
                result = JiaManager.getInstance().isUserAllowedJIA(login);
                logger.debug((Object)("JiaManager.isUserAllowedJIA(): " + result));
            }
            if (!result) {
                result = ComputersManager.getInstance().isUserAllowedToLogin(login);
                logger.debug((Object)("ComputersManager.isUserAllowedToLogin(): " + result));
            }
        }
        catch (Exception e) {
            logger.error((Object)("isUserAllowedToLogin error " + login), (Throwable)e);
        }
        return result;
    }

    public static boolean isUserAllowedToLAPS(String login) {
        boolean result;
        block14: {
            result = false;
            try {
                if (!login.matches(userRegex)) {
                    logger.error((Object)("isUserAllowedToLogin not matched regex for login " + login));
                    return result;
                }
                HashMap<String, String> r = LdapManager.getUserAttributes(login);
                if (r == null) break block14;
                String distinguishedName = r.get("distinguishedName");
                String groups = r.get("memberOf");
                JSONArray jGroups = new JSONArray();
                if (groups != null) {
                    try {
                        jGroups = new JSONArray(groups);
                    }
                    catch (Exception e) {
                        jGroups.put((Object)groups);
                    }
                }
                int i = 0;
                while (i < jGroups.length()) {
                    String group = jGroups.getString(i);
                    for (HashMap<String, String> groupOU : lapsAccessMatrix.values()) {
                        if (!groupOU.containsKey(group.toLowerCase())) continue;
                        result = true;
                        break;
                    }
                    ++i;
                }
                if (!result && managedByAttribute != null && !managedByAttribute.isEmpty()) {
                    logger.debug((Object)(String.valueOf(login) + " not member of laps access group. lets try to find managed by PCs"));
                    String managedByFilter = "(&(" + managedByAttribute + "=" + distinguishedName + ")(objectClass=computer))";
                    String attribs = "distinguishedName,CN," + managedByAttribute;
                    ArrayList<HashMap<String, String>> managedPCSearchResults = LdapManager.search(managedByFilter, computerSearchBase, attribs, 1);
                    if (managedPCSearchResults.size() > 0) {
                        logger.debug((Object)("Found PC " + String.valueOf(managedPCSearchResults.size()) + "managed by " + login + "(" + distinguishedName + ")"));
                        result = true;
                    } else {
                        logger.debug((Object)"No directly manaded PC found, will try to find any pc which is managed by user's groups");
                        String pcManagedGroupFilter = "";
                        int i2 = 0;
                        while (i2 < jGroups.length()) {
                            String group = jGroups.getString(i2);
                            pcManagedGroupFilter = String.valueOf(pcManagedGroupFilter) + "(" + managedByAttribute + "=" + group + ")";
                            ++i2;
                        }
                        pcManagedGroupFilter = "(|" + pcManagedGroupFilter + ")";
                        pcManagedGroupFilter = "(&(objectClass=computer)" + pcManagedGroupFilter + ")";
                        attribs = "distinguishedName,cn";
                        String[] returningAttributes = attribs.split(",");
                        ArrayList<HashMap<String, String>> pcManagedGroupResult = LdapManager.search(pcManagedGroupFilter, computerSearchBase, attribs, 1);
                        if (pcManagedGroupResult.size() > 0) {
                            r = pcManagedGroupResult.get(0);
                            String pc = r.get("cn");
                            logger.debug((Object)("Found PC " + pc + " managed by group which exists in " + managedByAttribute + " attribute. Member " + login));
                            result = true;
                        } else {
                            logger.error((Object)("No LAPS access right for " + login));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("isUserAllowedToLogin " + login + " error"), (Throwable)e);
            }
        }
        return result;
    }

    public static JSONArray getUserGroups(String login) {
        JSONArray result = new JSONArray();
        try {
            result = (JSONArray)userGroupCache.get((Object)login);
        }
        catch (ExecutionException e) {
            logger.error((Object)("getUserGroups error " + login), (Throwable)e);
        }
        return result;
    }

    public static JSONArray getUserGroups(AccountModel accountModel) {
        JSONArray result = new JSONArray();
        try {
            result = (JSONArray)userGroupCache.get((Object)accountModel.getLogin());
        }
        catch (ExecutionException e) {
            logger.error((Object)("getUserGroups error " + accountModel.getLogin()), (Throwable)e);
        }
        return result;
    }

    public static JSONArray getUserGroupsFromAD(AccountModel accountModel) {
        if (accountModel.getExternal().booleanValue()) {
            return LdapManager.getUserGroupsFromAD(accountModel.getLogin());
        }
        return new JSONArray();
    }

    public static boolean isUserDisabledInAD(String login) {
        boolean isDisabled = false;
        try {
            String userAccountControlString;
            HashMap<String, String> r = LdapManager.getUserAttributes(login);
            if (r != null && (userAccountControlString = r.get("userAccountControl")) != null) {
                String groupsFromAD = r.get("memberOf");
                String userDN = r.get("distinguishedName");
                int userAccountControl = 0;
                int radix = 10;
                if (userAccountControlString.toLowerCase().startsWith("0x")) {
                    radix = 16;
                    userAccountControlString = userAccountControlString.substring(2, userAccountControlString.length());
                }
                if (userAccountControlString != null) {
                    userAccountControl = Integer.parseInt(userAccountControlString, radix);
                }
                isDisabled = (userAccountControl & 2) != 0;
            }
        }
        catch (Exception e) {
            logger.error((Object)("isUserDisabledInAD error for login " + login), (Throwable)e);
        }
        return isDisabled;
    }

    public static JSONArray getUserGroupsFromAD(String login) {
        JSONArray jGroups;
        block10: {
            jGroups = new JSONArray();
            if (!login.matches(userRegex)) {
                logger.error((Object)("getUserGroupsFromAD not matched regex for login " + login));
                return jGroups;
            }
            try {
                HashMap<String, String> r = LdapManager.getUserAttributes(login);
                if (r == null) break block10;
                String userAccountControlString = r.get("userAccountControl");
                String groupsFromAD = r.get("memberOf");
                String userDN = r.get("distinguishedName");
                int userAccountControl = 0;
                int radix = 10;
                if (userAccountControlString != null) {
                    boolean isDisabled;
                    if (userAccountControlString.toLowerCase().startsWith("0x")) {
                        radix = 16;
                        userAccountControlString = userAccountControlString.substring(2, userAccountControlString.length());
                    }
                    if (userAccountControlString != null) {
                        userAccountControl = Integer.parseInt(userAccountControlString, radix);
                    }
                    boolean bl = isDisabled = (userAccountControl & 2) != 0;
                    if (isDisabled) {
                        logger.debug((Object)("Return empty groups: " + login + "'s userAccountControl = " + userAccountControl + ". isDisabled=" + isDisabled));
                        return jGroups;
                    }
                }
                try {
                    if (groupsFromAD != null) {
                        jGroups = new JSONArray(groupsFromAD);
                    }
                }
                catch (Exception e) {
                    jGroups.put((Object)groupsFromAD);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to get groups for " + login));
                jGroups = null;
            }
        }
        return jGroups;
    }

    private static boolean isUserAllowedForPC(String pcDN, AccountModel accountModel) throws JSONException {
        boolean result;
        block13: {
            result = false;
            if (!accountModel.login.matches(userRegex)) {
                logger.error((Object)("isUserAllowedForPC not matched regex for login " + accountModel.login));
                return result;
            }
            if (accountModel.getExternal().booleanValue()) {
                try {
                    String userDN = LdapManager.getDNbyLogin(accountModel.login);
                    if (userDN == null) break block13;
                    JSONArray jGroups = LdapManager.getUserGroups(accountModel);
                    logger.debug((Object)("For login " + accountModel.login + " found " + jGroups.length() + " groups"));
                    int i = 0;
                    while (i < jGroups.length()) {
                        String group = jGroups.getString(i);
                        for (HashMap<String, String> groupOU : lapsAccessMatrix.values()) {
                            if (!groupOU.containsKey(group.toLowerCase())) continue;
                            String ou = groupOU.get(group.toLowerCase()).toLowerCase();
                            if (!pcDN.toLowerCase().endsWith(ou)) continue;
                            result = true;
                            break;
                        }
                        ++i;
                    }
                    if (result || managedByAttribute == null || managedByAttribute.isEmpty()) break block13;
                    String managedByFilter = "(&(objectClass=computer)(distinguishedName=" + pcDN + "))";
                    String attribs = "distinguishedName,CN," + managedByAttribute;
                    String[] returningAttributes = attribs.split(",");
                    ArrayList<HashMap<String, String>> pcResult = LdapManager.search(managedByFilter, computerSearchBase, attribs, 1);
                    if (pcResult.size() <= 0) break block13;
                    String managedByAttributeValue = pcResult.get(0).get(managedByAttribute);
                    if (managedByAttributeValue != null) {
                        if (managedByAttributeValue.toLowerCase().equals(userDN.toLowerCase())) {
                            logger.debug((Object)("Found PC " + pcDN + " managed by " + accountModel.login + " (" + managedByAttributeValue + ")"));
                            result = true;
                        } else {
                            String groupFilter = "(&(objectClass=group)(distinguishedName=" + managedByAttributeValue + ")(member=" + userDN + "))";
                            String groupAttribs = "distinguishedName,CN";
                            returningAttributes = groupAttribs.split(",");
                            ArrayList<HashMap<String, String>> groupSearchResults = LdapManager.search(groupFilter, groupSearchBase, groupAttribs, 1);
                            if (groupSearchResults.size() > 0) {
                                logger.debug((Object)("Found PC " + pcDN + " managed by " + managedByAttributeValue + " member: " + userDN + " " + accountModel.login));
                                result = true;
                            }
                        }
                        if (!result) {
                            logger.error((Object)("No access rights for " + pcDN + ": " + managedByAttribute + " = " + managedByAttributeValue + " user:" + accountModel.login));
                        }
                        break block13;
                    }
                    logger.error((Object)(String.valueOf(pcDN) + " " + managedByAttribute + " is null " + accountModel.login + "  not allowed"));
                }
                catch (Exception e) {
                    logger.error((Object)"isUserAllowedForPC error", (Throwable)e);
                }
            } else if (accountModel.getLogin().equals("admin")) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            idToGroup.put(id, config.getString("group").toLowerCase());
            HashMap<String, String> groupOU = new HashMap<String, String>();
            groupOU.put(config.getString("group").toLowerCase(), config.getString("ou").toLowerCase());
            lapsAccessMatrix.put(id, groupOU);
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        try {
            idToGroup.put(id, config.getString("group").toLowerCase());
            HashMap<String, String> groupOU = new HashMap<String, String>();
            groupOU.put(config.getString("group").toLowerCase(), config.getString("ou").toLowerCase());
            lapsAccessMatrix.put(id, groupOU);
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    @Override
    public void del(String id) {
        try {
            if (idToGroup.containsKey(id)) {
                String group = idToGroup.get(id);
                lapsAccessMatrix.remove(id);
                idToGroup.remove(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Ldap remove error", (Throwable)e);
        }
    }

    public static void exportLdap(String filePath, String searchBase) {
        String filter = "(objectclass=computer)";
        String[] returningAttributes = new String[]{"distinguishedName", "cn", "ms-Mcs-AdmPwd", "msLAPS-Password"};
        ldapHelper.exportAllPaged(filePath, searchBase, filter, returningAttributes);
    }

    public static int countManagedPC(String searchBase, int limit) {
        String filter = "(&(objectclass=computer)(|(ms-Mcs-AdmPwd=*)(msLAPS-Password=*)))";
        String[] returningAttributes = new String[]{"cn", "distinguishedName"};
        int result = -1;
        ArrayList results = ldapHelper.getAllPaged(searchBase, filter, returningAttributes);
        result = results.size();
        logger.debug((Object)("Managed computers at " + searchBase + " found: " + result));
        return result;
    }

    public static ILibrary getInstance() {
        return instance;
    }

    public static boolean checkUserPasswd(String login, String password) {
        boolean result = false;
        try {
            if (login.isEmpty() || password.isEmpty()) {
                result = false;
            } else {
                ldapHelper.checkPassword(login, password, userSearchString, userSearchBase);
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("checkUserPasswd " + login), (Throwable)e);
        }
        return result;
    }

    public static String changeBindUserPassword(String dn, String newPassword) {
        String result = null;
        logger.info((Object)("Changing " + dn + " password"));
        try {
            boolean isModified = ldapHelper.passwordChangeByDN(dn, password, newPassword);
            logger.info((Object)("Changing " + dn + " password: " + isModified));
            if (isModified) {
                result = password;
                password = newPassword;
                LdapManager.reinit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"changeBindUserPassword error", (Throwable)e);
        }
        return result;
    }

    public static boolean leaveOrDelUser(String login) {
        boolean leaveUser = true;
        if (!login.matches(userRegex)) {
            return false;
        }
        String filter = String.format(userSearchString, login);
        String attribs = "samAccountName";
        String[] returningAttributes = attribs.split(",");
        try {
            ArrayList searchResults = ldapHelper.search(userSearchBase, filter, returningAttributes, 1);
            leaveUser = searchResults.size() > 0;
        }
        catch (NamingException e) {
            logger.error((Object)("leaveOrDelUser " + login + " error: " + e.toString()));
        }
        return leaveUser;
    }

    @Override
    public int importFromFile(String filePath) {
        logger.debug((Object)("Start import from " + filePath));
        int count = 0;
        try {
            String[] values;
            InputStreamReader ir = new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8");
            CSVReader reader = new CSVReader((Reader)ir, ";".charAt(0));
            String type = LibraryManager.TYPE.GROUP_OU_MAPPING.toString();
            LibraryModel model = null;
            while ((values = reader.readNext()) != null) {
                try {
                    if (values.length != 3) continue;
                    String name = values[0];
                    String group = values[1];
                    String OU = values[2];
                    if (!OU.contains("=") || name.isEmpty() || group.isEmpty()) continue;
                    JSONObject config = new JSONObject();
                    config.put("ou", (Object)OU);
                    config.put("group", (Object)group);
                    long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                    QueryBuilder qb = DBManager.createDao(LibraryModel.class).queryBuilder();
                    qb.where().eq("name", (Object)new SelectArg((Object)name)).and().eq("type", (Object)new SelectArg((Object)type));
                    model = (LibraryModel)DBManager.createDao(LibraryModel.class).queryForFirst(qb.prepare());
                    if (model == null) {
                        model = new LibraryModel();
                        model.type = type;
                        model.name = name;
                        model.modified = changedDate;
                        model.config = config.toString();
                        DBManager.getDao((Object)model).create((Object)model);
                    } else {
                        model.version = model.version + 1;
                        model.modified = changedDate;
                        model.config = config.toString();
                        DBManager.getDao((Object)model).update((Object)model);
                    }
                    idToGroup.put(model.id.toString(), group.toLowerCase());
                    HashMap<String, String> groupOU = new HashMap<String, String>();
                    groupOU.put(group.toLowerCase(), OU.toLowerCase());
                    lapsAccessMatrix.put(model.id.toString(), groupOU);
                    ++count;
                }
                catch (Exception e) {
                    logger.error((Object)"CSV line process error", (Throwable)e);
                }
            }
            ir.close();
        }
        catch (Exception e) {
            logger.error((Object)"importFromFile error", (Throwable)e);
        }
        logger.debug((Object)("Imported from " + filePath + " count:" + count));
        return count;
    }

    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.WRONG_PASSWORD;
        if (LdapManager.checkUserPasswd(login, password)) {
            result = AuthManager.AUTHSTATUS.SUCCESS;
        }
        return result;
    }

    public static boolean changeUserPassword(String login, String oldPassword, String newPassword) {
        boolean isModified = ldapHelper.passwordChangeByLogin(login, userSearchString, userSearchBase, oldPassword, newPassword);
        return isModified;
    }

    public static boolean movePC(String oldDN, String newDN, AccountModel accountModel) throws LdapHelperException, JSONException {
        boolean result = false;
        if (!LdapManager.isUserAllowedForPC(oldDN, accountModel)) {
            LdapManager ldapManager = instance;
            ldapManager.getClass();
            throw ldapManager.new LdapHelperException("No access rights to PC");
        }
        if (!LdapManager.isUserAllowedForPC(newDN, accountModel)) {
            LdapManager ldapManager = instance;
            ldapManager.getClass();
            throw ldapManager.new LdapHelperException("No access to new OU ");
        }
        boolean isMoved = ldapHelper.rename(oldDN, newDN);
        return isMoved;
    }

    public static JSONObject getCompInfoRestricted(String pc, String allowedOU) {
        JSONObject result = new JSONObject();
        String filter = "(&(CN=" + pc + ")(objectClass=computer))";
        String attribs = "ms-Mcs-AdmPwd,ms-Mcs-AdmPwdExpirationTime,msLAPS-Password,msLAPS-PasswordExpirationTime,distinguishedName";
        String extraAttribs = SettingModel.get("laps_extra:extra_pc_attributes");
        if (extraAttribs != null && !extraAttribs.isEmpty()) {
            attribs = String.valueOf(attribs) + "," + extraAttribs.trim();
        }
        String[] returningAttributes = attribs.split(",");
        try {
            HashMap<String, String> r;
            ArrayList<HashMap<String, String>> searchResults;
            if (!pc.matches(pcRegex) || allowedOU == null) {
                result.put("password", (Object)"PC not mathced regex [a-zA-Z0-9_-]+");
                result.put("error", (Object)"PC not mathced regex [a-zA-Z0-9_-]+");
            }
            if ((searchResults = LdapManager.search(filter, computerSearchBase, attribs, 1)).size() > 0 && (r = searchResults.get(0)).containsKey("ms-Mcs-AdmPwd")) {
                String pcDN = r.get("distinguishedName");
                result.put("dn", (Object)pcDN);
                if (!pcDN.toLowerCase().endsWith(allowedOU.toLowerCase())) {
                    result.put("password", (Object)"No access rights");
                    result.put("error", (Object)"No access rights");
                } else {
                    result.put("password", (Object)LdapManager.decryptPassword(r.get("ms-Mcs-AdmPwd")));
                    if (extraAttribs != null && !extraAttribs.isEmpty()) {
                        String[] extraAttribesArray;
                        String[] stringArray = extraAttribesArray = extraAttribs.trim().split(",");
                        int n = extraAttribesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String e = stringArray[n2];
                            if (r.containsKey(e)) {
                                result.put("e", (Object)r.get(e));
                            }
                            ++n2;
                        }
                    }
                    Long expire = Long.parseLong(r.get("ms-Mcs-AdmPwdExpirationTime"));
                    expire = expire / 10000000L - 11644473600L;
                    result.put("expire", (Object)expire);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getCompInfoRestricted error pc:" + pc), (Throwable)e);
            try {
                result.put("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Set<String> getUserPortalRoles(AccountModel model) {
        ArrayList<String> oldRoles;
        JSONArray groups = LdapManager.getUserGroups(model);
        HashSet<String> roles = new HashSet<String>();
        if (LdapManager.isUserAllowedToLAPS(model.getLogin())) {
            roles.add(AuthFilter.ROLE.LAPSUSER.name());
        }
        if (BitLockerManager.getInstance().isUserAllowedToLogin(model.getLogin())) {
            roles.add(AuthFilter.ROLE.LAPSUSER.name());
        }
        if (!roles.contains("JIAUSER") && JiaManager.getInstance().getUserRoles(model).size() > 0) {
            roles.add(AuthFilter.ROLE.JIAUSER.name());
        }
        if (ComputersManager.getInstance().isUserAllowedToLogin(model.getLogin())) {
            roles.add(AuthFilter.ROLE.LAPSUSER.name());
        }
        if ((oldRoles = model.getRolesArray()).contains(AuthFilter.ROLE.ADMIN.name())) {
            roles.add(AuthFilter.ROLE.ADMIN.name());
        }
        if (oldRoles.contains(AuthFilter.ROLE.USERMANAGEMENT.name())) {
            roles.add(AuthFilter.ROLE.USERMANAGEMENT.name());
        }
        return roles;
    }

    public static HashMap<String, String> getUserAttributes(String login) {
        HashMap result = new HashMap();
        try {
            result = (HashMap)userAtributeCache.get((Object)login);
        }
        catch (ExecutionException e) {
            logger.error((Object)("getUserGroups error " + login), (Throwable)e);
        }
        return result;
    }

    private static HashMap<String, String> getUserAttributesFromAD(String login) {
        HashMap result = new HashMap();
        if (!login.matches(userRegex)) {
            logger.error((Object)("getUserGroupsFromAD not matched regex for login " + login));
            return result;
        }
        try {
            String filter = String.format(userSearchString, login);
            String attribs = "samAccountName,memberOf,CN,userAccountControl,distinguishedName,mail";
            String[] returningAttributes = attribs.split(",");
            ArrayList searchResults = ldapHelper.search(userSearchBase, filter, returningAttributes, 1);
            logger.debug((Object)("Filter:" + filter + " base:" + userSearchBase + " returned " + searchResults.size() + " records"));
            if (searchResults.size() > 0) {
                result = (HashMap)searchResults.get(0);
                logger.debug((Object)("Filter:" + filter + " returned following object: " + result.toString()));
                String userAccountControlString = (String)result.get("userAccountControl");
                int userAccountControl = 0;
                int radix = 10;
                if (userAccountControlString != null) {
                    boolean isDisabled;
                    if (userAccountControlString.toLowerCase().startsWith("0x")) {
                        radix = 16;
                        userAccountControlString = userAccountControlString.substring(2, userAccountControlString.length());
                    }
                    if (userAccountControlString != null) {
                        userAccountControl = Integer.parseInt(userAccountControlString, radix);
                    }
                    boolean bl = isDisabled = (userAccountControl & 2) != 0;
                    if (isDisabled) {
                        logger.debug((Object)(String.valueOf(String.valueOf(login)) + "'s userAccountControl = " + userAccountControl + ". isDisabled=" + isDisabled));
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get DN for login " + login), (Throwable)e);
            result = null;
        }
        return result;
    }

    public static String getDNbyLogin(String login) {
        String distinguishedName = null;
        try {
            HashMap<String, String> r = LdapManager.getUserAttributes(login);
            if (r != null && r.containsKey("distinguishedName")) {
                distinguishedName = r.get("distinguishedName");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get DN for login " + login), (Throwable)e);
        }
        return distinguishedName;
    }

    public static boolean addUserToGroup(String login, String groupDN, boolean applyToAllDC) {
        boolean result = false;
        String userDN = LdapManager.getDNbyLogin(login);
        if (userDN != null) {
            result = ldapHelper.addUserToGroup(userDN, groupDN, applyToAllDC);
            logger.debug((Object)("User " + login + " add to group " + groupDN + " result: " + result));
        } else {
            logger.error((Object)("User " + login + " DN not found"));
        }
        return result;
    }

    public static boolean removeUserFromGroup(String login, String groupDN, boolean applyToAllDC) {
        boolean result = false;
        String userDN = LdapManager.getDNbyLogin(login);
        if (userDN != null) {
            result = ldapHelper.removeUserFromGroup(userDN, groupDN, applyToAllDC);
            logger.debug((Object)("User " + login + " remove from group " + groupDN + " result: " + result));
        } else {
            logger.error((Object)("User " + login + " DN not found"));
        }
        return result;
    }

    public class LdapHelperException
    extends Exception {
        public LdapHelperException(String message) {
            super(message);
        }
    }
}

