/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.APITokenManager;
import com.ksoft.laps.core.AdmPWDKeyManager;
import com.ksoft.laps.core.BitLockerManager;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.JiaManager;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.computers.ComputersGroupsManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.core.computers.LocalPCPolicyManager;
import com.ksoft.laps.db.LibraryModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LibraryManager {
    static Logger logger = Logger.getLogger((String)LibraryManager.class.getName());

    public static void create(String type, String id, String name, JSONObject config) {
        ILibrary manager = LibraryManager.getManager(type);
        if (manager != null) {
            manager.add(id, name, config);
        }
    }

    public static synchronized void update(String type, String id, String name, JSONObject config) {
        ILibrary manager = LibraryManager.getManager(type);
        if (manager != null) {
            manager.update(id, name, config);
        }
    }

    public static void del(String type, String id) {
        ILibrary manager = LibraryManager.getManager(type);
        if (manager != null) {
            manager.del(id);
        }
    }

    public static void del(String type, String[] ids) {
        ILibrary manager = LibraryManager.getManager(type);
        if (manager != null) {
            manager.del(ids);
        }
    }

    public static void reload(String type, String id) {
        try {
            ILibrary manager = LibraryManager.getManager(type);
            if (manager != null) {
                manager.del(id);
                QueryBuilder qb = DBManager.getDao(LibraryModel.class).queryBuilder();
                qb.where().eq("type", (Object)new SelectArg((Object)type)).and().eq("id", (Object)new SelectArg((Object)id)).and().eq("enabled", (Object)true);
                LibraryModel model = (LibraryModel)DBManager.getDao(LibraryModel.class).queryForFirst(qb.prepare());
                if (model != null) {
                    JSONObject jConfig = model.getConfigJSON();
                    JSONObject processedJSON = LibraryManager.processJSON(type, jConfig);
                    if (processedJSON != null) {
                        manager.add(model.id.toString(), model.name, jConfig);
                        logger.debug((Object)("Library element " + type + " " + model.name + "(" + id + ") updated"));
                    }
                } else {
                    logger.error((Object)("Library element " + type + " " + id + " not found"));
                }
            } else {
                logger.error((Object)("Library type not found " + type));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to reload " + type + " " + id), (Throwable)e);
        }
    }

    public static ILibrary getManager(String type) {
        ILibrary manager = null;
        TYPE elementType = TYPE.valueOf(type.toUpperCase());
        switch (elementType) {
            case GROUP_OU_MAPPING: {
                manager = LdapManager.getInstance();
                break;
            }
            case BITLOCKER_MAPPING: {
                manager = BitLockerManager.getInstance();
                break;
            }
            case JIA_MAPPING: {
                manager = JiaManager.getInstance();
                break;
            }
            case LAPSEKEY: {
                manager = AdmPWDKeyManager.getInstance();
                break;
            }
            case APITOKEN: {
                manager = APITokenManager.getInstance();
                break;
            }
            case GROUP_LOCALPC_MAPPING: {
                manager = ComputersManager.getInstance();
                break;
            }
            case LOCALPC_POLICY: {
                manager = LocalPCPolicyManager.getInstance();
                break;
            }
            case COMPUTERS_GROUP: {
                manager = ComputersGroupsManager.getInstance();
            }
        }
        return manager;
    }

    public static void init() {
        TYPE[] tYPEArray = TYPE.values();
        int n = tYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            TYPE elementType = tYPEArray[n2];
            logger.debug((Object)("Starting init of " + (Object)((Object)elementType)));
            LibraryManager.initType(elementType.toString());
            logger.debug((Object)("Init of " + (Object)((Object)elementType) + " completed"));
            ++n2;
        }
    }

    private static void initType(String type) {
        ILibrary manager = LibraryManager.getManager(type);
        try {
            QueryBuilder qb = DBManager.getDao(LibraryModel.class).queryBuilder();
            SelectArg selectArg = new SelectArg();
            selectArg.setValue((Object)type);
            qb.where().eq("type", (Object)selectArg).and().eq("enabled", (Object)true);
            List models = DBManager.getDao(LibraryModel.class).query(qb.prepare());
            String modelName = "";
            int i = 0;
            while (i < models.size()) {
                try {
                    LibraryModel model = (LibraryModel)models.get(i);
                    modelName = model.name;
                    JSONObject jConfig = model.getConfigJSON();
                    JSONObject processedJSON = LibraryManager.processJSON(type, jConfig);
                    if (processedJSON != null) {
                        manager.add(model.id.toString(), model.name, jConfig);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("unable to init model " + modelName), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error ", (Throwable)ex);
        }
    }

    private static JSONObject processJSON(String type, JSONObject json) throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        JSONObject jsonResult = null;
        TYPE elementType = TYPE.valueOf(type.toUpperCase());
        switch (elementType) {
            case GROUP_OU_MAPPING: {
                jsonResult = json;
                break;
            }
            default: {
                jsonResult = json;
            }
        }
        return jsonResult;
    }

    public static enum TYPE {
        GROUP_OU_MAPPING("group_ou_mapping"),
        APITOKEN("apitoken"),
        JIA_MAPPING("jia_mapping"),
        BITLOCKER_MAPPING("bitlocker_mapping"),
        GROUP_LOCALPC_MAPPING("group_localpc_mapping"),
        LOCALPC_POLICY("localpc_policy"),
        COMPUTERS_GROUP("computers_group"),
        LAPSEKEY("lapsekey");

        private final String value;

        private TYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

