/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.tls.TlsHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LicenseManager {
    static Logger logger = Logger.getLogger((String)LicenseManager.class.getName());
    static CommandLine commandLine;
    JSONObject license = new JSONObject();
    private String pubKeyString = "";
    private PublicKey pubKey;
    private static String algorithm;
    private int licensedPCcount = -1;
    private int actualManagedPCCount = -1;
    private LocalDateTime expires = LocalDateTime.now();
    private boolean isValid = false;
    private String licenseFile = "";
    private String errorMessage = "";

    static {
        algorithm = "SHA256WithRSA";
    }

    public JSONObject getLicenseInfo() {
        return this.license;
    }

    public void init() throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.pubKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqvf63fWNUe5kUEmLuF5ST9X5IG23RuffwDYn1I2MyOQWkxFD48/eeM8tY/+mkKQeFlnziTcDDhSU7CGjPLnEn92fclO9EyQW/hGObE8kR5DMTdWLITqaQ1BONIQf6nE5l1R+AhbKxIZ2dM0P+M/YHSAa3pt+beZxuaoPTya9h14gkWwTthD+wnM+SY22cajz5Ddt+f22zrG4ghhD/wz8DHNSjNZY0CHJBZrA8F++ELWDnePRK48vP8Hxbj9+7rVQWuo/5Y8XtESk8FjDvVSPNM8H0hyg6DNmtSZr3l+HWThYQpTmcLEDpWy778GgjX6RR7CRlgUNKrDS/OLTsZGZxwIDAQAB";
        this.pubKey = TlsHelper.publicKeyFromBase64String((String)this.pubKeyString, (String)"RSA");
    }

    public void init(String pubKeyString) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.pubKeyString = pubKeyString;
        this.pubKey = TlsHelper.publicKeyFromBase64String((String)pubKeyString, (String)"RSA");
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException, InvalidKeySpecException, JSONException, SignatureException {
        LicenseManager manager = new LicenseManager();
        if (args.length > 0) {
            commandLine = LicenseManager.initCommandLine(args);
            if (commandLine == null) {
                return;
            }
            String[] params = null;
            if (commandLine.hasOption("sign")) {
                params = commandLine.getOptionValues("sign");
                String toSignFile = params[0];
                String privKeyFile = params[1];
                File file = new File(privKeyFile);
                FileInputStream fis = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                fis.read(data);
                fis.close();
                String privKeyString = new String(data);
                PrivateKey privKey = TlsHelper.privateKeyFromBase64String((String)privKeyString, (String)"RSA");
                file = new File(toSignFile);
                fis = new FileInputStream(file);
                byte[] data2 = new byte[(int)file.length()];
                fis.read(data2);
                fis.close();
                String toSign = new String(data2);
                JSONObject json = new JSONObject(toSign);
                String fOut = String.valueOf(toSignFile.replace("evaluation.txt", "")) + json.getString("org").replace(" ", "") + ".lic";
                LicenseManager.signAndSaveLicense(json, privKey, fOut);
                System.out.println("Signed license saved to " + fOut);
            } else if (commandLine.hasOption("check")) {
                params = commandLine.getOptionValues("check");
                byte[] encoded = Files.readAllBytes(Paths.get(params[1], new String[0]));
                String pubKeyString = new String(encoded);
                manager.init(pubKeyString);
                String licFile = params[0];
                boolean result = manager.loadLicense(licFile);
                System.out.println("license validation " + result);
            }
        }
    }

    private static void signAndSaveLicense(JSONObject licenseData, PrivateKey privateKey, String fileOut) throws JSONException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, FileNotFoundException {
        String norm = LicenseManager.normalizeParams(licenseData);
        Signature sig = Signature.getInstance(algorithm);
        sig.initSign(privateKey);
        sig.update(norm.getBytes());
        byte[] signBytes = sig.sign();
        byte[] base64Signature = Base64.encodeBase64((byte[])signBytes);
        String signature = new String(base64Signature);
        JSONObject json = new JSONObject();
        json.put("license", (Object)licenseData);
        json.put("signature", (Object)signature);
        Throwable throwable = null;
        Object var10_11 = null;
        try (PrintWriter out = new PrintWriter(fileOut);){
            out.println(json.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isLicenseValid() {
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(this.expires)) {
            logger.error((Object)("License expires! current time: " + now.toString() + " license valid till: " + this.expires.toString()));
            this.isValid = false;
            this.errorMessage = "License expires! current time: " + now.toString() + " license valid till: " + this.expires.toString();
        }
        if ((double)this.licensedPCcount * 1.015 < (double)this.actualManagedPCCount) {
            logger.error((Object)("License overusage detected: Licensed PC " + this.licensedPCcount + " managedPC " + this.actualManagedPCCount));
            if (!this.errorMessage.isEmpty()) {
                this.errorMessage = String.valueOf(this.errorMessage) + "\r\n";
            }
            this.errorMessage = String.valueOf(this.errorMessage) + "Managed PC count > licensed (" + this.actualManagedPCCount + ">" + this.licensedPCcount + ")";
            this.isValid = false;
        }
        if (this.isValid) {
            this.errorMessage = "";
        }
        return this.isValid;
    }

    public void setLicenseFile(String fileName) {
        this.licenseFile = fileName;
    }

    public boolean loadLicense() {
        return this.loadLicense(this.licenseFile);
    }

    public boolean loadLicense(String fileName) {
        boolean result = false;
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(fileName, new String[0]));
            String decoded = new String(encoded);
            JSONObject json = new JSONObject(decoded);
            JSONObject licParams = json.getJSONObject("license");
            String signature = json.getString("signature");
            String norm = LicenseManager.normalizeParams(licParams);
            result = this.validateSignature(norm, signature);
            if (result) {
                logger.info((Object)("License signature is ok. License details: " + licParams.toString()));
                this.license = licParams;
                this.licensedPCcount = licParams.getInt("elements");
                String exp = licParams.getString("expires");
                String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT, Locale.ENGLISH);
                this.expires = LocalDateTime.parse(exp, dateFormatter);
                LocalDateTime now = LocalDateTime.now();
                if (now.isBefore(this.expires)) {
                    this.isValid = true;
                } else {
                    logger.error((Object)("License expires! Now: " + now + " license is valid till " + this.expires));
                }
            } else {
                this.isValid = false;
                logger.error((Object)"License not valid: wro");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Load license error " + fileName));
        }
        return result;
    }

    private boolean validateSignature(String params, String signature) {
        boolean result = false;
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(this.pubKey);
            sig.update(params.getBytes());
            byte[] signDecoded = Base64.decodeBase64((String)signature);
            result = sig.verify(signDecoded);
        }
        catch (Exception e) {
            logger.error((Object)"License validation error!", (Throwable)e);
        }
        return result;
    }

    private static String normalizeParams(JSONObject jObject) throws JSONException {
        String result = null;
        ArrayList<String> keysList = new ArrayList<String>();
        Iterator keys = jObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            keysList.add(key);
        }
        keysList.sort(null);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < keysList.size()) {
            String key = (String)keysList.get(i);
            sb.append(key).append("=").append(jObject.getString(key)).append(";");
            ++i;
        }
        result = sb.toString();
        return result;
    }

    private static CommandLine initCommandLine(String[] args) {
        CommandLine line = null;
        Options options = new Options();
        options.addOption("help", "print help");
        options.addOption(Option.builder((String)"sign").hasArgs().numberOfArgs(2).desc("sign license").argName("filein> <privatekey>").build());
        options.addOption(Option.builder((String)"check").hasArgs().numberOfArgs(2).desc("check license").argName("licensefile> <publicKey>").build());
        try {
            Object params = null;
            DefaultParser parser = new DefaultParser();
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("LicenseManager", options);
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("LicenseManager", options);
        }
        return line;
    }

    public int getLicensedPCCount() {
        return this.licensedPCcount;
    }

    public void setActualManagedPCcount(int pcCount) {
        this.actualManagedPCCount = pcCount;
    }

    public String getLicenseError() {
        return this.errorMessage;
    }
}

