/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.github.cage.Cage;
import com.github.cage.GCage;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAccountModel;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.AbstractWorker;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.SecretManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.laps.db.UserProfileModel;
import com.ksoft.tls.TlsHelper;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileManager
extends AbstractWorker {
    private static final Cage cage = new GCage();
    static Logger logger = Logger.getLogger((String)MobileManager.class.getName());
    boolean isCloudReaderRunning = false;
    ScheduledExecutorService cloudExecService;
    private String pushURL;
    private String fromServerURL;
    private String fromDeviceURL;
    private String enrollDeviceURL;
    private String apiOrg;
    private String apiKey;
    private Long lastRunTimeMilli = 0L;
    private int cloudReaderInterval = 2;
    private int iterationCount = 1000;
    private int keySize = 128;
    private static SecureRandom random = new SecureRandom();
    private static Thread cloudReaderThread;
    private boolean isPoolingMode = false;
    private int allowedClockDifference = 60;
    private int allowedPushAuthWaitInterval = 120;
    static MobileManager instance;

    static {
        instance = new MobileManager();
    }

    public void initWebHookMode(String publishedUrl, String pushUrl, String apiOrg, String apiKey) {
        this.isPoolingMode = false;
        this.apiKey = apiKey;
        this.apiOrg = apiOrg;
        if (this.isRunning()) {
            this.stop();
        }
        if (!publishedUrl.endsWith("/")) {
            publishedUrl = String.valueOf(publishedUrl) + "/";
        }
        if (!pushUrl.endsWith("/")) {
            pushUrl = String.valueOf(pushUrl) + "/";
        }
        this.fromDeviceURL = publishedUrl;
        this.pushURL = String.valueOf(pushUrl) + "push";
    }

    public void initPullMode(String apiURL, String apiOrg, String apiKey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String url;
        this.isPoolingMode = true;
        if (this.isRunning()) {
            this.stop();
        }
        if (!(url = apiURL).endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        this.pushURL = String.valueOf(url) + "push";
        this.fromServerURL = String.valueOf(url) + "fromserver";
        this.fromDeviceURL = url;
        this.enrollDeviceURL = String.valueOf(url) + "enroll/fromserver";
        this.apiKey = apiKey;
        this.apiOrg = apiOrg;
        this.startReadThread();
    }

    private void startReadThread() {
        this.stop();
        if (cloudReaderThread != null) {
            cloudReaderThread.interrupt();
        }
        this.isPoolingMode = true;
        cloudReaderThread = new Thread((Runnable)this, "MobileManagerCloudReader");
        cloudReaderThread.start();
    }

    public static MobileManager getInstance() {
        return instance;
    }

    public boolean ifSessionValidForUser(String sessionId, String user) {
        boolean result = false;
        String _user = ClusterManager.get(sessionId);
        result = _user != null && _user.equals(user);
        return result;
    }

    public boolean sendPush(String login, String title, String text, JSONObject payload) throws JSONException, KeyManagementException, NoSuchAlgorithmException {
        boolean result = false;
        try {
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            if (accountModel != null) {
                JSONObject profile = accountModel.getFullProfileJSON();
                if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                    JSONObject mobileConf = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
                    String fcmToken = mobileConf.getString("fcmToken");
                    result = this.sendPush(fcmToken, login, title, text, payload);
                }
            } else {
                logger.error((Object)"Unable to find account model");
            }
        }
        catch (Exception e) {
            logger.error((Object)("sendPush to " + login + " error"), (Throwable)e);
        }
        return result;
    }

    public boolean sendPush(String fcmToken, String login, String title, String text, JSONObject payload) throws JSONException, KeyManagementException, NoSuchAlgorithmException {
        boolean result = false;
        Response responseEntity = null;
        JSONObject json = new JSONObject();
        json.put("from", (Object)this.apiKey);
        json.put("to", (Object)fcmToken);
        if (title != null) {
            json.put("title", (Object)title);
        }
        if (text != null) {
            json.put("text", (Object)text);
        }
        if (payload != null) {
            json.put("payload", (Object)payload);
        }
        boolean useProxy = SettingModel.getBool("mobile:use_proxy");
        boolean doTlsCheck = SettingModel.getBool("mobile:do_cert_check");
        Client client = TlsHelper.getTlsClient((boolean)doTlsCheck, (boolean)useProxy);
        responseEntity = client.target(this.pushURL).request().post(Entity.entity((Object)json.toString(), (String)"application/json"));
        String resp = (String)responseEntity.readEntity(String.class);
        if (responseEntity.getStatus() == 200) {
            result = true;
            logger.info((Object)("Push sent to " + login + " Title: " + title + " Text: " + text));
        } else {
            result = false;
            logger.info((Object)("Unable to sent push to " + login + " Title: " + title + " Text: " + text + " Response code " + responseEntity.getStatus() + ". Content: " + resp));
        }
        return result;
    }

    public String sendAuthPush(String fcmToken, String login, String ip) throws KeyManagementException, NoSuchAlgorithmException, JSONException {
        String session = UUID.randomUUID().toString();
        JSONObject payload = new JSONObject();
        payload.put("session", (Object)this.encrypt(login, session));
        payload.put("type", (Object)"auth_confirm");
        boolean isPushSent = this.sendPush(fcmToken, login, "LAPS authentication", "User: " + login + " IP:" + ip, payload);
        if (isPushSent) {
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            this.putToCache("push_auth:" + session, String.valueOf(login) + ":" + ip + ":" + now, true);
            logger.debug((Object)("Push auth request sent. Login " + login + " IP:" + ip));
        } else {
            logger.error((Object)("Unable to send push auth request sent. Login " + login + " IP:" + ip));
        }
        return session;
    }

    private void readFromCloud() {
        try {
            Response responseEntity = null;
            JSONObject json = new JSONObject();
            json.put("from", (Object)this.apiKey);
            boolean useProxy = SettingModel.getBool("mobile:use_proxy");
            boolean doTlsCheck = SettingModel.getBool("mobile:do_cert_check");
            Client client = TlsHelper.getTlsClient((boolean)doTlsCheck, (boolean)useProxy);
            responseEntity = client.target(this.fromServerURL).request().post(Entity.entity((Object)json.toString(), (String)"application/json"));
            String resp = (String)responseEntity.readEntity(String.class);
            if (responseEntity.getStatus() == 200) {
                JSONObject jresp = new JSONObject(resp);
                if (jresp.has("messages")) {
                    JSONObject messages = jresp.getJSONObject("messages");
                    Iterator keys = messages.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JSONObject message = messages.getJSONObject(key);
                        this.processIncomingCloudMessage(message, null);
                    }
                }
            } else {
                logger.error((Object)("Unable readFromCloud. Response code " + responseEntity.getStatus() + ". Content: " + resp));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Read from cloud error", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public JSONObject processIncomingCloudMessage(JSONObject message, String source_ip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 12] lbl93 : CaseStatement: default:\u000a, @NONE, blocks:[0, 12] lbl93 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JSONObject processSecretsRequest(String from, JSONObject payload, String source_ip) {
        String login = "N/A";
        JSONObject result = new JSONObject();
        Integer timeout = SettingModel.getInt("laps_extra:laps_access_timeout");
        try {
            login = payload.getString("login");
            String pc = payload.getString("pc");
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            SecretManager secretManager = SecretManager.getInstance();
            try {
                JSONArray allSecrets = secretManager.getAllSecrets(accountModel, source_ip, pc);
                int i = 0;
                while (i < allSecrets.length()) {
                    JSONObject element = allSecrets.getJSONObject(i);
                    if (element.has("password")) {
                        String password = element.getString("password");
                        String encryptedPassword = this.encrypt(login, password);
                        element.put("password", (Object)encryptedPassword);
                        if (element.has("other_passwords")) {
                            JSONArray otherPasswords = element.getJSONArray("other_passwords");
                            JSONArray otherPasswordsEnc = new JSONArray();
                            int j = 0;
                            while (j < otherPasswords.length()) {
                                String other_password = this.encrypt(login, otherPasswords.getString(j));
                                otherPasswordsEnc.put((Object)other_password);
                                ++j;
                            }
                            element.put("other_passwords", (Object)otherPasswordsEnc);
                        }
                        if (element.has("oldpassword")) {
                            String oldpassword = element.getString("oldpassword");
                            String encryptedoldpasswordPassword = this.encrypt(login, oldpassword);
                            element.put("oldpassword", (Object)encryptedoldpasswordPassword);
                        }
                        if (element.has("temppassword")) {
                            String temppassword = element.getString("temppassword");
                            String encryptedtemppasswordpasswordPassword = this.encrypt(login, temppassword);
                            element.put("temppassword", (Object)encryptedtemppasswordpasswordPassword);
                        }
                        allSecrets.put(i, (Object)element);
                    }
                    ++i;
                }
                if (allSecrets != null) {
                    result.put("secrets", (Object)allSecrets);
                }
            }
            catch (Exception e) {
                logger.error((Object)"processSecretsRequest error", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"processSecretsRequest error", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AUTH_STATUS authByPassword(String from, JSONObject payload, String sourceIp) {
        AUTH_STATUS result = AUTH_STATUS.ERROR;
        String login = "N/A";
        try {
            AccountModel model;
            login = payload.getString("login").toLowerCase();
            String password = payload.getString("password");
            String otp = payload.getString("otp");
            String device = payload.getString("device");
            String iv = payload.getString("iv");
            String salt = payload.getString("salt");
            String cypherkey = payload.getString("cypherkey");
            String enteredCapcha = payload.optString("capcha", null);
            String capchaUUID = payload.optString("capcha_uuid", null);
            String lockoutKey = "auth_lockout:" + login;
            Long lockoutTime = ClusterManager.getLong(lockoutKey);
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            if (lockoutTime != null) {
                long diff = now - lockoutTime;
                if (diff < (long)SettingModel.getInt("auth:lockout_duration").intValue()) {
                    result = AUTH_STATUS.LOCKOUT_TIMEOUT;
                    LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, sourceIp, login, "", "", "Account locked, wait " + diff + " for unlocking");
                    return result;
                }
                ClusterManager.remove(lockoutKey, true);
            }
            if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:capcha_count")) {
                if (enteredCapcha == null) {
                    result = AUTH_STATUS.CAPCHA_REQUIRED;
                    logger.debug((Object)("Capcha required for  " + login));
                    LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, sourceIp, login, "", "", "Capcha required");
                    return result;
                }
                String capchaKey = "capcha:" + login + ":" + capchaUUID;
                String capchaOriginal = ClusterManager.get(capchaKey);
                if (capchaOriginal != null && enteredCapcha.toLowerCase().equals(capchaOriginal.toLowerCase())) {
                    logger.debug((Object)("Capcha is OK for " + login));
                    ClusterManager.remove(capchaKey, true);
                } else {
                    result = AUTH_STATUS.WRONG_CAPCHA;
                    LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, sourceIp, login, "", "", "Wrong capcha");
                    logger.debug((Object)("Wrong capcha for " + login));
                    return result;
                }
            }
            if ((model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login)) == null) return AUTH_STATUS.WRONG_PASSWORD;
            if (model.getExternal().booleanValue() || model.getEnabled().booleanValue() && LapsLauncher.debugMobile) {
                JSONObject mobileProfile = this.getMobileProfile(login);
                if (mobileProfile != null) return AUTH_STATUS.DEVICE_ALREADY_REGISTERED;
                AuthManager.AUTHSTATUS authResult = CoreEngine.getInstance().getAuthManager().authExisting((IAccountModel)model, password, otp, sourceIp);
                if (authResult.equals((Object)AuthManager.AUTHSTATUS.SUCCESS)) {
                    result = AUTH_STATUS.OK;
                    JSONObject profileJSON = new JSONObject();
                    profileJSON.put("iv", (Object)iv);
                    profileJSON.put("salt", (Object)salt);
                    profileJSON.put("key", (Object)SettingModel.encrypt(cypherkey));
                    profileJSON.put("fcmToken", (Object)from);
                    profileJSON.put("device", (Object)payload.getJSONObject("device"));
                    model.modifyProfile("set", UserProfileModel.CATEGORY.MOBILE.toString(), profileJSON.toString());
                    this.deleteFailCountPerLogin(login);
                    ClusterManager.remove(lockoutKey, true);
                }
                if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:lockout_threshold")) {
                    ClusterManager.putToCache(lockoutKey, String.valueOf(now), true);
                    result = AUTH_STATUS.LOCKOUT_TIMEOUT;
                }
                if (authResult.equals((Object)AuthManager.AUTHSTATUS.WRONG_PASSWORD)) {
                    this.increaseFailCount(login);
                    return AUTH_STATUS.WRONG_PASSWORD;
                }
                if (!authResult.equals((Object)AuthManager.AUTHSTATUS.WRONG_OTP)) return result;
                this.increaseFailCount(login);
                return AUTH_STATUS.WRONG_OTP;
            }
            result = AUTH_STATUS.NOT_ALLOWED;
            logger.error((Object)("Auth error for " + login + " user is not external or not allowed to login"));
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("processDeviceRegistrationByPasswordResponse for " + login), (Throwable)e);
        }
        return result;
    }

    private JSONObject updateDeviceToken(String from, JSONObject payload, String source_ip) {
        JSONObject pushJson = new JSONObject();
        String login = "N/A";
        try {
            pushJson.put("type", (Object)"update_token");
            String xAuth = payload.getString("X-Auth");
            String newFcmToken = payload.getString("new_token");
            String[] xAuthData = xAuth.split("::");
            login = xAuthData[0];
            String encrypted = xAuthData[1];
            String decrypted = this.decryptValue(login, encrypted);
            String[] decData = decrypted.split("::");
            String gotLogin = decData[0];
            JSONObject gotDevice = new JSONObject(decData[1]);
            Long ts = Long.parseLong(decData[2]);
            JSONObject mobileProfile = this.getMobileProfile(login);
            boolean loginChecked = false;
            boolean tsChecked = false;
            boolean profileChecked = false;
            if (mobileProfile != null) {
                if (!login.equals(gotLogin)) {
                    logger.error((Object)("Logins are different! " + gotLogin + " " + login));
                    pushJson.put("error", (Object)"Logins are different");
                } else {
                    loginChecked = true;
                }
                long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                if (Math.abs(now - ts) >= (long)this.allowedClockDifference) {
                    logger.error((Object)("authenticate fail for " + login + " current time " + now + " timestamp from request: " + ts));
                    pushJson.put("error", (Object)("authenticate fail for " + login + " current time " + now + " timestamp from request: " + ts));
                } else {
                    tsChecked = true;
                }
                JSONObject storedDevice = mobileProfile.getJSONObject("device");
                Iterator iter = storedDevice.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String storedValue = storedDevice.getString(key);
                    String gotValue = gotDevice.getString(key);
                    if (key.equals("fcmToken") || storedValue.equals(gotValue)) continue;
                    logger.error((Object)("Device profile is different: " + login + " "));
                    pushJson.put("error", (Object)"Device profile changed");
                }
                profileChecked = true;
                if (loginChecked && tsChecked && profileChecked) {
                    AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
                    mobileProfile.put("fcmToken", (Object)newFcmToken);
                    model.modifyProfile("set", UserProfileModel.CATEGORY.MOBILE.toString(), mobileProfile.toString());
                    pushJson.put("status", (Object)"token updated");
                    LogModel.register(LogModel.EVENT_TYPE.DEVICE_TOKEN_UPDATED, source_ip, model.login.toLowerCase(), "", "", "FCM token updated");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to update device token login: " + login + " data: " + payload.toString()), (Throwable)e);
        }
        return pushJson;
    }

    private JSONObject profileGet(String from, JSONObject payload) {
        String login = "N/A";
        JSONObject result = new JSONObject();
        try {
            login = payload.getString("login");
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            if (accountModel != null) {
                result = accountModel.getNonSensitiveProfileJSON();
                result.put("status", (Object)"OK");
            } else {
                logger.error((Object)"Account model not found");
                result.put("error", (Object)"Unable to get profile: user not found");
            }
        }
        catch (Exception e) {
            logger.error((Object)("profileGet error for " + login), (Throwable)e);
        }
        return result;
    }

    private JSONObject profileModify(String from, JSONObject payload) {
        String login = "N/A";
        JSONObject result = new JSONObject();
        try {
            login = payload.getString("login");
            String operation = payload.getString("operation");
            String value = payload.getString("value");
            String category = payload.getString("category");
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            if (accountModel != null) {
                accountModel.modifyProfile(operation, category, value);
                result.put("status", (Object)"OK");
            } else {
                logger.error((Object)"Account model not found");
                result.put("error", (Object)"Unable to modify profile: user not found");
            }
        }
        catch (Exception e) {
            logger.error((Object)("profileModify error for " + login), (Throwable)e);
        }
        return result;
    }

    private JSONObject setPin(String from, JSONObject payload, String source_ip) {
        JSONObject result = new JSONObject();
        String login = "N/A";
        try {
            login = payload.getString("login");
            String encPin = payload.getString("enc_pin");
            String[] decData = this.decryptValue(login, encPin).split(":");
            String newPin = decData[0];
            String oldPin = decData[1];
            JSONObject mobileProfile = this.getMobileProfile(login);
            if (mobileProfile != null) {
                AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
                String pinHash = mobileProfile.optString("pin", null);
                if (pinHash == null) {
                    mobileProfile.put("pin", (Object)AccountModel.hashString(newPin));
                    model.modifyProfile("set", UserProfileModel.CATEGORY.MOBILE.toString(), mobileProfile.toString());
                    result.put("status", (Object)AUTH_STATUS.OK);
                    LogModel.register(LogModel.EVENT_TYPE.SET_PIN, source_ip, model.login.toLowerCase(), "", "", "PIN set for mobile device");
                    logger.debug((Object)("PIN set for " + login));
                } else {
                    boolean pinCheckResult = AccountModel.checkHashedValue(oldPin, pinHash);
                    if (pinCheckResult) {
                        mobileProfile.put("pin", (Object)AccountModel.hashString(newPin));
                        model.modifyProfile("set", UserProfileModel.CATEGORY.MOBILE.toString(), mobileProfile.toString());
                        result.put("status", (Object)AUTH_STATUS.OK);
                        LogModel.register(LogModel.EVENT_TYPE.SET_PIN, source_ip, model.login.toLowerCase(), "", "", "PIN for mobile device updated");
                        logger.debug((Object)("PIN updated for " + login));
                    } else {
                        result.put("error", (Object)"Unable to set new PIN: old pin not same");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Set PIN error for " + login), (Throwable)e);
        }
        return result;
    }

    private JSONObject processLapsExpire(String from, JSONObject payload, String source_ip) {
        String login = "N/A";
        JSONObject result = new JSONObject();
        try {
            login = payload.getString("login");
            Long expire = payload.getLong("expire");
            String pc = payload.getString("pc");
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            String searchPC = pc.trim().toLowerCase();
            if (searchPC.trim().matches("[a-zA-Z0-9_-]+")) {
                JSONObject profile;
                boolean forceUpdateToAllDC = SettingModel.getBool("laps_extra:expire_force_alldc");
                boolean isExpireSet = LdapManager.setExpire(searchPC, accountModel, expire, forceUpdateToAllDC);
                if (isExpireSet) {
                    LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE, source_ip, accountModel.login.toLowerCase(), "", searchPC, "New expire: " + Instant.ofEpochMilli(expire).toString());
                } else {
                    LogModel.register(LogModel.EVENT_TYPE.SET_EXPIRE_FAIL, source_ip, accountModel.login.toLowerCase(), "", searchPC, "Failed to set new expire: " + Instant.ofEpochMilli(expire).toString());
                    result.put("error", (Object)"Unable to set new expire");
                }
                result.put("type", (Object)"expire");
                result.put("status", isExpireSet);
                if (this.isPoolingMode && !(profile = accountModel.getFullProfileJSON()).has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                    this.sendPush(login, "New expire set for " + searchPC, "", result);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"processLapsPassword error", (Throwable)e);
        }
        return result;
    }

    private JSONObject processLapsPassword(String from, JSONObject payload, String source_ip) {
        JSONObject result;
        block26: {
            String login = "N/A";
            result = new JSONObject();
            Integer timeout = SettingModel.getInt("laps_extra:laps_access_timeout");
            try {
                String searchPC;
                AccountModel accountModel;
                block27: {
                    login = payload.getString("login");
                    String pc = payload.getString("pc");
                    long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                    accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
                    searchPC = pc.trim().toLowerCase();
                    if (!searchPC.trim().matches("[a-zA-Z0-9_-]+")) break block27;
                    try {
                        JSONArray allSecrets = SecretManager.getInstance().getAllSecrets(accountModel, source_ip, pc);
                        String lapsPwd = "";
                        String winLapsPwd = "";
                        String localPwd = "";
                        String resultPassword = "";
                        Long lapsExpire = 0L;
                        Long winLapsExpire = 0L;
                        Long localExpire = 0L;
                        Long resultExpire = 0L;
                        JSONArray otherLapsPasswords = new JSONArray();
                        JSONArray otherWinLapsPasswords = new JSONArray();
                        JSONArray otherlocalPasswords = new JSONArray();
                        JSONArray otherResultPasswords = new JSONArray();
                        int i = 0;
                        while (i < allSecrets.length()) {
                            String secretType = "";
                            JSONObject element = allSecrets.getJSONObject(i);
                            if (element.has("type")) {
                                secretType = element.getString("type");
                            }
                            switch (secretType) {
                                case "LAPS": {
                                    lapsPwd = element.optString("password", "");
                                    lapsExpire = element.optLong("expire", 0L);
                                    otherLapsPasswords = element.optJSONArray("other_passwords");
                                    break;
                                }
                                case "WindowsLAPS": {
                                    winLapsPwd = element.optString("password");
                                    winLapsExpire = element.optLong("expire", 0L);
                                    otherWinLapsPasswords = element.optJSONArray("other_passwords");
                                    break;
                                }
                                case "Windows_Local": {
                                    localPwd = element.optString("password");
                                    localExpire = element.optLong("expire", 0L);
                                    otherlocalPasswords = element.optJSONArray("other_passwords");
                                }
                            }
                            ++i;
                        }
                        if (!localPwd.isEmpty()) {
                            resultPassword = this.encrypt(login, localPwd);
                            otherResultPasswords = otherlocalPasswords;
                            resultExpire = localExpire;
                        } else if (!lapsPwd.isEmpty()) {
                            resultPassword = this.encrypt(login, lapsPwd);
                            otherResultPasswords = otherLapsPasswords;
                            resultExpire = lapsExpire;
                        } else if (!winLapsPwd.isEmpty()) {
                            resultPassword = this.encrypt(login, winLapsPwd);
                            otherResultPasswords = otherWinLapsPasswords;
                            resultExpire = winLapsExpire;
                        }
                        result.put("password", (Object)resultPassword);
                        result.put("expire", (Object)resultExpire);
                        if (otherResultPasswords.length() > 0) {
                            JSONArray otherPasswordsEnc = new JSONArray();
                            int i2 = 0;
                            while (i2 < otherResultPasswords.length()) {
                                String other_password = this.encrypt(login, otherResultPasswords.getString(i2));
                                otherPasswordsEnc.put((Object)other_password);
                                ++i2;
                            }
                            result.put("other_passwords", (Object)otherPasswordsEnc);
                        }
                        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, accountModel.login, "", searchPC, "Mobile access");
                    }
                    catch (Exception e) {
                        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", searchPC, e.getMessage());
                        result.put("error", (Object)e.getMessage());
                    }
                    break block26;
                }
                logger.error((Object)("PC not pass regex " + searchPC));
                LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", searchPC, "PC not mathced regex [a-zA-Z0-9_-]+");
            }
            catch (Exception e) {
                logger.error((Object)"processLapsPassword error", (Throwable)e);
            }
        }
        return result;
    }

    private AUTH_STATUS authenticate(String fcmToken, JSONObject payload, String source_ip) throws JSONException {
        AUTH_STATUS result = AUTH_STATUS.ERROR;
        try {
            String xAuth = payload.getString("X-Auth");
            String[] xAuthData = xAuth.split("::");
            String login = xAuthData[0];
            String encrypted = xAuthData[1];
            String decrypted = this.decryptValue(login, encrypted);
            if (decrypted == null) {
                LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", "Wrong encryption key");
                logger.error((Object)("Unable to decrypt value. Login:" + login + " ip:" + source_ip));
                result = AUTH_STATUS.WRONG_DEVICE;
                return result;
            }
            String[] decData = decrypted.split("::");
            String gotLogin = decData[0];
            JSONObject gotDevice = new JSONObject(decData[1]);
            Long ts = Long.parseLong(decData[2]);
            String gotPIN = decData[3];
            String enteredCapcha = payload.optString("capcha", null);
            String capchaUUID = payload.optString("capcha_uuid", null);
            AccountModel model = new AccountModel();
            model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            JSONObject mobileProfile = this.getMobileProfile(login);
            boolean loginChecked = false;
            boolean tsChecked = false;
            boolean profileChecked = false;
            if (mobileProfile != null) {
                String lockoutKey = "auth_lockout:" + login;
                Long lockoutTime = ClusterManager.getLong(lockoutKey);
                long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                if (lockoutTime != null) {
                    long diff = now - lockoutTime;
                    if (diff < (long)SettingModel.getInt("auth:lockout_duration").intValue()) {
                        result = AUTH_STATUS.LOCKOUT_TIMEOUT;
                        return result;
                    }
                    ClusterManager.remove(lockoutKey, true);
                }
                if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:capcha_count")) {
                    if (enteredCapcha == null) {
                        result = AUTH_STATUS.CAPCHA_REQUIRED;
                        logger.debug((Object)("Capcha required for  " + login));
                        return result;
                    }
                    String capchaKey = "capcha:" + login + ":" + capchaUUID;
                    String capchaOriginal = ClusterManager.get(capchaKey);
                    if (capchaOriginal != null && enteredCapcha.toLowerCase().equals(capchaOriginal.toLowerCase())) {
                        logger.debug((Object)("Capcha is OK for " + login));
                        ClusterManager.remove(capchaKey, true);
                    } else {
                        result = AUTH_STATUS.WRONG_CAPCHA;
                        logger.debug((Object)("Wrong capcha for " + login));
                        return result;
                    }
                }
                if (!login.equals(gotLogin)) {
                    logger.error((Object)("Logins are different! " + gotLogin + " " + login));
                    result = AUTH_STATUS.LOGIN_MISMATCH;
                    return result;
                }
                if (!(model.getEnabled().booleanValue() && LapsLauncher.debugMobile || model.getExternal().booleanValue() && LdapManager.getLdapManagerInstance().isUserAllowedToLogin(model.getLogin()))) {
                    result = AUTH_STATUS.NOT_ALLOWED;
                    logger.error((Object)("Auth error for " + login + " user is not external or not allowed to login"));
                    return result;
                }
                loginChecked = true;
                if (Math.abs(now - ts) >= (long)this.allowedClockDifference) {
                    logger.error((Object)("authenticate fail for " + login + " current time " + now + " timestamp from request: " + ts));
                    result = AUTH_STATUS.TIME_NOT_SYNCED;
                    return result;
                }
                tsChecked = true;
                JSONObject storedDevice = mobileProfile.getJSONObject("device");
                Iterator iter = storedDevice.keys();
                while (iter.hasNext()) {
                    String gotValue;
                    String key = (String)iter.next();
                    String storedValue = storedDevice.getString(key);
                    if (storedValue.equals(gotValue = gotDevice.getString(key))) continue;
                    result = AUTH_STATUS.WRONG_DEVICE;
                    logger.error((Object)("Device profile is different: " + login + " "));
                    return result;
                }
                profileChecked = true;
                String pinHash = mobileProfile.optString("pin", null);
                boolean pinCheckResult = false;
                if (pinHash != null && gotPIN != "-1") {
                    pinCheckResult = AccountModel.checkHashedValue(gotPIN, pinHash);
                    if (!pinCheckResult) {
                        logger.error((Object)("Wrong PIN for " + login));
                        result = AUTH_STATUS.WRONG_PIN;
                    }
                } else if (loginChecked && tsChecked && profileChecked && pinHash != null) {
                    result = AUTH_STATUS.PIN_NOT_SET;
                    return result;
                }
                if (loginChecked && tsChecked && profileChecked && pinCheckResult || loginChecked && tsChecked && profileChecked && pinHash == null) {
                    result = AUTH_STATUS.OK;
                    this.deleteFailCountPerLogin(login);
                    ClusterManager.remove(lockoutKey, true);
                } else {
                    this.increaseFailCount(login);
                    if (this.getFailCountPerLogin(login) >= SettingModel.getInt("auth:lockout_threshold")) {
                        ClusterManager.putToCache(lockoutKey, String.valueOf(now), true);
                        result = AUTH_STATUS.LOCKOUT_TIMEOUT;
                        return result;
                    }
                }
            } else {
                logger.error((Object)("Auth error, mobile profile not found for " + login));
                result = AUTH_STATUS.NOT_ENROLLED;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Mobile auth error", (Throwable)e);
            result = AUTH_STATUS.ERROR;
        }
        return result;
    }

    private JSONObject getMobileProfile(String login) {
        JSONObject result = null;
        try {
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            JSONObject profile = model.getFullProfileJSON();
            if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                result = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get mobile profile for login: " + login));
        }
        return result;
    }

    private String decryptValue(String login, String ciphertext) {
        String result = null;
        try {
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            JSONObject profile = model.getFullProfileJSON();
            if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                JSONObject mobileConf = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
                result = this.decrypt(mobileConf.getString("salt"), mobileConf.getString("iv"), SettingModel.decrypt(mobileConf.getString("key")), ciphertext);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to decrypt value for login: " + login));
        }
        return result;
    }

    private String ecnryptValue(String login, String value) {
        String result = null;
        try {
            AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            JSONObject profile = model.getFullProfileJSON();
            if (profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                JSONObject mobileConf = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
                result = this.encrypt(mobileConf.getString("salt"), mobileConf.getString("iv"), SettingModel.decrypt(mobileConf.getString("key")), value);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to decrypt value for login: " + login));
        }
        return result;
    }

    private JSONObject processPushAuthResponse(String from, JSONObject payload, String source_ip) {
        String login = "N/A";
        String errorMsg = "";
        JSONObject result = new JSONObject();
        try {
            login = payload.getString("login");
            String encryptedSession = payload.getString("session");
            String decrypted = this.decryptValue(login, encryptedSession);
            String session = decrypted.split("::")[0];
            Long ts = Long.parseLong(decrypted.split("::")[1]);
            boolean status = payload.getBoolean("status");
            result.put("status", status);
            String key = "push_auth:" + session;
            String data = ClusterManager.get(key);
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            if (Math.abs(now - ts) >= (long)this.allowedClockDifference) {
                errorMsg = "processPushAuthResponse fail for " + login + " current time " + now + " timestamp from request: " + ts;
                LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", errorMsg);
                logger.error((Object)errorMsg);
                result.put("error", (Object)"Too late, please check time settings");
                this.removeFromCache(key, true);
            }
            if (data != null) {
                String _login = data.split(":")[0];
                String ip = data.split(":")[1];
                Long cacheTs = Long.parseLong(data.split(":")[2]);
                if (Math.abs(now - cacheTs) >= (long)this.allowedPushAuthWaitInterval) {
                    errorMsg = "processPushAuthResponse fail for " + login + " current time " + now + " timestamp from cache: " + cacheTs;
                    logger.error((Object)errorMsg);
                    result.put("error", (Object)"Too late2, please check time settings");
                    this.removeFromCache(key, true);
                    LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", errorMsg);
                } else if (_login != null && login != null && login != "" && _login.equals(login)) {
                    this.putToCache("push_auth_result:" + session + ":" + login + ":" + ip, Boolean.toString(status), true);
                    if (status) {
                        LogModel.register(LogModel.EVENT_TYPE.LOGIN_SUCCESS, source_ip, login, "", "", "Approved access from mobile");
                    } else {
                        LogModel.register(LogModel.EVENT_TYPE.PUSH_AUTH_FAIL, source_ip, login, "", "", "Rejected access from mobile");
                    }
                    this.removeFromCache(key, true);
                } else {
                    errorMsg = "processPushAuthResponse fail for " + login + " logins are different " + _login;
                    this.putToCache("push_auth_result:" + session + ":" + login + ":" + ip, "fail", true);
                    logger.error((Object)errorMsg);
                    result.put("error", (Object)"processPushAuthResponse fail");
                    this.removeFromCache(key, true);
                    LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", errorMsg);
                }
            } else {
                logger.error((Object)("processPushAuthResponse session not found in cache: " + key + " login" + login + " ip:" + source_ip + " cache size:" + ClusterManager.getCacheSize()));
                result.put("status", (Object)"error");
                result.put("error", (Object)"Session not found");
                LogModel.register(LogModel.EVENT_TYPE.LOGIN_FAIL, source_ip, login, "", "", "Session not found");
            }
        }
        catch (Exception e) {
            logger.error((Object)"processPushAuthResponse error", (Throwable)e);
        }
        return result;
    }

    public String getPushAuthStatus(String login, String ip, String session) {
        String result = null;
        String key = "push_auth_result:" + session + ":" + login + ":" + ip;
        try {
            result = ClusterManager.get(key);
            if (result == null) {
                result = ClusterManager.containsKey("push_auth:" + session) ? "waiting" : "session_not_found";
            } else {
                this.removeFromCache(key, true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPushAuthStatus error", (Throwable)e);
        }
        return result;
    }

    private JSONObject processDeviceRegistrationResponse(String from, JSONObject payload, String source_ip) {
        JSONObject pushJson = new JSONObject();
        String login = "N/A";
        try {
            pushJson.put("type", (Object)"register");
            String cryptedSession = payload.getString("cryptedSession");
            String[] cryptedArr = cryptedSession.split("::");
            String iv = cryptedArr[0];
            String salt = cryptedArr[1];
            String ciphertext = cryptedArr[2];
            login = payload.getString("login");
            JSONObject regJSON = new JSONObject(ClusterManager.get("mobile_registration:" + login));
            String passphrase = regJSON.getString("key");
            String regNonce = regJSON.getString("nonce");
            String[] data = this.decrypt(salt, iv, passphrase, ciphertext).split("::");
            String gotLogin = data[0];
            String gotNonce = data[1];
            String gotFcmToken = data[2];
            long ts = Math.abs(Long.parseLong(data[3]));
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            if (Math.abs(now - ts) >= (long)this.allowedClockDifference) {
                logger.error((Object)("processDeviceRegistrationResponse fail for " + login + " current time " + now + " timestamp from request: " + ts));
                pushJson.put("status", (Object)"error");
                pushJson.put("error", (Object)"Timestamp check NOT passed");
                if (this.isPoolingMode) {
                    this.sendPush(from, login, "LAPS Portal", "Enroll error", pushJson);
                }
                return pushJson;
            }
            if (!gotLogin.equals(login)) {
                pushJson.put("status", (Object)"error");
                pushJson.put("error", (Object)"Logins are different!");
                logger.error((Object)("processDeviceRegistrationResponse fail for " + login + ": logins tokens are different!"));
                return pushJson;
            }
            if (!gotFcmToken.equals(from)) {
                pushJson.put("status", (Object)"error");
                pushJson.put("error", (Object)"Fcm tokens are different!");
                logger.error((Object)("processDeviceRegistrationResponse fail for " + login + " fcm tokens are different!"));
                return pushJson;
            }
            if (regNonce.equals(gotNonce)) {
                logger.debug((Object)("Nonce check passed for " + login));
                JSONObject profileJSON = new JSONObject();
                profileJSON.put("iv", (Object)iv);
                profileJSON.put("salt", (Object)salt);
                profileJSON.put("key", (Object)SettingModel.encrypt(passphrase));
                profileJSON.put("fcmToken", (Object)from);
                profileJSON.put("device", (Object)payload.getJSONObject("device"));
                AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
                JSONObject profile = model.getFullProfileJSON();
                if (!profile.has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                    model.modifyProfile("set", UserProfileModel.CATEGORY.MOBILE.toString(), profileJSON.toString());
                    this.removeFromCache("mobile_registration:" + login, true);
                } else {
                    logger.warn((Object)("User " + login + " already has registered device, but registration response recieved"));
                }
                pushJson.put("status", (Object)"ok");
                pushJson.put("profile_id", (Object)SettingModel.get("mobile:profile_id"));
                if (this.isPoolingMode) {
                    this.sendPush(from, login, "LAPS Portal", "Device enrolled", pushJson);
                }
                LogModel.register(LogModel.EVENT_TYPE.MOBILE_DEVICE_ADD, source_ip, login, "", "", "Device enrolled " + payload.getJSONObject("device").toString());
                logger.info((Object)("User " + login + " registered mobile device"));
            } else {
                logger.error((Object)("Nonce check NOT passed for " + login));
                LogModel.register(LogModel.EVENT_TYPE.MOBILE_DEVICE_ADD_FAIL, source_ip, login, "", "", "Failed to enroll device " + payload.getJSONObject("device").toString());
                pushJson.put("status", (Object)"error");
                pushJson.put("error", (Object)"Nonce check NOT passed");
                if (this.isPoolingMode) {
                    this.sendPush(from, login, "LAPS Portal", "Enroll error", pushJson);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to process registration request. login: " + login + " data: " + payload.toString()), (Throwable)e);
        }
        return pushJson;
    }

    public String decrypt(String salt, String iv, String passphrase, String ciphertext) {
        try {
            SecretKey key = this.generateKey(salt, passphrase);
            byte[] decrypted = this.doFinal(2, key, iv, MobileManager.base64(ciphertext));
            return new String(decrypted, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(encryptMode, (Key)key, new IvParameterSpec(MobileManager.hex(iv)));
            return cipher.doFinal(bytes);
        }
        catch (Exception e) {
            logger.error((Object)"Exception ", (Throwable)e);
            return null;
        }
    }

    private SecretKey generateKey(String salt, String passphrase) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), MobileManager.hex(salt), this.iterationCount, this.keySize);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] base64(String str) {
        return Base64.decodeBase64((String)str);
    }

    public static byte[] hex(String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    public String encrypt(String login, String plaintext) {
        String result = null;
        try {
            JSONObject profile;
            AccountModel accountModel = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
            if (accountModel != null && (profile = accountModel.getFullProfileJSON()).has(UserProfileModel.CATEGORY.MOBILE.toString())) {
                JSONObject mobileConf = profile.getJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
                String iv = mobileConf.getString("iv");
                String salt = mobileConf.getString("salt");
                String passphrase = SettingModel.decrypt(mobileConf.getString("key"));
                result = this.encrypt(salt, iv, passphrase, plaintext);
            }
        }
        catch (Exception e) {
            logger.error((Object)("sendPush to " + login + " error"), (Throwable)e);
        }
        return result;
    }

    public String encrypt(String salt, String iv, String passphrase, String plaintext) {
        try {
            SecretKey key = this.generateKey(salt, passphrase);
            byte[] encrypted = this.doFinal(1, key, iv, plaintext.getBytes("UTF-8"));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (UnsupportedEncodingException e) {
            throw this.fail(e);
        }
    }

    private IllegalStateException fail(Exception e) {
        return null;
    }

    public void putToCache(String key, String value, boolean sendToRemote) {
        ClusterManager.getInstance();
        ClusterManager.putToCache(key, value, sendToRemote);
    }

    public void removeFromCache(String key, boolean sendToRemote) {
        ClusterManager.getInstance();
        ClusterManager.remove(key, sendToRemote);
    }

    public JSONObject startDeviceRegistration(String login) throws JSONException, KeyManagementException, NoSuchAlgorithmException {
        logger.debug((Object)("startDeviceRegistration for " + login));
        JSONObject json = new JSONObject();
        String dic = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890#$%^&*()_+=";
        String key = "";
        int i = 0;
        while (i < 10) {
            int index = random.nextInt(dic.length());
            key = String.valueOf(key) + dic.charAt(index);
            ++i;
        }
        String nonce = "";
        int i2 = 0;
        while (i2 < 6) {
            int index = random.nextInt(dic.length());
            nonce = String.valueOf(nonce) + dic.charAt(index);
            ++i2;
        }
        json.put("mode", (Object)SettingModel.get("mobile:mode"));
        if (this.isPoolingMode) {
            json.put("url", (Object)this.fromDeviceURL);
            boolean useProxy = SettingModel.getBool("mobile:use_proxy");
            boolean doTlsCheck = SettingModel.getBool("mobile:do_cert_check");
            Client client = TlsHelper.getTlsClient((boolean)doTlsCheck, (boolean)useProxy);
            JSONObject reqJson = new JSONObject();
            UUID uuid = UUID.randomUUID();
            reqJson.put("from", (Object)this.apiKey);
            reqJson.put("session", (Object)uuid.toString());
            Response responseEntity = client.target(this.enrollDeviceURL).request().post(Entity.entity((Object)reqJson.toString(), (String)"application/json"));
            String resp = (String)responseEntity.readEntity(String.class);
            if (responseEntity.getStatus() == 200) {
                logger.info((Object)("Device enrollment session for " + login + " sent to cloud"));
            } else {
                logger.info((Object)("Device enrollment session for " + login + " NOT sent to cloud"));
            }
        } else {
            json.put("url", (Object)this.fromDeviceURL);
        }
        json.put("org", (Object)SettingModel.get("mobile:org"));
        json.put("key", (Object)key);
        json.put("login", (Object)login);
        json.put("nonce", (Object)nonce);
        this.putToCache("mobile_registration:" + login, json.toString(), true);
        return json;
    }

    public static void main(String[] args) {
        MobileManager mm = MobileManager.getInstance();
        System.out.println(mm.encrypt("0ccc9a3a2c74022ae6c9bf8c6b9f8342", "9a3b7014ae699eac242bb02035cf2f7f", "%*S$_s*3H_", "691452de-5244-4a03-b452-3950c808321a"));
    }

    @Override
    protected void work() throws Exception {
        this.readFromCloud();
        Thread.sleep((long)this.cloudReaderInterval * 1000L);
    }

    @Override
    protected void handleError(Exception t) {
        logger.error((Object)"MobileManager handle error ", (Throwable)t);
    }

    @Override
    protected void prepareWorker() throws Exception {
    }

    @Override
    protected void releaseWorker() throws Exception {
    }

    @Override
    protected void health_monitor() {
    }

    public boolean deleteDevice(JSONObject profile) {
        boolean wasDeleted = false;
        try {
            if (this.isPoolingMode) {
                boolean useProxy = SettingModel.getBool("mobile:use_proxy");
                boolean doTlsCheck = SettingModel.getBool("mobile:do_cert_check");
                Client client = TlsHelper.getTlsClient((boolean)doTlsCheck, (boolean)useProxy);
                JSONObject reqJson = new JSONObject();
                reqJson.put("from", (Object)this.apiKey);
                reqJson.put("token", (Object)profile.getString("fcmToken"));
                Response responseEntity = client.target(this.fromServerURL).request().post(Entity.entity((Object)reqJson.toString(), (String)"application/json"));
                String resp = (String)responseEntity.readEntity(String.class);
                if (responseEntity.getStatus() == 200) {
                    wasDeleted = true;
                }
            } else {
                wasDeleted = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to delete device");
        }
        return wasDeleted;
    }

    private Integer getFailCountPerLogin(String login) {
        Integer count = ClusterManager.getInteger("fail_mobile_login:" + login);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public void deleteFailCountPerLogin(String login) {
        ClusterManager.putToCache("fail_mobile_login:" + login, "0", true);
    }

    private void increaseFailCount(String login) {
        Integer l = this.getFailCountPerLogin(login) + 1;
        ClusterManager.putToCache("fail_mobile_login:" + login, l.toString(), true);
    }

    public void setClockDiff(Integer diffSeconds) {
        this.allowedClockDifference = diffSeconds;
    }

    public void setPushAuthWaitInterval(Integer allowedPushAuthWaitInterval) {
        this.allowedPushAuthWaitInterval = allowedPushAuthWaitInterval;
    }

    public static enum AUTH_STATUS {
        OK,
        WRONG_PIN,
        WRONG_DEVICE,
        TIME_NOT_SYNCED,
        ERROR,
        LOGIN_MISMATCH,
        NOT_ENROLLED,
        DEVICE_ALREADY_REGISTERED,
        CAPCHA_REQUIRED,
        WRONG_CAPCHA,
        PIN_NOT_SET,
        WRONG_PASSWORD,
        NOT_ALLOWED,
        WRONG_OTP,
        LOCKOUT_TIMEOUT;

    }
}

