/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.ksoft.laps.core.BitLockerManager;
import com.ksoft.laps.core.ClusterManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.LogModel;
import com.ksoft.laps.db.SettingModel;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecretManager {
    static Logger logger = Logger.getLogger((String)SecretManager.class.getName());
    static SecretManager instance = new SecretManager();

    public static SecretManager getInstance() {
        return instance;
    }

    public JSONArray getAllSecrets(AccountModel accountModel, String source_ip, String pc) throws Exception {
        JSONArray allSecrets = new JSONArray();
        String login = accountModel.getLogin();
        String searchPC = pc.trim().toLowerCase();
        Integer timeout = SettingModel.getInt("laps_extra:laps_access_timeout");
        if (searchPC.trim().matches("[a-zA-Z0-9_~-]+")) {
            JSONObject j;
            JSONObject result = new JSONObject();
            long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
            Long pre = ClusterManager.getLong("laps_pwd_access:" + login);
            if (pre != null) {
                long diff = now - pre;
                if (diff < (long)timeout.intValue()) {
                    logger.error((Object)("Laps password access too fast. Login: " + login + " pc: " + searchPC + " current time:" + now + " previous:" + pre + " timeout:" + timeout));
                    throw new Exception("Too fast requests, please wait " + String.valueOf((long)timeout.intValue() - diff) + " sec");
                }
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            } else {
                ClusterManager.putToCache("laps_pwd_access:" + login, String.valueOf(now), false);
            }
            JSONObject adSecrets = new JSONObject();
            JSONObject localSercrets = new JSONObject();
            JSONObject bitlockerSecrets = null;
            String errorMsg = "";
            if (LdapManager.isLDAPconfigured()) {
                adSecrets = LdapManager.getCompInfo(searchPC.trim(), accountModel);
                if (SettingModel.getBool("laps_extra:get_bitlocker")) {
                    bitlockerSecrets = BitLockerManager.getInstance().getBitLockerInfo(searchPC.trim(), accountModel);
                }
            }
            localSercrets = ComputersManager.getInstance().getCompInfo(searchPC.trim(), accountModel);
            if (adSecrets.has("error")) {
                errorMsg = adSecrets.getString("error");
            }
            if (localSercrets.has("error")) {
                if (!errorMsg.isEmpty()) {
                    errorMsg = String.valueOf(errorMsg) + "\r\n";
                }
                errorMsg = String.valueOf(errorMsg) + localSercrets.getString("error");
            }
            if (!errorMsg.isEmpty()) {
                result.put("error", (Object)errorMsg);
            }
            if (adSecrets.has("password")) {
                j = new JSONObject();
                j.put("id", (Object)"lapsId");
                j.put("subject", (Object)"");
                j.put("type", (Object)"LAPS");
                j.put("password", adSecrets.get("password"));
                j.put("expire", adSecrets.get("expire"));
                if (adSecrets.has("other_passwords")) {
                    j.put("other_passwords", adSecrets.get("other_passwords"));
                }
                allSecrets.put((Object)j);
            }
            if (adSecrets.has("winlaps_password")) {
                j = new JSONObject();
                j.put("id", (Object)"winLapsId");
                j.put("subject", adSecrets.get("winlaps_login"));
                j.put("type", (Object)"WindowsLAPS");
                j.put("password", adSecrets.get("winlaps_password"));
                j.put("expire", adSecrets.get("winlaps_expire"));
                if (adSecrets.has("winlaps_other_passwords")) {
                    j.put("other_passwords", adSecrets.get("winlaps_other_passwords"));
                }
                allSecrets.put((Object)j);
            }
            if (bitlockerSecrets != null && bitlockerSecrets.names() != null) {
                int i = 0;
                while (i < bitlockerSecrets.names().length()) {
                    String key = bitlockerSecrets.names().getString(i);
                    if (!key.equals("error")) {
                        JSONObject bitSec = new JSONObject();
                        bitSec.put("password", bitlockerSecrets.get(key));
                        bitSec.put("subject", (Object)key);
                        bitSec.put("type", (Object)"BITLOCKER");
                        allSecrets.put((Object)bitSec);
                    }
                    ++i;
                }
            }
            if (localSercrets.has("secrets")) {
                JSONArray secretsArray = localSercrets.getJSONArray("secrets");
                int i = 0;
                while (i < secretsArray.length()) {
                    allSecrets.put(secretsArray.get(i));
                    ++i;
                }
            }
            LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS, source_ip, login, "", searchPC, "");
            if (!CoreEngine.getLicenseManager().isLicenseValid()) {
                result.put("error", (Object)CoreEngine.getLicenseManager().getLicenseError());
                logger.error((Object)("License invalid! Returning masked value for PC " + searchPC));
            }
            return allSecrets;
        }
        logger.error((Object)("PC not pass regex " + searchPC));
        LogModel.register(LogModel.EVENT_TYPE.PASSWORD_ACCESS_FAIL, source_ip, accountModel.login, "", searchPC, "PC not mathced regex [a-zA-Z0-9_-]+");
        throw new Exception("PC not pass regex");
    }
}

