/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ksoft.laps.core.LapsLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingsManager {
    static Logger logger = Logger.getLogger((String)SettingsManager.class.getName());
    private static JSONObject globalConfig;
    private static JSONObject runConfig;

    public SettingsManager(JSONObject config) {
        globalConfig = config;
    }

    public static void setGlobalConfig(JSONObject config) {
        globalConfig = config;
    }

    public static String getBaseFolder() {
        String dir = globalConfig.optString("basepath");
        String osAppropriatePath = System.getProperty("os.name").contains("indow") ? dir.substring(1) : dir;
        return osAppropriatePath;
    }

    public static String getKeyStoreFolder() {
        String dir = String.valueOf(SettingsManager.getBaseFolder()) + globalConfig.optString("keystore_dir", "keystore") + "/";
        try {
            Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dir;
    }

    public static void setRunConfig(JSONObject runConfig) {
        SettingsManager.runConfig = runConfig;
    }

    public static JSONArray getInputsConfig() {
        JSONArray result = new JSONArray();
        try {
            JSONArray config;
            result = config = runConfig.getJSONArray("inputs");
        }
        catch (Exception e) {
            logger.error((Object)"Error in getReadersConfig", (Throwable)e);
        }
        return result;
    }

    public static JSONObject getEngineConfig() {
        JSONObject result = new JSONObject();
        try {
            result = runConfig.getJSONObject("engine");
        }
        catch (Exception e) {
            logger.error((Object)"Error in getEngineConfig", (Throwable)e);
        }
        return result;
    }

    public static String getNodesUUID() {
        return globalConfig.optString("node_uuid", "");
    }

    public static String getMyRole() {
        return globalConfig.optString("role", "");
    }

    public static void setUUID(String uuid) {
        try {
            globalConfig.put("node_uuid", (Object)uuid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() throws IOException {
        SettingsManager.saveConfig(globalConfig);
    }

    public static void saveConfig(JSONObject conf) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(conf.toString());
        String prettyJsonString = gson.toJson(je);
        prettyJsonString = prettyJsonString.replace("\\r\\n", "\n");
        prettyJsonString = prettyJsonString.replace("\\t", "\t");
        String base = globalConfig.optString("basepath");
        String fname = String.valueOf(base) + "conf//engine.conf";
        if (LapsLauncher.debugCluster) {
            fname = String.valueOf(base) + "conf//engine_cluster.conf";
        }
        FileUtils.writeStringToFile((File)new File(fname), (String)prettyJsonString);
    }

    public static Object getRegistrationToken() {
        return globalConfig.optString("processor_api_token", "secretTOKEN");
    }

    public static String getDir(String param, String defaultDir) {
        String dir = String.valueOf(SettingsManager.getBaseFolder()) + globalConfig.optString(param, defaultDir) + "/";
        try {
            if (!Files.exists(Paths.get(dir, new String[0]), new LinkOption[0])) {
                Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Directory already exists, it should be OK " + dir));
        }
        return dir;
    }

    public static String getKeyStorePass() {
        return globalConfig.optString("keystore_pass", "17atlkATLK");
    }

    public static int getSslPort() {
        return globalConfig.optInt("sslport", 8443);
    }

    public static int getIntValue(String property, int defaultVaule) {
        return globalConfig.optInt(property, defaultVaule);
    }

    public static String getStringValue(String property, String defaultVaule) {
        return globalConfig.optString(property, defaultVaule);
    }

    public static void setValue(String param, Object value) {
        try {
            if (value != null) {
                globalConfig.put(param, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void setMgmtAccessToken(String token) {
        try {
            globalConfig.put("mgmt_access_token", (Object)token);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static String getMgmtAccessToken() {
        return globalConfig.optString("mgmt_access_token");
    }

    public static void setMgmtUrl(String apiUrl) {
        try {
            globalConfig.put("mgmtServer", (Object)apiUrl);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static int getNodeSSLPort() {
        return globalConfig.optInt("node_ssl_port", 12348);
    }

    public static ArrayList<String> getModelsClassToInit() throws JSONException {
        JSONArray arr = globalConfig.getJSONArray("db_models_classes");
        ArrayList<String> classes = new ArrayList<String>();
        int i = 0;
        while (i < arr.length()) {
            classes.add(arr.getString(i));
            ++i;
        }
        return classes;
    }
}

