/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core.computers;

import com.google.common.collect.Range;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.db.SettingModel;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComputersGroupsManager
implements ILibrary {
    static ComputersGroupsManager instance = new ComputersGroupsManager();
    static Logger logger = Logger.getLogger((String)ComputersGroupsManager.class.getName());
    HashMap<String, String> ruleIdToNode = new HashMap();
    HashMap<String, String> ruleIdToValue = new HashMap();
    HashMap<String, Pattern> patternsMap = new HashMap();
    private HashMap<String, Range<Long>> netMap = new HashMap();

    public static ComputersGroupsManager getInstance() {
        return instance;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            String type = config.getString("type");
            String ruleValue = config.getString("rule_value");
            String nodeId = config.getString("node_id");
            RULETYPE ruleType = RULETYPE.valueOf(type.toUpperCase());
            this.ruleIdToValue.put(id, ruleValue);
            switch (ruleType) {
                case NAME: {
                    Pattern pattern = Pattern.compile(ruleValue);
                    this.patternsMap.put(id, pattern);
                    this.ruleIdToNode.put(id, nodeId);
                    break;
                }
                case NET: {
                    if (ruleValue.contains("-")) {
                        String[] ips = ruleValue.split("-");
                        long lowestAddress = this.ipToLong(ips[0].trim());
                        long highestAddress = this.ipToLong(ips[1].trim());
                        if (lowestAddress > 0L && highestAddress > 0L && highestAddress >= lowestAddress) {
                            this.netMap.put(id, (Range<Long>)Range.closed((Comparable)Long.valueOf(lowestAddress), (Comparable)Long.valueOf(highestAddress)));
                            this.ruleIdToNode.put(id, nodeId);
                        }
                        break;
                    }
                    if (ruleValue.contains("/")) {
                        SubnetUtils subnet = new SubnetUtils(ruleValue.trim());
                        long lowestAddress = this.ipToLong(subnet.getInfo().getLowAddress());
                        long highestAddress = this.ipToLong(subnet.getInfo().getHighAddress());
                        if (lowestAddress > 0L && highestAddress > 0L && highestAddress >= lowestAddress) {
                            this.netMap.put(id, (Range<Long>)Range.closed((Comparable)Long.valueOf(lowestAddress), (Comparable)Long.valueOf(highestAddress)));
                            this.ruleIdToNode.put(id, nodeId);
                        }
                        break;
                    }
                    logger.error((Object)("Unknown net format for value " + ruleValue));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to init element " + id), (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        this.del(id);
        this.add(id, name, config);
    }

    @Override
    public void del(String id) {
        this.patternsMap.remove(id);
        this.ruleIdToNode.remove(id);
        this.ruleIdToValue.remove(id);
    }

    public String getNodeIdByComputerName(String computerName) {
        String result = null;
        try {
            for (Map.Entry<String, Pattern> entry : this.patternsMap.entrySet()) {
                String patternID = entry.getKey();
                Pattern pattern = entry.getValue();
                Matcher m = pattern.matcher(computerName);
                if (!m.find()) continue;
                String nodeID = this.ruleIdToNode.get(patternID);
                if (nodeID != null) {
                    result = nodeID;
                    return result;
                }
                logger.error((Object)("getNodeIdByComputerName returned null for pattern " + patternID));
            }
        }
        catch (Exception e) {
            logger.error((Object)("getNodeIdByComputerName error " + computerName), (Throwable)e);
        }
        return result;
    }

    public String getNodeIdByComputerIP(String ip) {
        String result = null;
        try {
            Long ipLong = this.ipToLong(ip);
            if (ipLong > 0L) {
                for (Map.Entry<String, Range<Long>> entry : this.netMap.entrySet()) {
                    String rangeID = entry.getKey();
                    Range<Long> range = entry.getValue();
                    if (!range.contains((Comparable)ipLong)) continue;
                    String nodeID = this.ruleIdToNode.get(rangeID);
                    if (nodeID != null) {
                        result = nodeID;
                        return result;
                    }
                    logger.error((Object)("getNodeIdByComputerIP returned null for net range " + rangeID));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getNodeIdByComputerIP error" + ip), (Throwable)e);
        }
        return result;
    }

    public JSONArray getRulesForNode(String nodeId) throws JSONException {
        JSONArray rules = new JSONArray();
        for (String ruleId : this.ruleIdToNode.keySet()) {
            String tempNodeId = this.ruleIdToNode.get(ruleId);
            if (!tempNodeId.equals(nodeId)) continue;
            JSONObject json = new JSONObject();
            String type = "";
            if (this.patternsMap.containsKey(ruleId)) {
                type = "name";
            } else if (this.netMap.containsKey(ruleId)) {
                type = "net";
            }
            json.put("type", (Object)type);
            json.put("value", (Object)this.ruleIdToValue.get(ruleId));
            rules.put((Object)json);
        }
        return rules;
    }

    public String getNodeIDforComputer(String computerName, String ip) {
        String result = null;
        try {
            if (SettingModel.getBool("computers_agent:rule_name_first")) {
                result = this.getNodeIdByComputerName(computerName);
                if (!SettingModel.getBool("computers_agent:rule_stop_after_match")) {
                    result = this.getNodeIdByComputerIP(ip);
                }
            } else {
                result = this.getNodeIdByComputerIP(ip);
                if (!SettingModel.getBool("computers_agent:rule_stop_after_match")) {
                    result = this.getNodeIdByComputerName(computerName);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getNodeIDforComputer error " + computerName + " " + ip), (Throwable)e);
        }
        return result;
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    public long ipToLong(String ipAddress) {
        long result = 0L;
        try {
            String[] ipAddressInArray = ipAddress.split("\\.");
            int i = 3;
            while (i >= 0) {
                long ip = Long.parseLong(ipAddressInArray[3 - i]);
                result |= ip << i * 8;
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static enum RULETYPE {
        NAME,
        NET;

    }
}

