/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core.computers;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.CoreEngine;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.LdapManager;
import com.ksoft.laps.core.computers.ComputersGroupsManager;
import com.ksoft.laps.core.computers.LocalPCPolicyManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.laps.db.HostModel;
import com.ksoft.laps.db.SecretModel;
import com.ksoft.laps.db.SettingModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComputersManager
implements ILibrary {
    static ComputersManager instance = new ComputersManager();
    static Logger logger = Logger.getLogger((String)ComputersManager.class.getName());
    boolean isPcTreeLoaded = false;
    public static final String pcTreeSettingKey = "computers:tree";
    private static PublicKey pubKey;
    private static PrivateKey privKey;
    private JSONArray computersTree = new JSONArray();
    HashMap<String, String> nodeIdToPathId = new HashMap();
    HashMap<String, String> nodeIdToPathName = new HashMap();
    HashMap<String, String> idToADGroup = new HashMap();
    HashMap<String, JSONObject> idToConfig = new HashMap();
    HashMap<String, HashMap<String, String>> accessMatrix = new HashMap();
    static String userRegex;
    static String hostRegex;

    static {
        userRegex = "[a-zA-Z0-9_\\\\@\\.-]+";
        hostRegex = "[a-zA-Z0-9_-\\.]+";
    }

    public static ComputersManager getInstance() {
        return instance;
    }

    public boolean movePcGroup(String fromNodeId, String toNodeId) {
        boolean result = false;
        try {
            JSONArray _computersTree = new JSONArray(this.computersTree.toString());
            TreeSearchResult found = new TreeSearchResult();
            JSONArray path = new JSONArray();
            JSONArray fromPath = this.traverse(_computersTree, OPERATION.PATH, fromNodeId, null, path, found);
            String fromPathStr = fromPath.join(",").replaceAll("\"", "");
            found = new TreeSearchResult();
            path = new JSONArray();
            JSONArray toPath = this.traverse(_computersTree, OPERATION.PATH, toNodeId, null, path, found);
            String toPathStr = toPath.join(",").replaceAll("\"", "");
            if (toPathStr.startsWith(fromPathStr)) {
                logger.error((Object)("Wrong path from:" + fromPathStr + " to:" + toPathStr));
            } else {
                found = new TreeSearchResult();
                if (this.findInTree(_computersTree, fromNodeId, found)) {
                    JSONObject cutted = found.element;
                    found = new TreeSearchResult();
                    this.traverse(_computersTree, OPERATION.DELETE, fromNodeId, null, fromPath, found);
                    found = new TreeSearchResult();
                    this.traverse(_computersTree, OPERATION.ADD, toNodeId, cutted, path, found);
                    result = true;
                    this.computersTree = _computersTree;
                    this.savePcTree();
                    this.reloadPCTree();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("movePcGroup error. from:" + fromNodeId + " to:" + toNodeId));
        }
        return result;
    }

    public boolean renamePCGroup(String groupName, String nodeId) {
        boolean result = false;
        try {
            JSONArray _computersTree = new JSONArray(this.computersTree.toString());
            JSONObject json = new JSONObject();
            json.put("name", (Object)groupName);
            TreeSearchResult found = new TreeSearchResult();
            JSONArray path = new JSONArray();
            this.traverse(_computersTree, OPERATION.RENAME, nodeId, json, path, found);
            this.computersTree = _computersTree;
            this.savePcTree();
            this.reloadPCTree();
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("renamePCGroup group error " + nodeId), (Throwable)e);
        }
        return result;
    }

    public String addPcGroup(String groupName, String parentNodeId) {
        String result = null;
        try {
            JSONArray _computersTree = new JSONArray(this.computersTree.toString());
            JSONObject json = new JSONObject();
            json.put("name", (Object)groupName);
            String uuid = UUID.randomUUID().toString();
            json.put("id", (Object)uuid);
            TreeSearchResult found = new TreeSearchResult();
            JSONArray path = new JSONArray();
            this.traverse(_computersTree, OPERATION.ADD, parentNodeId, json, path, found);
            this.computersTree = _computersTree;
            this.savePcTree();
            this.reloadPCTree();
            result = uuid;
        }
        catch (Exception e) {
            logger.error((Object)("addPcGroup group: " + groupName + " parentNodeId:" + parentNodeId));
        }
        return result;
    }

    public boolean deletePcGroup(String nodeId) {
        boolean result = false;
        try {
            JSONArray _computersTree = new JSONArray(this.computersTree.toString());
            TreeSearchResult found = new TreeSearchResult();
            boolean isFound = this.findInTree(_computersTree, nodeId, found);
            int childrensCount = 0;
            if (isFound && found.element.has("children")) {
                childrensCount = found.element.getJSONArray("children").length();
            }
            List computers = DBManager.findAll(HostModel.class, (String)"node_id", (Object)nodeId);
            found = new TreeSearchResult();
            if ((computers == null || computers.size() == 0) && childrensCount == 0) {
                JSONArray path = new JSONArray();
                this.traverse(_computersTree, OPERATION.DELETE, nodeId, null, path, found);
                this.computersTree = _computersTree;
                this.savePcTree();
                this.reloadPCTree();
                result = true;
            } else {
                logger.error((Object)("Unable to delete pc group " + nodeId + ". PC in group: " + computers.size() + " childrens count: " + childrensCount));
            }
        }
        catch (Exception e) {
            logger.error((Object)("deletePcGroup error. id: " + nodeId), (Throwable)e);
        }
        return result;
    }

    private JSONArray traverse(JSONArray items, OPERATION operation, String idToFind, JSONObject element, JSONArray path, TreeSearchResult serchResult) {
        try {
            int i = items.length() - 1;
            while (i >= 0) {
                if (!serchResult.isFound) {
                    JSONArray children;
                    JSONObject item = items.getJSONObject(i);
                    if (item.getString("id").equals(idToFind)) {
                        path.put((Object)idToFind);
                        serchResult.isFound = true;
                        switch (operation) {
                            case ADD: {
                                if (!item.has("children")) {
                                    JSONArray child = new JSONArray();
                                    item.put("children", (Object)child);
                                }
                                if (element != null && element.has("id")) {
                                    item.getJSONArray("children").put((Object)element);
                                    break;
                                }
                                logger.error((Object)"Attempt to insert null or id empty element");
                                break;
                            }
                            case DELETE: {
                                items.remove(i);
                                break;
                            }
                            case RENAME: {
                                String name = element.getString("name");
                                item.put("name", (Object)name);
                            }
                        }
                    }
                    if (!serchResult.isFound && item.has("children") && (children = item.getJSONArray("children")).length() > 0) {
                        path.put((Object)item.getString("id"));
                        this.traverse(children, operation, idToFind, element, path, serchResult);
                    }
                }
                --i;
            }
            if (!serchResult.isFound) {
                path.remove(path.length() - 1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Traverse error ", (Throwable)e);
        }
        return path;
    }

    private boolean findInTree(JSONArray items, String idToFind, TreeSearchResult found) {
        try {
            int i = items.length() - 1;
            while (i >= 0) {
                if (!found.isFound) {
                    JSONArray children;
                    JSONObject item = items.getJSONObject(i);
                    if (item.getString("id").equals(idToFind)) {
                        found.isFound = true;
                        found.element = item;
                        return found.isFound;
                    }
                    if (!found.isFound && item.has("children") && (children = item.getJSONArray("children")).length() > 0) {
                        this.findInTree(children, idToFind, found);
                    }
                }
                --i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Traverse error ", (Throwable)e);
        }
        return found.isFound;
    }

    private void reloadPCTree() {
        JSONArray path = new JSONArray();
        JSONArray pathName = new JSONArray();
        this.nodeIdToPathId = new HashMap();
        this.nodeIdToPathName = new HashMap();
        this.loadTree(this.computersTree, path, pathName);
    }

    private void loadTree(JSONArray items, JSONArray path, JSONArray pathName) {
        try {
            int i = items.length() - 1;
            while (i >= 0) {
                JSONArray children;
                JSONObject item = items.getJSONObject(i);
                path.put((Object)item.getString("id"));
                pathName.put((Object)item.getString("name"));
                this.nodeIdToPathId.put(item.getString("id"), path.join(",").replaceAll("\"", ""));
                this.nodeIdToPathName.put(item.getString("id"), pathName.join("/").replaceAll("\"", ""));
                if (item.has("children") && (children = item.getJSONArray("children")).length() > 0) {
                    this.loadTree(children, path, pathName);
                }
                path.remove(path.length() - 1);
                pathName.remove(pathName.length() - 1);
                --i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Traverse error ", (Throwable)e);
        }
    }

    public void init(JSONArray tree, PublicKey pubKey, PrivateKey privKey) {
        try {
            ComputersManager.pubKey = pubKey;
            ComputersManager.privKey = privKey;
            if (tree.length() == 0) {
                JSONObject allPc = new JSONObject();
                allPc.put("id", (Object)NODES.ALL_COMPUTERS.getValue());
                allPc.put("name", (Object)"All computers");
                tree.put((Object)allPc);
                JSONObject conflicts = new JSONObject();
                conflicts.put("id", (Object)NODES.NAME_CONFLICT.getValue());
                conflicts.put("name", (Object)"Name conflicts");
                tree.put((Object)conflicts);
                this.computersTree = tree;
                this.savePcTree();
            } else {
                this.computersTree = tree;
            }
            this.reloadPCTree();
        }
        catch (Exception e) {
            logger.error((Object)"Init tree error", (Throwable)e);
        }
    }

    private void savePcTree() {
        SettingModel.set(pcTreeSettingKey, this.computersTree.toString());
        String group = pcTreeSettingKey.split(":")[0];
        CoreEngine.getInstance().notifySettingsUpdate(group, true);
        logger.debug((Object)"PC tree saved");
    }

    public JSONArray getComputersTree() {
        return this.computersTree;
    }

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            this.idToADGroup.put(id, config.getString("group").toLowerCase());
            this.idToConfig.put(id, config);
            HashMap<String, String> groupToNodePath = new HashMap<String, String>();
            String nodeId = config.getString("node_id");
            if (this.nodeIdToPathId.containsKey(nodeId)) {
                groupToNodePath.put(config.getString("group").toLowerCase(), this.nodeIdToPathId.get(nodeId));
                this.accessMatrix.put(id, groupToNodePath);
            } else {
                logger.error((Object)("PC groups tree not contains " + nodeId));
            }
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    public boolean isNodeExists(String nodeId) {
        return this.nodeIdToPathId.containsKey(nodeId);
    }

    public String getNodePathId(String nodeId) {
        return this.nodeIdToPathId.get(nodeId);
    }

    public String getNodePathName(String nodeId) {
        return this.nodeIdToPathName.get(nodeId);
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        try {
            this.idToADGroup.put(id, config.getString("group").toLowerCase());
            this.idToConfig.put(id, config);
            HashMap<String, String> groupOU = new HashMap<String, String>();
            String nodeId = config.getString("node_id");
            if (this.nodeIdToPathId.containsKey(nodeId)) {
                groupOU.put(config.getString("group").toLowerCase(), this.nodeIdToPathId.get(nodeId));
                this.accessMatrix.put(id, groupOU);
            } else {
                logger.error((Object)("PC groups tree not contains " + nodeId));
            }
        }
        catch (Exception e) {
            logger.error((Object)"add error", (Throwable)e);
        }
    }

    @Override
    public void del(String id) {
        try {
            if (this.idToADGroup.containsKey(id)) {
                String group = this.idToADGroup.get(id);
                this.accessMatrix.remove(id);
                this.idToADGroup.remove(id);
                this.idToConfig.remove(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Remove error", (Throwable)e);
        }
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    public JSONArray getAllowedGroupsForNode(String nodeId) {
        JSONArray groups = new JSONArray();
        String nodePathId = this.nodeIdToPathId.get(nodeId);
        for (HashMap<String, String> groupToNodePath : this.accessMatrix.values()) {
            for (String group : groupToNodePath.keySet()) {
                String tempNodePath = groupToNodePath.get(group.toLowerCase()).toLowerCase();
                if (tempNodePath == null || nodePathId == null || !nodePathId.startsWith(tempNodePath)) continue;
                groups.put((Object)group);
            }
        }
        return groups;
    }

    private boolean isUserAllowedForSecret(SecretModel secretModel, AccountModel accountModel) throws JSONException {
        boolean result;
        block21: {
            result = false;
            if (!accountModel.login.matches(userRegex)) {
                logger.error((Object)("isUserAllowedForPC not matched regex for login " + accountModel.login));
                return result;
            }
            String computerPath = this.nodeIdToPathId.get(secretModel.host.node_id);
            if (accountModel.getExternal().booleanValue()) {
                try {
                    JSONArray jGroups = LdapManager.getUserGroupsFromAD(accountModel);
                    if (jGroups.length() > 0) {
                        logger.debug((Object)("For login " + accountModel.login + " found " + jGroups.length() + " groups"));
                        int i = 0;
                        while (i < jGroups.length()) {
                            String group = jGroups.getString(i);
                            for (String accessId : this.accessMatrix.keySet()) {
                                HashMap<String, String> groupToNodePath = this.accessMatrix.get(accessId);
                                if (!groupToNodePath.containsKey(group.toLowerCase())) continue;
                                String nodePath = groupToNodePath.get(group.toLowerCase()).toLowerCase();
                                if (computerPath == null || nodePath == null || !computerPath.startsWith(nodePath)) continue;
                                if (secretModel == null) {
                                    result = true;
                                    return result;
                                }
                                JSONObject config = this.idToConfig.get(accessId);
                                if (config == null) continue;
                                String subjects = config.optString("subjects", "").replace(" ", "").trim();
                                if (subjects.isEmpty()) {
                                    result = true;
                                    return result;
                                }
                                String[] allowedSubjects = new String[1];
                                if (subjects.contains(";")) {
                                    allowedSubjects = subjects.split(";");
                                } else if (subjects.contains(",")) {
                                    allowedSubjects = subjects.split(",");
                                } else {
                                    allowedSubjects[0] = subjects;
                                }
                                if (allowedSubjects.length <= 0) continue;
                                int j = 0;
                                while (i < allowedSubjects.length) {
                                    if (secretModel.subject.toLowerCase().trim().equals(allowedSubjects[j].toLowerCase().trim())) {
                                        result = true;
                                        return result;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    if (result || secretModel.host.managedby == null) break block21;
                    String userDN = LdapManager.getDNbyLogin(accountModel.getLogin());
                    if (secretModel.host.managedby.toLowerCase().equals(userDN.toLowerCase())) {
                        logger.debug((Object)("Found PC " + secretModel.host + " managed by " + accountModel.login + " (" + secretModel.host.managedby + ")"));
                        result = true;
                    } else {
                        String groupAttribs;
                        String groupFilter = "(&(objectClass=group)(distinguishedName=" + secretModel.host.managedby + ")(member=" + userDN + "))";
                        ArrayList<HashMap<String, String>> groupSearchResults = LdapManager.search(groupFilter, LdapManager.groupSearchBase, groupAttribs = "distinguishedName,CN", 1);
                        if (groupSearchResults.size() > 0) {
                            logger.debug((Object)("Found PC " + secretModel.host + " managed by " + secretModel.host.managedby + " member: " + userDN + " " + accountModel.login));
                            result = true;
                        }
                    }
                    if (!result) {
                        logger.error((Object)("No access rights for " + secretModel.host + ": managedBy= " + secretModel.host.managedby + " user:" + accountModel.login));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"isUserAllowedForSecret error", (Throwable)e);
                }
            } else if (accountModel.getLogin().equals("admin")) {
                result = true;
            }
        }
        return result;
    }

    public JSONObject getCompInfo(String pc, AccountModel accountModel) {
        JSONObject result = new JSONObject();
        Integer expireMinutes = SettingModel.getInt("computers_agent:secret_expire");
        boolean isPwdFound = false;
        boolean isLapsInstalled = false;
        boolean isComputerFound = false;
        try {
            pc.equals("__test2__");
            HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"name", (Object)pc);
            if (hostModel != null) {
                isComputerFound = true;
                List secrets = DBManager.findAll(SecretModel.class, (String)"host_id", (Object)hostModel.id);
                if (secrets != null && secrets.size() > 0) {
                    JSONArray jSecrets = new JSONArray();
                    for (SecretModel secretModel : secrets) {
                        JSONObject j;
                        String subject = secretModel.subject;
                        if (this.isUserAllowedForSecret(secretModel, accountModel)) {
                            j = new JSONObject();
                            j.put("id", (Object)secretModel.id);
                            j.put("subject", (Object)subject);
                            j.put("type", (Object)secretModel.type);
                            j.put("password", (Object)this.decryptPassword(secretModel.secret));
                            if (secretModel.oldsecret != null && !secretModel.oldsecret.isEmpty()) {
                                j.put("oldpassword", (Object)this.decryptPassword(secretModel.oldsecret));
                            }
                            if (secretModel.tempsecret != null && !secretModel.tempsecret.isEmpty()) {
                                j.put("temppassword", (Object)this.decryptPassword(secretModel.tempsecret));
                            }
                            Long expire = secretModel.ts_expire;
                            j.put("expire", expire / 1000L);
                            if (expireMinutes != null && expireMinutes > 0) {
                                long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                                Long newExpireMili = (now + (long)(expireMinutes * 60)) * 1000L;
                                logger.info((Object)("Attempt to set new expire for host: " + pc + " subject: " + subject + ". Old " + expire + " New: " + newExpireMili));
                                boolean expireSeted = this.setExpire(secretModel, accountModel, newExpireMili);
                                if (expireSeted) {
                                    Long newExpire2 = newExpireMili / 1000L;
                                    j.put("expire", (Object)newExpire2);
                                }
                            }
                            jSecrets.put((Object)j);
                            continue;
                        }
                        j = new JSONObject();
                        j.put("id", (Object)secretModel.id);
                        j.put("subject", (Object)subject);
                        j.put("type", (Object)secretModel.type);
                        j.put("error", (Object)"No access rights");
                        jSecrets.put((Object)j);
                    }
                    result.put("secrets", (Object)jSecrets);
                } else {
                    result.put("password", (Object)"No access rights");
                    result.put("error", (Object)"No access rights");
                }
            } else {
                result.put("error", (Object)("Computer " + pc + " not found"));
                logger.error((Object)("Host " + pc + " not found"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("getCompInfo error " + pc));
            try {
                result.put("error", (Object)e.getMessage().toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean setExpire(SecretModel secretModel, AccountModel accountModel, long unixMillis) {
        boolean result = false;
        Integer expireMaxMinDifference = SettingModel.getInt("computers_agent:secret_max_expire");
        Long maxExpireMillis = Instant.now().toEpochMilli() + (long)(expireMaxMinDifference * 60 * 1000);
        String host = "";
        String subject = "";
        try {
            host = secretModel.host.name;
            subject = secretModel.subject;
            if (secretModel != null && this.isUserAllowedForSecret(secretModel, accountModel)) {
                if (unixMillis < Instant.now().toEpochMilli()) {
                    unixMillis = Instant.now().toEpochMilli();
                    logger.warn((Object)("unixMillis < Now fixing unixMillis=" + unixMillis + " PC: " + host + ", login: " + accountModel.login));
                }
                if (unixMillis > maxExpireMillis) {
                    unixMillis = maxExpireMillis;
                    logger.warn((Object)("unixMillis > maxExpireMillis fixing unixMillis=" + unixMillis + " PC: " + host + ", login: " + accountModel.login));
                }
                if (unixMillis >= Instant.now().toEpochMilli() && unixMillis <= maxExpireMillis) {
                    secretModel.ts_expire = unixMillis / 1000L;
                    DBManager.getDao(SecretModel.class).update((Object)secretModel);
                    result = true;
                } else {
                    logger.error((Object)("SetExpire constraint error. PC: " + host + " subject: " + subject + ", login: " + accountModel.login + " unixmillis: " + String.valueOf(unixMillis) + " maxExpireMillis: " + String.valueOf(maxExpireMillis)));
                }
            } else {
                logger.error((Object)("Secret not found or user not allowed. ID: " + secretModel.id + " Subject: " + subject + ", computer: " + host + " login:" + accountModel.getLogin()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("setExpire error. Subject: " + subject + ", computer: " + host + " login:" + accountModel.getLogin()), (Throwable)e);
        }
        return result;
    }

    public String decryptPassword(String encrypted) {
        String result = "";
        try {
            boolean isLicenseValid = CoreEngine.getLicenseManager().isLicenseValid();
            if (encrypted != null && !encrypted.isEmpty()) {
                String password = SettingModel.decrypt(encrypted);
                if (!isLicenseValid) {
                    int len = password.length();
                    String masked = password.substring(0, len - 3);
                    result = masked = String.valueOf(masked) + "_UNLICENSED";
                } else {
                    result = password;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"decryptPassword error", (Throwable)e);
        }
        return result;
    }

    public boolean checkHMAC(String base64Mac, String key, String message) {
        boolean result = false;
        String HMAC_SHA256 = "HmacSHA256";
        try {
            byte[] byteKey = key.getBytes(StandardCharsets.UTF_8);
            Mac sha256Hmac = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec keySpec = new SecretKeySpec(byteKey, HMAC_SHA256);
            sha256Hmac.init(keySpec);
            byte[] macData = sha256Hmac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            String computedMac = Base64.getEncoder().encodeToString(macData);
            if (computedMac.equals(base64Mac)) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"check hmac error", (Throwable)e);
        }
        return result;
    }

    public boolean joinPC(String ip, String uuid, String nodeUUID, String name, String version) {
        HostModel model;
        HostModel newPC;
        boolean result;
        block5: {
            result = false;
            newPC = new HostModel();
            newPC.name = name.toLowerCase();
            newPC.uuid = uuid;
            newPC.ip = ip;
            newPC.version = version;
            model = (HostModel)DBManager.findOne(HostModel.class, (String)"name", (Object)name);
            HostModel modelByUUID = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)uuid);
            if (modelByUUID == null) break block5;
            logger.error((Object)("Computer with uuid " + uuid + " already joined!"));
            return false;
        }
        try {
            if (model != null) {
                logger.warn((Object)("Join pc name conflict. Name: " + name));
                newPC.name = String.valueOf(name) + "~" + uuid;
                newPC.node_id = NODES.NAME_CONFLICT.getValue();
            } else {
                newPC.node_id = nodeUUID != null && ComputersManager.getInstance().isNodeExists(nodeUUID) ? nodeUUID : this.guesNodeForPC(name, ip);
            }
            newPC.beforeCreate();
            DBManager.getDao(HostModel.class).create((Object)newPC);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("joinPC " + name + " error"), (Throwable)e);
        }
        return result;
    }

    private String guesNodeForPC(String name, String ip) {
        String result = NODES.ALL_COMPUTERS.getValue();
        String nodeId = ComputersGroupsManager.getInstance().getNodeIDforComputer(name, ip);
        if (nodeId != null) {
            if (this.isNodeExists(nodeId)) {
                result = nodeId;
            } else {
                logger.error((Object)("ComputersGroupsManager returned node that does not exist " + nodeId));
            }
        }
        return result;
    }

    public String passwordChangePrepare(String pcUuid, String subject, String encrypted) throws Exception {
        String commitUUID = null;
        HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)pcUuid);
        if (hostModel == null) {
            logger.error((Object)("Computer " + pcUuid + " not found"));
            throw new ComputerManagerException(ERROR_CODE.AGENT_NOTFOUND, "Computer not found");
        }
        String password = this.decryptWithPrivKey(encrypted);
        if (password != null && !password.isEmpty()) {
            boolean needToCreate = false;
            SecretModel secretModel = SecretModel.getSecretModelByHostAndSubject(hostModel.id, subject);
            if (secretModel == null) {
                needToCreate = true;
                secretModel = new SecretModel();
                secretModel.subject = subject;
                secretModel.host = hostModel;
                secretModel.type = SecretModel.TYPE.Windows_Local.toString();
            }
            secretModel.tempsecret = SettingModel.encrypt(password);
            secretModel.commituuid = UUID.randomUUID().toString();
            secretModel.beforeUpdate();
            if (needToCreate) {
                DBManager.getDao(SecretModel.class).create((Object)secretModel);
            } else {
                DBManager.getDao(SecretModel.class).update((Object)secretModel);
            }
            logger.debug((Object)("Password prepared for " + pcUuid));
            commitUUID = secretModel.commituuid;
        }
        return commitUUID;
    }

    private String decryptWithPrivKey(String encrypted) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] data = Base64.getDecoder().decode(encrypted);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privKey);
        byte[] decrypted = cipher.doFinal(data);
        String result = new String(decrypted);
        return result;
    }

    public boolean passwordChangeCommit(String pcUUID, String subject, String commitUUID) throws GeneralSecurityException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, JSONException {
        boolean result = false;
        HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)pcUUID);
        if (hostModel == null) {
            logger.error((Object)("Computer " + pcUUID + " not found"));
            throw new ComputerManagerException(ERROR_CODE.AGENT_NOTFOUND, "Computer not found");
        }
        SecretModel secretModel = SecretModel.getSecretModelByHostAndSubject(hostModel.id, subject);
        if (secretModel == null) {
            logger.error((Object)("Secret for subject " + subject + " at computer " + pcUUID + " not found"));
            throw new ComputerManagerException(ERROR_CODE.SECRET_NOTFOUND, "Secret not found");
        }
        String newPassword = SettingModel.decrypt(secretModel.tempsecret);
        String currentPassword = "";
        if (secretModel.secret != null && !secretModel.secret.isEmpty()) {
            currentPassword = SettingModel.decrypt(secretModel.secret);
        }
        if (secretModel.commituuid.equals(commitUUID)) {
            if (newPassword != null) {
                secretModel.tempsecret = "";
                secretModel.commituuid = "";
                secretModel.secret = SettingModel.encrypt(newPassword);
                secretModel.oldsecret = SettingModel.encrypt(currentPassword);
                long now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
                long pwdAgeHours = LocalPCPolicyManager.getInstance().getPasswordAge(pcUUID, subject);
                secretModel.beforeUpdate();
                secretModel.ts_expire = now + pwdAgeHours * 60L * 60L;
                DBManager.getDao(SecretModel.class).update((Object)secretModel);
                logger.debug((Object)("Password updated for " + subject + " at host " + pcUUID));
                result = true;
            }
        } else {
            logger.error((Object)("Wrong commit uuid for host " + pcUUID + " expected " + secretModel.commituuid + " recieved" + commitUUID));
        }
        return result;
    }

    public boolean isUserAllowedToLogin(String login) {
        boolean result = false;
        try {
            HashMap<String, String> attributes = LdapManager.getUserAttributes(login);
            String distinguishedName = attributes.get("distinguishedName");
            String groups = attributes.get("memberOf");
            JSONArray jGroups = new JSONArray();
            if (groups != null) {
                try {
                    jGroups = new JSONArray(groups);
                }
                catch (Exception e) {
                    jGroups.put((Object)groups);
                }
            }
            int i = 0;
            while (i < jGroups.length()) {
                String group = jGroups.getString(i).toLowerCase();
                for (HashMap<String, String> groupOU : this.accessMatrix.values()) {
                    if (!groupOU.containsKey(group.toLowerCase())) continue;
                    result = true;
                    break;
                }
                ++i;
            }
            if (!result) {
                HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"managedby", (Object)distinguishedName.toLowerCase());
                if (hostModel != null) {
                    logger.debug((Object)("Found local computer " + hostModel.name + " managed by " + login + " (" + hostModel.managedby + ")"));
                    result = true;
                }
                if (!result) {
                    QueryBuilder builder = DBManager.getDao(HostModel.class).queryBuilder();
                    Where where = builder.where().isNotNull("managedby").and().ne("managedby", (Object)"");
                    List hostModels = DBManager.getDao(HostModel.class).query(builder.prepare());
                    block6: for (HostModel hostModel2 : hostModels) {
                        for (HashMap<String, String> groupOU : this.accessMatrix.values()) {
                            if (hostModel2.managedby == null || !groupOU.containsKey(hostModel2.managedby.toLowerCase())) continue;
                            result = true;
                            continue block6;
                        }
                    }
                }
                if (!result) {
                    logger.error((Object)("No access rights for user:" + login));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"isUserAllowedToLogin error", (Throwable)e);
        }
        return result;
    }

    public class ComputerManagerException
    extends RuntimeException {
        public ERROR_CODE code;

        public ComputerManagerException(ERROR_CODE code, String message) {
            super(message);
            this.code = code;
        }

        public ERROR_CODE getErrorCode() {
            return this.code;
        }
    }

    public static enum ERROR_CODE {
        AGENT_NOTFOUND,
        SECRET_NOTFOUND;

    }

    public static enum NODES {
        ALL_COMPUTERS("0"),
        NAME_CONFLICT("-1");

        private final String value;

        private NODES(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    static enum OPERATION {
        ADD,
        DELETE,
        PATH,
        RENAME;

    }

    class TreeSearchResult {
        public boolean isFound = false;
        public JSONObject element = new JSONObject();

        TreeSearchResult() {
        }
    }
}

