/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.core.computers;

import com.ksoft.core.DBManager;
import com.ksoft.laps.core.ILibrary;
import com.ksoft.laps.core.computers.ComputersManager;
import com.ksoft.laps.db.HostModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPCPolicyManager
implements ILibrary {
    static Logger logger = Logger.getLogger((String)LocalPCPolicyManager.class.getName());
    private static LocalPCPolicyManager instance = new LocalPCPolicyManager();
    HashMap<String, String> ploicyIdToPathId = new HashMap();
    HashMap<String, HashMap<String, JSONObject>> nodePolicy = new HashMap();
    HashMap<String, String> idToNode = new HashMap();
    ComputersManager compManager = ComputersManager.getInstance();

    @Override
    public void add(String id, String name, JSONObject config) {
        try {
            String nodeId = config.getString("node_id");
            if (this.compManager.isNodeExists(nodeId)) {
                this.idToNode.put(id, nodeId);
                if (this.nodePolicy.containsKey(nodeId)) {
                    this.nodePolicy.get(nodeId).put(id, config);
                } else {
                    HashMap<String, JSONObject> p = new HashMap<String, JSONObject>();
                    p.put(id, config);
                    this.nodePolicy.put(nodeId, p);
                }
            } else {
                logger.error((Object)("Node " + id + " not exists"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"LocalPCPolicy error", (Throwable)e);
        }
    }

    @Override
    public void update(String id, String name, JSONObject config) {
        this.del(id);
        this.add(id, name, config);
    }

    @Override
    public void del(String id) {
        if (this.idToNode.containsKey(id)) {
            String nodeId = this.idToNode.get(id);
            if (this.nodePolicy.containsKey(nodeId)) {
                this.nodePolicy.get(nodeId).remove(id);
            } else {
                logger.error((Object)("Node " + nodeId + " not exists"));
            }
        } else {
            logger.error((Object)("id not registered " + id));
        }
    }

    @Override
    public int importFromFile(String filePath) {
        return 0;
    }

    public static LocalPCPolicyManager getInstance() {
        return instance;
    }

    public JSONArray getPolicyForNode(String nodeId) {
        JSONArray policy = new JSONArray();
        if (this.compManager.isNodeExists(nodeId)) {
            HashMap policyHash = new HashMap();
            String computerPath = this.compManager.getNodePathId(nodeId);
            String[] path = computerPath.split(",");
            int i = 0;
            while (i < path.length) {
                String node = path[i];
                if (this.nodePolicy.containsKey(node)) {
                    HashMap<String, JSONObject> p = this.nodePolicy.get(node);
                    p.forEach((k, userPolicy) -> {
                        try {
                            policy.put(userPolicy);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to get policy " + k));
                        }
                    });
                }
                ++i;
            }
        } else {
            logger.error((Object)"node uuid not exists");
        }
        return policy;
    }

    public JSONArray getPolicyForHost(String pcUuid) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, JSONException {
        JSONArray policy = new JSONArray();
        HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)pcUuid);
        if (hostModel != null) {
            policy = this.getPolicyForNode(hostModel.node_id);
        } else {
            logger.error((Object)("Host " + pcUuid + " does not exist"));
        }
        return policy;
    }

    public long getPasswordAge(String pcUuid, String subject) throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        long result = 0L;
        HostModel hostModel = (HostModel)DBManager.findOne(HostModel.class, (String)"uuid", (Object)pcUuid);
        if (this.compManager.isNodeExists(hostModel.node_id)) {
            HashMap policyHash = new HashMap();
            String computerPath = this.compManager.getNodePathId(hostModel.node_id);
            String[] path = computerPath.split(",");
            int i = 0;
            while (i < path.length) {
                String node = path[i];
                if (this.nodePolicy.containsKey(node)) {
                    HashMap<String, JSONObject> p = this.nodePolicy.get(node);
                    p.forEach((k, userPolicy) -> {
                        try {
                            String user = userPolicy.getString("subject");
                            policyHash.put(user, userPolicy);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to get policy " + k));
                        }
                    });
                }
                ++i;
            }
            if (policyHash.containsKey(subject)) {
                JSONObject p = (JSONObject)policyHash.get(subject);
                result = p.optLong("pwdAge", 0L);
            } else {
                logger.error((Object)("Policy for " + subject + " not found pc uuid:" + pcUuid));
            }
        } else {
            logger.error((Object)"node uuid of pc not exists");
        }
        return result;
    }

    public static JSONObject getDefaultPolicy() {
        JSONObject json = new JSONObject();
        try {
            json.put("subject", (Object)"Administrator");
            json.put("pwdAge", 1);
            json.put("pwdLength", 8);
            json.put("uCase", true);
            json.put("lCase", true);
            json.put("num", true);
            json.put("sym", true);
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        return json;
    }
}

