/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAccountModel;
import com.ksoft.core.DBManager;
import com.ksoft.laps.core.MobileManager;
import com.ksoft.laps.db.TOTPModel;
import com.ksoft.laps.db.UserProfileModel;
import com.ksoft.utils.NullAwareBeanUtilsBean;
import com.ksoft.web.AuthFilter;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@DatabaseTable(tableName="accounts")
@XmlRootElement
public class AccountModel
implements Principal,
IAccountModel {
    private static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    static Logger logger = Logger.getLogger((String)AccountModel.class.getName());
    @DatabaseField(generatedId=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, unique=true, index=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public String login;
    @DatabaseField(defaultValue="true", canBeNull=false)
    @XmlElement
    @Expose
    public Boolean enabled;
    @DatabaseField(defaultValue="false", canBeNull=false)
    @XmlElement
    @Expose
    public Boolean change_password;
    @DatabaseField(defaultValue="false", canBeNull=false)
    @XmlElement
    @Expose
    public Boolean external;
    @DatabaseField(canBeNull=false)
    @XmlElement
    @Expose
    public String email;
    @DatabaseField(canBeNull=false)
    @XmlTransient
    public String hash;
    @DatabaseField(canBeNull=true, index=true)
    @XmlTransient
    public String token;
    @XmlElement
    @Expose(serialize=true, deserialize=false)
    @DatabaseField(canBeNull=false, defaultValue="[]", index=true)
    public String roles;
    @Expose(deserialize=true, serialize=false)
    @XmlTransient
    public String password;
    @XmlTransient
    @DatabaseField(canBeNull=true, foreign=true, foreignAutoRefresh=true)
    public TOTPModel totp;
    @XmlTransient
    @ForeignCollectionField(eager=true)
    public ForeignCollection<UserProfileModel> profiles;
    @XmlTransient
    private static String salt = "saltq7q87q0r7q8191asdfhjkHHHcatasdfa!@#";

    public String getLogin() {
        return this.login.toLowerCase();
    }

    public void setLogin(String login) {
        this.login = login.toLowerCase();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobile() {
        JSONObject result = new JSONObject();
        JSONObject json = this.getNonSensitiveProfileJSON();
        JSONObject device = json.optJSONObject(UserProfileModel.CATEGORY.MOBILE.toString());
        if (device != null) {
            device.remove("uuid");
            result = device;
        }
        return result.toString();
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @XmlTransient
    public String getHash() {
        return this.hash;
    }

    @XmlTransient
    public void setHash(String hash) {
        this.hash = hash;
    }

    @XmlTransient
    public String getToken() {
        return this.token;
    }

    @XmlTransient
    public void setToken(String token) {
        this.token = token;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public String getRoles() {
        return this.roles;
    }

    public ArrayList<String> getRolesArray() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            if (this.roles != null) {
                JSONArray jRoles = new JSONArray(this.roles);
                int i = 0;
                while (i < jRoles.length()) {
                    result.add(jRoles.getString(i));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get roles for " + this.login), (Throwable)e);
        }
        return result;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public void hashPassword() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.hash = AccountModel.hashString(this.password, salt);
    }

    public AuthManager.AUTHSTATUS checkPassword(String password) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.WRONG_PASSWORD;
        try {
            String check_hash = AccountModel.hashString(password, salt);
            if (this.hash.equals(check_hash)) {
                if (this.change_password.booleanValue()) {
                    logger.debug((Object)("Password for " + this.login + " is OK but must be changed"));
                    result = AuthManager.AUTHSTATUS.PASSWORD_CHANGE;
                } else {
                    result = AuthManager.AUTHSTATUS.SUCCESS;
                    logger.debug((Object)("Password for " + this.login + " is OK"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("checkPassword for " + this.login + " error"), (Throwable)e);
        }
        return result;
    }

    public String generateToken() {
        this.token = UUID.randomUUID().toString();
        return this.token;
    }

    public static String generateJWTtoken(PrivateKey key, String login, Object roles, String ip, int durationMinutes) {
        String jwtToken = Jwts.builder().setSubject(login.toLowerCase()).setAudience("general").setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 60000L * (long)durationMinutes)).claim("ip", (Object)ip).claim("roles", roles).signWith(SignatureAlgorithm.RS512, (Key)key).compact();
        return jwtToken;
    }

    public String generateJWTtoken(PrivateKey key, String ip, int durationMinutes) throws JSONException {
        JSONArray jRoles = new JSONArray(this.roles);
        ArrayList<String> roles = new ArrayList<String>();
        int i = 0;
        while (i < jRoles.length()) {
            roles.add(jRoles.getString(i));
            ++i;
        }
        String jwtToken = Jwts.builder().setSubject(this.login.toLowerCase()).setAudience("general").setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 60000L * (long)durationMinutes)).claim("ip", (Object)ip).claim("roles", roles).signWith(SignatureAlgorithm.RS512, (Key)key).compact();
        return jwtToken;
    }

    public static String hashString(String text, String salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String result = "";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update((String.valueOf(salt) + text).getBytes("UTF-8"));
        byte[] digest = md.digest();
        result = String.format("%064x", new BigInteger(1, digest));
        return result;
    }

    public static String hashString(String text) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String result = "";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update((String.valueOf(salt) + text).getBytes("UTF-8"));
        byte[] digest = md.digest();
        result = String.format("%064x", new BigInteger(1, digest));
        return result;
    }

    public static boolean checkHashedValue(String text, String hash) {
        boolean result = false;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update((String.valueOf(salt) + text).getBytes("UTF-8"));
            byte[] digest = md.digest();
            String hash1 = String.format("%064x", new BigInteger(1, digest));
            if (hash1.toLowerCase().equals(hash.toLowerCase())) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkHashedValue error");
        }
        return result;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.login;
    }

    public static AccountModel fromJSONString(String request) {
        AccountModel model;
        block5: {
            model = (AccountModel)gson.fromJson(request, AccountModel.class);
            model.login = model.login.toLowerCase();
            try {
                JSONObject json = new JSONObject(request);
                if (!json.has("roles")) break block5;
                JSONArray c1 = json.getJSONArray("roles");
                HashSet<String> set = new HashSet<String>();
                int i = 0;
                while (i < c1.length()) {
                    String role = c1.getString(i);
                    try {
                        set.add(AuthFilter.ROLE.valueOf(role).name());
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)("Wrong role found " + c1.toString()), (Throwable)e);
                    }
                    ++i;
                }
                JSONArray newRoles = new JSONArray(set);
                model.roles = newRoles.toString();
            }
            catch (JSONException e) {
                logger.error((Object)"Failed to convert roles section");
            }
        }
        return model;
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        try {
            result.put("login", (Object)this.login);
            result.put("external", (Object)this.external);
            JSONArray jRoles = new JSONArray(this.roles);
            result.put("roles", (Object)jRoles);
            result.put("email", (Object)this.email);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @XmlTransient
    public JSONObject getFullProfileJSON() {
        JSONObject json = new JSONObject();
        for (UserProfileModel profile : this.profiles) {
            try {
                UserProfileModel.CATEGORY category = UserProfileModel.CATEGORY.valueOf(profile.category);
                switch (category) {
                    case FAVORITES_PC: 
                    case HISTORY_PC: {
                        JSONArray arr = new JSONArray(profile.value);
                        json.put(category.toString(), (Object)arr);
                        break;
                    }
                    case MOBILE: {
                        JSONObject jMobile = new JSONObject(profile.value);
                        json.put(category.toString(), (Object)jMobile);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"getFullProfileJSON error", (Throwable)e);
            }
        }
        return json;
    }

    @XmlTransient
    public JSONObject getNonSensitiveProfileJSON() {
        JSONObject json = new JSONObject();
        for (UserProfileModel profile : this.profiles) {
            try {
                UserProfileModel.CATEGORY category = UserProfileModel.CATEGORY.valueOf(profile.category);
                switch (category) {
                    case PC_DESC: {
                        JSONObject pcDescs = new JSONObject(profile.value);
                        json.put(category.toString(), (Object)pcDescs);
                        break;
                    }
                    case FAVORITES_PC: 
                    case HISTORY_PC: {
                        JSONArray arr = new JSONArray(profile.value);
                        json.put(category.toString(), (Object)arr);
                        break;
                    }
                    case MOBILE: {
                        JSONObject jMobile = new JSONObject(profile.value);
                        JSONObject device = jMobile.getJSONObject("device");
                        json.put(category.toString(), (Object)device);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"getNonSensitiveProfileJSON error", (Throwable)e);
            }
        }
        return json;
    }

    public Boolean getChange_password() {
        return this.change_password;
    }

    public void setChange_password(Boolean change_password) {
        this.change_password = change_password;
    }

    @Override
    public String toString() {
        return this.login;
    }

    public void modifyProfile(String operation, String category, String value) throws SQLException, JSONException {
        block47: {
            UserProfileModel profileModel;
            UserProfileModel.CATEGORY profileCategory;
            block46: {
                logger.debug((Object)("Profile modification: " + operation + " " + category));
                profileCategory = UserProfileModel.CATEGORY.valueOf(category);
                Predicate<UserProfileModel> profilePredicate = p -> p.category.equals(category);
                profileModel = null;
                if (this.profiles != null) {
                    profileModel = this.profiles.stream().filter(profilePredicate).findFirst().orElse(null);
                }
                if (profileModel == null) break block46;
                block0 : switch (profileCategory) {
                    case PC_DESC: {
                        switch (operation) {
                            case "set": {
                                profileModel.value = new JSONObject(value).toString();
                                DBManager.getDao((Object)profileModel).update((Object)profileModel);
                            }
                        }
                        break;
                    }
                    case MOBILE: {
                        JSONObject mobile = new JSONObject(profileModel.value);
                        switch (operation) {
                            case "del": {
                                DBManager.getDao((Object)profileModel).delete((Object)profileModel);
                                MobileManager.getInstance().deleteFailCountPerLogin(this.login);
                                break block0;
                            }
                            case "set": {
                                profileModel.value = new JSONObject(value).toString();
                                DBManager.getDao((Object)profileModel).update((Object)profileModel);
                                MobileManager.getInstance().deleteFailCountPerLogin(this.login);
                            }
                        }
                        break;
                    }
                    case FAVORITES_PC: 
                    case HISTORY_PC: {
                        JSONArray arr = new JSONArray(profileModel.value);
                        JSONArray arrWithOut = new JSONArray();
                        boolean arrContains = false;
                        int i = 0;
                        while (i < arr.length()) {
                            if (arr.getString(i).toLowerCase().equals(value.toLowerCase())) {
                                arrContains = true;
                            } else {
                                arrWithOut.put((Object)arr.getString(i));
                            }
                            ++i;
                        }
                        switch (operation) {
                            case "add": {
                                if (!arrContains) {
                                    arr.put((Object)value);
                                }
                                if (profileCategory.equals((Object)UserProfileModel.CATEGORY.HISTORY_PC) && arr.length() > 14) {
                                    arr.remove(0);
                                }
                                profileModel.value = arr.toString();
                                DBManager.getDao((Object)profileModel).update((Object)profileModel);
                                break block0;
                            }
                            case "del": {
                                if (arrWithOut.length() > 0) {
                                    profileModel.value = arrWithOut.toString();
                                    DBManager.getDao((Object)profileModel).update((Object)profileModel);
                                    break block0;
                                }
                                DBManager.getDao((Object)profileModel).delete((Object)profileModel);
                                break block0;
                            }
                            case "set": {
                                JSONArray setArray = new JSONArray();
                                setArray.put((Object)value);
                                profileModel.value = setArray.toString();
                                DBManager.getDao((Object)profileModel).update((Object)profileModel);
                                break block0;
                            }
                        }
                        break;
                    }
                }
                break block47;
            }
            profileModel = new UserProfileModel();
            profileModel.category = category;
            profileModel.account = this;
            switch (profileCategory) {
                case FAVORITES_PC: 
                case HISTORY_PC: 
                case PC_DESC: {
                    JSONArray arr = new JSONArray();
                    arr.put((Object)value);
                    profileModel.value = arr.toString();
                    break;
                }
                case MOBILE: {
                    JSONObject mobile = new JSONObject(value);
                    profileModel.value = mobile.toString();
                    break;
                }
            }
            DBManager.getDao((Object)profileModel).create((Object)profileModel);
        }
    }

    public Boolean isBuiltInTOTPexists() {
        if (this.totp != null) {
            return true;
        }
        return false;
    }
}

