/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.core.DBManager;
import com.ksoft.utils.NullAwareBeanUtilsBean;
import java.time.Instant;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@DatabaseTable(tableName="alerts")
@XmlRootElement
public class AlertModel {
    static Logger logger = Logger.getLogger((String)AlertModel.class.getName());
    private static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    static LinkedBlockingQueue<AlertModel> queue;
    @DatabaseField(generatedId=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public long ts_created;
    @DatabaseField(canBeNull=true)
    @XmlElement
    @Expose
    public long ts_updated;
    @DatabaseField(canBeNull=false, defaultValue="1")
    @XmlElement
    @Expose
    public Integer count;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public String type;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public String name;
    @DatabaseField(canBeNull=true, dataType=DataType.LONG_STRING)
    @XmlElement
    public String body;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @NullAwareBeanUtilsBean.NotCopy
    @Expose
    public String source;
    @DatabaseField(defaultValue="true", canBeNull=false)
    @XmlElement
    @Expose
    public Boolean isactive;
    @XmlTransient
    public boolean isNew = false;
    @XmlTransient
    public String supressKey;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Boolean getActive() {
        return this.isactive;
    }

    public void setActive(Boolean active) {
        this.isactive = active;
    }

    public long getTs_created() {
        return this.ts_created;
    }

    public void setTs_created(long ts_created) {
        this.ts_created = ts_created;
    }

    public long getTs_updated() {
        return this.ts_updated;
    }

    public void setTs_updated(long ts_updated) {
        this.ts_updated = ts_updated;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private static JSONObject buildAlertDetails(ALERT_TYPE alertType, String source, Object sourceModel) {
        JSONObject result = new JSONObject();
        try {
            switch (alertType) {
                case LDAP_CONNECTION: {
                    result = (JSONObject)sourceModel;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("buildAlertDetails error " + alertType.toString()), (Throwable)e);
        }
        return result;
    }

    public static AlertModel register(ALERT_TYPE alert, String supressKey, String source, Object sourceModel) {
        String alertName = alert.getValue();
        String alertType = alert.name();
        AlertModel model = null;
        try {
            logger.debug((Object)("Alert " + alertName + " " + alertType + " from " + source));
            model = (AlertModel)DBManager.getDao(AlertModel.class).queryBuilder().orderBy("ts_created", false).where().eq("type", (Object)new SelectArg((Object)alertType)).and().eq("source", (Object)new SelectArg((Object)source)).queryForFirst();
            if (model != null) {
                model.isNew = false;
                if (model.isactive.booleanValue()) {
                    model.ts_updated = Instant.now().toEpochMilli();
                    model.count = model.count + 1;
                    model.supressKey = supressKey;
                    DBManager.getDao(AlertModel.class).update((Object)model);
                } else {
                    model = new AlertModel();
                    model.ts_created = Instant.now().toEpochMilli();
                    model.source = source;
                    model.name = alertName;
                    model.type = alertType;
                    model.body = AlertModel.buildAlertDetails(alert, source, sourceModel).toString();
                    model.isactive = true;
                    model.count = 1;
                    DBManager.getDao(AlertModel.class).create((Object)model);
                    model.supressKey = supressKey;
                    queue.put(model);
                }
            } else {
                model = new AlertModel();
                model.ts_created = Instant.now().toEpochMilli();
                model.name = alertName;
                model.type = alertType;
                model.source = source;
                model.body = AlertModel.buildAlertDetails(alert, source, sourceModel).toString();
                model.isactive = true;
                model.isNew = true;
                model.count = 1;
                model.supressKey = supressKey;
                DBManager.getDao(AlertModel.class).create((Object)model);
                queue.put(model);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Alert generation error " + alertName + " " + alertType + " " + source));
        }
        return model;
    }

    public static void release(ALERT_TYPE alert, String source) {
        String type = alert.name();
        try {
            AlertModel model = (AlertModel)DBManager.getDao(AlertModel.class).queryBuilder().orderBy("ts_created", false).where().eq("type", (Object)new SelectArg((Object)type)).and().eq("source", (Object)new SelectArg((Object)source)).and().eq("active", (Object)true).queryForFirst();
            if (model != null) {
                model.isactive = false;
                model.ts_updated = Instant.now().toEpochMilli();
                DBManager.getDao((Object)model).update((Object)model);
                logger.debug((Object)("Alert released " + model.type));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Alert release error " + type + " " + source), (Throwable)e);
        }
    }

    public static JSONArray getRegisteredAlertTypes() throws JSONException {
        JSONArray array = new JSONArray();
        ALERT_TYPE[] alerts = ALERT_TYPE.values();
        int i = 0;
        while (i < alerts.length) {
            JSONObject json = new JSONObject();
            json.put("type", (Object)alerts[i].name());
            json.put("name", (Object)alerts[i].toString());
            array.put((Object)json);
            ++i;
        }
        return array;
    }

    @XmlTransient
    public JSONObject getJSON() {
        JSONObject json = new JSONObject();
        JSONObject jContent = new JSONObject();
        try {
            json = new JSONObject(gson.toJson((Object)this));
            jContent = new JSONObject(this.body);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to convert " + this.getClass().toString() + " to JSON"));
        }
        try {
            json.put("content", (Object)jContent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public static void setQueue(LinkedBlockingQueue<AlertModel> queue) {
        AlertModel.queue = queue;
    }

    public static enum ALERT_TYPE {
        LDAP_CONNECTION("LDAP connection error"),
        LICENSE_EXPIRATION("License expiration"),
        LICENSE_LIMIT("License limit is exceeded");

        private final String alert;

        private ALERT_TYPE(String alert) {
            this.alert = alert;
        }

        public String getValue() {
            return this.alert;
        }

        public String toString() {
            return this.alert;
        }
    }

    public static enum SEVERITY {
        CRITICAL("critical"),
        HIGH("high"),
        LOW("low");

        private final String severity;

        private SEVERITY(String severity) {
            this.severity = severity;
        }

        public String getValue() {
            return this.severity;
        }

        public String toString() {
            return this.severity;
        }
    }
}

